
#include <stdlib.h>
#include <NDS.h>

#include "glib.h"
#include "glmemtool.h"
#include "cglb32.h"

#include "cglstream.h"

CglB32::CglB32(TMM *_pMM,const u8 *_buf,const int _size)
{
  pMM=_pMM;
  
  if(_buf==NULL) StopFatalError(12801,"CglB32::CglB32: _buf is NULL.\n");
  
  CglStream stream(_buf,_size);
  
  Width=stream.Readu16();
  Height=stream.Readu16();
  
//  if(VerboseDebugLog==true) _consolePrintf("new CglB32: w,h=%d,%d size=%d\n",Width,Height,_size);
  
  data=(u32*)safemalloc_chkmem(pMM,Height*Width*sizeof(u32));
  
  stream.ReadBuffer(data,Height*Width*sizeof(u32));
}

CglB32::~CglB32(void)
{
  safefree(pMM,data); data=NULL;
}

int CglB32::GetWidth(void) const
{
  return(Width);
}

int CglB32::GetHeight(void) const
{
  return(Height);
}

const u32* CglB32::GetData(void) const
{
  return(data);
}

void CglB32::BitBlt(CglCanvas *pDestCanvas,const int nDestLeft,const int nDestTop,const int nWidth,const int nHeight,const int nSrcLeft,const int nSrcTop) const
{
//  pCanvas->BitBlt(pDestCanvas,nDestLeft,nDestTop,nWidth,nHeight,nSrcLeft,nSrcTop,TransFlag);
}

