unit MainWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    FileLst: TFileListBox;
    HeadLst: TListBox;
    HeadTopLst: TListBox;
    HeadEndLst: TListBox;
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var
  StartPath:string;
  SkinPath:string;
  idx,cnt:integer;
  rfs,wfs:TFileStream;
  names:array of string;
  offsets,sizes:array of dword;
  buf:array of byte;
  procedure w8(data:byte);
  begin
    wfs.WriteBuffer(data,1);
  end;
  procedure w32(data:dword);
  begin
    wfs.WriteBuffer(data,4);
  end;
  procedure whead;
  var
    idx:integer;
  begin
    for idx:=0 to cnt-1 do begin
      w32(offsets[idx]);
      w32(sizes[idx]);
    end;
  end;
begin
  StartPath:=ExtractFilePath(Application.ExeName);
  SkinPath:=StartPath+'skinpack\';

  FileLst.Directory:=SkinPath;
  cnt:=FileLst.Items.Count;
  setlength(names,cnt);
  setlength(offsets,cnt);
  setlength(sizes,cnt);

  wfs:=TFileStream.Create(StartPath+'skinpack.dat',fmCreate);

  for idx:=0 to cnt-1 do begin
    names[idx]:=FileLst.Items[idx];
    offsets[idx]:=0;
    sizes[idx]:=0;
  end;

  wfs.Position:=0;
  whead;

  for idx:=0 to cnt-1 do begin
    offsets[idx]:=wfs.Position;
    rfs:=TFileStream.Create(SkinPath+names[idx],fmOpenRead);
    sizes[idx]:=rfs.Size;
    setlength(buf,sizes[idx]);
    rfs.ReadBuffer(buf[0],sizes[idx]);
    wfs.WriteBuffer(buf[0],sizes[idx]);
    rfs.Free;
    while((wfs.Position and 3)<>0) do begin
      w8(0);
    end;
  end;

  wfs.Position:=0;
  whead;

  wfs.Free;

  HeadLst.Clear;
  HeadLst.Items.Text:=HeadLst.Items.Text+HeadTopLst.Items.Text;
  for idx:=0 to cnt-1 do begin
    if names[idx][length(names[idx])-3]<>'.' then ShowMessage('Illigal extention name. ['+names[idx]+']');
    names[idx][length(names[idx])-3]:='_';
    HeadLst.Items.Add('  ESF_'+names[idx]+',');
  end;
  HeadLst.Items.Text:=HeadLst.Items.Text+HeadEndLst.Items.Text;
  HeadLst.Items.SaveToFile(StartPath+'skinpack.h');

  Application.Terminate;
end;

end.
