#include "world.h"

#define MAPSIZE 64
#define exptiles_WIDTH 96
#define exptiles_HEIGHT 32

extern unsigned short map_colormap[];
extern unsigned char map_graphics[];
extern unsigned char map_map[];

s32 WORLDzoom = 1<<8;



void initMap(u16 * mapColorMap, u8 * mapGfx, u8 * mapMap)
{
	initBackground(&worldMap, 2);
	enableBackground(&worldMap);
	loadBGPalette((u16*)&mapColorMap);
	loadBGTiles(&worldMap, (u16*)&mapGfx, exptiles_WIDTH, exptiles_HEIGHT);
	loadBGMap(&worldMap, (u16*)mapMap, MAPSIZE);
}

void scrollMapTo(int x, int y)
{
	worldMap.x_scroll = -x;
	worldMap.y_scroll = -y;

}

void scrollMapBy(s16 x, s16 y)
{
	worldMap.x_scroll -= x;
	worldMap.y_scroll -= y;

}

s16 getMapScrollX()
{
	return -worldMap.x_scroll;
}

s16 getMapScrollY()
{
	return -worldMap.y_scroll;
}

int getTileAtScreenXY(u16 x, u16 y)
{
	u16 xTile = (x + worldMap.x_scroll)>>3;
	u16 yTile = (y + worldMap.y_scroll)>>3;

	return getTileAtMapXY(xTile, yTile);

}

int getTileAtMapXY(u16 x, u16 y)
{
	u8 *md = (u8*)(worldMap.mapData);
	return md[bg_tegel_id(x,y)];
}

void calcMap()
{
	rotateBackground(&worldMap, 0, 0, 0, WORLDzoom);
}

void updateMap()
{
	updateBackground(&worldMap);
}
