@ (0)
    .extern IntrTable
    .global IntrMain
    .section .iwram,"ax",%progbits
    .code 32

IntrMain:                           @ Single interrupts support
@ (1)
    mov     r3, #0x4000000          @ REG_BASE
    ldr     r2, [r3,#0x200]         @ Read REG_IE and REG_IF in one go
    and     r1, r2, r2, lsr #16     @ r1 = REG_IE & REG_IF

    ldrh    r2, [r3, #-8]           @\mix up with BIOS irq flags at 3007FF8h,
    orr     r2, r2, r1              @ aka mirrored at 3FFFFF8h, this is required
    strh    r2, [r3, #-8]           @/when using the (VBlank)IntrWait functions
@ (2)
    add     r3, r3, #0x200
    ldr     r2, =IntrTable
@ (3)
    ands    r0, r1, #0x0001          @ V-Blank Interrupt
    bne     jump_intr
    add     r2, r2, #4

    ands    r0, r1, #0x0002          @ H-Blank Interrupt
    bne     jump_intr
    add     r2, r2, #4

@ other interrupts snipped to keep it short
@ interrupts past this point won't work unless we add the code for them....

    ands    r0, r1, #0x1000         @ Key Interrupt
    bne     jump_intr
    add     r2, r2, #4

    ands    r0, r1, #0x2000         @ Cart Interrupt

    strneb  r0, [r3, #0x84 - 0x200] @ Stop sound if cart removed (REG_SOUNDCNT_X)
loop:
    bne     loop                    @ Infinite loop if cart removed

@ (4)
jump_intr:
    strh    r0, [r3, #2]            @ IF Clear
    ldr     r0, [r2]                @ Jump to user IRQ process
    bx      r0
    .align
    .pool

