#include "gbaIncludes/gba.h"
#include "irq.h"


 

extern void IntrMain();

 
#define BIT(x) (1<<x)


fp IntrTable[14];

 

 

void IRQ_Set(int irq, fp irq_handle)

{

   int i;

 

   for(i = 0; i < 14; i++)

   {

      if(irq & BIT(i))

         IntrTable[i] = irq_handle;

   }

 

   REG_INTERUPT = (int)IntrMain;

 

   REG_IME  = 0;

 

   REG_IE |= irq;

 

   REG_IME = 1;

}

 

void IRQ_Disable(int irqs)

{

   REG_IME = 0;

   REG_IE &= ~irqs;

   REG_IME = 1;

}

