

#ifndef _hardware_h_
#define _hardware_h_


#define RGB(r,g,b) (r+(g<<5)+(b<<10))                   //Macro to build a color

#define false 0
#define true !false

//define the screen width and height values to be used
#define SCREEN_WIDTH	240
#define SCREEN_HEIGHT   160


#ifndef BASETYPESDEFINED
#define BASETYPESDEFINED
typedef unsigned char 	u8;
typedef unsigned short 	u16;
typedef unsigned long 	u32;


typedef signed char 	s8;
typedef signed short 	s16;
typedef signed long 	s32;

typedef unsigned char 	byte;
typedef unsigned short 	hword;
typedef unsigned long 	word;

typedef u16 bool;
#endif


typedef char Sprite;
typedef char Background;

void waitForRedraw();
void drawGame();
void getInput();
void initGfx();
void initTileSpriteGfx(u8 * spriteGfx, u16 * Palette, u16 * mapColorMap, u8 * mapGfx, u8 * mapMap);
void hideSprites();
void showSprites();

void setModeBitmapNoFlipping();
inline void drawDot(int x, int y, u16 color);
inline void drawDotRGB(int x, int y, int R, int G, int B);
void drawLine(int x0, int y0, int x1, int y1, u16 color);
inline void drawLineRGB(int x0, int y0, int x1, int y1, int R, int G, int B);


Sprite * newSprite();

s32 worldX();
s32 worldY();
void setWorldX(s32 x);
void setWorldY(s32 y);
void incWorldX(s32 delta);
void incWorldY(s32 delta);
void scrollWorldBy(s32 deltaX, s32 deltaY);
void setWorldXY(s32 x, s32 y);


bool initSprite(Sprite * sprite);
void initSpriteList();

void spriteSetAttachedToMap(Sprite * sprite, bool attached);

void killSprite(Sprite * sprite);
bool spriteIsDead(Sprite * sprite);

s32 spriteX(Sprite * sprite);
void spriteSetX(Sprite * sprite, s32 y);
void spriteIncX(Sprite * sprite, s32 delta);

s32 spriteY(Sprite * sprite);
void spriteSetY(Sprite * sprite, s32 x);
void spriteIncY(Sprite * sprite, s32 delta);

void spriteSetXY(Sprite * sprite, s32 x, s32 y);

//screen setting
u16 spriteScreenX(Sprite * sprite);
void spriteSetScreenX(Sprite * sprite, u16 y);
void spriteIncScreenX(Sprite * sprite, s16 delta);

u16 spriteScreenY(Sprite * sprite);
void spriteSetScreenY(Sprite * sprite, u16 x);
void spriteIncScreenY(Sprite * sprite, s16 delta);

void spriteSetScreenXY(Sprite * sprite, u16 x, u16 y);



u16 spriteFrame(Sprite * sprite);
void spriteSetFrame(Sprite * sprite, u16 frame);

bool spriteHFlip(Sprite * sprite);
void spriteSetHFlip(Sprite * sprite, bool flip);

bool spriteVFlip(Sprite * sprite);
void spriteSetVFlip(Sprite * sprite, bool flip);

u16 spriteRot(Sprite * sprite);
void spriteSetRot(Sprite * sprite, u16 rot);

u16 spriteGfxKey(Sprite * sprite);
void spriteSetGfxKey(Sprite * sprite, u16 key);

inline bool keyLeft();
inline bool keyRight();
inline bool keyUp();
inline bool keyDown();
inline bool keyA();
inline bool keyB();
inline bool keyL();
inline bool keyR();
inline bool keyStart();
inline bool keySelect();

inline bool keyPressLeft();
inline bool keyPressRight();
inline bool keyPressUp();
inline bool keyPressDown();
inline bool keyPressA();
inline bool keyPressB();
inline bool keyPressL();
inline bool keyPressR();
inline bool keyPressStart();
inline bool keyPressSelect();


void loadMapTileGfx(u16* gfx, int tileWidth, int tileHeight);
void loadMapTiles(u16* map, int mapSize);

int getTileAtScreenXY(u16 x, u16 y);
int getTileAtMapXY(u16 x, u16 y);


void writeText(int textXLeft, int textYTop,  char *message);
void writeNum(int textXLeft,  int textYTop, int number);
void clearText();

void debugPrint(char * text);
void debugPrintNum(int num);
void debugPrintVal(char * text, int num);

u8 * saveRam;

#endif
