#include "gbaHardware.h"
#include "world.h"
#include "bg.h"
#include "irq.h"
#include "bios.h"

#define USE_IRQ_VBLANK
#define debugprint printf
#define HARDWARE

#define XWRAPMASK 0xFE00



/***********untested DMA code************************/
typedef struct tagDMAINFO
{
    const void *src;
    void *dst;
    u32 cnt;
} DMAINFO;

#define dma_mem ((volatile DMAINFO*)0x040000b0)
#define DMA_32NOW 0x02000000  //this is probably incorrect!

void dma_memcpy(void *dst, const void *src, u16 count)
{
    dma_mem[3].cnt = 0;	// shut off any previous transfer
    dma_mem[3].src = src;
    dma_mem[3].dst = dst;
    dma_mem[3].cnt = count | DMA_32NOW;

}
/**********end untested DMA code***********************/



extern u16 Bitmap[4608];
extern u16 Palette[256];

u8 debug;

u32* OAMmem 		=(u32*)0x7000000;
u16* VideoBuffer 	=(u16*)0x6000000;
u16* OAMData		=(u16*)0x6010000;
u16* BGPaletteMem 	=(u16*)0x5000000;
u16* OBJPaletteMem 	=(u16*)0x5000200;

u16 oldKeys;
u16 currKeys = 0xffff;


gbaSprite gbaSpriteList[MAXSPRITES];
hSprite spriteList[MAXSPRITES];
s16 maxSprite = -1;

u16* OAM = (u16*)0x7000000;


//create the rotation and scaling array (overlaps the OAMEntry array memory)
pRotData rotData = (pRotData)gbaSpriteList;

s32 WorldX;
s32 WorldY;

bool twiddler = true; 

void waitForRedraw()
{
#ifndef USE_IRQ_VBLANK
	while((volatile u16)REG_VCOUNT != 160){}
#else
	//doShutdownCPU
	swi_vblank();
#endif
}

/**************a functionless ISR for waking up on v-blank interrupt**************/
void vblank_isr()
{
	//do nothing, but use twiddler to keep the compiler from optimizing this away...
	twiddler = ~twiddler;
}
/**************/


void getInput()
{
	oldKeys = currKeys;
	currKeys = KEYS;
}

void copyOAM()
{
	u16 loop; 
 	u16* temp; 
 	temp = (u16*)gbaSpriteList; 
 	for(loop = 0; loop < 128*4; loop++) 
 	{ 
		  OAM[loop] = temp[loop]; 
 	}
}

//void updateHardwareSprite(ctr)
//{
       //gbaSpriteList[ctr].attribute0 = COLOR_256 | SQUARE | gbaSpriteList[ctr].y; 
       //gbaSpriteList[ctr].attribute1 = SIZE_32 | gbaSpriteList[ctr].x; 
       //gbaSpriteList[ctr].attribute2 = 0; 
//}

void drawGame()
{

    #ifndef NOHARDWARE
	calcMap();
	updateMap();
	copyOAM();
    #endif
}

void initGfx()
{
#ifdef USE_IRQ_VBLANK
	REG_DISPSTAT |= VID_IRQ_VB;
	IRQ_Set(IRQ_VBLANK, vblank_isr);
#endif
	saveRam = SAVE_RAM;
}

void setModeBitmapNoFlipping()
{
	SetMode(MODE_3 | BG2_ENABLE);
}

void drawDot(int x, int y, u16 color)
{
	VideoBuffer[y * 240 + x] = color;
}

void drawDotRGB(int x, int y, int R, int G, int B)
{
	drawDot(x,y,RGB(R,B,G));
}

void drawLineRGB(int x0, int y0, int x1, int y1, int R, int G, int B)
{
	drawLine(x0, y0, x1, y1, RGB(R,G,B));
}

void drawLine(int x0, int y0, int x1, int y1, u16 color)
    {
        int pix = color;
        int dy = y1 - y0;
        int dx = x1 - x0;
        int stepx, stepy;

        if (dy < 0) { dy = -dy;  stepy = -240; } else { stepy = 240; }
        if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; }
        dy <<= 1;
        dx <<= 1;

        y0 *= 240;
        y1 *= 240;
        VideoBuffer[x0+y0] = pix;
        if (dx > dy) {
            int fraction = dy - (dx >> 1);
            while (x0 != x1) {
                if (fraction >= 0) {
                    y0 += stepy;
                    fraction -= dx;
                }
                x0 += stepx;
                fraction += dy;
                VideoBuffer[x0+y0] = pix;
            }
        } else {
            int fraction = dx - (dy >> 1);
            while (y0 != y1) {
                if (fraction >= 0) {
                    x0 += stepx;
                    fraction -= dy;
                }
                y0 += stepy;
                fraction += dx;
                VideoBuffer[x0+y0] = pix;
            }
        }
    }


void hideSprites()
{
	SetMode(REG_DISPCNT & ~OBJ_ENABLE);
}

void showSprites()
{
	SetMode(REG_DISPCNT | OBJ_ENABLE);
}

void initTileSpriteGfx(u8 * spriteGfx, u16 * Palette, u16 * mapColorMap, u8 * mapGfx, u8 * mapMap)
{

	u16 loop; 
	WorldX = 0;
	WorldX = 0;
  #ifndef NOHARDWARE

	//set the screen mode
	SetMode(MODE_1 | OBJ_ENABLE | OBJ_MAP_1D); 


	//copy the sprite palette
	for(loop = 0; loop < 256; loop++) 
	{
		OBJPaletteMem[loop] = Palette[loop]; 
	}



       	//load the sprite gfx from the bitmap data
       for(loop = 0; loop < sizeof(spriteGfx); loop++) 
       { 
              OAMData[loop] = spriteGfx[loop];
       }
    #endif

	//set all the sprites offscreen
       for(loop = 0; loop < 128; loop++) 
       { 
             gbaSpriteList[loop].attribute0 = 160;  //y to > 159 
             gbaSpriteList[loop].attribute1 = 240;  //x to > 239 
       } 


       initMap(mapColorMap, mapGfx,mapMap);

}

s32 worldX()
{
	return WorldX;
}

s32 worldY()
{
	return WorldY;
}

void updateSpriteToWorldX(hSprite * hsprite)
{


	if (!(((hSprite*)hsprite)->attachedWorld)) return;


	s32 tmp;
	u16 sx;
	tmp = WorldX + hsprite->worldX;
	debugprint ("updating to world %i\n", tmp);
	if (tmp < 0)
	{
		if (tmp < -32)
		{
			sx = SCREEN_WIDTH + 1;
		}
		else
		{
			sx = MAGIC_WRAPAROUND_X - (-tmp);

		}
	}
	else if (tmp > SCREEN_WIDTH)
	{
		sx = SCREEN_WIDTH + 1;
	}
	else
	{
		sx = tmp;
	}
	spriteSetScreenX((Sprite*)hsprite, sx);
}

void updateSpriteToWorldY(hSprite * hsprite)
{
	if (!(((hSprite*)hsprite)->attachedWorld)) return;

	s32 tmp;
	u16 sy;
	tmp = WorldY + hsprite->worldY;
	if (tmp < 0)
	{
		if (tmp < -32)
		{
			sy = SCREEN_HEIGHT + 1;
		}
		else
		{
			sy = MAGIC_WRAPAROUND_Y - (-tmp);

		}
	}
	else if (tmp > SCREEN_HEIGHT)
	{
		sy = SCREEN_HEIGHT + 1;
	}
	else
	{
		sy = tmp;
	}
	spriteSetScreenY((Sprite*)hsprite, sy);

}



void updateSpritesToWorldCoords()
{
	u16 i;
	for (i = 0; i <= maxSprite; i++)
	{
		updateSpriteToWorldX(&spriteList[i]);
		updateSpriteToWorldY(&spriteList[i]);
	}
}

void updateSpritesToWorldX()
{
	hSprite * test;
	u16 i;
		debugprint("here: %i\n", maxSprite);
	for (i = 0; i <= maxSprite; i++)
	{
		updateSpriteToWorldX((hSprite*)&spriteList[i]);
	}
}

void updateSpritesToWorldY()
{
	u16 i;
	for (i = 0; i <= maxSprite; i++)
	{
		updateSpriteToWorldY(&spriteList[i]);
	}
}


void updateSpriteToWorldCoords(hSprite * hsprite)
{
	updateSpriteToWorldX(hsprite);
	updateSpriteToWorldY(hsprite);

}


void setWorldX(s32 x)
{
	WorldX = x;
	scrollMapTo(x, WorldY);
	updateSpritesToWorldX();
}

void setWorldY(s32 y)
{
	WorldY = y;
	scrollMapTo(WorldX, y);
	updateSpritesToWorldY();
}
void scrollWorldBy(s32 deltaX, s32 deltaY)
{
	WorldX += deltaX;
	WorldY += deltaY;
	scrollMapBy(deltaX, deltaY);
 	updateSpritesToWorldCoords();

}

void incWorldX(s32 delta)
{
	WorldX += delta;
	scrollMapBy(delta, 0);
	updateSpritesToWorldX();
}

void incWorldY(s32 delta)
{
	WorldY += delta;
	scrollMapBy(delta, 0);
	updateSpritesToWorldY();
}

void setWorldXY(s32 x, s32 y)
{
	WorldX = x;
	WorldY = y;
	scrollMapTo(x,y);
	updateSpritesToWorldCoords();
}




void initSpriteList()
{

}

void spriteSetAttachedToMap(Sprite * sprite, bool attached)
{
	((hSprite*)sprite)->attachedWorld = attached;
}

initGBSprite(gbaSprite * gbs)
{
	gbs->attribute0 = COLOR_256 | SQUARE;
	gbs->attribute1 = SIZE_32;
	gbs->attribute2 = 0;
}

bool initSpriteSlot(Sprite * sprite, u16 slot)
{
	debugprint("init sprite slot: %i\n", slot);
	((hSprite*)sprite)->gbs = &gbaSpriteList[slot];
	initGBSprite(((hSprite*)sprite)->gbs);
	

	spriteSetX(sprite, 0);
	spriteSetY(sprite, 0);
	((hSprite*)sprite)->isDead = false;
	((hSprite*)sprite)->startFrame = 0;

	return true;
	
}


Sprite * newSprite()
{
	s16 slot = -1;
	u16 i = 0;
	bool notDone = true;
	while (i <= maxSprite)
	{
		if (spriteIsDead(((Sprite*)&spriteList[i])))
		{
			slot = i;
			i = maxSprite;
		}
		i++;
	}
	if (slot == -1)
	{
		if (maxSprite >= MAXSPRITES)
		{
			return NULL;
		}
		maxSprite++;
		slot = maxSprite;
	}
	if (initSpriteSlot((Sprite*)&spriteList[slot], slot))
	{
		return (Sprite*)&spriteList[slot];
	}

	return NULL;
}

bool initSprite(Sprite * sprite)
{
	return initSpriteSlot(sprite, 0);

}


void killSprite(Sprite * sprite)
{
	((hSprite*)sprite)->isDead = true;
}

bool spriteIsDead(Sprite * sprite)
{
	return (((hSprite*)sprite)->isDead);
}


void spriteSetY(Sprite * sprite, s32 y)
{
	((hSprite*)sprite)->worldY = y;
	updateSpriteToWorldY((hSprite*)sprite);
}

void spriteSetScreenY(Sprite * sprite, u16 y)
{
	u8 temp = y;
	((hSprite*)sprite)->gbs->attribute0 &= 0xFF00;
	((hSprite*)sprite)->gbs->attribute0 |= temp;
}

s32 spriteY(Sprite * sprite)
{
	return ((hSprite*)sprite)->worldY;
}

u16 spriteScreenY(Sprite * sprite)
{
	return ((hSprite*)sprite)->gbs->attribute0 & 0x00FF;
}


s32 spriteX(Sprite * sprite)
{
	return ((hSprite*)sprite)->worldY;
}

u16 spriteScreenX(Sprite * sprite)
{
	return ((hSprite*)sprite)->gbs->attribute1 & 0x00FF;
}


void spriteSetX(Sprite * sprite, s32 x)
{
	((hSprite*)sprite)->worldX = x;
	updateSpriteToWorldX((hSprite*)sprite);
}

void spriteSetScreenX(Sprite * sprite, u16 x)
{
	x &= ~XWRAPMASK;

	((hSprite*)sprite)->gbs->attribute1 &= XWRAPMASK;
	((hSprite*)sprite)->gbs->attribute1 |= x;

}

void spriteIncX(Sprite * sprite, s32 delta)
{
	hSprite * hs = ((hSprite*)sprite);
	hs->worldX += delta;
	updateSpriteToWorldX(hs);
}

void spriteIncScreenX(Sprite * sprite, s16 delta)
{
	spriteSetScreenX(sprite, spriteX(sprite) + delta);
}

void spriteIncY(Sprite * sprite, s32 delta)
{
	hSprite * hs = ((hSprite*)sprite);
	hs->worldY += delta;
	updateSpriteToWorldY(hs);
}

void spriteIncScreenY(Sprite * sprite, s16 delta)
{
	spriteSetScreenY(sprite, spriteY(sprite) + delta);
}

void spriteSetXY(Sprite * sprite, s32 x, s32 y)
{
	spriteSetX(sprite, x);
	spriteSetY(sprite, y);
}

void spriteSetScreenXY(Sprite * sprite, u16 x, u16 y)
{
	spriteSetScreenX(sprite, x);
	spriteSetScreenY(sprite, y);
}



u16 spriteFrame(Sprite * sprite)
{
	return (((hSprite*)sprite)->gbs->attribute2 - ((hSprite*)sprite)->startFrame) >> 5;
}

void spriteSetFrame(Sprite * sprite, u16 frame)
{
	((hSprite*)sprite)->gbs->attribute2 = (frame + ((hSprite*)sprite)->startFrame) << 5;

}


bool spriteHFlip(Sprite * sprite)
{
	return (((hSprite*)sprite)->gbs->attribute1 & HORIZONTAL_FLIP) == HORIZONTAL_FLIP;
}

void spriteSetHFlip(Sprite * sprite, bool flip)
{
	if (flip)
	{
		//set the horizontal flip bit
		((hSprite*)sprite)->gbs->attribute1 |= HORIZONTAL_FLIP;
	}
	else
	{
		//clear the horizontal Flip bit
		((hSprite*)sprite)->gbs->attribute1 &= (~HORIZONTAL_FLIP);
	}

}


bool spriteVFlip(Sprite * sprite)
{
	return (((hSprite*)sprite)->gbs->attribute1 & VERTICAL_FLIP) == VERTICAL_FLIP;
}

void spriteSetVFlip(Sprite * sprite, bool flip)
{
	if (flip)
	{
		//set the vertical flip bit
		((hSprite*)sprite)->gbs->attribute1 |= VERTICAL_FLIP;
	}
	else
	{
		//clear the Vertical Flip bit
		((hSprite*)sprite)->gbs->attribute1 &= (~VERTICAL_FLIP);
	}

}


u16 spriteRot(Sprite * sprite)
{
	return 0;
}

void spriteSetRot(Sprite * sprite, u16 rot)
{

}


u16 spriteGfxKey(Sprite * sprite)
{
	return ((hSprite*)sprite)->startFrame;
}

void spriteSetGfxKey(Sprite * sprite, u16 key)
{
	((hSprite*)sprite)->startFrame = key;
}




bool keyLeft(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYLEFT));
	#else
	return false;
	#endif
}

bool keyRight(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYRIGHT));
	#else
	return false;
	#endif
}

bool keyUp(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYUP));
	#else
	return false;
	#endif
}

bool keyDown(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYDOWN));
	#else
	return false;
	#endif
}

bool keyA(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYA));
	#else
	return false;
	#endif
}

bool keyB(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYB));
	#else
	return false;
	#endif
}

bool keyL(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYL));
	#else
	return false;
	#endif
}

bool keyR(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYR));
	#else
	return false;
	#endif
}

bool keyStart(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYSTART));
	#else
	return false;
	#endif
}

bool keySelect(){
 	#ifndef NOHARDWARE
	return(KEY_DOWN(KEYSELECT));
	#else
	return false;
	#endif
}

bool keyPressLeft(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYLEFT));
	#else
	return false;
	#endif
}

bool keyPressRight(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYRIGHT));
	#else
	return false;
	#endif
}

bool keyPressUp(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYUP));
	#else
	return false;
	#endif
}

bool keyPressDown(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYDOWN));
	#else
	return false;
	#endif
}

bool keyPressA(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYA));
	#else
	return false;
	#endif
}

bool keyPressB(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYB));
	#else
	return false;
	#endif
}

bool keyPressL(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYL));
	#else
	return false;
	#endif
}

bool keyPressR(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYR));
	#else
	return false;
	#endif
}

bool keyPressStart(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYSTART));
	#else
	return false;
	#endif
}

bool keyPressSelect(){
 	#ifndef NOHARDWARE
	return(KEY_PRESS(oldKeys,KEYSELECT));
	#else
	return false;
	#endif
}

void loadMapTileGfx(u16* gfx, int tileWidth, int tileHeight)
{
	loadBGTiles(&worldMap, gfx, tileWidth, tileHeight);	

}

void loadMapTiles(u16* map, int mapSize)
{
	loadBGMap(&worldMap, map, mapSize);

}

void debugPrint(char * text)
   {
     asm volatile("mov r0, %0;"
                  "swi 0xff0000;"
                  : // no ouput
                  : "r" (text)
                  : "r0");
   }

void debugPrintNum(int num)
{
	char numString[17] = "";			//Create a string to hold the conversion

	sprintf(numString, "%d", num);	//Convert

	debugPrint(numString);

}

void debugPrintVal(char * text, int num)
{
	char numString[17] = "";			//Create a string to hold the conversion

	sprintf(numString, "%s %d", text,num);	//Convert

	debugPrint(numString); 
}

