#include "hardware.h"
#include "dots.h"

#include <string.h>	

//bugs 2 fix:


bool quitLoop;
void initEngine();
void mainLoop();
void move();
void drawDotArray();
void drawPlayerLine();
void clearPlayerLine();
inline int getScreenX(int x);
inline int getScreenY(int y);
void placeLine();
void nextTurn();
void takeSquare(int x, int y, int currentPlayer);
void choosePlayersMove();
void drawClearLines(int startx, int starty, int endx, int endy);
void drawChoosePlayerDots();
void drawSwitchPlayers();
void drawArtLine(int ax, int ay, int adirection);
void winner();
void saveDot(int x, int y);
void loadBoard();
void clearSave();
void resetScore();

#define DOTSPACING 10
#define BOARDX 60
#define BOARDY 20

#define SAVE_DOTS 32
#define SAVE_SQUARES 256
#define SAVE_IN_GAME 0
#define SAVE_NUM_PLAYERS 1
#define SAVE_PLAYER_TURN 2
#define SAVE_X 3
#define SAVE_Y 4
#define SAVE_DIR 5
#define SAVE_SCORES 6




int players = 2;
#define WHITE 0xFFFF
#define BLACK 0x0000
u16 playerColors[4];
int scores[4];

int x;
int y;
int direction;
int currentPlayer;
int taken;






int main()
{

	while (true) mainLoop();
	return 0;
}

void initEngine()
{
	resetScore();
	direction = HORIZ;
	initGfx();
	setModeBitmapNoFlipping();
	dotsClearDots();
	drawDotArray();
	playerColors[1] = RGB(31,0,0);
	playerColors[2] = RGB(31,31,0);
	playerColors[3] = RGB(0,31,31);
	playerColors[4] = BLACK;
	playerColors[0] = RGB(0,0,31);
}

void resetScore()
{
	int i;

	for (i = 0; i < 5; i++){
		scores[i] = 0;
		saveRam[SAVE_SCORES + i] = 0;
	}
}

void mainLoop()
{
	drawClearLines(0,0,10,10);
	initEngine();
	if (saveRam[SAVE_IN_GAME])
	{
		loadBoard();
	}
	else
	{
		quitLoop = false;
		drawChoosePlayerDots();
		drawSwitchPlayers();
		while (!quitLoop)
		{
			getInput();
			choosePlayersMove();
			waitForRedraw();
			drawGame();
		}
		dotsClearDots();
		drawClearLines(0,0,10,10);
		drawDotArray();
		currentPlayer = 1;
		taken = 0;
		resetScore();
	}
	getInput();
	quitLoop = false;
	drawPlayerLine();
	saveRam[SAVE_IN_GAME] = true;
	saveRam[SAVE_NUM_PLAYERS] = players;
	while(!quitLoop){
		getInput();
		move();
		waitForRedraw();
		drawGame();
	}
	players = 5;
	scores[4] = 500;
	winner();
	players = 2;

}


void drawDotArray()
{
	int cx;
	int cy;
	int max =  DOTSPACING * 10;
	for (cx = BOARDX; cx <= BOARDX + max; cx+=DOTSPACING)
	for (cy = BOARDY; cy <= BOARDY + max; cy+=DOTSPACING)
	{
		drawDot(cx,cy,WHITE);
	}

}

void move()
{
	if (keyPressL() || keyPressR() || keyPressB())
	{
		clearPlayerLine();
		direction = (direction==HORIZ) ? VERT : HORIZ;
		int minus = 0;
		if (direction == HORIZ) minus = 1;
		if (x >= (WIDTH - minus)) x = WIDTH - minus;
		minus = 0;
		if (direction == VERT) minus = 1;
		if (y >= (HEIGHT - minus)) y = HEIGHT - minus;
		drawPlayerLine();
	}

	if (keyPressRight())
	{
		int minus = 0;
		clearPlayerLine();
		x++;
		if (direction == HORIZ) minus = 1;
		if (x >= (WIDTH - minus)) x = WIDTH - minus;
		drawPlayerLine();
	}

	if (keyPressLeft())
	{
		clearPlayerLine();
		x--;
		if (x < 0) x = 0;
		drawPlayerLine();
	}

	if (keyPressDown())
	{
		int minus = 0;
		clearPlayerLine();
		y++;
		if (direction == VERT) minus = 1;
		if (y >= (HEIGHT - minus)) y = HEIGHT - minus;
		drawPlayerLine();
	}

	if (keyPressUp())
	{
		clearPlayerLine();
		y--;
		if (y < 0) y = 0;
		drawPlayerLine();
	}

	if (keyPressA())
	{
		placeLine();
	}

	if (keyPressStart())
	{
		clearSave();
		quitLoop = true;
	}

}

void drawPlayerLine()
{
	//draw a colored thick line from the dot at  x,y
	int tmp;
	int lineColor = playerColors[currentPlayer];
	int pColor = lineColor;

	if (direction == VERT)
	{
		tmp = getScreenX(x);

		if (dot(x,y) & VERT) lineColor = BLACK;

		drawLine(tmp, getScreenY(y)+1,
			 tmp, getScreenY(y+1)-1, lineColor);

		drawLine(tmp+1, getScreenY(y)+1,
			 tmp+1, getScreenY(y+1)-1, pColor);
		drawLine(tmp-1, getScreenY(y)+1,
			 tmp-1, getScreenY(y+1)-1, pColor);

	}
	else
	{
		tmp = getScreenY(y);

		if (dot(x,y) & HORIZ) lineColor = BLACK;

		drawLine(getScreenX(x)+1,   tmp,
			 getScreenX(x+1)-1, tmp, lineColor);


		drawLine(getScreenX(x)+1,   tmp+1,
			 getScreenX(x+1)-1, tmp+1, pColor);
		drawLine(getScreenX(x)+1,   tmp-1,
			 getScreenX(x+1)-1, tmp-1, pColor);


	}
}

void clearPlayerLine()
{
	//draw a thick black line from dot at x,y
	//then, if a line exists from that point, draw it
	int tmp;
	u16 clearColor = BLACK;

	if (direction == VERT)
	{
		tmp = getScreenX(x);
		drawLine(tmp+1, getScreenY(y)+1,
			 tmp+1, getScreenY(y+1)-1, BLACK);
		drawLine(tmp-1, getScreenY(y)+1,
			 tmp-1, getScreenY(y+1)-1, BLACK);

		if (dot(x,y) & VERT) clearColor = WHITE;

		drawLine(tmp, getScreenY(y)+1,
			 tmp, getScreenY(y+1)-1, clearColor);

	}
	else
	{
		tmp = getScreenY(y);
		drawLine(getScreenX(x)+1,   tmp+1,
			 getScreenX(x+1)-1, tmp+1, BLACK);
		drawLine(getScreenX(x)+1,   tmp-1,
			 getScreenX(x+1)-1, tmp-1, BLACK);


		if (dot(x,y) & HORIZ) clearColor = WHITE;

		drawLine(getScreenX(x)+1,   tmp,
			 getScreenX(x+1)-1, tmp, clearColor);
	}
}


void drawOwnedSquare(int x, int y, int player)
{
	int ctr;
	for (ctr = getScreenX(x) + 2; ctr < getScreenX(x+1) - 1; ctr++)
	{
		drawLine(ctr, getScreenY(y)   + 2,
		 	 ctr, getScreenY(y+1) - 2, playerColors[player]);
	}
}

int getScreenX(int x)
{
	return x * DOTSPACING + BOARDX;
}

int getScreenY(int y)
{
	return y * DOTSPACING + BOARDY;
}

void placeLine()
{
	int completed;
	if (!(dot(x,y) & direction)){
		completed = dotsDrawLine(x,y,direction);
		clearPlayerLine();
		if (!completed) nextTurn();
		if (completed & SQUARE_UR) takeSquare(x,y-1, currentPlayer);
		if (completed & SQUARE_LL) takeSquare(x-1,y, currentPlayer);
		if (completed & SQUARE_LR) takeSquare(x,y,   currentPlayer);
		drawPlayerLine();
		saveDot(x,y);
	}
}

void nextTurn()
{
	currentPlayer++;
	if (currentPlayer >= players)
	{
		currentPlayer = 0;
	}
	saveRam[SAVE_PLAYER_TURN] = currentPlayer;
}

void takeSquare(int x, int y, int currentPlayer)
{
	scores[currentPlayer]++;
	drawOwnedSquare(x, y, currentPlayer);
	taken++;
	saveRam[SAVE_SQUARES + x + y * WIDTH] = currentPlayer;
	saveRam[SAVE_SCORES + currentPlayer] = scores[currentPlayer];
	if (taken >= 99)
	{
		winner();
	}
}

void drawClearLines(int startx, int starty, int endx, int endy)
{
	dotsClearDots();
	for (x = startx; x <= endx; x++)
	for (y = starty; y <= endy; y++)
	{
		direction = VERT;
		clearPlayerLine();
		direction = HORIZ;
		clearPlayerLine();
		

	}
	x = 0;
	y = 0;

}

void drawChoosePlayerDots()
{
	currentPlayer = 2;
	//d
	drawArtLine(2,0,VERT);
	drawArtLine(2,1,VERT);
	drawArtLine(1,1,HORIZ);
	drawArtLine(1,1,VERT);
	drawArtLine(1,2,HORIZ);

	//o
	drawArtLine(3,0,VERT);	
	drawArtLine(3,1,VERT);	
	drawArtLine(3,0,HORIZ);	
	drawArtLine(4,0,VERT);	
	drawArtLine(4,1,VERT);	
	drawArtLine(3,2,HORIZ);	

	//t
	drawArtLine(6,0,VERT);	
	drawArtLine(6,1,VERT);	
	drawArtLine(5,1,HORIZ);	
	drawArtLine(6,1,HORIZ);	

	//s
	drawArtLine(8,0,HORIZ);	
	drawArtLine(8,1,HORIZ);	
	drawArtLine(8,2,HORIZ);	
	drawArtLine(8,0,VERT);	
	drawArtLine(9,1,VERT);	
	
	

	




}

void drawSwitchPlayers()
{
	drawClearLines(5,5,10,10);
	x = 5;
	y = 5;
	currentPlayer = players - 1;
	switch (players)
	{

		case 2:
			drawArtLine(5,5,HORIZ);
			drawArtLine(5,6,HORIZ);
			drawArtLine(5,7,HORIZ);
			drawArtLine(6,5,VERT);
			drawArtLine(5,6,VERT);
			break;
		case 3:
			drawArtLine(5,5,HORIZ);
			drawArtLine(5,6,HORIZ);
			drawArtLine(5,7,HORIZ);
			drawArtLine(6,5,VERT);
			drawArtLine(6,6,VERT);
			break;
		case 4:
			drawArtLine(5,5,VERT);
			drawArtLine(6,5,VERT);
			drawArtLine(5,6,HORIZ);
			drawArtLine(6,6,VERT);
			break;

	}
	

}


void choosePlayersMove()
{
	if (keyPressUp())
	{
		swi_vblank();
	}
	if (keyPressRight())
	{
		players++;
		if (players > 4) players = 2;
		drawSwitchPlayers();
	}

	if (keyPressLeft())
	{
		players--;
		if (players < 2) players = 4;
		drawSwitchPlayers();
	}

	if (keyPressA())
	{
		quitLoop = true;
	}

	if (keyPressStart())
	{
		quitLoop = true;
	}


}

void drawArtLine(int ax, int ay, int adirection)
{
	x = ax;
	y = ay;
	direction = adirection;
	drawPlayerLine();
}

void winner()
{
	int p;
	currentPlayer = 0;
	int high = 0;
	int tied = -1;
	for (p = 0; p < players; p++)
	{
		if (scores[p] == high)
		{
			tied = p;
		}
		if (scores[p] > high)
		{
			tied = -1;
			high = scores[p];
			currentPlayer = p;
		}
	}
	for (x = 0; x < 10; x++)
	for (y = 0; y < 10; y++)
	{
		if (tied > -1)
		{
			int tmp = tied;
			tied = currentPlayer;
			currentPlayer = tmp;
		}
		drawOwnedSquare(x, y, currentPlayer);
	}

}

void saveDot(int x, int y)
{
	saveRam[x + y * WIDTH + SAVE_DOTS] = dot(x,y);
	//saveRam[x + y * WIDTH + 32] = 1;
	
}

void loadDots()
{
	int i;
	int j;
	for (i = 0; i <= WIDTH; i++)
	for (j = 0; j <= HEIGHT; j++)
	{
		setDot(i,j,saveRam[i + j * WIDTH + SAVE_DOTS]);
		//setDot(i,j,1);
	}
}

void loadBoard()
{
	int tmp;
	if (saveRam[SAVE_IN_GAME] == false) return;
	players = saveRam[SAVE_NUM_PLAYERS];

	taken = 0;
	for (tmp = 0; tmp < players; tmp++)
	{
		scores[tmp] = saveRam[SAVE_SCORES + tmp];
		taken += scores[tmp];

	}


	loadDots();
	for (x = 0; x < WIDTH; x++)
	for (y = 0; y < HEIGHT; y++)
	{
		direction = VERT;
		clearPlayerLine();
		direction = HORIZ;
		clearPlayerLine();
		tmp = saveRam[SAVE_SQUARES + x + y * WIDTH];
		if ( tmp < 9)
		{
			drawOwnedSquare(x,y,tmp);
		}
		
	}
	x = 0;
	y = 0;

	currentPlayer = saveRam[SAVE_PLAYER_TURN];
	
}

void clearSave()
{
	saveRam[SAVE_IN_GAME] = false;
	int i;
	int j;
	for (i = 0; i <= WIDTH; i++)
	for (j = 0; j <= HEIGHT; j++)
	{
		saveRam[SAVE_DOTS + i + j * WIDTH] = 0;
		saveRam[SAVE_SQUARES + i + j * WIDTH] = 9;
	}

}
