#include "dots.h"

int dotsMap[(WIDTH+1) * (HEIGHT+1)];

int dot(int x, int y)
{
	if ((x < 0) || 
	    (x > WIDTH) ||
	    (y < 0) ||
	    (y > HEIGHT))
	{
		return 0;
	}

	return dotsMap[x + y * HEIGHT];
}

int setDot(int x, int y, int state)
{
	int tmp;

	if ((x < 0) || 
	    (x > WIDTH) ||
	    (y < 0) ||
	    (y > HEIGHT))
	{
		return 0;
	}

	tmp = dot(x,y);

	dotsMap[x + y * HEIGHT] = state;

	return tmp;

}

void dotsClearDots()
{
	int x;
	int y; 

	for (x = 0; x <= WIDTH; x++)
	for (y = 0; y <= HEIGHT; y++)
	{
		dotsMap[x + y * HEIGHT] = 0;
	}
}

bool dotsCheckUpperRight(int x, int y)
{
	//these two depend on the dot next to them, 
	//so they are inclusive
	if (y <= 0) return false;
	if (x >= WIDTH) return false;

	//these two don't, so they are exclusive
	if (x < 0) return false;
	if (y > HEIGHT) return false;

	if ((dot(x,y-1) == (HORIZ | VERT)) &&
	    (dot(x+1,y-1)& VERT) &&
            (dot(x,y)     & HORIZ)
	   )
	{
		return true;
	}

	return false;
}


int dotsDrawLine(int x, int y, int direction)
{
	dotsMap[x + y * HEIGHT] |= direction;	

	int result = 0;

	if (direction == HORIZ) result |= dotsCheckUpperRight(x,y)       ? SQUARE_UR : 0;
	if (direction == VERT)  result |= dotsCheckUpperRight(x-1,y+1)   ? SQUARE_LL : 0;

	result |= dotsCheckUpperRight(x,y+1)  ? SQUARE_LR : 0;

	return result;

}
