#define BG_C

#include "bg.h"


s32 COS[360];
s32 SIN[360];

#define FIXED s32
#define PI 3.14159
#define RADIAN(n) 		(((float)n)/(float)180*PI)

u16* BGPaletteMem ;

u16 bg_tegel_id(u16 x, u16 y)
{
    //return ((y >> 5) << 12) + ((x >> 5) << 10) + ((y&31)<<5) + (x&31) ;
    return (y << 7) + x;
}


void scr_copy(u16 *dest,const u16 *src,int count) {
	while (count--)
		*dest++ = *src++;
}


void scr_palette(int offset,const u16 *palette,int count) {
	u16 *dest = BGPaletteMem;
	do *dest++ = *palette++;
	while (--count);
}

void loadBGPalette(u16 * palette)
{
	scr_palette(0, palette, 256);
}


void loadBGTiles(Bg * bg, u16* gfx, int tileWidth, int tileHeight)
{
	if (!bg){
		return;
	}
	scr_copy(bg->tileData, gfx, tileWidth * tileHeight >> 1);

}

void zeroBGMap(Bg * bg, int mapSize)
{
	u16* dest = bg->mapData;
	mapSize = mapSize * mapSize >> 1;
	while (mapSize--)
		*dest++ = 0;

}

void loadBGMap(Bg * bg, u16 * map, int mapSize)
{
	int count = mapSize * mapSize >> 1;
	u8 * dest = (u8*)bg->mapData;
	u8 * src = (u8*)map;
	if (!bg)
	{
		return;
	}
	scr_copy(bg->mapData, map, mapSize * mapSize >> 1);
	return;
	
	while (count--)
		if ((*src) < 10 )
		{
			*dest++ = 0;
			*src++;
		}
		else
		{
			*dest++ = *src++;
		}
}

bool initBackground(Bg* bg, int layer)
{
	if (!bg)
	{
		return false;
	}
	bg->number = layer;				//background number 0-3
	bg->charBaseBlock = 0;
	bg->screenBaseBlock = 28;
	bg->colorMode = BG_COLOR_256;
	bg->size = ROTBG_SIZE_1024x1024;          //size of map
	bg->mosaic = 0;                         //not enabled
	bg->x_scroll = 0;			//scrolling variables
	bg->y_scroll = 0;
	bg->collisionTileStart = 29;

	return true;
}

void enableBackground(Bg* bg)
{
#ifndef NOHARDWARE

	u16 temp;
	u16 loop;

	//compute my Look up tables (Rotation stuff again)
	for(loop = 0; loop < 1; loop++)
	{
		SIN[loop] = (FIXED)(sin(RADIAN(loop)) * 256);  //sin and cos are computed and cast to fixed							//fixed
		COS[loop] = (FIXED)(cos(RADIAN(loop)) * 256);

	}


	bg->tileData = (u16*)CharBaseBlock(bg->charBaseBlock);
	bg->mapData = (u16*)ScreenBaseBlock(bg->screenBaseBlock);
	temp = bg->size | (bg->charBaseBlock<<CHAR_SHIFT) | (bg->screenBaseBlock<<SCREEN_SHIFT)
		| bg->colorMode | bg->mosaic | bg->wraparound;

	switch(bg->number)
	{
	case 0:
		{
			REG_BG0CNT = temp;
			REG_DISPCNT |= BG0_ENABLE;
		}break;
	case 1:
		{
			REG_BG1CNT = temp;
			REG_DISPCNT |= BG1_ENABLE;
		}break;
	case 2:
		{
			REG_BG2CNT = temp;
			REG_DISPCNT |= BG2_ENABLE;
		}break;
	case 3:
		{
			REG_BG3CNT = temp;
			REG_DISPCNT |= BG3_ENABLE;
		}break;

	default:break;

	}
#endif
}

void updateBackground(Bg* bg)
{
#ifndef NOHARDWARE
	switch(bg->number)
	{
	case 0:
		REG_BG0HOFS = bg->x_scroll;
		REG_BG0VOFS = bg->y_scroll;
		break;
	case 1:
		REG_BG1HOFS = bg->x_scroll;
		REG_BG1VOFS = bg->y_scroll;
		break;
	case 2:
		if(!(REG_DISPCNT & MODE_0))//it is a rot background
		{
			REG_BG2X = bg->DX;
			REG_BG2Y = bg->DY;

			REG_BG2PA = bg->PA;
			REG_BG2PB = bg->PB;
			REG_BG2PC = bg->PC;
			REG_BG2PD = bg->PD;
		}
		else  //it is a text background
		{
			REG_BG2HOFS = bg->x_scroll;
			REG_BG2VOFS = bg->y_scroll;
		}
		break;
	case 3:
		if(!(REG_DISPCNT & MODE_0))//it is a rot background
		{
			REG_BG3X = bg->DX;
			REG_BG3Y = bg->DY;

			REG_BG3PA = bg->PA;
			REG_BG3PB = bg->PB;
			REG_BG3PC = bg->PC;
			REG_BG3PD = bg->PD;
		}
		else //it is a text background
		{
			REG_BG3HOFS = bg->x_scroll;
			REG_BG3VOFS = bg->y_scroll;
		}
		break;
	default: break;
	}
#endif
}

void rotateBackground(Bg* bg, int angle,int center_x, int center_y, int zoom)
{
#ifndef NOHARDWARE

	center_y = (center_y * zoom)>>8;
	center_x = (center_x * zoom)>>8;

	bg->DX = ((bg->x_scroll<<8)-center_y*SIN[angle]-center_x*COS[angle]);
	bg->DY = ((bg->y_scroll<<8)-center_y*COS[angle]+center_x*SIN[angle]);

	bg->PA = (COS[angle]*zoom)>>8;  //cos&sin are LUTs that are .8 fixed numbers
	bg->PB = (SIN[angle]*zoom)>>8;  //zoom is also fixed
	bg->PC = (-SIN[angle]*zoom)>>8;
	bg->PD = (COS[angle]*zoom)>>8;

#endif
}

bool BGCollision(Bg * bg, int x, int y)
{
	u8 * md = (u8*)(bg->mapData);
	if (md[bg_tegel_id(x,y)] >= bg->collisionTileStart)
	{
		return true;
	}
	if (md[bg_tegel_id(x,y)] <= 22)
	{
		return true;
	}
	return false;
};
