#ifndef BG_H
#define BG_H

#include "gbaHardware.h"

///BGCNT defines ///
#define BG_MOSAIC_ENABLE		0x40
#define BG_COLOR_256			0x80
#define BG_COLOR_16			0x0

#define CharBaseBlock(n)		(((n)*0x4000)+0x6000000)
#define ScreenBaseBlock(n)		(((n)*0x800)+0x6000000)

#define CHAR_SHIFT			2
#define SCREEN_SHIFT			8
#define TEXTBG_SIZE_256x256		0x0
#define TEXTBG_SIZE_256x512		0x8000
#define TEXTBG_SIZE_512x256		0x4000
#define TEXTBG_SIZE_512x512		0xC000

#define ROTBG_SIZE_128x128		0x0
#define ROTBG_SIZE_256x256		0x4000
#define ROTBG_SIZE_512x512		0x8000
#define ROTBG_SIZE_1024x1024		0xC000

#define WRAPAROUND              	0x1

typedef struct Bg
{
	u16* tileData;
	u16* mapData;
	u8 mosaic;
	u8 colorMode;
	u8 number;
	u16 size;
	u8 charBaseBlock;
	u8 screenBaseBlock;
	u8 wraparound;
	s16 x_scroll,y_scroll;
	s32 DX,DY;
	s16 PA,PB,PC,PD;
	u8 collisionTileStart;
}Bg;

#ifndef BG_C
extern void enableBackground(Bg* bg);
extern void rotateBackground(Bg* bg, int angle, int center_x, int center_y, int zoom);
extern void updateBackground(Bg* bg);
extern bool initBackground(Bg* bg, int layer);
extern void loadBGPalette(u16 * palette);
extern void loadBGTiles(Bg * bg, u16* gfx, int tileWidth, int tileHeight);
extern void loadBGMap(Bg * bg, u16* map, int mapSize);
extern bool BGCollision(Bg * bg, int x, int y);
#endif
#endif
