//AGB_Rogue was adapted from IBM(TM) PC Rogue version 1.48
//by Donnie Russell, Copyright (C) 2007



#define VERSION_MESSAGE  "AGB_Rogue 1.21"



// ###   ###   ###  #   # #####
// #  # #   # #   # #   # #
// #  # #   # #   # #   # #
// ###  #   # #     #   # ###
// #  # #   # #  ## #   # #
// #  # #   # #   # #   # #
// #  #  ###   ###   ###  #####
//
//Exploring the Dungeons of Doom
//Copyright (C) 1981 by Michael Toy, Ken Arnold, and Glenn Wichman
//Copyright (C) 1983 by Mel Sibony, Jon Lane (A.I. Design update for the IBM PC)
//All rights reserved

//Original source files used in this adaptation:

//armor.c      1.2   (A.I. Design)   2/12/84  This file contains misc functions for dealing with armor
//chase.c      1.32  (A.I. Design)  12/12/84  Code for one creature to chase another
//command.c    1.44  (A.I. Design)   2/14/85  Read and execute the user commands
//daemon.c     5.2   (Berkeley)      6/18/82  Contains functions for dealing with things that happen in the future
//daemons.c    5.1   (Berkeley)      5/11/82  All the daemon and fuse functions are in here
//extern.c     5.2   (Berkeley)      6/16/82  Global variable initialization
//fight.c      1.43  (A.I. Design)   1/19/85  All the fighting gets done here
//init.c       1.4   (A.I. Design)  12/14/84  Global variable initialization
//io.c         1.4   (A.I. Design)  12/10/84  Various input/output functions
//list.c       1.4   (A.I. Design)  12/ 5/85  Functions for dealing with linked lists of goodies
//mach_dep.c   1.4   (A.I. Design)  12/ 1/84  Various installation dependent routines
//main.c       1.4   (A.I. Design)  11/28/84
//maze.c       1.4   (A.I. Design)  12/14/84  Maze drawing routines. Based on the algorithm presented in the December 1981 Byte "How to Build a Maze" by David Matuszek
//misc.c       1.4   (A.I. Design)  12/14/84  All sorts of miscellaneous routines
//monsters.c   1.4   (A.I. Design)  12/14/84  File with various monster functions in it
//move.c       1.4   (A.I. Design)  12/22/84  Hero movement commands
//new_level.c  1.4   (A.I. Design)  12/13/84  Dig and draw a new level
//pack.c       1.4   (A.I. Design)  12/14/84  Routines to deal with the pack
//passages.c   1.4   (A.I. Design)  12/14/84  Draw the connecting passages
//potions.c    1.4   (A.I. Design)   2/12/84  Function(s) for dealing with potions
//rings.c      1.4   (A.I. Design)  12/13/84  Routines dealing specifically with rings
//rip.c        1.4   (A.I. Design)  12/14/84  File for the fun ends. Death or a total win
//rooms.c      1.4   (A.I. Design)  12/16/84  Create the layout for the new level
//save.c       1.32  (A.I. Design)  12/13/84  Save and restore routines
//scrolls.c    1.4   (A.I. Design)  12/14/84  Read a scroll and let it happen
//slime.c      1.42  (A.I. Design)   1/17/85  Code for handling the various special properties of the slime
//sticks.c     1.2   (A.I. Design)   2/12/84  Functions to implement the various sticks one might find while wandering around the dungeon
//things.c     1.4   (A.I. Design)  12/14/84  Contains functions for dealing with things like potions, scrolls, and other items
//weapons.c    1.4   (A.I. Design)  12/22/84  Functions for dealing with problems brought about by weapons
//wizard.c     1.4   (A.I. Design)  12/14/84  Special wizard commands (some of which are also non-wizard commands under strange circumstances)
//rogue.h      1.4   (A.I. Design)  12/14/84  Rogue definitions and variable declarations



#include <stdlib.h> //atoi
#include <stdio.h>  //sprintf
#include <string.h> //strcat strchr strlen
#include <ctype.h>  //isalpha isdigit isupper islower isspace isprint toascii toupper tolower

#include "inc.h"



extern unsigned short savewin[]; //defined in console.c; in saved state
extern unsigned char _flags[];   //defined in console.c; in saved state
extern unsigned char _level[];   //defined in console.c; in saved state

extern int display_credits_flag;



#define CURSOR_CHAR  177 //used for input cursor

typedef struct {int x; int y;} coord;

#define MAXROOMS      9
#define MAXTHINGS     9
#define MAXOBJ        9
#define MAXPACK      22
#define MAXTRAPS     10
#define AMULETLEVEL  26
#define NUMTHINGS     7 //number of types of things
#define MAXPASS      13 //upper limit on number of passages
#define MAXNAME      20 //Maximum Length of a scroll
#define MAXITEMS     83 //Maximum number of randomly generated things
#define TOPSCORES    10
#define MAXSTR       80
#define MSGSIZE     128
#define MAXDAEMONS   20
#define MAXATTR      17
#define MAXFRNT     100 //maze
#define DRAGONSHOT    5 //one chance in DRAGONSHOT that a dragon will flame
#define GOLDGRP       1
#define TREAS_ROOM   20 //one chance in TREAS_ROOM for a treasure room
#define MAXTREAS     10 //maximum number of treasures in a treasure room
#define MINTREAS      2 //minimum number of treasures in a treasure room
#define MAXTRIES     10 //max number of tries to put down a monster

#define clearmsg()            {move(0, 0); clrtoeol(); mpos = 0;}
#define msg(fmt, args...)     {sprintf(&msgbuf[io_newpos], fmt , ## args); io_newpos = strlen(msgbuf); endmsg();}
#define addmsg(fmt, args...)  {sprintf(&msgbuf[io_newpos], fmt , ## args); io_newpos = strlen(msgbuf);}
#define printw(fmt, args...)  {sprintf(pwbuf, fmt , ## args); addstr(pwbuf);}
#define bcopy(b, a)           b = a
#define MAX2(a,b)             ((a)>(b)?(a):(b))
#define MAX4(a,b,c,d)         (a>b?(a>c?(a>d?a:d):(c>d?c:d)):(b>c?(b>d?b:d):(c>d?c:d)))
#define abs(x)                ((x)<0?-(x):(x))
#define ce(a,b)               _ce(&(a),&(b))
#define attach(a,b)           _attach(&a,b)
#define detach(a,b)           _detach(&a,b)
#define free_list(a)          _free_list(&a)
#define on(thing,flag)        (((thing).t_flags&(flag))!=0)
#define GOLDCALC              (rnd(50+10*level)+2)
#define ISRING(h,r)           (cur_ring[h]!=0 && cur_ring[h]->o_which==r)
#define ISWEARING(r)          (ISRING(LEFT,r) || ISRING(RIGHT,r))
#define ISMULT(type)          (type==POTION || type==SCROLL || type==FOOD || type==GOLD)
#define chat(y,x)             (_level[INDEX(y,x)])
#define flat(y,x)             (_flags[INDEX(y,x)])
#define unc(cp)               (cp).y,(cp).x
#define isfloor(c)            ((c)==FLOOR || (c)==PASSAGE)
#define isgone(rp)            (((rp)->r_flags&ISGONE) && ((rp)->r_flags&ISMAZE)==0)

#define PASSAGE   (0xb1)
#define DOOR      (0xce)
#define FLOOR     (0xfa)
#define PLAYER    (0x01)
#define TRAP      (0x04)
#define STAIRS    (0xf0)
#define GOLD      (0x0f)
#define POTION    (0xad)
#define SCROLL    (0x0d)
#define FOOD      (0x05)
#define STICK     (0xe7)
#define ARMOR     (0x08)
#define AMULET    (0x0c)
#define RING      (0x09)
#define WEAPON    (0x18)
#define VWALL     (0xba)
#define HWALL     (0xcd)
#define ULWALL    (0xc9)
#define URWALL    (0xbb)
#define LLWALL    (0xc8)
#define LRWALL    (0xbc)
#define MAGIC     '$'
#define BMAGIC    '+'
#define CALLABLE  -1

#define BEARTIME     spread(3)
#define SLEEPTIME    spread(5)
#define HEALTIME     spread(30)
#define HOLDTIME     spread(2)
#define WANDERTIME   spread(70)
#define HUHDURATION  spread(20)
#define SEEDURATION  spread(300)
#define HUNGERTIME   spread(1300)
#define MORETIME     150
#define STOMACHSIZE  2000
#define STARVETIME   850
#define ESCAPE       27
#define LEFT         0
#define RIGHT        1
#define BOLT_LENGTH  6
#define LAMPDIST     3

#define VS_POISON        00
#define VS_PARALYZATION  00
#define VS_LUCK          01
#define VS_DEATH         00
#define VS_BREATH        02
#define VS_MAGIC         03

#define ISDARK  0x0001 //room is dark
#define ISGONE  0x0002 //room is gone (a corridor)
#define ISMAZE  0x0004 //room is a maze

#define ISCURSED  0x0001 //object is cursed
#define ISKNOW    0x0002 //player knows details about the object
#define DIDFLASH  0x0004 //has the vorpal weapon flashed
#define ISEGO     0x0008 //weapon has control of player
#define ISMISL    0x0010 //object is a missile type
#define ISMANY    0x0020 //object comes in groups
#define ISREVEAL  0x0040 //Do you know who the enemy of the object is

#define ISBLIND   0x0001 //creature is blind
#define SEEMONST  0x0002 //hero can detect unseen monsters
#define ISRUN     0x0004 //creature is running at the player
#define ISFOUND   0x0008 //creature has been seen (used for objects)
#define ISINVIS   0x0010 //creature is invisible
#define ISMEAN    0x0020 //creature can wake when player enters room
#define ISGREED   0x0040 //creature runs to protect gold
#define ISHELD    0x0080 //creature has been held
#define ISHUH     0x0100 //creature is confused
#define ISREGEN   0x0200 //creature can regenerate
#define CANHUH    0x0400 //creature can confuse
#define CANSEE    0x0800 //creature can see invisible creatures
#define ISCANC    0x1000 //creature has special qualities cancelled
#define ISSLOW    0x2000 //creature has been slowed
#define ISHASTE   0x4000 //creature has been hastened
#define ISFLY     0x8000 //creature is of the flying type

#define F_PASS   0x040 //is a passageway
#define F_MAZE   0x020 //have seen this corridor before
#define F_REAL   0x010 //what you see is what you get
#define F_PNUM   0x00f //passage number mask
#define F_TMASK  0x007 //trap number mask

#define T_DOOR   00
#define T_ARROW  01
#define T_SLEEP  02
#define T_BEAR   03
#define T_TELEP  04
#define T_DART   05
#define NTRAPS   6

#define P_CONFUSE   0
#define P_PARALYZE  1
#define P_POISON    2
#define P_STRENGTH  3
#define P_SEEINVIS  4
#define P_HEALING   5
#define P_MFIND     6
#define P_TFIND     7
#define P_RAISE     8
#define P_XHEAL     9
#define P_HASTE     10
#define P_RESTORE   11
#define P_BLIND     12
#define P_NOP       13
#define MAXPOTIONS  14

#define S_CONFUSE   0
#define S_MAP       1
#define S_HOLD      2
#define S_SLEEP     3
#define S_ARMOR     4
#define S_IDENT     5
#define S_SCARE     6
#define S_GFIND     7
#define S_TELEP     8
#define S_ENCH      9
#define S_CREATE    10
#define S_REMOVE    11
#define S_AGGR      12
#define S_NOP       13
#define S_VORPAL    14
#define MAXSCROLLS  15

#define MACE        0
#define SWORD       1
#define BOW         2
#define ARROW       3
#define DAGGER      4
#define TWOSWORD    5
#define DART        6
#define CROSSBOW    7
#define BOLT        8
#define SPEAR       9
#define FLAME       10 //fake entry for dragon breath (ick)
#define MAXWEAPONS  10 //this should equal FLAME

#define LEATHER          0
#define RING_MAIL        1
#define STUDDED_LEATHER  2
#define SCALE_MAIL       3
#define CHAIN_MAIL       4
#define SPLINT_MAIL      5
#define BANDED_MAIL      6
#define PLATE_MAIL       7
#define MAXARMORS        8

#define R_PROTECT   0
#define R_ADDSTR    1
#define R_SUSTSTR   2
#define R_SEARCH    3
#define R_SEEINVIS  4
#define R_NOP       5
#define R_AGGR      6
#define R_ADDHIT    7
#define R_ADDDAM    8
#define R_REGEN     9
#define R_DIGEST    10
#define R_TELEPORT  11
#define R_STEALTH   12
#define R_SUSTARM   13
#define MAXRINGS    14

#define WS_LIGHT      0
#define WS_HIT        1
#define WS_ELECT      2
#define WS_FIRE       3
#define WS_COLD       4
#define WS_POLYMORPH  5
#define WS_MISSILE    6
#define WS_HASTE_M    7
#define WS_SLOW_M     8
#define WS_DRAIN      9
#define WS_NOP        10
#define WS_TELAWAY    11
#define WS_TELTO      12
#define WS_CANCEL     13
#define MAXSTICKS     14

#define hero        player.t_pos
#define pstats      player.t_stats
#define max_hp      player.t_stats.s_maxhp
#define pack        player.t_pack
#define proom       player.t_room
#define next(ptr)   (*ptr).l_next
#define prev(ptr)   (*ptr).l_prev
#define l_next      _t._l_next
#define l_prev      _t._l_prev
#define t_pos       _t._t_pos
#define t_turn      _t._t_turn
#define t_type      _t._t_type
#define t_disguise  _t._t_disguise
#define t_oldch     _t._t_oldch
#define t_dest      _t._t_dest
#define t_flags     _t._t_flags
#define t_stats     _t._t_stats
#define t_pack      _t._t_pack
#define t_room      _t._t_room
#define o_type      _o._o_type
#define o_pos       _o._o_pos
#define o_text      _o._o_text
#define o_launch    _o._o_launch
#define o_damage    _o._o_damage
#define o_hurldmg   _o._o_hurldmg
#define o_count     _o._o_count
#define o_which     _o._o_which
#define o_hplus     _o._o_hplus
#define o_dplus     _o._o_dplus
#define o_ac        _o._o_ac
#define o_flags     _o._o_flags
#define o_group     _o._o_group
#define o_enemy     _o._o_enemy
#define o_charges   o_ac
#define o_goldval   o_ac

struct magic_item {char *mi_name; int mi_prob; short mi_worth;};

struct name {char name[MAXNAME+1];};

//Room structure
struct room
{
  coord r_pos;      //Upper left corner
  coord r_max;      //Size of room
  coord r_gold;     //Where the gold is
  int r_goldval;    //How much the gold is worth
  short r_flags;    //Info about the room
  int r_nexits;     //Number of exits
  coord r_exit[12]; //Where the exits are
};

//Structure describing a fighting being
struct stats
{
  unsigned int s_str; //Strength
  int s_exp;          //Experience
  int s_lvl;          //Level of mastery
  int s_arm;          //Armor class
  int s_hpt;          //Hit points
  char *s_dmg;        //String describing damage done
  int s_maxhp;        //Max hit points
};

//Structure for monsters and player
union thing
{
  struct
  {
    union thing *_l_next, *_l_prev; //Next pointer in link
    coord _t_pos;                   //Position
    char _t_turn;                   //If slowed, is it a turn to move
    char _t_type;                   //What it is
    unsigned char _t_disguise;      //What mimic looks like
    unsigned char _t_oldch;         //Character that was where it was
    coord *_t_dest;                 //Where it is running to
    short _t_flags;                 //State word
    struct stats _t_stats;          //Physical description
    struct room *_t_room;           //Current room for thing
    union thing *_t_pack;           //What the thing is carrying
  } _t;
  struct
  {
    union thing *_l_next, *_l_prev; //Next pointer in link
    int _o_type;                    //What kind of object it is
    coord _o_pos;                   //Where it lives on the screen
    char *_o_text;                  //What it says if you read it
    char _o_launch;                 //What you need to launch it
    char *_o_damage;                //Damage if used like sword
    char *_o_hurldmg;               //Damage if thrown
    int _o_count;                   //Count for plural objects
    int _o_which;                   //Which object of a type it is
    int _o_hplus;                   //Plusses to hit
    int _o_dplus;                   //Plusses to damage
    short _o_ac;                    //Armor class
    short _o_flags;                 //Information about objects
    char _o_enemy;                  //If it is enchanted, who it hates
    int _o_group;                   //Group number for this object
  } _o;
};
typedef union thing THING;

//Array containing information on all the various types of monsters
struct monster
{
  char *m_name;         //What to call the monster
  int m_carry;          //Probability of carrying something
  short m_flags;        //Things about the monster
  struct stats m_stats; //Initial stats
};

struct sc_ent {char sc_name[38]; int sc_rank; int sc_gold; int sc_fate; int sc_level;};

struct init_weps
{
  char *iw_dam;   //Damage when wielded
  char *iw_hrl;   //Damage when thrown
  char iw_launch; //Launching weapon
  int iw_flags;   //Miscellaneous flags
};

struct delayed_action {int (*d_func)(int); int d_arg; int d_time;};

/////////////////////////////////////////////////////////////////////////////
void mvaddstr(int r, int c, char *s);
void mvaddch(int r, int c, char chr);
int mvinch(int r, int c);
int inch(void);
void addch(unsigned char chr);
void addstr(char *s);
void box(int ul_r, int ul_c, int lr_r, int lr_c);
void center(int row, char *string);
int getinfo(char *str, int size);
void flush_type(void);
int readchar(void);
void status(void);

void new_level(void);
void credits(void);
void quit(void);
void death(char monst);
char *killname(char monst, unsigned char doart);
void total_winner(void);

void seedMT(unsigned int seed);
unsigned int reloadMT(void);
unsigned int randomMT(void);
unsigned int rangeMT(unsigned int lower, unsigned int upper);
int rnd(int range);
int roll(int number, int sides);

void wear(void);
void take_off(void);
void waste_time(void);

void do_chase(THING *th);
int see_monst(THING *mp);
void start_run(coord *runner);
void chase(THING *tp, coord *ee);
struct room *roomin(coord *cp);
int diag_ok(coord *sp, coord *ep);
int cansee(int y, int x);
coord *find_dest(THING *tp);

void command(void);
int com_char(void);
int get_prefix(void);
void execcom(void);

struct delayed_action *d_slot(void);
struct delayed_action *find_slot(int (*func)(int));
void daemon(int (*func)(int), int arg);
void do_daemons(void);
void fuse(int (*func)(int), int arg, int time);
void lengthen(int (*func)(int), int xtime);
void extinguish(int (*func)(int));
void do_fuses(void);

int doctor(int dummy);
int swander(int dummy);
int rollwand(int dummy);
int unconfuse(int dummy);
int unsee(int dummy);
int sight(int dummy);
int nohaste(int dummy);
int stomach(int dummy);
int runners(int dummy);
int turn_see(int turn_off);

int fight(coord *mp, char mn, THING *weap, unsigned char thrown);
void attack(THING *mp);
int swing(int at_lvl, int op_arm, int wplus);
void check_level(void);
int roll_em(THING *thatt, THING *thdef, THING *weap, unsigned char hurl);
char *prname(char *who, unsigned char upper);
void hit(char *er, char *ee);
void miss(char *er, char *ee);
int save_throw(int which, THING *tp);
int save(int which);
int str_plus(unsigned int str);
int add_dam(unsigned int str);
void raise_level(void);
void thunk(THING *weap, char *mname, char *does, char *did);
void remove_monster(coord *mp, THING *tp, unsigned char waskill);
int is_magic(THING *obj);
void killed(THING *tp, unsigned char pr);

void init_player(void);
void init_colors(void);
void init_names(void);
void init_stones(void);
void init_materials(void);

void _detach(THING **list, THING *item);
void _attach(THING **list, THING *item);
void _free_list(THING **ptr);
THING *talloc(void);
THING *new_item(void);
int discard(THING *item);

void draw_maze(struct room *rp);

char *tr_name(unsigned char type);
void look(unsigned char wakeup);
THING *find_obj(int y, int x);
void eat(void);
void chg_str(int amt);
void add_str(unsigned int *sp, int amt);
int add_haste(unsigned char potion);
void aggravate(void);
char *vowelstr(char *str);
int is_current(THING *obj);
int get_dir(void);
int find_dir(unsigned char ch, coord *cp);
int sign(int nm);
int spread(int nm);
void call_it(unsigned char know, char **guess);
int step_ok(int ch);
int goodch(THING *obj);
void help(int num);
int DISTANCE(int y1, int x1, int y2, int x2);
int _ce(coord *a, coord *b);
int INDEX(int y, int x);
int offmap(int y, int x);
int winat(int y, int x);
void search(void);
void d_level(void);
void u_level(void);
void call(void);
void do_macro(void);

int randmonster(unsigned char wander);
void new_monster(THING *tp, unsigned char type, coord *cp);
void f_restor(void);
int exp_add(THING *tp);
void wanderer(void);
THING *wake_monster(int y, int x);
void give_pack(THING *tp);
int pick_mons(void);
THING *moat(int my, int mx);

void do_run(unsigned char ch);
void do_move(int dy, int dx);
void door_open(struct room *rp);
int be_trapped(coord *tc);
void descend(char *mesg);
void rndmove(THING *who, coord *newmv);

int rnd_room(void);
void put_things(void);
void treas_room(void);

THING *pack_obj(unsigned char ch, unsigned char *chp);
void add_pack(THING *obj, unsigned char silent);
int inventory(int type, char *purpose);
void pick_up(unsigned char ch);
THING *get_item(char *purpose, int type);
int pack_char(THING *obj);
void money(int value);

void conn(int r1, int r2);
void do_passages(void);
void door(struct room *rm, coord *cp);
void passnum(void);
void numpass(int y, int x);
void psplat(int y, int x);

void quaff(void);
void invis_on(void);
void th_effect(THING *obj, THING *tp);

void ring_on(void);
void ring_off(void);
int gethand(void);
int ring_eat(int hand);
char *ring_num(THING *obj);

void do_rooms(void);
void draw_room(struct room *rp);
void vert(struct room *rp, int startx);
void horiz(struct room *rp, int starty);
void rnd_pos(struct room *rp, coord *cp);
void enter_room(coord *cp);
void leave_room(coord *cp);

void read_scroll(void);

void slime_split(THING *tp);
int new_slime(THING *tp);
int plop_monster(int r, int c, coord *cp);

void fix_stick(THING *cur);
void do_zap(void);
void drain(void);
void fire_bolt(coord *start, coord *dir, char *name);
char *charge_str(THING *obj);

char *inv_name(THING *obj, unsigned char drop);
void drop(void);
int can_drop(THING *op);
THING *new_thing(void);
int pick_one(struct magic_item *magic, int nitems);
void discovered(void);
void print_disc(unsigned char type);
void set_order(short *order, int numthings);
int add_line(char *use, char *fmt, char *arg);
int end_line(char *use);
char *nothing(unsigned char type);

void missile(int ydelta, int xdelta);
void do_motion(THING *obj, int ydelta, int xdelta);
char *short_name(THING *obj);
void fall(THING *obj, unsigned char pr);
void init_weapon(THING *weap, unsigned char type);
int hit_monster(int y, int x, THING *obj);
char *num(int n1, int n2, char type);
void wield(void);
int fallpos(THING *obj, coord *newpos);

void whatis(void);
int teleport(void);
void create_obj(void);
void show_map(void);
void add_pass(void);

void endmsg(void);
void more(char *msg);
void putmsg(int msgline, char *msg);
void scrl(int msgline, char *str1, char *str2);
char *unctrl(unsigned char ch);
void str_attr(char *str);

void save_game(void);
int restore_game(void);

void score(int amount, int flags, char monst);
void pr_scores(int newrank, struct sc_ent *top10);
int add_scores(struct sc_ent *newscore, struct sc_ent *oldlist);
/////////////////////////////////////////////////////////////////////////////

//...........................................................................
char *helpcoms[] =
{
  "space  clear [More]",
  "+      <dir> throw",
  "-      <dir> zap wand",
  ".      rest",
  "/      list symbols",
  "<      go up",
  ">      go down",
  "?      list commands",
  "B      run down & left",
  "D      list discoveries",
  "H      run left",
  "J      run down",
  "K      run up",
  "L      run right",
  "N      run down & right",
  "P      put on ring",
  "Q      quit",
  "R      remove ring",
  "S      save and halt game",
  "T      take off armor",
  "U      run up & right",
  "W      wear armor",
  "Y      run up & left",
  "^      identify trap",
  "a      repeat command",
  "b      down & left",
  "c      rename",
  "d      drop",
  "e      eat food",
  "f      <dir> find",
  "h      left",
  "i      inventory",
  "j      down",
  "k      up",
  "l      right",
  "n      down & right",
  "q      quaff potion",
  "r      read scroll",
  "s      search",
  "t      <dir> throw",
  "u      up & right",
  "v      show version",
  "w      wield weapon",
  "y      up & left",
  "z      <dir> zap wand",
  0
};

char *helpobjs[] =
{
  "\xb2      passage",
  "\xfa      floor",
  "\xcd      horizontal wall",
  "\xba      vertical wall",
  "\xc9      wall corner",
  "\xbb      wall corner",
  "\xc8      wall corner",
  "\xbc      wall corner",
  "\xce      door",
  "\xf0      stairs",
  "\x04      trap",
  "\x1      hero",
  "\x5      food",
  "\xad      potion",
  "\xd      scroll",
  "\xe7      staff",
  "\x9      ring",
  "\x18      weapon",
  "\x8      armor",
  "\xf      gold",
  "\xc      amulet of yendor",
  "$,+    safe/perilous magic",
  "A-Z    26 monsters",
  0
};

char *he_man[] =
{
  "",             "Guild Novice", "Apprentice",   "Journeyman",
  "Adventurer",   "Fighter",      "Warrior",      "Rogue",
  "Champion",     "Master Rogue", "Warlord",      "Hero",
  "Guild Master", "Dragonlord",   "Wizard",       "Rogue Geek",
  "Rogue Addict", "Schmendrick",  "Gunfighter",   "Time Waster",
  "Bug Chaser"
};

//venus flytrap: the damage is %%% so that it won't merge
//with other strings, since it is written later in the program
struct monster monsters[26] =
{
  // Name           CARRY                  FLAG   str,  exp,lvl,amr,hpt, dmg
  { "aquator",          0,               ISMEAN, { 10,   20,  5,  2,  1, "0d0/0d0"         } },
  { "bat",              0,                ISFLY, { 10,    1,  1,  3,  1, "1d2"             } },
  { "centaur",         15,                    0, { 10,   25,  4,  4,  1, "1d6/1d6"         } },
  { "dragon",         100,               ISMEAN, { 10, 6800, 10, -1,  1, "1d8/1d8/3d10"    } },
  { "emu",              0,               ISMEAN, { 10,    2,  1,  7,  1, "1d2"             } },
  { "venus flytrap",    0,               ISMEAN, { 10,   80,  8,  3,  1, "%%%d0"           } },
  { "griffin",         20, ISMEAN|ISFLY|ISREGEN, { 10, 2000, 13,  2,  1, "4d3/3d5/4d3"     } },
  { "hobgoblin",        0,               ISMEAN, { 10,    3,  1,  5,  1, "1d8"             } },
  { "ice monster",      0,               ISMEAN, { 10,   15,  1,  9,  1, "1d2"             } },
  { "jabberwock",      70,                    0, { 10, 4000, 15,  6,  1, "2d12/2d4"        } },
  { "kestral",          0,         ISMEAN|ISFLY, { 10,    1,  1,  7,  1, "1d4"             } },
  { "leprechaun", ISGREED,                    0, { 10,   10,  3,  8,  1, "1d2"             } },
  { "medusa",          40,               ISMEAN, { 10,  200,  8,  2,  1, "3d4/3d4/2d5"     } },
  { "nymph",          100,                    0, { 10,   37,  3,  9,  1, "0d0"             } },
  { "orc",             15,              ISGREED, { 10,    5,  1,  6,  1, "1d8"             } },
  { "phantom",          0,              ISINVIS, { 10,  120,  8,  3,  1, "4d4"             } },
  { "quagga",          30,               ISMEAN, { 10,   32,  3,  2,  1, "1d2/1d2/1d4"     } },
  { "rattlesnake",      0,               ISMEAN, { 10,    9,  2,  3,  1, "1d6"             } },
  { "slime",            0,               ISMEAN, { 10,    1,  2,  8,  1, "1d3"             } },
  { "troll",           50,       ISREGEN|ISMEAN, { 10,  120,  6,  4,  1, "1d8/1d8/2d6"     } },
  { "ur-vile",          0,               ISMEAN, { 10,  190,  7, -2,  1, "1d3/1d3/1d3/4d6" } },
  { "vampire",         20,       ISREGEN|ISMEAN, { 10,  350,  8,  1,  1, "1d10"            } },
  { "wraith",           0,                    0, { 10,   55,  5,  4,  1, "1d6"             } },
  { "xeroc",           30,                    0, { 10,  100,  7,  7,  1, "3d4"             } },
  { "yeti",            30,                    0, { 10,   50,  4,  6,  1, "1d6/1d6"         } },
  { "zombie",           0,               ISMEAN, { 10,    6,  2,  8,  1, "1d8"             } }
};

struct init_weps init_dam[MAXWEAPONS] =
{
  {"2d4", "1d3", 100,      0            }, //Mace
  {"3d4", "1d2", 100,      0            }, //Long sword
  {"1d1", "1d1", 100,      0            }, //Bow
  {"1d1", "2d3", BOW,      ISMANY|ISMISL}, //Arrow
  {"1d6", "1d4", 100,      ISMISL       }, //Dagger
  {"4d4", "1d2", 100,      0            }, //2h sword
  {"1d1", "1d3", 100,      ISMANY|ISMISL}, //Dart
  {"1d1", "1d1", 100,      0            }, //Crossbow
  {"1d2", "2d5", CROSSBOW, ISMANY|ISMISL}, //Crossbow bolt
  {"2d3", "1d6", 100,      ISMISL       }  //Spear
};

//weapons
char *w_names[MAXWEAPONS+1] =
{
  "mace",             "long sword",       "short bow",
  "arrow",            "dagger",           "two handed sword",
  "dart",             "crossbow",         "crossbow bolt",
  "spear",            0 //filled in when needed
};

//armor
char *a_names[MAXARMORS] =
{
  "leather armor",         "ring mail",             "studded leather armor",
  "scale mail",            "chain mail",            "splint mail",
  "banded mail",           "plate mail"
};
int a_chances[MAXARMORS] = {20, 35, 50, 63, 75, 85, 95, 100};
int a_class[MAXARMORS] = {8, 7, 7, 6, 5, 4, 4, 3};

struct magic_item s_magic[MAXSCROLLS] =
{
  {"monster confusion",    8, 140}, {"magic mapping",       13, 150},
  {"hold monster",        16, 180}, {"sleep",               21,   5},
  {"enchant armor",       29, 160}, {"identify",            56, 100},
  {"scare monster",       60, 200}, {"food detection",      64,  50},
  {"teleportation",       71, 165}, {"enchant weapon",      81, 150},
  {"create monster",      86,  75}, {"remove curse",        94, 105},
  {"aggravate monsters",  98,  20}, {"blank paper",         99,   5},
  {"vorpalize weapon",   100, 300}
};

struct magic_item p_magic[MAXPOTIONS] =
{
  {"confusion",           8,   5}, {"paralysis",          18,   5},
  {"poison",             26,   5}, {"gain strength",      41, 150},
  {"see invisible",      43, 100}, {"healing",            58, 130},
  {"monster detection",  64, 130}, {"magic detection",    70, 105},
  {"raise level",        72, 250}, {"extra healing",      77, 200},
  {"haste self",         81, 190}, {"restore strength",   95, 130},
  {"blindness",          99,   5}, {"thirst quenching",  100,   5}
};

struct magic_item r_magic[MAXRINGS] =
{
  {"protection",          9, 400}, {"add strength",       18, 400},
  {"sustain strength",   23, 280}, {"searching",          33, 420},
  {"see invisible",      43, 310}, {"adornment",          44,  10},
  {"aggravate monster",  54,  10}, {"dexterity",          62, 440},
  {"increase damage",    70, 400}, {"regeneration",       74, 460},
  {"slow digestion",     83, 240}, {"teleportation",      88,  30},
  {"stealth",            95, 470}, {"maintain armor",    100, 380}
};

struct magic_item ws_magic[MAXSTICKS] =
{
  {"light",          12, 250}, {"striking",       21,  75},
  {"lightning",      24, 330}, {"fire",           27, 330},
  {"cold",           30, 330}, {"polymorph",      45, 310},
  {"magic missile",  55, 170}, {"haste monster",  64,   5},
  {"slow monster",   75, 350}, {"drain life",     84, 300},
  {"nothing",        85,   5}, {"teleport away",  90, 340},
  {"teleport to",    95,  50}, {"cancellation",  100, 280}
};

//probabilities of things appearing
struct magic_item things[NUMTHINGS] =
{
  {0,  27, 0}, //potion
  {0,  57, 0}, //scroll
  {0,  74, 0}, //food
  {0,  82, 0}, //weapon
  {0,  90, 0}, //armor
  {0,  95, 0}, //ring
  {0, 100, 0}  //stick
};

int e_levels[20] = {10, 20, 40, 80, 160, 320, 640, 1280, 2560, 5120, 10240, 20480, 40960, 81920, 163840, 327680, 655360, 1310720, 2621440, 0};

//utility variables
int pas_pnum;               //passage generation
unsigned char pas_newpnum;  //passage generation
unsigned char after;        //True if we want after daemons
unsigned char again;        //The last command is repeated
unsigned char do_take;
char take;                  //Thing the rogue is taking
char runch;                 //Direction player is running
char pwbuf[132];            //printw only
char prbuf[MAXSTR];         //temp string used throughout
char msgbuf[MSGSIZE];       //message buffer
char huh[MSGSIZE];          //last message printed
char *typeahead = "";
unsigned char save_msg = 1; //Remember last msg
int iguess = 0;             //used only in inits
int count = 0;              //Number of times to repeat command
int io_newpos = 0;          //used in msg functions
int mpos = 0;               //Where cursor is on top line


//--------------------above are believed non-saved-state variables


unsigned char amulet = 0;        //He has the amulet
unsigned char saw_amulet = 0;    //He has seen the amulet
unsigned char door_stop = 0;     //Stop running when we pass a door
unsigned char fastmode = 0;      //Run until you see something
unsigned char faststate = 0;     //Toggle for find (see above)
unsigned char firstmove = 0;     //First move after setting door_stop
unsigned char playing = 1;       //True until he quits
unsigned char running = 0;       //True if player is running
unsigned char was_trapped = 0;   //Was a trap sprung
unsigned char newpage = 0;       //discoveries flag
int maxitems = 0;
int bailout = 0;
int max_level;                   //Deepest player has gone
int level = 1;                   //What level rogue is on
int purse = 0;                   //How much gold the rogue has
int no_move = 0;                 //Number of turns held in place
int no_command = 0;              //Number of turns asleep
int inpack = 0;                  //Number of things in pack
int total = 0;                   //Total dynamic memory bytes
int no_food = 0;                 //Number of levels without food
int fung_hit = 0;                //Number of time fungi has hit
int quiet = 0;                   //Number of quiet turns
int food_left;                   //Amount of food in hero's stomach
int group = 2;                   //Current group number
int hungry_state = 0;            //How hungry is he
int line_cnt = 0;                //discoveries count
coord oldpos;                    //Position before last look() call
coord delta;                     //Change indicated to get_dir()
coord nh;                        //Used to hold the new hero position
coord ch_ret;                    //Where chasing takes you
coord slimy;
struct room *oldrp;
struct stats max_stats = {16, 0, 1, 10, 12, "1d4", 12};
THING player;                    //The rogue
THING *cur_armor;                //What a well dressed rogue wears
THING *cur_weapon;               //Which weapon he is wielding
THING *lvl_obj = 0;              //List of objects on this level
THING *mlist = 0;                //List of monsters on the level

int _t_alloc[MAXITEMS];
unsigned char r_know[MAXRINGS];    //Does he know what a ring does
unsigned char s_know[MAXSCROLLS];  //Does he know what a scroll does
unsigned char p_know[MAXPOTIONS];  //Does he know what a potion does
unsigned char ws_know[MAXSTICKS];  //Does he know what a stick does
short r_stoneworth[MAXRINGS];      //Price of stone setting
char whoami[24];
char fruit[24];
char macro[42];
char f_damage[10];
char *r_guess[MAXRINGS];           //Players guess at what ring is
char *s_guess[MAXSCROLLS];         //Players guess at what scroll is
char *p_guess[MAXPOTIONS];         //Players guess at what potion is
char *ws_guess[MAXSTICKS];         //Players guess at what wand is
char *r_stones[MAXRINGS];          //Stone settings of the rings
char *p_colors[MAXPOTIONS];        //Colors of the potions
char *ws_made[MAXSTICKS];          //What sticks are made of
char *ws_type[MAXSTICKS];          //Is it a wand or a staff
struct name s_names[MAXSCROLLS];   //Names of the scrolls
struct name _guesses[MAXSCROLLS+MAXPOTIONS+MAXRINGS+MAXSTICKS];
struct room rooms[MAXROOMS];
struct room passages[MAXPASS];
struct delayed_action d_list[MAXDAEMONS];
THING *cur_ring[2];                //Which rings are being worn
THING _things[MAXITEMS];
//...........................................................................

//###########################################################################
int main(void)
{
  startup();

  if (restore_game()) goto play;

  strcpy(whoami, "Rodney");
  strcpy(fruit, "Slime Mold");
  strcpy(macro, "v");

  credits();

  seedMT(get_seed());

  init_player();
  init_names();
  init_colors();
  init_stones();
  init_materials();

  drop_curtain();
  new_level();
  raise_curtain();

  daemon(doctor, 0);
  fuse(swander, 0, WANDERTIME);
  daemon(stomach, 0);
  daemon(runners, 0);

  msg("Hello %s.  Welcome to the Dungeons of Doom.", whoami)

play:

  while (playing) command();



  soft_reset();
  return 0; //not reached
}
//###########################################################################

//***************************************************************************
//this function is only used by console.c
void get_hero_position(int *x, int *y)
{
  *x = hero.x;
  *y = hero.y;
}
//***************************************************************************

//***************************************************************************
void mvaddstr(int r, int c, char *s)
{
  move(r, c); addstr(s);
}

void mvaddch(int r, int c, char chr)
{
  move(r, c); addch(chr);
}

int mvinch(int r, int c)
{
  move(r, c); return (curch()&0xff);
}

int inch(void)
{
  return (curch()&0xff);
}

void addch(unsigned char chr)
{
  int r, c;
  unsigned char a;

  getrc(&r, &c);
  if (chr=='\n') {move(r+1, 0); return;}

  a = get_attr();
  if (a==GREY) switch(chr) //room
  {
    case DOOR: case VWALL: case HWALL: case ULWALL: case URWALL: case LLWALL: case LRWALL: set_attr(BROWN); break;
    case FLOOR: set_attr(LGREEN); break;
    case STAIRS: set_attr(BLACK_ON_GREEN+FLASH); break;
    case TRAP: set_attr(MAGENTA); break;
    case GOLD: case PLAYER: set_attr(YELLOW); break;
    case POTION: case SCROLL: case STICK: case ARMOR: case AMULET: case RING: case WEAPON: set_attr(LBLUE); break;
    case FOOD: set_attr(RED); break;
  }
  else if (a==BLACK_ON_GREY) switch(chr) //passage or maze
  {
    case GOLD: case PLAYER: set_attr(YELLOW+BLACK_ON_GREY); break;
    case POTION: case SCROLL: case STICK: case ARMOR: case AMULET: case RING: case WEAPON: set_attr(BLUE+BLACK_ON_GREY); break;
    case FOOD: set_attr(RED+BLACK_ON_GREY); break;
  }
  else if (a==WHITE) switch(chr)
  {
    case STAIRS: set_attr(BLACK_ON_GREEN+FLASH); break;
  }
  putchr(chr);
  move(r, c+1);
  set_attr(a);
  return;
}

void addstr(char *s)
{
  while (*s) addch(*s++);
}

void box(int ul_r, int ul_c, int lr_r, int lr_c)
{
  int r, c, i;

  getrc(&r, &c);

  for (i = ul_c+1; i<lr_c; i++)
  {
    mvaddch(ul_r, i, 0xcd);
    mvaddch(lr_r, i, 0xcd);
  }

  for (i = ul_r+1; i<lr_r; i++)
  {
    mvaddch(i, ul_c, 0xba);
    mvaddch(i, lr_c, 0xba);
  }

  mvaddch(ul_r, ul_c, 0xc9);
  mvaddch(ul_r, lr_c, 0xbb);
  mvaddch(lr_r, ul_c, 0xc8);
  mvaddch(lr_r, lr_c, 0xbc);

  move(r, c);
}

void center(int row, char *string)
{
  mvaddstr(row, (60-strlen(string))/2, string);
}

int getinfo(char *str, int size)
{
  int r, c, ch;
  char *retstr;

  retstr = str; putchr(CURSOR_CHAR);
  while (1)
  {
    ch = get_input();
    if (ch=='\b') {if (str!=retstr) {putchr(' '); getrc(&r, &c); move(r, c-1); putchr(CURSOR_CHAR); str--;}}
    else if (ch=='\r' || ch==ESCAPE) {if (ch==ESCAPE) str = retstr; *str = 0; break;}
    else {if (str-retstr<size) {putchr(ch); getrc(&r, &c); move(r, c+1); putchr(CURSOR_CHAR); *str++ = ch;}}
  }
  return ch;
}

void flush_type(void)
{
  typeahead = "";
}

int readchar(void)
{
  int ch;

  if (*typeahead) return *typeahead++;
  ch = get_input();
  if (ch==ESCAPE) count = 0;
  return ch;
}



#define STATUS_WORD_SIZE   32
#define NUM_STATUS_WORDS   7
#define STATUS_LINE_WIDTH  40

void status(void)
{
  static char *state_name[] = {"", "Hungry", "Weak", "Faint", "?"};

  static char new_words[STATUS_WORD_SIZE*NUM_STATUS_WORDS];
  static char old_words[STATUS_WORD_SIZE*NUM_STATUS_WORDS];

  static int first_time = 1;



  if (first_time==0) memcpy(old_words, new_words, STATUS_WORD_SIZE*NUM_STATUS_WORDS);

  sprintf(new_words+STATUS_WORD_SIZE*0, "Lev:%d", level);
  sprintf(new_words+STATUS_WORD_SIZE*1, "HP:%d(%d)", pstats.s_hpt, max_hp);
  sprintf(new_words+STATUS_WORD_SIZE*2, "Str:%d(%d)", pstats.s_str, max_stats.s_str);
  sprintf(new_words+STATUS_WORD_SIZE*3, "Arm:%d", -((cur_armor!=0?cur_armor->o_ac:pstats.s_arm)-11));
  sprintf(new_words+STATUS_WORD_SIZE*4, "Au:%u", purse);
  sprintf(new_words+STATUS_WORD_SIZE*5, "%s", he_man[pstats.s_lvl-1]);
  sprintf(new_words+STATUS_WORD_SIZE*6, "%s", state_name[hungry_state]);

  if (first_time) memcpy(old_words, new_words, STATUS_WORD_SIZE*NUM_STATUS_WORDS);



  {
    int savedx, savedy, x, y, i;
    char *p;

    getrc(&savedy, &savedx);

    x = 0; y = 23;
    for (i=0; i<NUM_STATUS_WORDS; i++)
    {
      if (*(new_words+STATUS_WORD_SIZE*i))
      {
        if (strcmp(new_words+STATUS_WORD_SIZE*i, old_words+STATUS_WORD_SIZE*i)==0) set_attr(YELLOW); else set_attr(WHITE);
        if (i!=0 && i!=4 && x<STATUS_LINE_WIDTH) {move(y, x++); putchr(' ');}
        p = new_words+STATUS_WORD_SIZE*i;
        while (*p && x<STATUS_LINE_WIDTH) {move(y, x++); putchr(*p++);}
      }

      if (i==3 || i==6)
      {
        while (x<STATUS_LINE_WIDTH) {move(y, x++); putchr(' ');}
        x = 0; y++;
      }
    }

    set_attr(GREY); move(savedy, savedx);
  }



  first_time = 0;
}
//***************************************************************************

//***************************************************************************
void new_level(void)
{
  int rm, i, index;
  THING *tp;
  unsigned char *fp;
  coord stairs;

  start_transition();

  player.t_flags &= ~ISHELD; //unhold when you go down just in case
  if (level>max_level) max_level = level;
  //Clean things off from last level
  memset(_level, ' ', (25-3)*80);
  memset(_flags, F_REAL, (25-3)*80);
  //Free up the monsters on the last level
  for (tp = mlist; tp!=0; tp = next(tp)) free_list(tp->t_pack);
  free_list(mlist);
  //just in case we left some flytraps behind
  f_restor();
  //Throw away stuff left on the previous level (if anything)
  free_list(lvl_obj);
  do_rooms(); //Draw rooms
  do_passages(); //Draw passages
  no_food++;
  put_things(); //Place objects (if any)
  //Place the staircase down.
  do {rm = rnd_room(); rnd_pos(&rooms[rm], &stairs); index = INDEX(stairs.y, stairs.x);} while (!isfloor(_level[index]));
  _level[index] = STAIRS;
  //Place the traps
  if (rnd(10)<level)
  {
    i = rnd(level/4)+1; if (i>MAXTRAPS) i = MAXTRAPS;
    while (i--)
    {
      do {rm = rnd_room(); rnd_pos(&rooms[rm], &stairs); index = INDEX(stairs.y, stairs.x);} while (!isfloor(_level[index]));
      fp = &_flags[index];
      *fp &= ~F_REAL;
      *fp |= rnd(NTRAPS);
    }
  }
  //Place hero
  do {rm = rnd_room(); rnd_pos(&rooms[rm], &hero); index = INDEX(hero.y, hero.x);} while (!(isfloor(_level[index]) && (_flags[index]&F_REAL) && moat(hero.y, hero.x)==0));

  wclear();
  set_tile_mode(1);

  mpos = 0;
  enter_room(&hero);
  mvaddch(hero.y, hero.x, PLAYER);

  oldpos.x = hero.x;
  oldpos.y = hero.y;
  oldrp = roomin(&hero);

  if (on(player, SEEMONST)) turn_see(0);

  end_transition();

  status();
}

void credits(void)
{
  int i;
  char tname[25];



  display_credits_flag = 1;



  wclear();
  set_tile_mode(0);

  set_attr(BROWN); box(0, 0, 24, 60-1);



  display_credits();



  set_attr(BROWN);
  for (i = 1; i<(60-1); i++) {move(22, i); putchr(205);}
  mvaddch(22, 0, 204);
  mvaddch(22, 60-1, 185);

  set_attr(GREY); mvaddstr(23, 2, "Rogue's Name? ");

  set_attr(WHITE); getinfo(tname, 23); if (*tname) strcpy(whoami, tname);

  move(23, 0); clrtoeol();
  move(24, 0); clrtoeol();

  set_attr(BROWN);
  mvaddch(22, 0, 0xc8);
  mvaddch(22, 60-1, 0xbc);
  set_attr(GREY);



  tick_pause();



  display_credits_flag = 0;
}

void quit(void)
{
  int oy, ox;
  unsigned char answer;

  mpos = 0;
  getrc(&oy, &ox);
  move(0, 0); clrtoeol();
  move(0, 0); str_attr("Do you wish to end your quest now (%Yes/%No) ?");
  look(0);
  answer = readchar();
  if (answer=='y' || answer=='Y')
  {
    wclear();
    set_tile_mode(0);

    move(0, 0); printw("You quit with %u gold pieces\n", purse)

    score(purse, 1, 0);
  }
  else
  {
    move(0, 0); clrtoeol();
    move(oy, ox);
    mpos = 0;
    count = 0;
  }
}

void death(char monst)
{
  char *killer;
  char buf[MAXSTR];

  purse -= purse/10;
  killer = killname(monst, 1);

  drop_curtain();

  wclear();
  set_tile_mode(0);

  set_attr(BROWN); box(7, (60-28)/2, 22, (60+28)/2);
  set_attr(GREY); center(10, "REST"); center(11, "IN"); center(12, "PEACE");
  set_attr(RED); center(21, "  *    *      * ");
  set_attr(GREEN); center(22, "___\\/(\\/)/(\\/ \\\\(//)\\)\\/(//)\\\\)//(\\__");
  set_attr(GREY); center(14, whoami);
  strcpy(buf, "killed by"); center(15, buf); center(16, killer);
  sprintf(buf, "%u Au", purse); center(18, buf);

  raise_curtain();

  score(purse, 0, monst);
}

char *killname(char monst, unsigned char doart)
{
  char *sp;
  unsigned char article;

  sp = prbuf;
  article = 1;
  switch (monst)
  {
    case 'a': sp = "arrow"; break;
    case 'b': sp = "bolt"; break;
    case 'd': sp = "dart"; break;
    case 's': sp = "starvation"; article = 0; break;
    case 'f': sp = "fall"; break;
    default:
      if (monst>='A' && monst<='Z') sp = monsters[monst-'A'].m_name;
      else {sp = "God"; article = 0;}
    break;
  }
  if (doart && article) sprintf(prbuf, "a%s ", vowelstr(sp));
  else prbuf[0] = '\0';
  strcat(prbuf, sp);
  return prbuf;
}

void total_winner(void)
{
  THING *obj;
  int worth = 0;
  unsigned char c;
  int oldpurse;



  display_cave_exit();



  wclear();
  set_tile_mode(0);

  mvaddstr(0, 0, "   Worth  Item");
  oldpurse = purse;
  for (c = 'a', obj = pack; obj!=0; c++, obj = next(obj))
  {
    switch (obj->o_type)
    {
      case FOOD:
        worth = 2*obj->o_count;
      break;

      case WEAPON:
        switch (obj->o_which)
        {
          case MACE: worth = 8; break;
          case SWORD: worth = 15; break;
          case CROSSBOW: worth = 30; break;
          case ARROW: worth = 1; break;
          case DAGGER: worth = 2; break;
          case TWOSWORD: worth = 75; break;
          case DART: worth = 1; break;
          case BOW: worth = 15; break;
          case BOLT: worth = 1; break;
          case SPEAR: worth = 5; break;
        }
        worth *= 3*(obj->o_hplus+obj->o_dplus)+obj->o_count;
        obj->o_flags |= ISKNOW;
      break;

      case ARMOR:
        switch (obj->o_which)
        {
          case LEATHER: worth = 20; break;
          case RING_MAIL: worth = 25; break;
          case STUDDED_LEATHER: worth = 20; break;
          case SCALE_MAIL: worth = 30; break;
          case CHAIN_MAIL: worth = 75; break;
          case SPLINT_MAIL: worth = 80; break;
          case BANDED_MAIL: worth = 90; break;
          case PLATE_MAIL: worth = 150; break;
        }
        worth += (9-obj->o_ac)*100;
        worth += (10*(a_class[obj->o_which]-obj->o_ac));
        obj->o_flags |= ISKNOW;
      break;

      case SCROLL:
        worth = s_magic[obj->o_which].mi_worth;
        worth *= obj->o_count;
        if (!s_know[obj->o_which]) worth /= 2;
        s_know[obj->o_which] = 1;
      break;

      case POTION:
        worth = p_magic[obj->o_which].mi_worth;
        worth *= obj->o_count;
        if (!p_know[obj->o_which]) worth /= 2;
        p_know[obj->o_which] = 1;
      break;

      case RING:
        worth = r_magic[obj->o_which].mi_worth+r_stoneworth[obj->o_which];
        if (obj->o_which==R_ADDSTR || obj->o_which==R_ADDDAM || obj->o_which==R_PROTECT || obj->o_which==R_ADDHIT)
        {
          if (obj->o_ac>0) worth += obj->o_ac*100; else worth = 10;
        }
        if (!(obj->o_flags&ISKNOW)) worth /= 2;
        obj->o_flags |= ISKNOW;
        r_know[obj->o_which] = 1;
      break;

      case STICK:
        worth = ws_magic[obj->o_which].mi_worth;
        worth += 20*obj->o_charges;
        if (!(obj->o_flags&ISKNOW)) worth /= 2;
        obj->o_flags |= ISKNOW;
        ws_know[obj->o_which] = 1;
      break;

      case AMULET:
        worth = 1000;
      break;
    }
    if (worth<0) worth = 0;
    move(c-'a'+1, 0);
    printw("%c) %5d  %s", c, worth, inv_name(obj, 0))
    purse += worth;
  }
  move(c-'a'+1, 0);
  printw("   %5u  Gold Pieces          ", oldpurse)

  score(purse, 2, 0);
}
//***************************************************************************

//***************************************************************************
//Mersenne Twister random number generator MT19937

unsigned int stateMT[624+1];
unsigned int *nextMT;
int leftMT = -1;

void seedMT(unsigned int seed)
{
  unsigned int x = (seed|1U)&0xFFFFFFFFU, *s = stateMT;
  int j;

  for (leftMT=0, *s++=x, j=624; --j; *s++=(x*=69069U)&0xFFFFFFFFU);
}

unsigned int reloadMT(void)
{
  unsigned int *p0 = stateMT, *p2 = stateMT+2, *pM = stateMT+397, s0, s1;
  int j;

  if (leftMT<-1) seedMT(4357U);
  leftMT = 624-1;
  nextMT = stateMT+1;
  for (s0 = stateMT[0], s1 = stateMT[1], j = 624-397+1; --j; s0 = s1, s1 = *p2++)
    *p0++ = *pM++^(((s0&0x80000000U)|(s1&0x7FFFFFFFU))>>1)^(((s1)&0x00000001U)?0x9908B0DFU:0U);
  for (pM = stateMT, j = 397; --j; s0 = s1, s1 = *p2++)
    *p0++ = *pM++^(((s0&0x80000000U)|(s1&0x7FFFFFFFU))>>1)^(((s1)&0x00000001U)?0x9908B0DFU:0U);
  s1 = stateMT[0];
  *p0 = *pM^(((s0&0x80000000U)|(s1&0x7FFFFFFFU))>>1)^(((s1)&0x00000001U)?0x9908B0DFU:0U);
  s1 ^= (s1>>11);
  s1 ^= (s1<<7)&0x9D2C5680U;
  s1 ^= (s1<<15)&0xEFC60000U;
  return (s1^(s1>>18));
}

unsigned int randomMT(void)
{
  unsigned int y;

  if (--leftMT<0) return (reloadMT());
  y = *nextMT++;
  y ^= (y>>11);
  y ^= (y<<7)&0x9D2C5680U;
  y ^= (y<<15)&0xEFC60000U;
  return (y^(y>>18));
}

unsigned int rangeMT(unsigned int lower, unsigned int upper)
{
  return (((randomMT()&0x0000FFFFU)*(upper-lower+0x00000001U))>>16)+lower;
}

int rnd(int range)
{
  return range<1?0:randomMT()%range;
}

//Roll a number of dice
int roll(int number, int sides)
{
  int dtotal = 0;

  while (number--) dtotal += rnd(sides)+1;
  return dtotal;
}
//***************************************************************************

//***************************************************************************
//The player wants to wear something, so let him/her put it on.
void wear(void)
{
  THING *obj;
  char *sp;

  if (cur_armor!=0)
  {
    msg("you are already wearing some.  You'll have to take it off first.")
    after = 0;
    return;
  }
  if ((obj = get_item("wear", ARMOR))==0) return;
  if (obj->o_type!=ARMOR) {msg("you can't wear that") return;}
  waste_time();
  obj->o_flags |= ISKNOW ;
  sp = inv_name(obj, 1);
  cur_armor = obj;
  msg("you are now wearing %s", sp)
}

//Get the armor off of the player's back
void take_off(void)
{
  THING *obj;

  if ((obj = cur_armor)==0)
  {
    after = 0;
    msg("you aren't wearing any armor")
    return;
  }
  if (!can_drop(cur_armor)) return;
  cur_armor = 0;
  msg("you used to be wearing %c) %s", pack_char(obj), inv_name(obj, 1))
}

//Do nothing but let other things happen
void waste_time(void)
{
  do_daemons();
  do_fuses();
}
//***************************************************************************

//***************************************************************************
//Make one thing chase another.
void do_chase(THING *th)
{
  int mindist = 32767, i, dist;
  unsigned char door;
  THING *obj;
  struct room *oroom;
  struct room *rer, *ree; //room of chaser, room of chasee
  coord this; //Temporary destination for chaser

  rer = th->t_room; //Find room of chaser
  if (on(*th, ISGREED) && rer->r_goldval==0) th->t_dest = &hero; //If gold has been taken, run after hero
  ree = proom;
  if (th->t_dest!=&hero) ree = roomin(th->t_dest); //Find room of chasee
  if (ree==0) return;
  //We don't count doors as inside rooms for this routine
  door = (chat(th->t_pos.y, th->t_pos.x)==DOOR);
  //If the object of our desire is in a different room, and we are not in a maze, run to the door nearest to our goal.
over:
  if (rer!=ree && (rer->r_flags&ISMAZE)==0)
  {
    //loop through doors
    for (i = 0; i<rer->r_nexits; i++)
    {
      dist = DISTANCE(th->t_dest->y, th->t_dest->x, rer->r_exit[i].y, rer->r_exit[i].x);
      if (dist<mindist) {this = rer->r_exit[i]; mindist = dist;}
    }
    if (door)
    {
      rer = &passages[flat(th->t_pos.y, th->t_pos.x)&F_PNUM];
      door = 0;
      goto over;
    }
  }
  else
  {
    this = *th->t_dest;
    //For monsters which can fire bolts at the poor hero, we check to see if (a) the hero is on a straight line from it, and (b) that it is within shooting distance, but outside of striking range.
    if ((th->t_type=='D' || th->t_type=='I') && (th->t_pos.y==hero.y || th->t_pos.x==hero.x || abs(th->t_pos.y-hero.y)==abs(th->t_pos.x-hero.x)) && ((dist = DISTANCE(th->t_pos.y, th->t_pos.x, hero.y, hero.x))>2 && dist<=BOLT_LENGTH*BOLT_LENGTH) && !on(*th, ISCANC) && rnd(DRAGONSHOT)==0)
    {
      play_sound(th->t_type=='D'?FIRE_SOUND:ICE_SOUND);

      running = 0;
      delta.y = sign(hero.y-th->t_pos.y);
      delta.x = sign(hero.x-th->t_pos.x);
      fire_bolt(&th->t_pos, &delta, th->t_type=='D'?"flame":"frost");
      return;
    }
  }
  //This now contains what we want to run to this time so we run to it. If we hit it we either want to fight it or stop running
  chase(th, &this);
  if (ce(ch_ret, hero)) {attack(th); return;}
  else if (ce(ch_ret, *th->t_dest))
  {
    for (obj = lvl_obj; obj!=0; obj = next(obj)) if (th->t_dest==&obj->o_pos)
    {
      unsigned char oldchar;

      detach(lvl_obj, obj);
      attach(th->t_pack, obj);
      oldchar = chat(obj->o_pos.y, obj->o_pos.x) = (th->t_room->r_flags&ISGONE)?PASSAGE:FLOOR;
      if (cansee(obj->o_pos.y, obj->o_pos.x)) mvaddch(obj->o_pos.y, obj->o_pos.x, oldchar);
      th->t_dest = find_dest(th);
      break;
    }
  }
  if (th->t_type=='F') return;
  //If the chasing thing moved, update the screen
  if (th->t_oldch!='@')
  {
    if (th->t_oldch==' ' && cansee(th->t_pos.y, th->t_pos.x) && _level[INDEX(th->t_pos.y, th->t_pos.x)]==FLOOR) mvaddch(th->t_pos.y, th->t_pos.x, FLOOR);
    else if (th->t_oldch==FLOOR && !cansee(th->t_pos.y, th->t_pos.x) && !on(player, SEEMONST)) mvaddch(th->t_pos.y, th->t_pos.x, ' ');
    else mvaddch(th->t_pos.y, th->t_pos.x, th->t_oldch);
  }
  oroom = th->t_room;
  if (!ce(ch_ret, th->t_pos))
  {
    if ((th->t_room = roomin(&ch_ret))==0) {th->t_room = oroom; return;}
    if (oroom!=th->t_room) th->t_dest = find_dest(th);
    th->t_pos = ch_ret;
  }
  if (see_monst(th))
  {
    if (flat(ch_ret.y, ch_ret.x)&F_PASS) set_attr(BLACK_ON_GREY);
    th->t_oldch = mvinch(ch_ret.y, ch_ret.x);
    mvaddch(ch_ret.y, ch_ret.x, th->t_disguise);
  }
  else if (on(player, SEEMONST))
  {
    set_attr(BLACK_ON_GREY);
    th->t_oldch = mvinch(ch_ret.y, ch_ret.x);
    mvaddch(ch_ret.y, ch_ret.x, th->t_type);
  }
  else th->t_oldch = '@';
  if (th->t_oldch==FLOOR && oroom->r_flags&ISDARK) th->t_oldch = ' ';
  set_attr(GREY);
}

//Return 1 if the hero can see the monster
int see_monst(THING *mp)
{
  if (on(player, ISBLIND)) return 0;
  if (on(*mp, ISINVIS) && !on(player, CANSEE)) return 0;
  if (DISTANCE(mp->t_pos.y, mp->t_pos.x, hero.y, hero.x)>=LAMPDIST && ((mp->t_room!=proom || (mp->t_room->r_flags&ISDARK) || (mp->t_room->r_flags&ISMAZE)))) return 0;
  //If we are seeing the enemy of a vorpally enchanted weapon for the first time, give the player a hint as to what that weapon is good for.
  if (cur_weapon!=0 && mp->t_type==cur_weapon->o_enemy && ((cur_weapon->o_flags&DIDFLASH)==0))
  {
    cur_weapon->o_flags |= DIDFLASH;
    msg("your %s gives off a flash of intense white light", w_names[cur_weapon->o_which])
  }
  return 1;
}

//Set a monster running after something or stop it from running (for when it dies)
void start_run(coord *runner)
{
  THING *tp;

  //If we couldn't find him, something is funny
  tp = moat(runner->y, runner->x);
  if (tp!=0)
  {
    //Start the beastie running
    tp->t_flags |= ISRUN;
    tp->t_flags &= ~ISHELD;
    tp->t_dest = find_dest(tp);
  }
}

//Find the spot for the chaser(er) to move closer to the chasee(ee). Returns 1 if we want to keep on chasing later. 0 if we reach the goal.
void chase(THING *tp, coord *ee)
{
  int x, y;
  int dist, thisdist;
  THING *obj;
  coord *er;
  unsigned char ch;
  int plcnt = 1;

  er = &tp->t_pos;
  //If the thing is confused, let it move randomly. Phantoms are slightly confused all of the time, and bats are quite confused all the time
  if ((on(*tp, ISHUH) && rnd(5)!=0) || (tp->t_type=='P' && rnd(5)==0) || (tp->t_type=='B' && rnd(2)==0))
  {
    //get a valid random move
    rndmove(tp, &ch_ret);
    dist = DISTANCE(ch_ret.y, ch_ret.x, ee->y, ee->x);
    //Small chance that it will become un-confused
    if (rnd(30)==17) tp->t_flags &= ~ISHUH;
  }
  //Otherwise, find the empty spot next to the chaser that is closest to the chasee.
  else
  {
    int ey, ex;

    //This will eventually hold where we move to get closer. If we can't find an empty spot, we stay where we are.
    dist = DISTANCE(er->y, er->x, ee->y, ee->x);
    ch_ret = *er;
    ey = er->y+1;
    ex = er->x+1;
    for (x = er->x-1; x<=ex; x++)
    {
      for (y = er->y-1; y<=ey; y++)
      {
        coord tryp;

        tryp.x = x;
        tryp.y = y;
        if (offmap(y, x) || !diag_ok(er, &tryp)) continue;
        ch = winat(y, x);
        if (step_ok(ch))
        {
          //If it is a scroll, it might be a scare monster scroll so we need to look it up to see what type it is.
          if (ch==SCROLL)
          {
            for (obj = lvl_obj; obj!=0; obj = next(obj))
            {
              if (y==obj->o_pos.y && x==obj->o_pos.x) break;
            }
            if (obj!=0 && obj->o_which==S_SCARE) continue;
          }
          //If we didn't find any scrolls at this place or it wasn't a scare scroll, then this place counts
          thisdist = DISTANCE(y, x, ee->y, ee->x);
          if (thisdist<dist) {plcnt = 1; ch_ret = tryp; dist = thisdist;}
          else if (thisdist==dist && rnd(++plcnt)==0) {ch_ret = tryp; dist = thisdist;}
        }
      }
    }
  }
}

//Find what room some coordinates are in. 0 means they aren't in any room.
struct room *roomin(coord *cp)
{
  struct room *rp;
  unsigned char *fp;

  for (rp = rooms; rp<=&rooms[MAXROOMS-1]; rp++) if (cp->x<rp->r_pos.x+rp->r_max.x && rp->r_pos.x<=cp->x && cp->y<rp->r_pos.y+rp->r_max.y && rp->r_pos.y<=cp->y) return rp;
  fp = &flat(cp->y, cp->x);
  if (*fp&F_PASS) return &passages[*fp&F_PNUM];
  bailout++;
  return 0;
}

//Check to see if the move is legal if it is diagonal
int diag_ok(coord *sp, coord *ep)
{
  if (ep->x==sp->x || ep->y==sp->y) return 1;
  return (step_ok(chat(ep->y, sp->x)) && step_ok(chat(sp->y, ep->x)));
}

//Returns true if the hero can see a certain coordinate.
int cansee(int y, int x)
{
  struct room *rer;
  coord tp;

  if (on(player, ISBLIND)) return 0;
  if (DISTANCE(y, x, hero.y, hero.x)<LAMPDIST) return 1;
  //We can only see if the hero in the same room as the coordinate and the room is lit or if it is close.
  tp.y = y;
  tp.x = x;
  rer = roomin(&tp);
  return (rer==proom && !(rer->r_flags&ISDARK));
}

//find the proper destination for the monster
coord *find_dest(THING *tp)
{
  THING *obj;
  int prob;
  struct room *rp;

  if ((prob = monsters[tp->t_type-'A'].m_carry)<=0 || tp->t_room==proom || see_monst(tp)) return &hero;
  rp = tp->t_room;
  for (obj = lvl_obj; obj!=0; obj = next(obj))
  {
    if (obj->o_type==SCROLL && obj->o_which==S_SCARE) continue;
    if (roomin(&obj->o_pos)==rp && rnd(100)<prob)
    {
      for (tp = mlist; tp!=0; tp = next(tp)) if (tp->t_dest==&obj->o_pos) break;
      if (tp==0) return &obj->o_pos;
    }
  }
  return &hero;
}
//***************************************************************************

//***************************************************************************
void command(void)
{
  int ntimes;

  if (on(player, ISHASTE)) ntimes = rnd(2)+2;
  else ntimes = 1;
  while (ntimes--)
  {
    status();
    if (no_command)
    {
      if (--no_command<=0) {msg("you can move again") no_command = 0;}
    }
    else execcom();
    do_fuses();
    do_daemons();
    for (ntimes = LEFT; ntimes<=RIGHT; ntimes++) if (cur_ring[ntimes]) switch (cur_ring[ntimes]->o_which)
    {
      case R_SEARCH: search(); break;
      case R_TELEPORT: if (rnd(50)==17) teleport(); break;
    }
  }
}

int com_char(void)
{
  int same, ch;

  same = (fastmode==faststate);
  ch = readchar();
  if (same) fastmode = faststate;
  else fastmode = !faststate;
  switch (ch)
  {
    case '\b': ch = 'h'; break;
    case '+': ch = 't'; break;
    case '-': ch = 'z'; break;
  }
  if (mpos && !running) clearmsg()
  return ch;
}



unsigned char lastch = 'v', lasttake = 0;
int lastcount = 0;



//Read a command, setting things up according to prefix like devices. Return the command character to be executed.
int get_prefix(void)
{
  int retch, ch, junk;

  after = 1;
  fastmode = faststate;
  look(1);
  if (!running) door_stop = 0;
  do_take = 1;
  again = 0;
  if (--count>0) {do_take = lasttake; retch = lastch; fastmode = 0;}
  else
  {
    count = 0;
    if (running) {retch = runch; do_take = lasttake;}
    else
    {
      for (retch = 0; retch==0;)
      {
        switch (ch = com_char())
        {
          case '0': case '1': case '2': case '3': case '4': case '5': case '6': case '7': case '8': case '9':
            junk = count*10;
            if ((junk += ch-'0')>0 && junk<10000) count = junk;
          break;

          case 'f': fastmode = !fastmode; break;
          case 'g': do_take = 0; break;
          case 'a': retch = lastch; count = lastcount; do_take = lasttake; again = 1; break;
          case ' ': break;
          case ESCAPE: door_stop = 0; count = 0; break;
          default: retch = ch; break;
        }
      }
    }
  }
  if (count) fastmode = 0;
  switch (retch)
  {
    case 'h': case 'j': case 'k': case 'l': case 'y': case 'u': case 'b': case 'n':
      if (fastmode && !running)
      {
        if (!on(player, ISBLIND)) {door_stop = 1; firstmove = 1;}
        retch = toupper(retch);
      }

    case 'H': case 'J': case 'K': case 'L': case 'Y': case 'U': case 'B': case 'N': case 'q': case 'r': case 's': case 'z': case 't': case '.':

    case CTRL('D'): case 'C':

    break;

    default: count = 0;
  }

  lastch = retch;
  lastcount = count;
  lasttake = do_take;

  return retch;
}

void execcom(void)
{
  coord mv;
  int ch;

  do
  {
    ch = get_prefix();

again:
    switch (ch)
    {
      case 13:
        ch = command_menu(); if (ch!=ESCAPE) {lastch = ch; goto again;}
        after = 0;
      break;

      case 'h': case 'j': case 'k': case 'l': case 'y': case 'u': case 'b': case 'n': find_dir(ch, &mv); do_move(mv.y, mv.x); break;
      case 'H': case 'J': case 'K': case 'L': case 'Y': case 'U': case 'B': case 'N': do_run(tolower(ch)); break;
      case 't': if (get_dir()) missile(delta.y, delta.x); else after = 0; break;
      case 'Q': after = 0; quit(); break;
      case 'i': after = 0; inventory(0, ""); break;
      case 'd': drop(); break;
      case 'q': quaff(); break;
      case 'r': read_scroll(); break;
      case 'e': eat(); break;
      case 'w': wield(); break;
      case 'W': wear(); break;
      case 'T': take_off(); break;
      case 'P': ring_on(); break;
      case 'R': ring_off(); break;
      case 'c': after = 0; call(); break;
      case '>': after = 0; d_level(); break;
      case '<': after = 0; u_level(); break;
      case '/': after = 0; help(1); break;
      case '?': after = 0; help(0); break;
      case 's': search(); break;
      case 'z': if (get_dir()) do_zap(); else after = 0; break;
      case 'D': after = 0; discovered(); break;
      case 'o': after = 0; msg(huh) break;
      case 'F': after = 0; do_macro(); break;
      case 'G': after = 0; typeahead = macro; break;
      case 'v': after = 0; msg(VERSION_MESSAGE) break;
      case '!': after = 0; toggle_tiles(); break;
      case 'S': save_game(); break;
      case '.': doctor(0); break;
      case '^':
        after = 0;
        if (get_dir())
        {
          coord lookat;

          lookat.y = hero.y+delta.y;
          lookat.x = hero.x+delta.x;
          if (chat(lookat.y, lookat.x)!=TRAP) msg("no trap there.")
          else msg("you found %s", tr_name(flat(lookat.y, lookat.x)&F_TMASK))
        }
      break;

      case 'C': after = 0; create_obj(); break; //wizard command
      case 'M': after = 0; show_map(); break; //wizard command

      default: after = 0; save_msg = 0; msg("illegal command '%s'", unctrl(ch)) count = 0; save_msg = 1; break;
    }

    if (take && do_take) pick_up(take);
    take = 0;
    if (!running) door_stop = 0;
  } while (after==0);
}
//***************************************************************************

//***************************************************************************
//Find an empty slot in the daemon/fuse list
struct delayed_action *d_slot(void)
{
  struct delayed_action *dev;

  for (dev = d_list; dev<&d_list[MAXDAEMONS]; dev++) if (dev->d_func==0) return dev;
  return 0;
}

//Find a particular slot in the table
struct delayed_action *find_slot(int (*func)(int))
{
  struct delayed_action *dev;

  for (dev = d_list; dev<&d_list[MAXDAEMONS]; dev++) if (func==dev->d_func) return dev;
  return 0;
}

//Start a daemon, takes a function.
void daemon(int (*func)(int), int arg)
{
  struct delayed_action *dev;

  dev = d_slot();
  dev->d_func = func;
  dev->d_arg = arg;
  dev->d_time = -1;
}

//Run all the daemons, passing the argument to the function.
void do_daemons(void)
{
  struct delayed_action *dev;

  //Loop through the devil list, Executing each one, giving it the proper arguments
  for (dev = d_list; dev<&d_list[MAXDAEMONS]; dev++)
  if (dev->d_time==-1 && dev->d_func!=0) (*dev->d_func)(dev->d_arg);
}

//Start a fuse to go off in a certain number of turns
void fuse(int (*func)(int), int arg, int time)
{
  struct delayed_action *wire;

  wire = d_slot();
  wire->d_func = func;
  wire->d_arg = arg;
  wire->d_time = time;
}

//Increase the time until a fuse goes off
void lengthen(int (*func)(int), int xtime)
{
  struct delayed_action *wire;

  if ((wire = find_slot(func))==0) return;
  wire->d_time += xtime;
}

//Put out a fuse
void extinguish(int (*func)(int))
{
  struct delayed_action *wire;

  if ((wire = find_slot(func))==0) return;
  wire->d_func = 0;
}

//Decrement counters and start needed fuses
void do_fuses(void)
{
  struct delayed_action *wire;

  //Step through the list, Decrementing counters and starting things we want.  We also need to remove the fuse from the list once it has gone off.
  for (wire = d_list; wire<&d_list[MAXDAEMONS]; wire++)
  {
    if (wire->d_func!=0 && wire->d_time>0 && --wire->d_time==0)
    {
      (*wire->d_func)(wire->d_arg);
      wire->d_func = 0;
    }
  }
}
//***************************************************************************

//***************************************************************************
//A healing daemon that restores hit points after rest
int doctor(int dummy)
{
  int lv, ohp;

  lv = pstats.s_lvl;
  ohp = pstats.s_hpt;
  quiet++;
  if (lv<8)
  {
    if (quiet+(lv<<1)>20) pstats.s_hpt++;
  }
  else if (quiet>=3) pstats.s_hpt += rnd(lv-7)+1;
  if (ISRING(LEFT, R_REGEN)) pstats.s_hpt++;
  if (ISRING(RIGHT, R_REGEN)) pstats.s_hpt++;
  if (ohp!=pstats.s_hpt)
  {
    if (pstats.s_hpt>max_hp) pstats.s_hpt = max_hp;
    quiet = 0;
  }
  return 0;
}

//Called when it is time to start rolling for wandering monsters
int swander(int dummy)
{
  daemon(rollwand, 0);
  return 0;
}

//Called to roll to see if a wandering monster starts up
int rollwand(int dummy)
{
  static int between = 0;

  if (++between>=3+rnd(3))
  {
    if (roll(1, 6)==4) {wanderer(); extinguish(rollwand); fuse(swander, 0, WANDERTIME);}
    between = 0;
  }
  return 0;
}

//Release the poor player from his confusion
int unconfuse(int dummy)
{
  player.t_flags &= ~ISHUH;
  msg("you feel less confused now")
  return 0;
}

//Turn off the ability to see invisible
int unsee(int dummy)
{
  THING *th;

  for (th = mlist; th!=0; th = next(th)) if (on(*th, ISINVIS) && see_monst(th) && th->t_oldch!='@') mvaddch(th->t_pos.y, th->t_pos.x, th->t_oldch);
  player.t_flags &= ~CANSEE;
  return 0;
}

//He gets his sight back
int sight(int dummy)
{
  if (on(player, ISBLIND))
  {
    extinguish(sight);
    player.t_flags &= ~ISBLIND;
    if (!(proom->r_flags&ISGONE)) enter_room(&hero);
    msg("the veil of darkness lifts")
  }
  return 0;
}

//End the hasting
int nohaste(int dummy)
{
  player.t_flags &= ~ISHASTE;
  msg("you feel yourself slowing down")
  return 0;
}

//Digest the hero's food
int stomach(int dummy)
{
  int oldfood, deltafood;

  if (food_left<=0)
  {
    if (food_left--<-STARVETIME) death('s');
    //the hero is fainting
    if (no_command || rnd(5)!=0) return 0;
    no_command += rnd(8)+4;
    player.t_flags &= ~ISRUN;
    running = 0;
    count = 0;
    hungry_state = 3;
    msg("you feel very weak. you faint from lack of food")
  }
  else
  {
    oldfood = food_left;
    deltafood = ring_eat(LEFT)+ring_eat(RIGHT)+1;
    food_left -= deltafood;
    if (food_left<MORETIME && oldfood>=MORETIME) {hungry_state = 2; msg("you are starting to feel weak")}
    else if (food_left<2*MORETIME && oldfood>=2*MORETIME) {hungry_state = 1; msg("you are starting to get hungry")}
  }
  return 0;
}

//Make all the running monsters move.
int runners(int dummy)
{
  THING *tp;
  int dist;

  for (tp = mlist; tp!=0; tp = next(tp))
  {
    if (!on(*tp, ISHELD) && on(*tp, ISRUN))
    {
      dist = DISTANCE(hero.y, hero.x, tp->t_pos.y, tp->t_pos.x);
      if (!(on(*tp, ISSLOW) || (tp->t_type=='S' && dist>3)) || tp->t_turn) do_chase(tp);
      if (on(*tp, ISHASTE)) do_chase(tp);
      dist = DISTANCE(hero.y, hero.x, tp->t_pos.y, tp->t_pos.x);
      if (on(*tp, ISFLY) && dist>3) do_chase(tp);
      tp->t_turn ^= 1;
    }
  }
  return 0;
}

//Turn on or off seeing monsters on this level
int turn_see(int turn_off)
{
  THING *mp;
  unsigned char can_see, add_new;
  unsigned char was_there = 0;

  add_new = 0;
  for (mp = mlist; mp!=0; mp = next(mp))
  {
    move(mp->t_pos.y, mp->t_pos.x);
    can_see = (see_monst(mp) || (was_there = inch())==mp->t_type);
    if (turn_off)
    {
      if (!see_monst(mp) && mp->t_oldch!='@') addch(mp->t_oldch);
    }
    else
    {
      if (!can_see) {set_attr(BLACK_ON_GREY); mp->t_oldch = was_there;}
      addch(mp->t_type);
      if (!can_see) {set_attr(GREY); add_new++;}
    }
  }
  player.t_flags |= SEEMONST;
  if (turn_off) player.t_flags &= ~SEEMONST;
  return add_new;
}
//***************************************************************************

//***************************************************************************
//The player attacks the monster.
int fight(coord *mp, char mn, THING *weap, unsigned char thrown)
{
  THING *tp;
  char *mname;



  if (weap==0)
  {
    msg("you must wield something first")
    return 0;
  }

  if (weap->o_type!=WEAPON && weap->o_type!=POTION && weap->o_type!=STICK && weap->o_type!='*')
  {
    msg("you can't fight with that")
    return 0;
  }



  //Find the monster we want to fight
  if ((tp = moat(mp->y, mp->x))==0) return 0;
  //Since we are fighting, things are not quiet so no healing takes place.  Cancel any command counts so player can recover.
  count = quiet = 0;
  start_run(mp);
  //Let him know it was really a mimic (if it was one).
  if (tp->t_type=='X' && tp->t_disguise!='X' && !on(player, ISBLIND))
  {
    mn = tp->t_disguise = 'X';
    if (thrown) return 0;
    msg("wait! That's a Xeroc!")
  }
  mname = monsters[mn-'A'].m_name;
  if (on(player, ISBLIND)) mname = "it";
  if (roll_em(&player, tp, weap, thrown) || (weap && weap->o_type==POTION))
  {
    unsigned char did_huh = 0;

    if (thrown) thunk(weap, mname, "hits", "hit");
    else hit(0, mname);
    if (weap->o_type==POTION)
    {
      th_effect(weap, tp);
      if (!thrown)
      {
        if (weap->o_count>1) weap->o_count--;
        else {detach(pack, weap); discard(weap);}
        cur_weapon = 0;
      }
    }
    if (on(player, CANHUH))
    {
      did_huh = 1;
      tp->t_flags |= ISHUH;
      player.t_flags &= ~CANHUH;
      msg("your hands stop glowing red")
    }
    if (tp->t_stats.s_hpt<=0) killed(tp, 1);
    else if (did_huh && !on(player, ISBLIND)) msg("the %s appears confused", mname)
    return 1;
  }
  if (thrown) thunk(weap, mname, "misses", "missed");
  else miss(0, mname);
  if (tp->t_type=='S' && rnd(100)>25) slime_split(tp);
  return 0;
}

//The monster attacks the player
void attack(THING *mp)
{
  char *mname;

  //Since this is an attack, stop running and any healing that was going on at the time.
  running = 0;
  count = quiet = 0;
  if (mp->t_type=='X' && !on(player, ISBLIND)) mp->t_disguise = 'X';
  mname = monsters[mp->t_type-'A'].m_name;
  if (on(player, ISBLIND)) mname = "it";
  if (roll_em(mp, &player, 0, 0))
  {
    hit(mname, 0);
    if (pstats.s_hpt<=0) death(mp->t_type); //Bye bye life ...
    if (!on(*mp, ISCANC)) switch (mp->t_type)
    {

      case 'A': //If a rust monster hits, you lose armor, unless that armor is leather or there is a magic ring
        if (cur_armor!=0 && cur_armor->o_ac<9 && cur_armor->o_which!=LEATHER)
        {
          if (ISWEARING(R_SUSTARM)) msg("the rust vanishes instantly")
          else {msg("your armor weakens, oh my!") cur_armor->o_ac++;}
        }
      break;

      case 'I': //When an Ice Monster hits you, you get unfrozen faster
        if (no_command>1) no_command--;
      break;

      case 'R': //Rattlesnakes have poisonous bites
        if (!save(VS_POISON))
        {
          if (!ISWEARING(R_SUSTSTR)) {chg_str(-1); msg("you feel a bite in your leg and now feel weaker")}
          else msg("a bite momentarily weakens you")
        }
      break;

      case 'W': case 'V': //Wraiths might drain energy levels, and Vampires can steal max_hp
        if (rnd(100)<(mp->t_type=='W'?15:30))
        {
          int fewer;

          if (mp->t_type=='W')
          {
            if (pstats.s_exp==0) death('W'); //All levels gone
            if (--pstats.s_lvl==0) {pstats.s_exp = 0; pstats.s_lvl = 1;}
            else pstats.s_exp = e_levels[pstats.s_lvl-1]+1;
            fewer = roll(1, 10);
          }
          else fewer = roll(1, 5);
          pstats.s_hpt -= fewer;
          max_hp -= fewer;
          if (pstats.s_hpt<1) pstats.s_hpt = 1;
          if (max_hp<1) death(mp->t_type);
          msg("you suddenly feel weaker")
        }
      break;

      case 'F': //Violet fungi stops the poor guy from moving
        player.t_flags |= ISHELD;
        sprintf(mp->t_stats.s_dmg, "%dd1", ++fung_hit);
      break;

      case 'L': //Leprechaun steals some gold
      {
        int lastpurse;

        lastpurse = purse;
        purse -= GOLDCALC;
        if (!save(VS_MAGIC)) purse -= GOLDCALC+GOLDCALC+GOLDCALC+GOLDCALC;
        if (purse<0) purse = 0;
        remove_monster(&mp->t_pos, mp, 0);
        if (purse!=lastpurse) msg("your purse feels lighter")

        break;
      }

      case 'N': //Nymphs steal a magic item, look through the pack and pick out one we like.
      {
        THING *obj, *steal;
        int nobj;
        char *she_stole = "she stole %s!";

        steal = 0;
        for (nobj = 0, obj = pack; obj!=0; obj = next(obj))
        if (obj!=cur_armor && obj!=cur_weapon && obj!=cur_ring[LEFT] && obj!=cur_ring[RIGHT] && is_magic(obj) && rnd(++nobj)==0) steal = obj;
        if (steal!=0)
        {
          remove_monster(&mp->t_pos, mp, 0);
          if (steal->o_count>1 && steal->o_group==0)
          {
            int oc;

            oc = steal->o_count-1;
            steal->o_count = 1;
            msg(she_stole, inv_name(steal, 1))
            steal->o_count = oc;
          }
          else {inpack--; detach(pack, steal); discard(steal); msg(she_stole, inv_name(steal, 1))}
        }

        break;
      }

      default: break;
    }
  }
  else if (mp->t_type!='I')
  {
    if (mp->t_type=='F')
    {
      pstats.s_hpt -= fung_hit;
      if (pstats.s_hpt<=0) death(mp->t_type); //Bye bye life ...
    }
    miss(mname, 0);
  }
  flush_type();
  count = 0;
}

//Returns true if the swing hits
int swing(int at_lvl, int op_arm, int wplus)
{
  int res = rnd(20);
  int need = (20-at_lvl)-op_arm;

  return (res+wplus>=need);
}

//Check to see if the guy has gone up a level.
void check_level(void)
{
  int i, add, olevel;

  for (i = 0; e_levels[i]!=0; i++) if (e_levels[i]>pstats.s_exp) break;
  i++;
  olevel = pstats.s_lvl;
  pstats.s_lvl = i;
  if (i>olevel)
  {
    play_sound(LEVEL_SOUND);

    add = roll(i-olevel, 10);
    max_hp += add;
    if ((pstats.s_hpt += add)>max_hp) pstats.s_hpt = max_hp;
    msg("and achieve the rank of \"%s\"", he_man[i-1])
  }
}

//Roll several attacks
int roll_em(THING *thatt, THING *thdef, THING *weap, unsigned char hurl)
{
  struct stats *att, *def;
  char *cp;
  int ndice, nsides, def_arm;
  unsigned char did_hit = 0;
  int hplus;
  int dplus;
  int damage;

  att = &thatt->t_stats;
  def = &thdef->t_stats;
  if (weap==0) {cp = att->s_dmg; dplus = 0; hplus = 0;}
  else
  {
    hplus = weap->o_hplus;
    dplus = weap->o_dplus;
    //Check for vorpally enchanted weapon
    if (thdef->t_type==weap->o_enemy) {hplus += 4; dplus += 4;}
    if (weap==cur_weapon)
    {
      if (ISRING(LEFT, R_ADDDAM)) dplus += cur_ring[LEFT]->o_ac;
      else if (ISRING(LEFT, R_ADDHIT)) hplus += cur_ring[LEFT]->o_ac;
      if (ISRING(RIGHT, R_ADDDAM)) dplus += cur_ring[RIGHT]->o_ac;
      else if (ISRING(RIGHT, R_ADDHIT))
      hplus += cur_ring[RIGHT]->o_ac;
    }
    cp = weap->o_damage;
    if (hurl && (weap->o_flags&ISMISL) && cur_weapon!=0 && cur_weapon->o_which==weap->o_launch)
    {
      cp = weap->o_hurldmg;
      hplus += cur_weapon->o_hplus;
      dplus += cur_weapon->o_dplus;
    }
    //Drain a staff of striking
    if (weap->o_type==STICK && weap->o_which==WS_HIT && --weap->o_charges<0)
    {
      cp = weap->o_damage = "0d0";
      weap->o_hplus = weap->o_dplus = 0;
      weap->o_charges = 0;
    }
  }
  //If the creature being attacked is not running (asleep or held) then the attacker gets a plus four bonus to hit.
  if (!on(*thdef, ISRUN)) hplus += 4;
  def_arm = def->s_arm;
  if (def==&pstats)
  {
    if (cur_armor!=0) def_arm = cur_armor->o_ac;
    if (ISRING(LEFT, R_PROTECT)) def_arm -= cur_ring[LEFT]->o_ac;
    if (ISRING(RIGHT, R_PROTECT)) def_arm -= cur_ring[RIGHT]->o_ac;
  }
  for (;;)
  {
    ndice = atoi(cp);
    if ((cp = strchr(cp, 'd'))==0) break;
    nsides = atoi(++cp);
    if (swing(att->s_lvl, def_arm, hplus+str_plus(att->s_str)))
    {
      int proll;

      proll = roll(ndice, nsides);
      damage = dplus+proll+add_dam(att->s_str);
      //special goodies for the commercial version of rogue
      //make it easier on level one
      if (thdef==&player && max_level==1) damage = (damage+1)/2;
      def->s_hpt -= MAX2(0, damage);
      did_hit = 1;
    }
    if ((cp = strchr(cp, '/'))==0) break;
    cp++;
  }
  return did_hit;
}

//The print name of a combatant
char *prname(char *who, unsigned char upper)
{
  static char tbuf[MAXSTR];

  *tbuf = '\0';
  if (who==0) strcpy(tbuf, "you");
  else if (on(player, ISBLIND)) strcpy(tbuf, "it");
  else {strcpy(tbuf, "the "); strcat(tbuf, who);}
  if (upper) *tbuf = toupper(*tbuf);
  return tbuf;
}

//Print a message to indicate a successful hit
void hit(char *er, char *ee)
{
  char *s = 0;

  if (ee==0) play_sound(HIT1_SOUND);
  else       play_sound(HIT2_SOUND);

  switch (rnd(4))
  {
    case 0: s = " scored an excellent hit on "; break;
    case 1: s = " hit "; break;
    case 2: s = (er==0?" have injured ":" has injured "); break;
    case 3: s = (er==0?" swing and hit ":" swings and hits "); break;
  }

  addmsg(prname(er, 1))
  msg("%s%s", s, prname(ee, 0))
}

//Print a message to indicate a poor swing
void miss(char *er, char *ee)
{
  char *s = 0;

  if (ee==0) play_sound(MISS1_SOUND);
  else       play_sound(MISS2_SOUND);

  switch (rnd(4))
  {
    case 0: s = (er==0?" swing and miss":" swings and misses"); break;
    case 1: s = (er==0?" miss":" misses"); break;
    case 2: s = (er==0?" barely miss":" barely misses"); break;
    case 3: s = (er==0?" don't hit":" doesn't hit"); break;
  }

  addmsg(prname(er, 1))
  msg("%s %s", s, prname(ee, 0))
}

//See if a creature saves against something
int save_throw(int which, THING *tp)
{
  int need;

  need = 14+which-tp->t_stats.s_lvl/2;
  return (roll(1, 20)>=need);
}

//See if he saves against various nasty things
int save(int which)
{
  if (which==VS_MAGIC)
  {
    if (ISRING(LEFT, R_PROTECT)) which -= cur_ring[LEFT]->o_ac;
    if (ISRING(RIGHT, R_PROTECT)) which -= cur_ring[RIGHT]->o_ac;
  }
  return save_throw(which, &player);
}

//Compute bonus/penalties for strength on the "to hit" roll
int str_plus(unsigned int str)
{
  int add = 4;

  if (str<8) return str-7;
  if (str<31) add--;
  if (str<21) add--;
  if (str<19) add--;
  if (str<17) add--;
  return add;
}

//Compute additional damage done for exceptionally high or low strength
int add_dam(unsigned int str)
{
  int add = 6;

  if (str<8) return str-7;
  if (str<31) add--;
  if (str<22) add--;
  if (str<20) add--;
  if (str<18) add--;
  if (str<17) add--;
  if (str<16) add--;
  return add;
}

//The guy just magically went up a level.
void raise_level(void)
{
  pstats.s_exp = e_levels[pstats.s_lvl-1]+1L;
  check_level();
}

//A missile hit or missed a monster
void thunk(THING *weap, char *mname, char *does, char *did)
{
  if (weap->o_type==WEAPON) addmsg("the %s %s ", w_names[weap->o_which], does)
  else addmsg("you %s ", did)
  if (on(player, ISBLIND)) msg("it")
  else msg("the %s", mname)
}

//Remove a monster from the screen
void remove_monster(coord *mp, THING *tp, unsigned char waskill)
{
  THING *obj, *nexti;

  if (tp==0) return;
  for (obj = tp->t_pack; obj!=0; obj = nexti)
  {
    nexti = next(obj);
    bcopy(obj->o_pos, tp->t_pos);
    detach(tp->t_pack, obj);
    if (waskill) fall(obj, 0); else discard(obj);
  }
  if (_level[INDEX(mp->y, mp->x)]==PASSAGE) set_attr(BLACK_ON_GREY);
  if (tp->t_oldch==FLOOR && !cansee(mp->y, mp->x)) mvaddch(mp->y, mp->x, ' ');
  else if (tp->t_oldch!='@') mvaddch(mp->y, mp->x, tp->t_oldch);
  set_attr(GREY);
  detach(mlist, tp);
  discard(tp);
}

//Returns true if an object radiates magic
int is_magic(THING *obj)
{
  switch (obj->o_type)
  {
    case ARMOR: return obj->o_ac!=a_class[obj->o_which];
    case WEAPON: return obj->o_hplus!=0 || obj->o_dplus!=0;
    case POTION: case SCROLL: case STICK: case RING: case AMULET: return 1;
  }
  return 0;
}

//Called to put a monster to death
void killed(THING *tp, unsigned char pr)
{
  pstats.s_exp += tp->t_stats.s_exp;
  //If the monster was a violet fungi, un-hold him
  switch (tp->t_type)
  {

    case 'F':
      player.t_flags &= ~ISHELD;
      f_restor();
    break;

    case 'L':
    {
      THING *gold;

      if ((gold = new_item())==0) return;
      gold->o_type = GOLD;
      gold->o_goldval = GOLDCALC;
      if (save(VS_MAGIC)) gold->o_goldval += GOLDCALC+GOLDCALC+GOLDCALC+GOLDCALC;
      attach(tp->t_pack, gold);

      break;
    }

  }
  //Get rid of the monster.
  remove_monster(&tp->t_pos, tp, 1);
  if (pr)
  {
    addmsg("you have defeated ")
    if (on(player, ISBLIND)) msg("it")
    else msg("the %s", monsters[tp->t_type-'A'].m_name)
  }
  //Do adjustments if he went up a level
  check_level();
}
//***************************************************************************

//***************************************************************************
//Roll up the rogue
void init_player(void)
{
  THING *obj;

  bcopy(pstats, max_stats);

  food_left = HUNGERTIME;

  memset(_things, 0, MAXITEMS*sizeof(THING));
  memset(_t_alloc, 0, MAXITEMS*sizeof(int));

  obj = new_item();
  obj->o_type = WEAPON;
  obj->o_which = MACE;
  init_weapon(obj, MACE);
  obj->o_hplus = 1;
  obj->o_dplus = 1;
  obj->o_flags |= ISKNOW;
  obj->o_count = 1;
  obj->o_group = 0;
  add_pack(obj, 1);
  cur_weapon = obj;

  obj = new_item();
  obj->o_type = WEAPON;
  obj->o_which = BOW;
  init_weapon(obj, BOW);
  obj->o_hplus = 1;
  obj->o_dplus = 0;
  obj->o_count = 1;
  obj->o_group = 0;
  obj->o_flags |= ISKNOW;
  add_pack(obj, 1);

  obj = new_item();
  obj->o_type = WEAPON;
  obj->o_which = ARROW;
  init_weapon(obj, ARROW);
  obj->o_count = rnd(15)+25;
  obj->o_hplus = obj->o_dplus = 0;
  obj->o_flags |= ISKNOW;
  add_pack(obj, 1);

  obj = new_item();
  obj->o_type = ARMOR;
  obj->o_which = RING_MAIL;
  obj->o_ac = a_class[RING_MAIL]-1;
  obj->o_flags |= ISKNOW;
  obj->o_count = 1;
  obj->o_group = 0;
  cur_armor = obj;
  add_pack(obj, 1);

  obj = new_item();
  obj->o_type = FOOD;
  obj->o_count = 1;
  obj->o_which = 0;
  obj->o_group = 0;
  add_pack(obj, 1);
}

//Initialize the potion color scheme
void init_colors(void)
{
  int i, j;
  unsigned char used[27];

  static char *rainbow[27] =
  {
    "amber",      "aquamarine", "black",      "blue",       "brown",
    "clear",      "crimson",    "cyan",       "ecru",       "gold",
    "green",      "grey",       "magenta",    "orange",     "pink",
    "plaid",      "purple",     "red",        "silver",     "tan",
    "tangerine",  "topaz",      "turquoise",  "vermilion",  "violet",
    "white",      "yellow"
  };

  for (i = 0; i<27; i++) used[i] = 0;
  for (i = 0; i<MAXPOTIONS; i++)
  {
    do j = rnd(27); while (used[j]); used[j] = 1;

    p_colors[i] = rainbow[j];
    p_know[i] = 0;
    p_guess[i] = _guesses[iguess++].name;
  }
}

//Generate the names of the various scrolls
void init_names(void)
{
  int i, nwords, nsyl, flag;
  char *cp;

  static char c_set[21+1] = "bcdfghjklmnpqrstvwxyz";
  static char v_set[5+1] = "aeiou";

  for (i = 0; i<MAXSCROLLS; i++)
  {
    cp = prbuf; flag = 0; nwords = rnd(4)+2;
    while (nwords--)
    {
      nsyl = rnd(2)+1; if (cp-prbuf+1+3*nsyl>MAXNAME) break;
      if (flag) *cp++ = ' '; else flag = 1;
      while (nsyl--) {*cp++ = c_set[rnd(21)]; *cp++ = v_set[rnd(5)]; *cp++ = c_set[rnd(21)];}
    }
    *cp = 0;

    s_know[i] = 0;
    s_guess[i] = _guesses[iguess++].name;
    strcpy(s_names[i].name, prbuf);
  }
}

//Initialize the ring stone setting scheme
void init_stones(void)
{
  int i, j;
  unsigned char used[26];

  static struct {char *st_name; int st_value;} stones[26] =
  {
    {"agate",           25}, {"alexandrite",     40}, {"amethyst",        50},
    {"carnelian",       40}, {"diamond",        300}, {"emerald",        300},
    {"germanium",      225}, {"granite",          5}, {"garnet",          50},
    {"jade",           150}, {"kryptonite",     300}, {"lapis lazuli",    50},
    {"moonstone",       50}, {"obsidian",        15}, {"onyx",            60},
    {"opal",           200}, {"pearl",          220}, {"peridot",         63},
    {"ruby",           350}, {"sapphire",       285}, {"stibotantalite", 200},
    {"tiger eye",       50}, {"topaz",           60}, {"turquoise",       70},
    {"taaffeite",      300}, {"zircon",          80}
  };

  for (i = 0; i<26; i++) used[i] = 0;
  for (i = 0; i<MAXRINGS; i++)
  {
    do j = rnd(26); while (used[j]); used[j] = 1;

    r_stones[i] = stones[j].st_name;
    r_stoneworth[i] = stones[j].st_value;
    r_know[i] = 0;
    r_guess[i] = _guesses[iguess++].name;
  }
}

//Initialize the construction materials for wands and staffs
void init_materials(void)
{
  int i, j;
  unsigned char woodused[33], metused[22];

  static char *wood[33] =
  {
    "avocado wood",   "balsa",          "bamboo",         "banyan",
    "birch",          "cedar",          "cherry",         "cinnibar",
    "cypress",        "dogwood",        "driftwood",      "ebony",
    "elm",            "eucalyptus",     "fall",           "hemlock",
    "holly",          "ironwood",       "kukui wood",     "mahogany",
    "manzanita",      "maple",          "oaken",          "persimmon wood",
    "pecan",          "pine",           "poplar",         "redwood",
    "rosewood",       "spruce",         "teak",           "walnut",
    "zebrawood"
  };
  static char *metal[22] =
  {
    "aluminum",  "beryllium", "bone",      "brass",     "bronze",
    "copper",    "electrum",  "gold",      "iron",      "lead",
    "magnesium", "mercury",   "nickel",    "pewter",    "platinum",
    "steel",     "silver",    "silicon",   "tin",       "titanium",
    "tungsten",  "zinc"
  };

  for (i = 0; i<33; i++) woodused[i] = 0;
  for (i = 0; i<22; i++) metused[i] = 0;
  for (i = 0; i<MAXSTICKS; i++)
  {
    while (1)
    {
      if (rnd(2)==0) {j = rnd(33); if (!woodused[j]) {ws_type[i] = "staff"; ws_made[i] =  wood[j]; woodused[j] = 1; break;}}
      else           {j = rnd(22); if (! metused[j]) {ws_type[i] =  "wand"; ws_made[i] = metal[j];  metused[j] = 1; break;}}
    }

    ws_know[i] = 0;
    ws_guess[i] = _guesses[iguess++].name;
  }
}
//***************************************************************************

//***************************************************************************
//takes an item out of whatever linked list it might be in
void _detach(THING **list, THING *item)
{
  if (*list==item) *list = next(item);
  if (prev(item)!=0) item->l_prev->l_next = next(item);
  if (next(item)!=0) item->l_next->l_prev = prev(item);
  item->l_next = 0;
  item->l_prev = 0;
}

//add an item to the head of a list
void _attach(THING **list, THING *item)
{
  if (*list!=0) {item->l_next = *list; (*list)->l_prev = item; item->l_prev = 0;}
  else {item->l_next = 0; item->l_prev = 0;}
  *list = item;
}

//throw the whole blamed thing away
void _free_list(THING **ptr)
{
  THING *item;

  while (*ptr!=0) {item = *ptr; *ptr = next(item); discard(item);}
}

THING *talloc(void)
{
  int i;

  for (i = 0; i<MAXITEMS; i++)
  {
    if (_t_alloc[i]==0)
    {
      if (++total>maxitems) maxitems = total;
      _t_alloc[i]++;
      memset(&_things[i], 0, sizeof(THING));
      return &_things[i];
    }
  }
  return 0;
}

THING *new_item(void)
{
  THING *item;

  item = talloc(); if (item==0) return 0;
  item->l_next = item->l_prev = 0;
  return item;
}

int discard(THING *item)
{
  int i;

  for (i = 0; i<MAXITEMS; i++)
  {
    if (item==&_things[i]) {--total; _t_alloc[i] = 0; return 1;}
  }
  return 0;
}
//***************************************************************************

//***************************************************************************
//rewritten: check
void draw_maze(struct room *rp)
{
  int n, cnt, y, x, psgcnt, fy[MAXFRNT], fx[MAXFRNT], choice[4];
  int frcnt, ny, nx, topy, topx, maxx, maxy;
  coord spos;

  frcnt = 0;
  maxx = maxy = 0;
  topy = rp->r_pos.y; if (topy==0) topy = ++rp->r_pos.y;
  topx = rp->r_pos.x;

  y = topy; x = topx;
  chat(y, x) = PASSAGE; flat(y, x) = F_MAZE|F_REAL;
  if (x>maxx) maxx = x; if (y>maxy) maxy = y;

  y = topy-2; x = topx  ; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==' ') {chat(y, x) = 'F'; fy[frcnt] = y; fx[frcnt++] = x;}
  y = topy+2; x = topx  ; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==' ') {chat(y, x) = 'F'; fy[frcnt] = y; fx[frcnt++] = x;}
  y = topy  ; x = topx-2; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==' ') {chat(y, x) = 'F'; fy[frcnt] = y; fx[frcnt++] = x;}
  y = topy  ; x = topx+2; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==' ') {chat(y, x) = 'F'; fy[frcnt] = y; fx[frcnt++] = x;}

  while (frcnt)
  {
    n = rnd(frcnt--);
    ny = fy[n]; fy[n] = fy[frcnt];
    nx = fx[n]; fx[n] = fx[frcnt];

    cnt = 0;
    y = ny-2; x = nx  ; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==PASSAGE) choice[cnt++] = 0;
    y = ny+2; x = nx  ; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==PASSAGE) choice[cnt++] = 1;
    y = ny  ; x = nx-2; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==PASSAGE) choice[cnt++] = 2;
    y = ny  ; x = nx+2; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==PASSAGE) choice[cnt++] = 3;

    y = ny; x = nx;
    chat(y, x) = PASSAGE; flat(y, x) = F_MAZE|F_REAL;
    if (x>maxx) maxx = x; if (y>maxy) maxy = y;

    switch (choice[rnd(cnt)])
    {
      case 0: y = ny-1; x = nx  ; break;
      case 1: y = ny+1; x = nx  ; break;
      case 2: y = ny  ; x = nx-1; break;
      case 3: y = ny  ; x = nx+1; break;
    }
    if (y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3)
    {
      chat(y, x) = PASSAGE; flat(y, x) = F_MAZE|F_REAL;
      if (x>maxx) maxx = x; if (y>maxy) maxy = y;
    }

    y = ny-2; x = nx  ; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==' ') {chat(y, x) = 'F'; fy[frcnt] = y; fx[frcnt++] = x;}
    y = ny+2; x = nx  ; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==' ') {chat(y, x) = 'F'; fy[frcnt] = y; fx[frcnt++] = x;}
    y = ny  ; x = nx-2; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==' ') {chat(y, x) = 'F'; fy[frcnt] = y; fx[frcnt++] = x;}
    y = ny  ; x = nx+2; if ((y>=topy && y<topy+(23+1)/3 && x>=topx && x<topx+80/3) && chat(y, x)==' ') {chat(y, x) = 'F'; fy[frcnt] = y; fx[frcnt++] = x;}
  }

  //According to the Grand Beeking, every maze should have a loop.
  rp->r_max.x = maxx-rp->r_pos.x+1;
  rp->r_max.y = maxy-rp->r_pos.y+1;
  do
  {
    int sh;
    coord *cp;

    static coord ld[4] = {{-1, 0}, {0, 1}, {1, 0}, {0, -1}};

    rnd_pos(rp, &spos);
    for (psgcnt = 0, cp = ld, sh = 1; cp<&ld[4]; sh <<= 1, cp++)
    {
      y = cp->y+spos.y; x = cp->x+spos.x;
      if (!offmap(y, x) && chat(y, x)==PASSAGE) psgcnt += sh;
    }
  } while (chat(spos.y, spos.x)==PASSAGE || psgcnt%5);

  y = spos.y; x = spos.x;
  chat(y, x) = PASSAGE; flat(y, x) = F_MAZE|F_REAL;
  if (x>maxx) maxx = x; if (y>maxy) maxy = y;
}
//***************************************************************************

//***************************************************************************
//Print the name of a trap
char *tr_name(unsigned char type)
{
  switch (type)
  {
    case T_DOOR: return "a trapdoor";
    case T_BEAR: return "a beartrap";
    case T_SLEEP: return "a sleeping gas trap";
    case T_ARROW: return "an arrow trap";
    case T_TELEP: return "a teleport trap";
    case T_DART: return "a poison dart trap";
  }
  msg("weird trap: %d", type)
  return 0;
}

//A quick glance all around the player
void look(unsigned char wakeup)
{
  int x, y;
  unsigned char ch, pch;
  int index;
  THING *tp;
  struct room *rp;
  int ey, ex;
  int passcount = 0;
  unsigned char pfl, *fp;
  int sy, sx, sumhero = 0, diffhero = 0;

  rp = proom;
  index = INDEX(hero.y, hero.x);
  pfl = _flags[index];
  pch = _level[index];
  //if the hero has moved
  if (!ce(oldpos, hero))
  {
    if (!on(player, ISBLIND))
    {
      for (x = oldpos.x-1; x<=(oldpos.x+1); x++)
      for (y = oldpos.y-1; y<=(oldpos.y+1); y++)
      {
        if ((y==hero.y && x==hero.x) || offmap(y,x)) continue;
        move(y, x);
        ch = inch();
        if (ch==FLOOR)
        {
          if ((oldrp->r_flags & (ISGONE|ISDARK))==ISDARK) addch(' ');
        }
        else
        {
          fp = &_flags[INDEX(y, x)];
          //if the maze or passage (that the hero is in!!) needs to be redrawn (passages once drawn always stay on) do it now.
          if (((*fp&F_MAZE) || (*fp&F_PASS)) && (ch!=PASSAGE) && (ch!=STAIRS) && ((*fp&F_PNUM)==(pfl & F_PNUM))) addch(PASSAGE);
        }
      }
    }
    oldpos = hero;
    oldrp = rp;
  }
  ey = hero.y+1;
  ex = hero.x+1;
  sx = hero.x-1;
  sy = hero.y-1;
  if (door_stop && !firstmove && running) {sumhero = hero.y+hero.x; diffhero = hero.y-hero.x;}
  for (y = sy; y<=ey; y++) if (y>0 && y<23) for (x = sx; x<=ex; x++)
  {
    if (x<=0 || x>=80) continue;
    if (!on(player, ISBLIND))
    {
      if (y==hero.y && x==hero.x) continue;
    }
    else if (y!=hero.y || x!=hero.x) continue;
    index = INDEX(y, x);
    //This replicates moat()
    fp = &_flags[index];
    ch = _level[index];
    if (pch!=DOOR && ch!=DOOR) //No Doors
    {
      if ((pfl&F_PASS)!=(*fp&F_PASS)) //Either hero or other in a passage
      {
        if (!(pfl&F_MAZE) && !(*fp&F_MAZE)) continue; //Neither is in a maze
      }
      else if ((*fp&F_PASS) && (*fp&F_PNUM)!=(pfl&F_PNUM)) continue; //Not in same passage
    }
    if ((tp = moat(y, x))!=0)
    {
      if (on(player, SEEMONST) && on(*tp, ISINVIS))
      {
        if (door_stop && !firstmove) running = 0;
        continue;
      }
      else
      {
        if (wakeup) wake_monster(y, x);
        if (tp->t_oldch != ' ' || (!(rp->r_flags&ISDARK) && !on(player, ISBLIND))) tp->t_oldch = _level[index];
        if (see_monst(tp)) ch = tp->t_disguise;
      }
    }
    //The current character used for IBM ARMOR doesn't look right in Inverse
    if ((ch!=PASSAGE) && (*fp&(F_PASS|F_MAZE))) if (ch!=ARMOR) set_attr(BLACK_ON_GREY);
    move(y, x);
    addch(ch);
    set_attr(GREY);
    if (door_stop && !firstmove && running)
    {
      switch (runch)
      {
        case 'h': if (x==ex) continue; break;
        case 'j': if (y==sy) continue; break;
        case 'k': if (y==ey) continue; break;
        case 'l': if (x==sx) continue; break;
        case 'y': if ((y+x)-sumhero>=1) continue; break;
        case 'u': if ((y-x)-diffhero>=1) continue; break;
        case 'n': if ((y+x)-sumhero<=-1) continue; break;
        case 'b': if ((y-x)-diffhero<=-1) continue; break;
      }
      switch (ch)
      {
        case DOOR: if (x==hero.x || y==hero.y) running = 0; break;
        case PASSAGE: if (x==hero.x || y==hero.y) passcount++; break;
        case FLOOR: case VWALL: case HWALL: case ULWALL: case URWALL: case LLWALL: case LRWALL: case ' ': break;
        default: running = 0; break;
      }
    }
  }
  if (door_stop && !firstmove && passcount>1) running = 0;
  move(hero.y, hero.x);
  if ((flat(hero.y, hero.x)&F_PASS) || (was_trapped>1) || (flat(hero.y, hero.x)&F_MAZE)) set_attr(BLACK_ON_GREY);
  addch(PLAYER);
  set_attr(GREY);
  if (was_trapped) was_trapped = 0;
}

//Find the unclaimed object at y, x
THING *find_obj(int y, int x)
{
  THING *op;

  for (op = lvl_obj; op!=0; op = next(op)) if (op->o_pos.y==y && op->o_pos.x==x) return op;
  return 0;
}

//She wants to eat something, so let her try
void eat(void)
{
  THING *obj;

  if ((obj = get_item("eat", FOOD))==0) return;
  if (obj->o_type!=FOOD) {msg("ugh, you would get ill if you ate that") return;}

  play_sound(EAT_SOUND);

  if (--obj->o_count<1) {inpack--; detach(pack, obj); discard(obj);}
  if (food_left<0) food_left = 0;
  if (food_left>(STOMACHSIZE-20)) no_command += 2+rnd(5);
  if ((food_left += HUNGERTIME-200+rnd(400))>STOMACHSIZE) food_left = STOMACHSIZE;
  hungry_state = 0;
  if (obj==cur_weapon) cur_weapon = 0;
  if (obj->o_which==1) msg("my, that was a yummy %s", fruit)
  else if (rnd(100)>70) {pstats.s_exp++; msg("yuk, this food tastes awful") check_level();}
  else msg("yum, that tasted good")
  if (no_command) msg("You feel bloated and fall asleep")
}

//Used to modify the player's strength.  It keeps track of the highest it has been, just in case
void chg_str(int amt)
{
  unsigned int comp;

  if (amt==0) return;
  add_str(&pstats.s_str, amt);
  comp = pstats.s_str;
  if (ISRING(LEFT, R_ADDSTR)) add_str(&comp, -cur_ring[LEFT]->o_ac);
  if (ISRING(RIGHT, R_ADDSTR)) add_str(&comp, -cur_ring[RIGHT]->o_ac);
  if (comp>max_stats.s_str) max_stats.s_str = comp;
}

//Perform the actual add, checking upper and lower bound
void add_str(unsigned int *sp, int amt)
{
  if ((*sp += amt)<3) *sp = 3;
  else if (*sp>31) *sp = 31;
}

//Add a haste to the player
int add_haste(unsigned char potion)
{
  if (on(player, ISHASTE))
  {
    no_command += rnd(8);
    player.t_flags &= ~ISRUN;
    extinguish(nohaste);
    player.t_flags &= ~ISHASTE;
    msg("you faint from exhaustion")
    return 0;
  }
  else
  {
    player.t_flags |= ISHASTE;
    if (potion) fuse(nohaste, 0, rnd(4)+10);
    return 1;
  }
}

//Aggravate all the monsters on this level
void aggravate(void)
{
  THING *mi;

  for (mi = mlist; mi!=0; mi = next(mi)) start_run(&mi->t_pos);
}

//For printfs: if string starts with a vowel, return "n" for an "an".
char *vowelstr(char *str)
{
  switch (*str)
  {
    case 'a': case 'A': case 'e': case 'E': case 'i': case 'I': case 'o': case 'O': case 'u': case 'U': return "n";
    default: return "";
  }
}

//See if the object is one of the currently used items
int is_current(THING *obj)
{
  if (obj==0) return 0;
  if (obj==cur_armor || obj==cur_weapon || obj==cur_ring[LEFT] || obj==cur_ring[RIGHT])
  {
    msg("That's already in use")
    return 1;
  }
  return 0;
}

//Set up the direction coordinate for use in various "prefix" commands
int get_dir(void)
{
  int ch;

  if (again) return 1;
  msg("which direction? ")
  do if ((ch = readchar())==ESCAPE) {clearmsg() return 0;} while (find_dir(ch, &delta)==0);
  clearmsg()
  if (on(player, ISHUH) && rnd(5)==0) do
  {
    delta.y = rnd(3)-1;
    delta.x = rnd(3)-1;
  } while (delta.y==0 && delta.x==0);
  return 1;
}

int find_dir(unsigned char ch, coord *cp)
{
  unsigned char gotit;

  gotit = 1;
  switch (ch)
  {
    case 'h': case'H': cp->y = 0; cp->x = -1; break;
    case 'j': case'J': cp->y = 1; cp->x = 0; break;
    case 'k': case'K': cp->y = -1; cp->x = 0; break;
    case 'l': case'L': cp->y = 0; cp->x = 1; break;
    case 'y': case'Y': cp->y = -1; cp->x = -1; break;
    case 'u': case'U': cp->y = -1; cp->x = 1; break;
    case 'b': case'B': cp->y = 1; cp->x = -1; break;
    case 'n': case'N': cp->y = 1; cp->x = 1; break;
    default: gotit = 0; break;
  }
  return gotit;
}

//Return the sign of the number
int sign(int nm)
{
  if (nm<0) return -1; else return (nm>0);
}

//Give a spread around a given number (+/- 10%)
int spread(int nm)
{
  int r = nm-nm/10+rnd(nm/5);

  return r;
}

//Call an object something after use.
void call_it(unsigned char know, char **guess)
{
  if (know && **guess) **guess = 0;
  else if (!know && **guess==0)
  {
    msg("what do you want to call it? ")
    getinfo(prbuf, MAXNAME); if (*prbuf) strcpy(*guess, prbuf);
    clearmsg()
  }
}

//Returns true if it is ok to step on ch
int step_ok(int ch)
{
  switch (ch)
  {
    case ' ': case VWALL: case HWALL: case ULWALL: case URWALL: case LLWALL: case LRWALL: return 0;
    default: return ((ch<'A') || (ch>'Z'));
  }
}

//Decide how good an object is and return the correct character for printing.
int goodch(THING *obj)
{
  int ch = MAGIC;

  if (obj->o_flags&ISCURSED) ch = BMAGIC;
  switch (obj->o_type)
  {
    case ARMOR:
      if (obj->o_ac>a_class[obj->o_which]) ch = BMAGIC;
    break;
    case WEAPON:
      if (obj->o_hplus<0 || obj->o_dplus<0) ch = BMAGIC;
    break;
    case SCROLL:
      switch (obj->o_which) {case S_SLEEP: case S_CREATE: case S_AGGR: ch = BMAGIC; break;}
    break;
    case POTION:
      switch (obj->o_which) {case P_CONFUSE: case P_PARALYZE: case P_POISON: case P_BLIND: ch = BMAGIC; break;}
    break;
    case STICK:
      switch (obj->o_which) {case WS_HASTE_M: case WS_TELTO: ch = BMAGIC; break;}
    break;
    case RING:
      switch (obj->o_which)
      {
        case R_PROTECT: case R_ADDSTR: case R_ADDDAM: case R_ADDHIT: if (obj->o_ac<0) ch = BMAGIC; break;
        case R_AGGR: case R_TELEPORT: ch = BMAGIC; break;
      }
    break;
  }
  return ch;
}

//view help screens (num 0: commands, 1: objects)
void help(int num)
{
  int hcount = 0, hrow, hcol, isfull;
  unsigned char answer = 0;
  char **helpscr;

  if (num==0) helpscr = helpcoms; else helpscr = helpobjs;

  wdump();
  while (*helpscr && answer!=ESCAPE)
  {
    isfull = 0;
    if (hcount%46==0)
    {
      wclear();
      set_tile_mode(0);
    }
    hcol = 0;
    hrow = (hcount%46)/2;
    if (hcount%2) hcol = 30;
    if (hrow==22 && hcol==30) isfull = 1;
    move(hrow, hcol); addstr(*helpscr++);
    if (*helpscr==0 || isfull)
    {
      if (*helpscr==0) mvaddstr(24, 0, "Press space to continue.");
      else mvaddstr(24, 0, "Press space for more, Esc to continue.");
      do answer = readchar(); while (answer!=' ' && answer!=ESCAPE);
    }
    hcount++;
  }

  set_tile_mode(1);
  wrestor();
}

int DISTANCE(int y1, int x1, int y2, int x2)
{
  int dx, dy;

  dx = (x1-x2);
  dy = (y1-y2);
  return dx*dx+dy*dy;
}

int _ce(coord *a, coord *b)
{
  return (a->x==b->x && a->y==b->y);
}

int INDEX(int y, int x)
{
  return ((x*(23-1))+y-1);
}

int offmap(int y, int x)
{
  return (y<1 || y>=23 || x<0 || x>=80);
}

int winat(int y, int x)
{
  return (moat(y, x)!=0?moat(y, x)->t_disguise:chat(y, x));
}

//Player gropes about him to find hidden things.
void search(void)
{
  int y, x;
  unsigned char *fp;
  int ey, ex;

  if (on(player, ISBLIND)) return;
  ey = hero.y+1;
  ex = hero.x+1;
  for (y = hero.y-1; y<=ey; y++) for (x = hero.x-1; x<=ex; x++)
  {
    if ((y==hero.y && x==hero.x) || offmap(y, x)) continue;
    fp = &flat(y, x);
    if (!(*fp&F_REAL)) switch (chat(y, x))
    {
      case VWALL: case HWALL: case ULWALL: case URWALL: case LLWALL: case LRWALL:
        if (rnd(5)!=0) break;
        chat(y, x) = DOOR;
        *fp |= F_REAL;
        count = running = 0;
      break;
      case FLOOR:
        if (rnd(2)!=0) break;
        chat(y, x) = TRAP;
        *fp |= F_REAL;
        count = running = 0;
        msg("you found %s", tr_name(*fp&F_TMASK))
      break;
    }
  }
}

//He wants to go down a level
void d_level(void)
{
  if (chat(hero.y, hero.x)!=STAIRS) msg("I see no way down")
  else
  {
    play_sound(STAIRS_SOUND);

    level++; new_level();
  }
}

//He wants to go up a level
void u_level(void)
{
  if (chat(hero.y, hero.x)==STAIRS)
    if (amulet)
    {
      play_sound(STAIRS_SOUND);

      level--; if (level==0) total_winner();
      new_level();
      clearmsg()
      msg("you feel a wrenching sensation in your gut")
    }
    else msg("your way is magically blocked")
  else msg("I see no way up")
}

//Allow a user to call a potion, scroll, or ring something
void call(void)
{
  THING *obj;
  char **guess, *elsewise;
  unsigned char *know;

  obj = get_item("call", CALLABLE);
  //Make certain that it is something that we want to wear
  if (obj==0) return;
  switch (obj->o_type)
  {
    case RING:   guess = (char **)r_guess;  know = r_know;  elsewise = (*guess[obj->o_which]!=0?guess[obj->o_which]:r_stones[obj->o_which]); break;
    case POTION: guess = (char **)p_guess;  know = p_know;  elsewise = (*guess[obj->o_which]!=0?guess[obj->o_which]:p_colors[obj->o_which]); break;
    case SCROLL: guess = (char **)s_guess;  know = s_know;  elsewise = (*guess[obj->o_which]!=0?guess[obj->o_which]:s_names[obj->o_which].name); break;
    case STICK:  guess = (char **)ws_guess; know = ws_know; elsewise = (*guess[obj->o_which]!=0?guess[obj->o_which]:ws_made[obj->o_which]); break;
    default: msg("you can't call that anything") return;
  }
  if (know[obj->o_which]) {msg("that has already been identified") return;}
  msg("Was called \"%s\"", elsewise)
  msg("what do you want to call it? ")
  getinfo(prbuf, MAXNAME); if (*prbuf) strcpy(guess[obj->o_which], prbuf);
  clearmsg()
}

void do_macro(void)
{
  msg("macro was: %s", macro)
  msg("enter new macro: ")
  getinfo(prbuf, 30); if (*prbuf) strcpy(macro, prbuf);
  clearmsg()
  flush_type();
}
//***************************************************************************

//***************************************************************************
//Pick a monster to show up.  The lower the level, the meaner the monster.
int randmonster(unsigned char wander)
{
  char *lvl_mons =  "K BHISOR LCA NYTWFP GMXVJD";
  char *wand_mons = "KEBHISORZ CAQ YTW PUGM VJ ";
  char *mons;
  int d;

  mons = wander?wand_mons:lvl_mons;
  do
  {
    int r10 = rnd(5)+rnd(6);

    d = level+(r10-5);
    if (d<1) d = rnd(5)+1;
    if (d>26) d = rnd(5)+22;
  } while (mons[--d]==' ');
  return mons[d];
}

//Pick a new monster and add it to the list
void new_monster(THING *tp, unsigned char type, coord *cp)
{
  struct monster *mp;
  int lev_add;

  if ((lev_add = level-AMULETLEVEL)<0) lev_add = 0;
  attach(mlist, tp);
  tp->t_type = type;
  tp->t_disguise = type;
  bcopy(tp->t_pos, *cp);
  tp->t_oldch = '@';
  tp->t_room = roomin(cp);
  mp = &monsters[tp->t_type-'A'];
  tp->t_stats.s_lvl = mp->m_stats.s_lvl+lev_add;
  tp->t_stats.s_maxhp = tp->t_stats.s_hpt = roll(tp->t_stats.s_lvl, 8);
  tp->t_stats.s_arm = mp->m_stats.s_arm-lev_add;
  tp->t_stats.s_dmg = mp->m_stats.s_dmg;
  tp->t_stats.s_str = mp->m_stats.s_str;
  tp->t_stats.s_exp = mp->m_stats.s_exp+lev_add*10+exp_add(tp);
  tp->t_flags = mp->m_flags;
  tp->t_turn = 1;
  tp->t_pack = 0;
  if (ISWEARING(R_AGGR)) start_run(cp);
  if (type=='F') tp->t_stats.s_dmg = f_damage;
  if (type=='X') switch (rnd(level>25?9:8))
  {
    case 0: tp->t_disguise = GOLD; break;
    case 1: tp->t_disguise = POTION; break;
    case 2: tp->t_disguise = SCROLL; break;
    case 3: tp->t_disguise = STAIRS; break;
    case 4: tp->t_disguise = WEAPON; break;
    case 5: tp->t_disguise = ARMOR; break;
    case 6: tp->t_disguise = RING; break;
    case 7: tp->t_disguise = STICK; break;
    case 8: tp->t_disguise = AMULET; break;
  }
}

//restore initial damage string for flytraps
void f_restor(void)
{
  struct monster *mp = &monsters['F'-'A'];

  fung_hit = 0;
  strcpy(f_damage, mp->m_stats.s_dmg);
}

//Experience to add for this monster's level/hit points
int exp_add(THING *tp)
{
  int mod;

  if (tp->t_stats.s_lvl==1) mod = tp->t_stats.s_maxhp/8;
  else mod = tp->t_stats.s_maxhp/6;
  if (tp->t_stats.s_lvl>9) mod *= 20;
  else if (tp->t_stats.s_lvl>6) mod *= 4;
  return mod;
}

//Create a new wandering monster and aim it at the player
void wanderer(void)
{
  int i;
  struct room *rp;
  THING *tp;
  coord cp;

  //can we allocate a new monster
  if ((tp = new_item())==0) return;
  do
  {
    i = rnd_room();
    if ((rp = &rooms[i])==proom) continue;
    rnd_pos(rp, &cp);
  } while (!(rp!=proom && step_ok(winat(cp.y, cp.x))));
  new_monster(tp, randmonster(1), &cp);
  start_run(&tp->t_pos);
}

//What to do when the hero steps next to a monster
THING *wake_monster(int y, int x)
{
  THING *tp;
  struct room *rp;
  unsigned char ch;
  int dst;

  if ((tp = moat(y, x))==0) return tp;
  ch = tp->t_type;
  //Every time he sees mean monster, it might start chasing him
  if (!on(*tp, ISRUN) && rnd(3)!=0 && on(*tp, ISMEAN) && !on(*tp, ISHELD) && !ISWEARING(R_STEALTH))
  {
    tp->t_dest = &hero;
    tp->t_flags |= ISRUN;
  }
  if (ch=='M' && !on(player, ISBLIND) && !on(*tp, ISFOUND) && !on(*tp, ISCANC) && on(*tp, ISRUN))
  {
    rp = proom;
    dst = DISTANCE(y, x, hero.y, hero.x);
    if ((rp!=0 && !(rp->r_flags&ISDARK)) || dst<LAMPDIST)
    {
      tp->t_flags |= ISFOUND;
      if (!save(VS_MAGIC))
      {
        play_sound(MEDUSA_SOUND);

        if (on(player, ISHUH)) lengthen(unconfuse, rnd(20)+HUHDURATION);
        else fuse(unconfuse, 0, rnd(20)+HUHDURATION);
        player.t_flags |= ISHUH;
        msg("the medusa's gaze has confused you")
      }
    }
  }
  //Let greedy ones guard gold
  if (on(*tp, ISGREED) && !on(*tp, ISRUN))
  {
    tp->t_flags = tp->t_flags|ISRUN;
    if (proom->r_goldval) tp->t_dest = &proom->r_gold;
    else tp->t_dest = &hero;
  }
  return tp;
}

//Give a pack to a monster if it deserves one
void give_pack(THING *tp)
{
  //check if we can allocate a new item
  if (total<MAXITEMS && rnd(100)<monsters[tp->t_type-'A'].m_carry) attach(tp->t_pack, new_thing());
}

//Choose a sort of monster for the enemy of a vorpally enchanted weapon
int pick_mons(void)
{
  char *p, *mon = "KBHISORLCANYTWFPGMXVJD";

  p = mon+strlen(mon);
  while (--p>=mon && rnd(10)) ;
  if (p<mon) return 'M';
  return *p;
}

//returns pointer to monster at coordinate. if no monster there return 0
THING *moat(int my, int mx)
{
  THING *tp;

  for (tp = mlist; tp!=0; tp = next(tp)) if (tp->t_pos.x==mx && tp->t_pos.y==my) return (tp);
  return (0);
}
//***************************************************************************

//***************************************************************************
//Start the hero running
void do_run(unsigned char ch)
{
  running = 1;
  after = 0;
  runch = ch;
}

//Check to see that a move is legal.  If it is handle the consequences (fighting, picking up, etc.)
void do_move(int dy, int dx)
{
  unsigned char ch;
  int fl;

  firstmove = 0;
  if (bailout) {bailout = 0; msg("the crack widens ... ") descend(""); return;}
  if (no_move) {no_move--; msg("you are still stuck in the bear trap") return;}
  //Do a confused move (maybe)
  if (on(player, ISHUH) && rnd(5)!=0) rndmove(&player, &nh);
  else
  {
over:
    nh.y = hero.y+dy;
    nh.x = hero.x+dx;
  }
  //Check if he tried to move off the screen or make an illegal diagonal move, and stop him if he did. fudge it for 40/80 jll -- 2/7/84
  if (offmap(nh.y, nh.x)) goto hit_bound;
  if (!diag_ok(&hero, &nh)) {after = 0; running = 0; return;}
  //If you are running and the move does not get you anywhere stop running
  if (running && ce(hero, nh)) after = running = 0;
  fl = flat(nh.y, nh.x);
  ch = winat(nh.y, nh.x);
  //When the hero is on the door do not allow him to run until he enters the room all the way
  if ((chat(hero.y, hero.x)==DOOR) && (ch==FLOOR)) running = 0;
  if (!(fl&F_REAL) && ch==FLOOR) {chat(nh.y, nh.x) = ch = TRAP; flat(nh.y, nh.x) |= F_REAL;}
  else if (on(player, ISHELD) && ch!='F') {msg("you are being held") return;}
  switch (ch)
  {
    case ' ': case VWALL: case HWALL: case ULWALL: case URWALL: case LLWALL: case LRWALL:
hit_bound:
      if (running && isgone(proom) && !on(player, ISBLIND))
      {
        unsigned char b1, b2;

        switch (runch)
        {
          case 'h': case 'l':
            b1 = (hero.y>1 && ((flat(hero.y-1, hero.x)&F_PASS) || chat(hero.y-1, hero.x)==DOOR));
            b2 = (hero.y<23-1 && ((flat(hero.y+1, hero.x)&F_PASS) || chat(hero.y+1, hero.x)==DOOR));
            if (!(b1^b2)) break;
            if (b1) {runch = 'k'; dy = -1;}
            else {runch = 'j'; dy = 1;}
            dx = 0;
            goto over;

          case 'j': case 'k':
            b1 = (hero.x>1 && ((flat(hero.y, hero.x-1)&F_PASS) || chat(hero.y, hero.x-1)==DOOR));
            b2 = (hero.x<80-2 && ((flat(hero.y, hero.x+1)&F_PASS) || chat(hero.y, hero.x+1)==DOOR));
            if (!(b1^b2)) break;
            if (b1) {runch = 'h'; dx = -1;}
            else {runch = 'l'; dx = 1;}
            dy = 0;
            goto over;
        }
      }
      after = running = 0;
    break;

    case DOOR:
      running = 0;
      if (flat(hero.y, hero.x)&F_PASS) enter_room(&nh);
      goto move_stuff;

    case TRAP:
      ch = be_trapped(&nh);
      if (ch==T_DOOR || ch==T_TELEP) return;

    case PASSAGE:
      goto move_stuff;

    case FLOOR:
      if (!(fl&F_REAL)) be_trapped(&hero);
      goto move_stuff;

    default:
      running = 0;
      if (isupper(ch) || moat(nh.y, nh.x)) fight(&nh, ch, cur_weapon, 0);
      else
      {
        running = 0;
        if (ch!=STAIRS) take = ch;
move_stuff:
        mvaddch(hero.y, hero.x, chat(hero.y, hero.x));
        if ((fl&F_PASS) && (chat(oldpos.y, oldpos.x)==DOOR || (flat(oldpos.y, oldpos.x)&F_MAZE))) leave_room(&nh);
        if ((fl&F_MAZE) && (flat(oldpos.y, oldpos.x)&F_MAZE)==0) enter_room(&nh);
        bcopy(hero, nh);
      }
  }
}

//Called to illuminate a room.  If it is dark, remove anything that might move.
void door_open(struct room *rp)
{
  int j, k;
  unsigned char ch;
  THING *item;

  if (!(rp->r_flags&ISGONE) && !on(player, ISBLIND))
  for (j = rp->r_pos.y; j<rp->r_pos.y+rp->r_max.y; j++)
  for (k = rp->r_pos.x; k<rp->r_pos.x+rp->r_max.x; k++)
  {
    ch = winat(j, k);
    if (isupper(ch))
    {
      item = wake_monster(j, k);
      if (item->t_oldch==' ' && !(rp->r_flags&ISDARK) && !on(player, ISBLIND)) item->t_oldch = chat(j, k);
    }
  }
}

//The guy stepped on a trap.... Make him pay.
int be_trapped(coord *tc)
{
  unsigned char tr;
  int index;

  play_sound(TRAP_SOUND);

  count = running = 0;
  index = INDEX(tc->y, tc->x);
  _level[index] = TRAP;
  tr = _flags[index]&F_TMASK;
  was_trapped = 1;
  switch (tr)
  {
    case T_DOOR:
      descend("you fell into a trap!");
    break;

    case T_BEAR:
      no_move += BEARTIME;
      msg("you are caught in a bear trap")
    break;

    case T_SLEEP:
      no_command += SLEEPTIME;
      player.t_flags &= ~ISRUN;
      msg("a strange white mist envelops you and you fall asleep")
    break;

    case T_ARROW:
      if (swing(pstats.s_lvl-1, pstats.s_arm, 1))
      {
        pstats.s_hpt -= roll(1, 6);
        if (pstats.s_hpt<=0) {msg("an arrow killed you") death('a');}
        else msg("oh no! An arrow shot you")
      }
      else
      {
        THING *arrow;

        if ((arrow = new_item())!=0)
        {
          arrow->o_type = WEAPON;
          arrow->o_which = ARROW;
          init_weapon(arrow, ARROW);
          arrow->o_count = 1;
          bcopy(arrow->o_pos, hero);
          fall(arrow, 0);
        }
        msg("an arrow shoots past you")
      }
    break;

    case T_TELEP:
      teleport();
      mvaddch(tc->y, tc->x, TRAP); //since the hero's leaving, look() won't put it on for us
      was_trapped++;
    break;

    case T_DART:
      if (swing(pstats.s_lvl+1, pstats.s_arm, 1))
      {
        pstats.s_hpt -= roll(1, 4);
        if (pstats.s_hpt<=0) {msg("a poisoned dart killed you") death('d');}
        if (!ISWEARING(R_SUSTSTR) && !save(VS_POISON)) chg_str(-1);
        msg("a dart just hit you in the shoulder")
      }
      else msg("a dart whizzes by your ear and vanishes")
    break;
  }
  flush_type();
  return tr;
}

void descend(char *mesg)
{
  level++;
  if (*mesg==0) msg(" ")
  new_level();
  clearmsg()
  msg(mesg)
  if (!save(VS_LUCK))
  {
    msg("you are damaged by the fall")
    if ((pstats.s_hpt -= roll(1,8))<=0) death('f');
  }
}

//Move in a random direction if the monster/person is confused
void rndmove(THING *who, coord *newmv)
{
  int x, y;
  unsigned char ch;
  THING *obj;

  y = newmv->y = who->t_pos.y+rnd(3)-1;
  x = newmv->x = who->t_pos.x+rnd(3)-1;
  //Now check to see if that's a legal move.  If not, don't move. (I.e., bump into the wall or whatever)
  if (y==who->t_pos.y && x==who->t_pos.x) return;
  if ((y<1 || y>=23) || (x<0 || x>=80)) goto bad;
  else if (!diag_ok(&who->t_pos, newmv)) goto bad;
  else
  {
    ch = winat(y, x);
    if (!step_ok(ch)) goto bad;
    if (ch==SCROLL)
    {
      for (obj = lvl_obj; obj!=0; obj = next(obj)) if (y==obj->o_pos.y && x==obj->o_pos.x) break;
      if (obj!=0 && obj->o_which==S_SCARE) goto bad;
    }
  }
  return;
bad:
  bcopy((*newmv), who->t_pos);
  return;
}
//***************************************************************************

//***************************************************************************
//Pick a room that is really there
int rnd_room(void)
{
  int rm;

  do rm = rnd(MAXROOMS); while (!((rooms[rm].r_flags&ISGONE)==0 || (rooms[rm].r_flags&ISMAZE)));
  return rm;
}

//Put potions and scrolls on this level
void put_things(void)
{
  int i = 0;
  THING *cur;
  int rm;
  coord tp;

  //Once you have found the amulet, the only way to get new stuff is to go down into the dungeon.
  //This is real unfair - I'm going to allow one thing, that way the poor guy will get some food.
  if (saw_amulet && level<max_level) i = MAXOBJ-1;
  else
  {
    //If he is really deep in the dungeon and he hasn't found the amulet yet, put it somewhere on the ground
    //Check this first so if we are out of memory the guy has a hope of getting the amulet
    if (level>=AMULETLEVEL && !saw_amulet)
    {
      if ((cur = new_item())!=0)
      {
        attach(lvl_obj, cur);
        cur->o_hplus = cur->o_dplus = 0;
        cur->o_damage = cur->o_hurldmg = "0d0";
        cur->o_ac = 11;
        cur->o_type = AMULET;
        //Put it somewhere
        do {rm = rnd_room(); rnd_pos(&rooms[rm], &tp);} while (!isfloor(winat(tp.y, tp.x)));
        chat(tp.y, tp.x) = AMULET;
        bcopy(cur->o_pos, tp);
      }
    }
    //check for treasure rooms, and if so, put it in.
    if (rnd(TREAS_ROOM)==0) treas_room();
  }
  //Do MAXOBJ attempts to put things on a level
  for (; i<MAXOBJ; i++) if (total<MAXITEMS && rnd(100)<35)
  {
    //Pick a new object and link it in the list
    cur = new_thing();
    attach(lvl_obj, cur);
    //Put it somewhere
    do {rm = rnd_room(); rnd_pos(&rooms[rm], &tp);} while (!isfloor(chat(tp.y, tp.x)));
    chat(tp.y, tp.x) = cur->o_type;
    bcopy(cur->o_pos, tp);
  }
}

//Add a treasure room
void treas_room(void)
{
  int nm, index;
  THING *tp;
  struct room *rp;
  int spots, num_monst;
  coord mp;

  rp = &rooms[rnd_room()];
  spots = (rp->r_max.y-2)*(rp->r_max.x-2)-MINTREAS;
  if (spots>(MAXTREAS-MINTREAS)) spots = (MAXTREAS-MINTREAS);
  num_monst = nm = rnd(spots)+MINTREAS;
  while (nm-- && total<MAXITEMS)
  {
    do {rnd_pos(rp, &mp); index = INDEX(mp.y, mp.x);} while (!isfloor(_level[index]));
    tp = new_thing();
    bcopy(tp->o_pos, mp);
    attach(lvl_obj, tp);
    _level[index] = tp->o_type;
  }
  //fill up room with monsters from the next level down
  if ((nm = rnd(spots)+MINTREAS)<num_monst+2) nm = num_monst+2;
  spots = (rp->r_max.y-2)*(rp->r_max.x-2);
  if (nm>spots) nm = spots;
  level++;
  while (nm--)
  {
    for (spots = 0; spots<MAXTRIES; spots++)
    {
      rnd_pos(rp, &mp);
      index = INDEX(mp.y, mp.x);
      if (isfloor(_level[index]) && moat(mp.y, mp.x)==0) break;
    }
    if (spots!=MAXTRIES)
    {
      if ((tp = new_item())!=0)
      {
        new_monster(tp, randmonster(0), &mp);
        tp->t_flags |= ISMEAN; //no sloughers in THIS room
        give_pack(tp);
      }
    }
  }
  level--;
}
//***************************************************************************

//***************************************************************************
THING *pack_obj(unsigned char ch, unsigned char *chp)
{
  THING *obj;
  unsigned char och;

  for (obj = pack, och = 'a'; obj!=0; obj = next(obj), och++) if (ch==och) return obj;
  *chp = och;
  return 0;
}

//rewritten: check
//Pick up an object and add it to the pack.
void add_pack(THING *obj, unsigned char silent)
{
  THING *p, *last = 0;
  unsigned char exact = 0, from_floor = 0, floor = 0;

  if (obj==0)
  {
    from_floor = 1;
    floor = (proom->r_flags&ISGONE)?PASSAGE:FLOOR;
    obj = find_obj(hero.y, hero.x); if (obj==0) return;
  }

  p = 0; if (obj->o_group) {p = pack; while (p) {if (p->o_group==obj->o_group) break; p = next(p);}}
  if (p==0 && inpack>=MAXPACK) {msg("you can't carry anything else") return;}
  if (from_floor) {detach(lvl_obj, obj); mvaddch(hero.y, hero.x, floor); chat(hero.y, hero.x) = floor;}
  if (p) {p->o_count += obj->o_count; discard(obj); obj = p; goto picked_up;}
  if (obj->o_type==SCROLL && obj->o_which==S_SCARE)
  {
    if (obj->o_flags&ISFOUND) {discard(obj); msg("the scroll turns to dust as you pick it up.") return;}
    obj->o_flags |= ISFOUND;
  }

  //find place to put in pack
  p = pack; while (p) {if (p->o_type==obj->o_type) break; p = next(p);}
  if (p==0) //new type
  {
    p = pack; while (p) {last = p; if (p->o_type!=FOOD) break; p = next(p);}
  }
  else //found type: try to find exact match
  {
    while (p)
    {
      last = p; if (p->o_type!=obj->o_type) break;
      if (p->o_which==obj->o_which) {exact = 1; break;}
      p = next(p);
    }
  }
  if (p==0)
  {
    if (pack==0) pack = obj;
    else
    {
      last->l_next = obj;
      obj->l_prev = last;
      obj->l_next = 0;
    }
  }
  else
  {
    if (exact==1 && ISMULT(obj->o_type)) {p->o_count++; discard(obj); obj = p; goto picked_up;}
    if (p->l_prev==0) pack = obj; else p->l_prev->l_next = obj;
    obj->l_prev = p->l_prev;
    obj->l_next = p;
    p->l_prev = obj;
  }

  inpack++;

picked_up:

  p = mlist;
  while (p)
  {
    if (p->t_dest) if (p->t_dest->x==obj->o_pos.x && p->t_dest->y==obj->o_pos.y) p->t_dest = &hero;
    p = next(p);
  }

  if (obj->o_type==AMULET) {amulet = 1; saw_amulet = 1;}

  if (!silent) msg("you now have %s (%c)", inv_name(obj, 1), pack_char(obj))
}



#define ITEM_NOT_RELEVANT  (type && type!=p->o_type && !(type==CALLABLE && (p->o_type==SCROLL || p->o_type==POTION || p->o_type==RING || p->o_type==STICK)) && !(type==WEAPON && p->o_type==POTION) && !(type==STICK && p->o_enemy && p->o_charges))



int inventory(int type, char *purpose)
{
  THING *p;
  int num, pos, i, ch;
  char right_arrow_string[2] = {16, 0};

  num = 0; for (p=pack; p!=0; p=next(p)) num++;
  if (num==0) {msg("you are empty handed") return 0;}

  wdump();
  wclear();
  set_tile_mode(0);

  move(24, 0); if (*purpose) printw("Select item to %s. Esc to cancel.", purpose) else addstr("Press space to continue.");

  pos = 0;

  i = 0;
  set_attr(*purpose?YELLOW:GREY); for (p=pack; p!=0; p=next(p)) if (!ITEM_NOT_RELEVANT) mvaddstr(i++, 1, inv_name(p, 0));
  set_attr(                GREY); for (p=pack; p!=0; p=next(p)) if ( ITEM_NOT_RELEVANT) mvaddstr(i++, 1, inv_name(p, 0));

  set_attr(LRED);

  while (1)
  {
    mvaddstr(pos, 0, right_arrow_string);

    ch = readchar();

    if (ch==ESCAPE) break;

    if (ch=='\b' || ch==' ' || ch==13)
    {
      i = 0;
      for (p=pack,ch='a'; p!=0; p=next(p),ch++) {if (!ITEM_NOT_RELEVANT) if ((i++)==pos) goto done;}
      for (p=pack,ch='a'; p!=0; p=next(p),ch++) {if ( ITEM_NOT_RELEVANT) if ((i++)==pos) goto done;}

      ch = ' '; break;
    }

    if (ch=='k') {mvaddstr(pos, 0, " "); if (pos>0    ) pos--;} //up
    if (ch=='j') {mvaddstr(pos, 0, " "); if (pos<num-1) pos++;} //down
  }

done:
  set_tile_mode(1);
  wrestor();

  set_attr(GREY);

  return ch;
}



//Add something to character's pack.
void pick_up(unsigned char ch)
{
  THING *obj;

  switch (ch)
  {
    case GOLD:
      if ((obj = find_obj(hero.y, hero.x))==0) return;
      money(obj->o_goldval);
      detach(lvl_obj, obj);
      discard(obj);
      proom->r_goldval = 0;
    break;
    default:
    case ARMOR: case POTION: case FOOD: case WEAPON: case SCROLL: case AMULET: case RING: case STICK:
      add_pack(0, 0);
    break;
  }
}

//Pick something out of a pack for a purpose
THING *get_item(char *purpose, int type)
{
  THING *obj;
  unsigned char ch, och, gi_state;
  int once_only = 0;

  static unsigned char lch;
  static THING *wasthing = 0;

  once_only = 1;
  gi_state = again;
  if (pack==0) msg("you aren't carrying anything")
  else
  {
    ch = lch;
    for (;;)
    {
      //if we are doing something AGAIN, and the pack hasn't changed then don't ask just give him the same thing he got on the last command.
      if (gi_state && wasthing==pack_obj(ch, &och)) goto skip;
      if (once_only) {ch = '*'; goto skip;}
      msg("which object do you want to %s? (* for list): ", purpose)
      //ignore any alt characters that may be typed
      ch = readchar();
skip:
      mpos = 0;
      gi_state = 0;
      once_only = 0;
      if (ch=='*')
      {
        if ((ch = inventory(type, purpose))==0) {after = 0; return 0;}
        if (ch==' ') continue;
        lch = ch;
      }
      //Give the poor player a chance to abort the command
      if (ch==ESCAPE) {after = 0; clearmsg() return 0;}
      if ((obj = pack_obj(ch, &och))==0)
      {
        msg("please specify a letter between 'a' and '%c'", och-1)
        continue;
      }
      else
      {
        //If you find an object reset flag because you really don't know if the object he is getting is going to change the pack.  If he detaches the thing from the pack later this flag will get set.
        if (strcmp(purpose, "identify")) {lch = ch; wasthing = obj;}
        return obj;
      }
    }
  }
  return 0;
}

//Return which character would address a pack object
int pack_char(THING *obj)
{
  THING *item;
  unsigned char c;

  c = 'a';
  for (item = pack; item!=0; item = next(item)) if (item==obj) return c; else c++;
  return '?';
}

//Add or subtract gold from the pack
void money(int value)
{
  unsigned char floor;

  play_sound(GOLD_SOUND);

  floor = (proom->r_flags&ISGONE)?PASSAGE:FLOOR;
  purse += value;
  mvaddch(hero.y, hero.x, floor);
  chat(hero.y, hero.x) = floor;
  if (value>0) msg("you found %d gold pieces", value)
}
//***************************************************************************

//***************************************************************************
//Draw a corridor from a room in a certain direction.
void conn(int r1, int r2)
{
  struct room *rpf, *rpt = 0;
  int rmt, rm;
  int distance = 0, turn_spot, turn_distance = 0;
  int direc;
  coord del, curr, turn_delta, spos, epos;

  if (r1<r2)
  {
    rm = r1;
    if (r1+1==r2) direc = 'r'; else direc = 'd';
  }
  else
  {
    rm = r2;
    if (r2+1==r1) direc = 'r'; else direc = 'd';
  }
  rpf = &rooms[rm];
  //Set up the movement variables, in two cases: first drawing one down.
  if (direc=='d')
  {
    rmt = rm+3; //room # of dest
    rpt = &rooms[rmt]; //room pointer of dest
    del.x = 0; //direction of move
    del.y = 1;
    //If we are drawing from/to regular or maze rooms, we have to pick the spot we draw from/to
    if ((rpf->r_flags&ISGONE)==0 || (rpf->r_flags&ISMAZE))
    {
      spos.y = rpf->r_pos.y+rpf->r_max.y-1;
      do {spos.x = rpf->r_pos.x+rnd(rpf->r_max.x-2)+1;} while (chat(spos.y,spos.x)==' ');
    }
    else {spos.x = rpf->r_pos.x; spos.y = rpf->r_pos.y;}
    epos.y = rpt->r_pos.y;
    if ((rpt->r_flags&ISGONE)==0 || (rpt->r_flags&ISMAZE))
    {
      do {epos.x = rpt->r_pos.x+rnd(rpt->r_max.x-2)+1;} while (chat(epos.y,epos.x)==' ');
    }
    else epos.x = rpt->r_pos.x;
    distance = abs(spos.y-epos.y)-1; //distance to move
    turn_delta.y = 0; //direction to turn
    turn_delta.x = (spos.x<epos.x?1:-1);
    turn_distance = abs(spos.x-epos.x); //how far to turn
  }
  else if (direc=='r')
  {
    //for moving right
    rmt = rm+1;
    rpt = &rooms[rmt];
    del.x = 1;
    del.y = 0;
    if ((rpf->r_flags&ISGONE)==0 || (rpf->r_flags&ISMAZE))
    {
      spos.x = rpf->r_pos.x+rpf->r_max.x-1;
      do {spos.y = rpf->r_pos.y+rnd(rpf->r_max.y-2)+1;} while (chat(spos.y,spos.x)==' ');
    }
    else {spos.x = rpf->r_pos.x; spos.y = rpf->r_pos.y;}
    epos.x = rpt->r_pos.x;
    if ((rpt->r_flags&ISGONE)==0 || (rpt->r_flags&ISMAZE))
    {
      do {epos.y = rpt->r_pos.y+rnd(rpt->r_max.y-2)+1;} while (chat(epos.y, epos.x)==' ');
    }
    else epos.y = rpt->r_pos.y;
    distance = abs(spos.x-epos.x)-1;
    turn_delta.y = (spos.y<epos.y?1:-1);
    turn_delta.x = 0;
    turn_distance = abs(spos.y-epos.y);
  }
  turn_spot = rnd(distance-1)+1;
  //Draw in the doors on either side of the passage or just put #'s if the rooms are gone.
  if (!(rpf->r_flags&ISGONE)) door(rpf, &spos);
  else psplat(spos.y, spos.x);
  if (!(rpt->r_flags&ISGONE)) door(rpt, &epos);
  else psplat(epos.y, epos.x);
  //Get ready to move...
  curr.x = spos.x;
  curr.y = spos.y;
  while (distance)
  {
    //Move to new position
    curr.x += del.x;
    curr.y += del.y;
    //Check if we are at the turn place, if so do the turn
    if (distance==turn_spot)
    {
      while (turn_distance--) {psplat(curr.y, curr.x); curr.x += turn_delta.x; curr.y += turn_delta.y;}
    }
    //Continue digging along
    psplat(curr.y, curr.x);
    distance--;
  }
  curr.x += del.x;
  curr.y += del.y;
  if (!ce(curr, epos)) {epos.x -= del.x; epos.y -= del.y; psplat(epos.y, epos.x);}
}

//Draw all the passages on a level.
void do_passages(void)
{
  int i, j;
  int roomcount;

  static struct rdes
  {
    char conn[MAXROOMS]; //possible to connect to room i?
    char isconn[MAXROOMS]; //connection been made to room i?
    char ingraph; //this room in graph already?
  } rdes[MAXROOMS] =
  {
    { {0, 1, 0, 1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0},
    { {1, 0, 1, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0},
    { {0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0},
    { {1, 0, 0, 0, 1, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0},
    { {0, 1, 0, 1, 0, 1, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0},
    { {0, 0, 1, 0, 1, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0},
    { {0, 0, 0, 1, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0},
    { {0, 0, 0, 0, 1, 0, 1, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0},
    { {0, 0, 0, 0, 0, 1, 0, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, 0}
  };
  struct rdes *r1, *r2 = 0;

  //reinitialize room graph description
  for (r1 = rdes; r1<&rdes[MAXROOMS]; r1++)
  {
    for (j = 0; j<MAXROOMS; j++) r1->isconn[j] = 0;
    r1->ingraph = 0;
  }
  //starting with one room, connect it to a random adjacent room and then pick a new room to start with.
  roomcount = 1;
  r1 = &rdes[rnd(MAXROOMS)];
  r1->ingraph = 1;
  do
  {
    //find a room to connect with
    j = 0;
    for (i = 0; i<MAXROOMS; i++) if (r1->conn[i] && !rdes[i].ingraph && rnd(++j)==0) r2 = &rdes[i];
    //if no adjacent rooms are outside the graph, pick a new room to look from
    if (j==0)
    {
      do r1 = &rdes[rnd(MAXROOMS)]; while (!r1->ingraph);
    }
    //otherwise, connect new room to the graph, and draw a tunnel to it
    else
    {
      r2->ingraph = 1;
      i = r1-rdes;
      j = r2-rdes;
      conn(i, j);
      r1->isconn[j] = 1;
      r2->isconn[i] = 1;
      roomcount++;
    }
  } while (roomcount<MAXROOMS);
  //attempt to add passages to the graph a random number of times so that there isn't always just one unique passage through it.
  for (roomcount = rnd(5); roomcount>0; roomcount--)
  {
    r1 = &rdes[rnd(MAXROOMS)]; //a random room to look from
    //find an adjacent room not already connected
    j = 0;
    for (i = 0; i<MAXROOMS; i++) if (r1->conn[i] && !r1->isconn[i] && rnd(++j)==0) r2 = &rdes[i];
    //if there is one, connect it and look for the next added passage
    if (j!=0)
    {
      i = r1-rdes;
      j = r2-rdes;
      conn(i, j);
      r1->isconn[j] = 1;
      r2->isconn[i] = 1;
    }
  }
  passnum();
}

//Add a door or possibly a secret door.  Also enters the door in the exits array of the room.
void door(struct room *rm, coord *cp)
{
  int index, xit;

  index = INDEX(cp->y, cp->x);
  if (rnd(10)+1<level && rnd(5)==0)
  {
    _level[index] = (cp->y==rm->r_pos.y || cp->y==rm->r_pos.y+rm->r_max.y-1)?HWALL:VWALL;
    _flags[index] &= ~F_REAL;
  }
  else _level[index] = DOOR;
  xit = rm->r_nexits++;
  rm->r_exit[xit].y = cp->y;
  rm->r_exit[xit].x = cp->x;
}

//Assign a number to each passageway
void passnum(void)
{
  struct room *rp;
  int i;

  pas_pnum = 0;
  pas_newpnum = 0;
  for (rp = passages; rp<&passages[MAXPASS]; rp++)
  {
    rp->r_flags = ISGONE|ISDARK;
    rp->r_nexits = 0;
  }
  for (rp = rooms; rp<&rooms[MAXROOMS]; rp++) for (i = 0; i<rp->r_nexits; i++)
  {
    pas_newpnum++;
    numpass(rp->r_exit[i].y, rp->r_exit[i].x);
  }
}

//Number a passageway square and its brethren
void numpass(int y, int x)
{
  unsigned char *fp;
  struct room *rp;
  unsigned char ch;

  if (offmap(y, x)) return;
  fp = &flat(y, x);
  if (*fp&F_PNUM) return;
  if (pas_newpnum) {pas_pnum++; pas_newpnum = 0;}
  //check to see if it is a door or secret door, i.e., a new exit, or a numberable type of place
  if ((ch = chat(y, x))==DOOR || (!(*fp&F_REAL) && ch!=FLOOR))
  {
    rp = &passages[pas_pnum];
    rp->r_exit[rp->r_nexits].y = y;
    rp->r_exit[rp->r_nexits++].x = x;
  }
  else if (!(*fp&F_PASS)) return;
  *fp |= pas_pnum;
  //recurse on the surrounding places
  numpass(y+1, x);
  numpass(y-1, x);
  numpass(y, x+1);
  numpass(y, x-1);
}

void psplat(int y, int x)
{
  int idx;

  _level[idx = INDEX(y, x)] = PASSAGE;
  _flags[idx] |= F_PASS;
}
//***************************************************************************

//***************************************************************************
//Quaff a potion from the pack
void quaff(void)
{
  THING *obj, *th;
  unsigned char discardit = 0;

  if ((obj = get_item("quaff", POTION))==0) return;
  //Make certain that it is something that we want to drink
  if (obj->o_type!=POTION) {msg("yuk! Why would you want to drink that?") return;}

  play_sound(EAT_SOUND);

  if (obj==cur_weapon) cur_weapon = 0;
  //Calculate the effect it has on the poor guy.
  switch (obj->o_which)
  {
    case P_CONFUSE:
      p_know[P_CONFUSE] = 1;
      if (!on(player, ISHUH))
      {
        if (on(player, ISHUH)) lengthen(unconfuse, rnd(8)+HUHDURATION);
        else fuse(unconfuse, 0, rnd(8)+HUHDURATION);
        player.t_flags |= ISHUH;
        msg("wait, what's going on? Huh? What? Who?")
      }
    break;

    case P_POISON:
    {
      char *sick = "you feel %s sick.";

      p_know[P_POISON] = 1;
      if (!ISWEARING(R_SUSTSTR)) {chg_str(-(rnd(3)+1)); msg(sick, "very")}
      else msg(sick, "momentarily")

      break;
    }

    case P_HEALING:
      p_know[P_HEALING] = 1;
      if ((pstats.s_hpt += roll(pstats.s_lvl, 4))>max_hp) pstats.s_hpt = ++max_hp;
      sight(0);
      msg("you begin to feel better")
    break;

    case P_STRENGTH:
      p_know[P_STRENGTH] = 1;
      chg_str(1);
      msg("you feel stronger. What bulging muscles!")
    break;

    case P_MFIND:
      fuse(turn_see, 1, HUHDURATION);
      if (mlist==0) msg("you have a strange feeling for a moment.")
      else {p_know[P_MFIND] |= turn_see(0); clearmsg()}
    break;

    case P_TFIND:
      //Potion of magic detection.  Find everything interesting on the level and show him where they are.  Also give hints as to whether he would want to use the object.
      if (lvl_obj!=0)
      {
        THING *tp;
        unsigned char show;

        show = 0;
        for (tp = lvl_obj; tp!=0; tp = next(tp))
        {
          if (is_magic(tp))
          {
            show = 1;
            mvaddch(tp->o_pos.y, tp->o_pos.x, goodch(tp));
            p_know[P_TFIND] = 1;
          }
        }
        for (th = mlist; th!=0; th = next(th))
        {
          for (tp = th->t_pack; tp!=0; tp = next(tp))
          {
            if (is_magic(tp))
            {
              show = 1;
              mvaddch(th->t_pos.y, th->t_pos.x, MAGIC);
              p_know[P_TFIND] = 1;
            }
          }
        }
        if (show) {msg("You sense the presence of magic.") break;}
      }
      msg("you have a strange feeling for a moment, then it passes.")
    break;

    case P_PARALYZE:
      p_know[P_PARALYZE] = 1;
      no_command = HOLDTIME;
      player.t_flags &= ~ISRUN;
      msg("you can't move")
    break;

    case P_SEEINVIS:
      if (!on(player, CANSEE)) {fuse(unsee, 0, SEEDURATION); look(0); invis_on();}
      sight(0);
      msg("this potion tastes like %s juice", fruit)
    break;

    case P_RAISE:
      p_know[P_RAISE] = 1;
      msg("you suddenly feel much more skillful")
      raise_level();
    break;

    case P_XHEAL:
      p_know[P_XHEAL] = 1;
      if ((pstats.s_hpt += roll(pstats.s_lvl, 8))>max_hp)
      {
        if (pstats.s_hpt>max_hp+pstats.s_lvl+1) ++max_hp;
        pstats.s_hpt = ++max_hp;
      }
      sight(0);
      msg("you begin to feel much better")
    break;

    case P_HASTE:
      p_know[P_HASTE] = 1;
      if (add_haste(1)) msg("you feel yourself moving much faster")
    break;

    case P_RESTORE:
      if (ISRING(LEFT, R_ADDSTR)) add_str(&pstats.s_str, -cur_ring[LEFT]->o_ac);
      if (ISRING(RIGHT, R_ADDSTR)) add_str(&pstats.s_str, -cur_ring[RIGHT]->o_ac);
      if (pstats.s_str<max_stats.s_str) pstats.s_str = max_stats.s_str;
      if (ISRING(LEFT, R_ADDSTR)) add_str(&pstats.s_str, cur_ring[LEFT]->o_ac);
      if (ISRING(RIGHT, R_ADDSTR)) add_str(&pstats.s_str, cur_ring[RIGHT]->o_ac);
      msg("hey, this tastes great.  It makes you feel warm all over")
    break;

    case P_BLIND:
      p_know[P_BLIND] = 1;
      if (!on(player, ISBLIND))
      {
        player.t_flags |= ISBLIND;
        fuse(sight, 0, SEEDURATION);
        look(0);
      }
      msg("a cloak of darkness falls around you")
    break;

    case P_NOP:
      msg("this potion tastes extremely dull")
    break;

    default: msg("what an odd tasting potion!") return;
  }
  //Throw the item away
  if (obj->o_count>1) obj->o_count--; else {inpack--; detach(pack, obj); discardit = 1;}
  call_it(p_know[obj->o_which], &p_guess[obj->o_which]);
  if (discardit) discard(obj);
}

//Turn on the ability to see invisible
void invis_on(void)
{
  THING *th;

  player.t_flags |= CANSEE;
  for (th = mlist; th!=0; th = next(th)) if (on(*th, ISINVIS) && see_monst(th))
  {
    mvaddch(th->t_pos.y, th->t_pos.x, th->t_disguise);
  }
}

//Compute the effect of this potion hitting a monster.
void th_effect(THING *obj, THING *tp)
{
  switch (obj->o_which)
  {
    case P_CONFUSE: case P_BLIND:
      tp->t_flags |= ISHUH;
      msg("the %s appears confused", monsters[tp->t_type-'A'].m_name)
    break;

    case P_PARALYZE:
      tp->t_flags &= ~ISRUN;
      tp->t_flags |= ISHELD;
    break;

    case P_HEALING: case P_XHEAL:
      if ((tp->t_stats.s_hpt += rnd(8))>tp->t_stats.s_maxhp) tp->t_stats.s_hpt = ++tp->t_stats.s_maxhp;
    break;

    case P_RAISE:
      tp->t_stats.s_hpt += 8;
      tp->t_stats.s_maxhp += 8;
      tp->t_stats.s_lvl++;
    break;

    case P_HASTE:
      tp->t_flags |= ISHASTE;
    break;
  }
  msg("the flask shatters.")
}
//***************************************************************************

//***************************************************************************
//Put a ring on a hand
void ring_on(void)
{
  THING *obj;
  int ring = -1;

  if ((obj = get_item("put on", RING))==0) goto no_ring;
  //Make certain that it is something that we want to wear
  if (obj->o_type!=RING) {msg("you can't put that on your finger") goto no_ring;}
  //find out which hand to put it on
  if (is_current(obj)) goto no_ring;
  if (cur_ring[LEFT]==0) ring = LEFT;
  if (cur_ring[RIGHT]==0) ring = RIGHT;
  if (cur_ring[LEFT]==0 && cur_ring[RIGHT]==0) if ((ring = gethand())<0) goto no_ring;
  if (ring<0) {msg("you already have a ring on each hand") goto no_ring;}
  cur_ring[ring] = obj;
  //Calculate the effect it has on the poor guy.
  switch (obj->o_which)
  {
    case R_ADDSTR: chg_str(obj->o_ac); break;
    case R_SEEINVIS: invis_on(); break;
    case R_AGGR: aggravate(); break;
  }
  msg("you are now wearing %s (%c)", inv_name(obj, 1), pack_char(obj))
  return;
no_ring:
  after = 0;
  return;
}

//Take off a ring
void ring_off(void)
{
  int ring;
  THING *obj;
  char packchar;

  if (cur_ring[LEFT]==0 && cur_ring[RIGHT]==0) {msg("you aren't wearing any rings") after = 0; return;}
  else if (cur_ring[LEFT]==0) ring = RIGHT;
  else if (cur_ring[RIGHT]==0) ring = LEFT;
  else if ((ring = gethand())<0) return;
  mpos = 0;
  obj = cur_ring[ring];
  if (obj==0) {msg("not wearing such a ring") after = 0; return;}
  packchar = pack_char(obj);
  if (can_drop(obj)) msg("was wearing %s(%c)", inv_name(obj, 1), packchar)
}

//Which hand is the hero interested in?
int gethand(void)
{
  int c;

  for (;;)
  {
    msg("left hand or right hand? ")
    if ((c = readchar())==ESCAPE) {after = 0; return -1;}
    mpos = 0;
    if (c=='l' || c=='L') return LEFT;
    else if (c=='r' || c=='R') return RIGHT;
    msg("please type L or R")
  }
}

//How much food does this ring use up?
int ring_eat(int hand)
{
  if (cur_ring[hand]==0) return 0;
  switch (cur_ring[hand]->o_which)
  {
    case R_REGEN: return 2;
    case R_SUSTSTR: case R_SUSTARM: case R_PROTECT: case R_ADDSTR: case R_STEALTH: return 1;
    case R_SEARCH: return (rnd(5)==0);
    case R_ADDHIT: case R_ADDDAM: return (rnd(3)==0);
    case R_DIGEST: return -rnd(2);
    case R_SEEINVIS: return (rnd(5)==0);
    default: return 0;
  }
}

//Print ring bonuses
char *ring_num(THING *obj)
{
  static char ring_buf[6];

  if (!(obj->o_flags&ISKNOW)) return "";
  switch (obj->o_which)
  {
    case R_PROTECT: case R_ADDSTR: case R_ADDDAM: case R_ADDHIT:
      ring_buf[0] = ' ';
      strcpy(&ring_buf[1], num(obj->o_ac, 0, RING));
    break;

    default: return "";
  }
  return ring_buf;
}
//***************************************************************************

//***************************************************************************
//Create rooms and corridors with a connectivity graph
void do_rooms(void)
{
  int i, rm;
  struct room *rp;
  THING *tp;
  int left_out;
  coord top;
  coord bsze;
  coord mp;
  int old_lev;
  int endline;

  endline = 23+1;
  old_lev = level;
  //bsze is the maximum room size
  bsze.x = 80/3;
  bsze.y = endline/3;
  //Clear things for a new level
  for (rp = rooms; rp<&rooms[MAXROOMS]; rp++) rp->r_goldval = rp->r_nexits = rp->r_flags = 0;
  //Put the gone rooms, if any, on the level
  left_out = rnd(4);
  for (i = 0; i<left_out; i++)
  {
    do rp = &rooms[(rm = rnd_room())]; while (rp->r_flags&ISMAZE);
    rp->r_flags |= ISGONE;
    if (rm>2 && level>10 && rnd(20)<level-9) rp->r_flags |= ISMAZE;
  }
  //dig and populate all the rooms on the level
  for (i = 0, rp = rooms; i<MAXROOMS; rp++, i++)
  {
    //Find upper left corner of box that this room goes in
    top.x = (i%3)*bsze.x+1;
    top.y = i/3*bsze.y;
    if (rp->r_flags&ISGONE)
    {
      //If the gone room is a maze room, draw the maze and set the size equal to the maximum possible.
      if (rp->r_flags&ISMAZE) {rp->r_pos.x = top.x; rp->r_pos.y = top.y; draw_maze(rp);}
      else
      {
        //Place a gone room.  Make certain that there is a blank line for passage drawing.
        do
        {
          rp->r_pos.x = top.x+rnd(bsze.x-2)+1;
          rp->r_pos.y = top.y+rnd(bsze.y-2)+1;
          rp->r_max.x = -80;
          rp->r_max.x = -endline;
        } while (!(rp->r_pos.y>0 && rp->r_pos.y<endline-1));
      }
      continue;
    }
    if (rnd(10)<(level-1)) rp->r_flags |= ISDARK;
    //Find a place and size for a random room
    do
    {
      rp->r_max.x = rnd(bsze.x-4)+4;
      rp->r_max.y = rnd(bsze.y-4)+4;
      rp->r_pos.x = top.x+rnd(bsze.x-rp->r_max.x);
      rp->r_pos.y = top.y+rnd(bsze.y-rp->r_max.y);
    } while (rp->r_pos.y==0);
    draw_room(rp);
    //Put the gold in
    if ((rnd(2)==0) && (!saw_amulet || (level>=max_level)))
    {
      THING *gold;

      if ((gold = new_item())!=0)
      {
        gold->o_goldval = rp->r_goldval = GOLDCALC;
        while (1)
        {
          unsigned char gch;

          rnd_pos(rp, &rp->r_gold);
          gch = chat(rp->r_gold.y, rp->r_gold.x);
          if (isfloor(gch)) break;
        }
        bcopy(gold->o_pos, rp->r_gold);
        gold->o_flags = ISMANY;
        gold->o_group = GOLDGRP;
        gold->o_type = GOLD;
        attach(lvl_obj, gold);
        chat(rp->r_gold.y, rp->r_gold.x) = GOLD;
      }
    }
    //Put the monster in
    if (rnd(100)<(rp->r_goldval>0?80:25))
    {
      if ((tp = new_item())!=0)
      {
        unsigned char mch;

        do {rnd_pos(rp, &mp); mch = winat(mp.y, mp.x);} while (!isfloor(mch));
        new_monster(tp, randmonster(0), &mp);
        give_pack(tp);
      }
    }
  }
}

//Draw a box around a room and lay down the floor
void draw_room(struct room *rp)
{
  int y, x;

  //Here we draw normal rooms, one side at a time
  vert(rp, rp->r_pos.x); //Draw left side
  vert(rp, rp->r_pos.x+rp->r_max.x-1); //Draw right side
  horiz(rp, rp->r_pos.y); //Draw top
  horiz(rp, rp->r_pos.y+rp->r_max.y-1); //Draw bottom
  chat(rp->r_pos.y, rp->r_pos.x) = ULWALL;
  chat(rp->r_pos.y, rp->r_pos.x+rp->r_max.x-1) = URWALL;
  chat(rp->r_pos.y+rp->r_max.y-1, rp->r_pos.x) = LLWALL;
  chat(rp->r_pos.y+rp->r_max.y-1, rp->r_pos.x+rp->r_max.x-1) = LRWALL;
  //Put the floor down
  for (y = rp->r_pos.y+1; y<rp->r_pos.y+rp->r_max.y-1; y++)
  for (x = rp->r_pos.x+1; x<rp->r_pos.x+rp->r_max.x-1; x++)
  chat(y, x) = FLOOR;
}

//Draw a vertical line
void vert(struct room *rp, int startx)
{
  int y;

  for (y = rp->r_pos.y+1; y<=rp->r_max.y+rp->r_pos.y-1; y++) chat(y, startx) = VWALL;
}

//Draw a horizontal line
void horiz(struct room *rp, int starty)
{
  int x;

  for (x = rp->r_pos.x; x<=rp->r_pos.x+rp->r_max.x-1; x++) chat(starty, x) = HWALL;
}

//Pick a random spot in a room
void rnd_pos(struct room *rp, coord *cp)
{
  cp->x = rp->r_pos.x+rnd(rp->r_max.x-2)+1;
  cp->y = rp->r_pos.y+rnd(rp->r_max.y-2)+1;
}

//Code that is executed whenever you appear in a room
void enter_room(coord *cp)
{
  struct room *rp;
  int y, x;
  THING *tp;

  rp = proom = roomin(cp);
  if (bailout || (rp->r_flags&ISGONE && (rp->r_flags&ISMAZE)==0)) return;
  door_open(rp);
  if (!(rp->r_flags&ISDARK) && !on(player, ISBLIND) && !(rp->r_flags&ISMAZE))
  for (y = rp->r_pos.y; y<rp->r_max.y+rp->r_pos.y; y++)
  {
    move(y, rp->r_pos.x);
    for (x = rp->r_pos.x; x<rp->r_max.x+rp->r_pos.x; x++)
    {
      //Displaying monsters is all handled in the chase code now
      tp = moat(y, x);
      if (tp==0 || !see_monst(tp)) addch(chat(y, x));
      else {tp->t_oldch = chat(y,x); addch(tp->t_disguise);}
    }
  }
}

//Code for when we exit a room
void leave_room(coord *cp)
{
  int y, x;
  struct room *rp;
  unsigned char floor;
  unsigned char ch;

  rp = proom;
  proom = &passages[flat(cp->y, cp->x)&F_PNUM];
  floor = ((rp->r_flags&ISDARK) && !on(player, ISBLIND))?' ':FLOOR;
  if (rp->r_flags&ISMAZE) floor = PASSAGE;
  for (y = rp->r_pos.y+1; y<rp->r_max.y+rp->r_pos.y-1; y++)
  for (x = rp->r_pos.x+1; x<rp->r_max.x+rp->r_pos.x-1; x++)
  switch (ch = mvinch(y, x))
  {
    case ' ': case PASSAGE: case TRAP: case STAIRS:
    break;

    case FLOOR:
      if (floor==' ') addch(' ');
    break;

    default:
      //check for monster
      if (isupper(toascii(ch)))
      {
        if (on(player, SEEMONST)) {set_attr(BLACK_ON_GREY); addch(ch); set_attr(GREY); break;}
        else moat(y, x)->t_oldch = '@';
      }
      addch(floor);
    break;
  }
  door_open(rp);
}
//***************************************************************************

//***************************************************************************
//Read a scroll from the pack and do the appropriate thing
void read_scroll(void)
{
  THING *obj;
  int y, x;
  unsigned char ch;
  THING *op;
  int index;
  unsigned char discardit = 0;

  obj = get_item("read", SCROLL);
  if (obj==0) return;
  if (obj->o_type!=SCROLL) {msg("there is nothing on it to read") return;}
  msg("as you read the scroll, it vanishes")
  //Calculate the effect it has on the poor guy.
  if (obj==cur_weapon) cur_weapon = 0;
  switch (obj->o_which)
  {
    case S_CONFUSE: //Scroll of monster confusion.  Give him that power.
      player.t_flags |= CANHUH;
      msg("your hands begin to glow red")
    break;

    case S_ARMOR:
      if (cur_armor!=0)
      {
        cur_armor->o_ac--;
        cur_armor->o_flags &= ~ISCURSED;
        msg("your armor glows faintly for a moment")
      }
    break;

    case S_HOLD: //Hold monster scroll.  Stop all monsters within two spaces from chasing after the hero.
      for (x = hero.x-3; x<=hero.x+3; x++)
      if (x>=0 && x<80)
      for (y = hero.y-3; y<=hero.y+3; y++)
      if ((y>0 && y<23) && ((op = moat(y, x))!=0))
      {
        op->t_flags &= ~ISRUN;
        op->t_flags |= ISHELD;
      }
    break;

    case S_SLEEP: //Scroll which makes you fall asleep
      s_know[S_SLEEP] = 1;
      no_command += rnd(SLEEPTIME)+4;
      player.t_flags &= ~ISRUN;
      msg("you fall asleep")
    break;

    case S_CREATE:
    {
      coord mp;

      if (plop_monster(hero.y, hero.x, &mp) && (op = new_item())!=0) new_monster(op, randmonster(0), &mp);
      else msg("you hear a faint cry of anguish in the distance")

      break;
    }

    case S_IDENT: //Identify, let the rogue figure something out
      s_know[S_IDENT] = 1;
      msg("this scroll is an identify scroll")
      more(" More ");
      whatis();
    break;

    case S_MAP: //Scroll of magic mapping.
      s_know[S_MAP] = 1;
      msg("oh, now this scroll has a map on it")
      //Take all the things we want to keep hidden out of the window
      for (y = 1; y<23; y++) for (x = 0; x<80; x++)
      {
        index = INDEX(y, x);
        switch (ch = _level[index])
        {
          case VWALL: case HWALL: case ULWALL: case URWALL: case LLWALL: case LRWALL:
            if (!(_flags[index]&F_REAL)) {ch = _level[index] = DOOR; _flags[index] &= ~F_REAL;}
          case DOOR: case PASSAGE: case STAIRS:
            if ((op = moat(y, x))!=0) if (op->t_oldch==' ') op->t_oldch = ch;
          break;
          default: ch = ' ';
        }
        if (ch==DOOR)
        {
          move(y, x);
          if (inch()!=DOOR) set_attr(BLACK_ON_GREY);
        }
        if (ch!=' ') mvaddch(y, x, ch);
        set_attr(GREY);
      }
    break;

    case S_GFIND: //Scroll of food detection
      ch = 0;
      for (op = lvl_obj; op!=0; op = next(op))
      {
        if (op->o_type==FOOD)
        {
          ch = 1;
          set_attr(BLACK_ON_GREY);
          mvaddch(op->o_pos.y, op->o_pos.x, FOOD);
          set_attr(GREY);
        }
        //as a bonus this will detect amulets as well
        else if (op->o_type==AMULET)
        {
          ch = 1;
          set_attr(BLACK_ON_GREY);
          mvaddch(op->o_pos.y, op->o_pos.x, AMULET);
          set_attr(GREY);
        }
      }
      if (ch) {s_know[S_GFIND] = 1; msg("your nose tingles as you sense food")}
      else msg("you hear a growling noise very close to you")
    break;

    case S_TELEP: //Scroll of teleportation: Make him disappear and reappear
    {
      struct room *cur_room;

      cur_room = proom;
      teleport();
      if (cur_room!=proom) s_know[S_TELEP] = 1;

      break;
    }

    case S_ENCH:
      if (cur_weapon==0 || cur_weapon->o_type!=WEAPON) msg("you feel a strange sense of loss")
      else
      {
        cur_weapon->o_flags &= ~ISCURSED;
        if (rnd(2)==0) cur_weapon->o_hplus++;
        else cur_weapon->o_dplus++;
        msg("your %s glows blue for a moment", w_names[cur_weapon->o_which])
      }
    break;

    case S_SCARE: //Reading it is a mistake and produces laughter at the poor rogue's boo boo.
      msg("you hear maniacal laughter in the distance.")
    break;

    case S_REMOVE:
      if (cur_armor!=0) cur_armor->o_flags &= ~ISCURSED;
      if (cur_weapon!=0) cur_weapon->o_flags &= ~ISCURSED;
      if (cur_ring[LEFT]!=0) cur_ring[LEFT]->o_flags &= ~ISCURSED;
      if (cur_ring[RIGHT]!=0) cur_ring[RIGHT]->o_flags &= ~ISCURSED;
      msg("you feel as if somebody is watching over you")
    break;

    case S_AGGR: //This scroll aggravates all the monsters on the current level and sets them running towards the hero
      aggravate();
      msg("you hear a high pitched humming noise")
    break;

    case S_NOP:
      msg("this scroll seems to be blank")
    break;

    case S_VORPAL:
      //Extra Vorpal Enchant Weapon
      //    Give weapon +1,+1
      //    Is extremely vorpal against one certain type of monster
      //    Against this type (o_enemy) the weapon gets:
      // +4,+4
      // The ability to zap one such monster into oblivion
      //
      //    Some of these are cursed and if the rogue misses her saving
      //    throw she will be forced to attack monsters of this type
      //    whenever she sees one (not yet implemented)
      //
      //If he doesn't have a weapon I get to chortle again!
      if (cur_weapon==0 || cur_weapon->o_type!=WEAPON) msg("you hear maniacal laughter in the distance.")
      else
      {
        //You aren't allowed to doubly vorpalize a weapon.
        if (cur_weapon->o_enemy!=0)
        {
          msg("your %s vanishes in a puff of smoke", w_names[cur_weapon->o_which])
          detach(pack, cur_weapon);
          discard(cur_weapon);
          cur_weapon = 0;
        }
        else
        {
          cur_weapon->o_enemy = pick_mons();
          cur_weapon->o_hplus++;
          cur_weapon->o_dplus++;
          cur_weapon->o_charges = 1;
          msg("your %s gives off a flash of intense white light", w_names[cur_weapon->o_which])
        }
      }
    break;

    default: msg("what a puzzling scroll!") return;
  }
  look(1); //put the result of the scroll on the screen
  //Get rid of the thing
  if (obj->o_count>1) obj->o_count--; else {inpack--; detach(pack, obj); discardit = 1;}
  call_it(s_know[obj->o_which], &s_guess[obj->o_which]);
  if (discardit) discard(obj);
}
//***************************************************************************

//***************************************************************************
//Called when it has been decided that a slime should divide itself
void slime_split(THING *tp)
{
  THING *nslime;

  if (new_slime(tp)==0 || (nslime = new_item())==0) return;
  msg("The slime divides.  Ick!")
  new_monster(nslime, 'S', &slimy);
  if (cansee(slimy.y, slimy.x))
  {
    nslime->t_oldch = chat(slimy.y, slimy.x);
    mvaddch(slimy.y, slimy.x, 'S');
  }
  start_run(&slimy);
}

int new_slime(THING *tp)
{
  int y, x, ty, tx, ret;
  THING *ntp;
  coord sp;

  ret = 0;
  tp->t_flags |= ISFLY;
  if (plop_monster((ty = tp->t_pos.y), (tx = tp->t_pos.x), &sp)==0)
  {
    //There were no open spaces next to this slime, look for other slimes that might have open spaces next to them.
    for (y = ty-1; y<=ty+1; y++)
    for (x = tx-1; x<=tx+1; x++)
    if (winat(y, x)=='S' && (ntp = moat(y, x)))
    {
      if (ntp->t_flags&ISFLY) continue; //Already done this one
      if (new_slime(ntp)) {y = ty+2; x = tx+2;}
    }
  }
  else {ret = 1; slimy = sp;}
  tp->t_flags &= ~ISFLY;
  return ret;
}

int plop_monster(int r, int c, coord *cp)
{
  int y, x;
  unsigned char appear = 0;
  unsigned char ch;

  for (y = r-1; y<=r+1; y++)
  for (x = c-1; x<=c+1; x++)
  {
    //Don't put a monster on top of the player.
    if ((y==hero.y && x==hero.x) || offmap(y,x)) continue;
    //Or anything else nasty
    if (step_ok(ch = winat(y, x)))
    {
      if (ch==SCROLL && find_obj(y, x)->o_which==S_SCARE) continue;
      if (rnd(++appear)==0) {cp->y = y; cp->x = x;}
    }
  }
  return appear;
}
//***************************************************************************

//***************************************************************************
//Set up a new stick
void fix_stick(THING *cur)
{
  if (strcmp(ws_type[cur->o_which], "staff")==0) cur->o_damage = "2d3";
  else cur->o_damage = "1d1";
  cur->o_hurldmg = "1d1";
  cur->o_charges = 3+rnd(5);
  switch (cur->o_which)
  {
    case WS_HIT: cur->o_hplus = 100; cur->o_dplus = 3; cur->o_damage = "1d8"; break;
    case WS_LIGHT: cur->o_charges = 10+rnd(10); break;
  }
}

//Perform a zap with a wand
void do_zap(void)
{
  THING *obj;
  THING *tp;
  int y, x;
  char *name;
  int which_one;

  if ((obj = get_item("zap with", STICK))==0) return;
  which_one = obj->o_which;
  if (obj->o_type!=STICK)
  {
    if (obj->o_enemy && obj->o_charges) which_one = MAXSTICKS;
    else {msg("you can't zap with that!") after = 0; return;}
  }
  if (obj->o_charges==0) {msg("nothing happens") return;}

  play_sound(ZAP_SOUND);

  switch (which_one)
  {
    case WS_LIGHT: //Ready Kilowat wand.  Light up the room
      if (on(player,ISBLIND)) msg("you feel a warm glow around you")
      else
      {
        ws_know[WS_LIGHT] = 1;
        if (proom->r_flags&ISGONE) msg("the corridor glows and then fades")
        else msg("the room is lit by a shimmering blue light")
      }
      if (!(proom->r_flags&ISGONE))
      {
        proom->r_flags &= ~ISDARK;
        //Light the room and put the player back up
        enter_room(&hero);
      }
    break;

    case WS_DRAIN: //Take away 1/2 of hero's hit points, then take it away evenly from the monsters in the room (or next to hero if he is in a passage)
      if (pstats.s_hpt<2) {msg("you are too weak to use it") return;}
      else drain();
    break;

    case WS_POLYMORPH: case WS_TELAWAY: case WS_TELTO: case WS_CANCEL: case MAXSTICKS: //Special case for vorpal weapon
    {
      unsigned char monster, oldch;
      int rm;

      y = hero.y;
      x = hero.x;
      while (step_ok(winat(y, x))) {y += delta.y; x += delta.x;}
      if ((tp = moat(y, x))!=0)
      {
        unsigned char omonst;

        omonst = monster = tp->t_type;
        if (monster=='F') player.t_flags &= ~ISHELD;
        if (which_one==MAXSTICKS)
        {
          if (monster==obj->o_enemy)
          {
            msg("the %s vanishes in a puff of smoke", monsters[monster-'A'].m_name)
            killed(tp, 0);
          }
          else msg("you hear a maniacal chuckle in the distance.")
        }
        else if (which_one==WS_POLYMORPH)
        {
          THING *pp;
          coord temp_coord;

          pp = tp->t_pack;
          detach(mlist, tp);
          if (see_monst(tp)) mvaddch(y, x, chat(y, x));
          oldch = tp->t_oldch;

          temp_coord.y = y;
          temp_coord.x = x;
          new_monster(tp, monster = rnd(26)+'A', &temp_coord);

          if (see_monst(tp)) mvaddch(y, x, monster);
          tp->t_oldch = oldch;
          tp->t_pack = pp;
          ws_know[WS_POLYMORPH] |= (monster!=omonst);
        }
        else if (which_one==WS_CANCEL)
        {
          tp->t_flags |= ISCANC;
          tp->t_flags &= ~(ISINVIS|CANHUH);
          tp->t_disguise = tp->t_type;
        }
        else
        {
          if (see_monst(tp)) mvaddch(y, x, tp->t_oldch);
          if (which_one==WS_TELAWAY)
          {
            coord tempc;

            do {rm = rnd_room(); rnd_pos(&rooms[rm], &tempc);} while (!(isfloor(winat(tempc.y, tempc.x))));
            tp->t_room = roomin(&tempc);
            tp->t_pos.x = tempc.x;
            tp->t_pos.y = tempc.y;
            tp->t_oldch = '@';
          }
          else
          {
            tp->t_pos.y = hero.y+delta.y;
            tp->t_pos.x = hero.x+delta.x;
            tp->t_oldch = '@';
          }
          if (tp->t_type=='F') player.t_flags &= ~ISHELD;
        }
        tp->t_dest = &hero;
        tp->t_flags |= ISRUN;
      }
      break;
    }

    case WS_MISSILE:
    {
      THING bolt;

      ws_know[WS_MISSILE] = 1;
      bolt.o_type = '*';
      bolt.o_hurldmg = "1d8";
      bolt.o_hplus = 1000;
      bolt.o_dplus = 1;
      bolt.o_flags = ISMISL;
      if (cur_weapon!=0) bolt.o_launch = cur_weapon->o_which;
      do_motion(&bolt, delta.y, delta.x);
      if ((tp = moat(bolt.o_pos.y, bolt.o_pos.x))!=0 && !save_throw(VS_MAGIC, tp)) hit_monster(unc(bolt.o_pos), &bolt);
      else msg("the missile vanishes with a puff of smoke")

      break;
    }

    case WS_HIT:
    {
      coord temp_coord;

      temp_coord.y = hero.y+delta.y;
      temp_coord.x = hero.x+delta.x;

      if ((tp = moat(temp_coord.y, temp_coord.x))!=0)
      {
        if (rnd(20)==0) {obj->o_damage = "3d8"; obj->o_dplus = 9;} else {obj->o_damage = "2d8"; obj->o_dplus = 4;}
        fight(&temp_coord, tp->t_type, obj, 0);
      }

      break;
    }

    case WS_HASTE_M: case WS_SLOW_M:
    {
      coord temp_coord;

      y = hero.y;
      x = hero.x;
      while (step_ok(winat(y, x))) {y += delta.y; x += delta.x;}
      if ((tp = moat(y, x))!=0)
      {
        if (which_one==WS_HASTE_M)
        {
          if (on(*tp, ISSLOW)) tp->t_flags &= ~ISSLOW;
          else tp->t_flags |= ISHASTE;
        }
        else
        {
          if (on(*tp, ISHASTE)) tp->t_flags &= ~ISHASTE;
          else tp->t_flags |= ISSLOW;
          tp->t_turn = 1;
        }

        temp_coord.y = y;
        temp_coord.x = x;
        start_run(&temp_coord);
      }

      break;
    }

    case WS_ELECT: case WS_FIRE: case WS_COLD:
      if (which_one==WS_ELECT) name = "bolt";
      else if (which_one==WS_FIRE) name = "flame";
      else name = "ice";
      fire_bolt(&hero, &delta, name);
      ws_know[which_one] = 1;
    break;
  }
  if (--obj->o_charges<0) obj->o_charges = 0;
}

//Do drain hit points from player schtick
void drain(void)
{
  THING *mp;
  int cnt;
  struct room *corp;
  THING **dp;
  unsigned char inpass;
  THING *drainee[40];

  //First count how many things we need to spread the hit points among
  cnt = 0;
  if (chat(hero.y, hero.x)==DOOR) corp = &passages[flat(hero.y, hero.x)&F_PNUM];
  else corp = 0;
  inpass = (proom->r_flags&ISGONE);
  dp = drainee;
  for (mp = mlist; mp!=0; mp = next(mp)) if (mp->t_room==proom || mp->t_room==corp || (inpass && chat(mp->t_pos.y, mp->t_pos.x)==DOOR && &passages[flat(mp->t_pos.y, mp->t_pos.x)&F_PNUM]==proom)) *dp++ = mp;
  if ((cnt = dp-drainee)==0) {msg("you have a tingling feeling") return;}
  *dp = 0;
  pstats.s_hpt /= 2;
  cnt = pstats.s_hpt/cnt+1;
  //Now zot all of the monsters
  for (dp = drainee; *dp; dp++)
  {
    mp = *dp;
    if ((mp->t_stats.s_hpt -= cnt)<=0) killed(mp, see_monst(mp));
    else start_run(&mp->t_pos);
  }
}

//Fire a bolt in a given direction from a specific starting place
void fire_bolt(coord *start, coord *dir, char *name)
{
  int i, j;
  unsigned char dirch = 0, ch, hit_hero, used, changed, is_frost;
  coord pos;
  struct {coord s_pos; unsigned char s_under;} spotpos[BOLT_LENGTH*2];
  THING *tp, bolt;

  is_frost = (strcmp(name, "frost")==0);
  bolt.o_type = WEAPON;
  bolt.o_which = FLAME;
  bolt.o_damage = bolt.o_hurldmg = "6d6";
  bolt.o_hplus = 30;
  bolt.o_dplus = 0;
  w_names[FLAME] = name;
  switch (dir->y+dir->x)
  {
    case 0: dirch = '/'; break;
    case 1: case -1: dirch = (dir->y==0?'-':'|'); break;
    case 2: case -2: dirch = '\\'; break;
  }
  pos = *start;
  hit_hero = (start!=&hero);
  used = 0;
  changed = 0;
  for (i = 0; i<BOLT_LENGTH && !used; i++)
  {
    pos.y += dir->y;
    pos.x += dir->x;
    ch = winat(pos.y, pos.x);
    spotpos[i].s_pos = pos;
    if ((spotpos[i].s_under = mvinch(pos.y, pos.x))==dirch) spotpos[i].s_under = 0;
    switch (ch)
    {
      case DOOR: case HWALL: case VWALL: case ULWALL: case URWALL: case LLWALL: case LRWALL: case ' ':
        if (!changed) hit_hero = !hit_hero;
        changed = 0;
        dir->y = -dir->y;
        dir->x = -dir->x;
        i--;
        msg("the %s bounces", name)
      break;

      default:
        if (!hit_hero && (tp = moat(pos.y, pos.x))!=0)
        {
          hit_hero = 1;
          changed = !changed;
          if (tp->t_oldch!='@') tp->t_oldch = chat(pos.y, pos.x);
          if (!save_throw(VS_MAGIC, tp) || is_frost)
          {
            bolt.o_pos = pos;
            used = 1;
            if (tp->t_type=='D' && strcmp(name, "flame")==0) msg("the flame bounces off the dragon")
            else
            {
              hit_monster(unc(pos), &bolt);
              if (mvinch(unc(pos))!=dirch) spotpos[i].s_under = mvinch(unc(pos));
            }
          }
          else if (ch!='X' || tp->t_disguise=='X')
          {
            if (start==&hero) start_run(&pos);
            msg("the %s whizzes past the %s", name, monsters[ch-'A'].m_name)
          }
        }
        else if (hit_hero && ce(pos, hero))
        {
          hit_hero = 0;
          changed = !changed;
          if (!save(VS_MAGIC))
          {
            if (is_frost)
            {
              msg("You are frozen by a blast of frost from the Ice Monster.")
              if (no_command<20) no_command += spread(7);
            }
            else if ((pstats.s_hpt -= roll(6, 6))<=0) {if (start==&hero) death('b'); else death(moat(start->y, start->x)->t_type);}
            used = 1;
            if (!is_frost) msg("you are hit by the %s", name)
          }
          else msg("the %s whizzes by you", name)
        }
        if (is_frost) set_attr(BLUE); else set_attr(RED);
        tick_pause();
        mvaddch(pos.y, pos.x, dirch);
        set_attr(GREY);
    }
  }
  for (j = 0; j<i; j++)
  {
    tick_pause();
    if (spotpos[j].s_under) mvaddch(spotpos[j].s_pos.y, spotpos[j].s_pos.x, spotpos[j].s_under);
  }
}

//Return an appropriate string for a wand charge
char *charge_str(THING *obj)
{
  static char buf[20];

  if (!(obj->o_flags&ISKNOW)) buf[0] = '\0';
  else sprintf(buf, " [%d charges]", obj->o_charges);
  return buf;
}
//***************************************************************************

//***************************************************************************
//Return the name of something as it would appear in an inventory.
char *inv_name(THING *obj, unsigned char drop)
{
  int which = obj->o_which;
  char *pb;

  pb = prbuf;
  switch (obj->o_type)
  {
    case SCROLL:
      if (obj->o_count==1) {strcpy(pb, "A scroll "); pb = &prbuf[9];}
      else {sprintf(pb, "%d scrolls ", obj->o_count); pb = &prbuf[strlen(prbuf)];}
      if (s_know[which]) sprintf(pb, "of %s", s_magic[which].mi_name);
      else if (*s_guess[which]) sprintf(pb, "called %s", s_guess[which]);
      else sprintf(pb, "titled '%s'", s_names[which].name);
    break;

    case POTION:
      if (obj->o_count==1) {strcpy(pb, "A potion "); pb = &prbuf[9];}
      else {sprintf(pb, "%d potions ", obj->o_count); pb = &pb[strlen(prbuf)];}
      if (p_know[which]) sprintf(pb, "of %s(%s)", p_magic[which].mi_name, p_colors[which]);
      else if (*p_guess[which]) sprintf(pb, "called %s(%s)", p_guess[which], p_colors[which]);
      else if (obj->o_count==1) sprintf(prbuf, "A%s %s potion", vowelstr(p_colors[which]), p_colors[which]);
      else sprintf(prbuf, "%d %s potions", obj->o_count, p_colors[which]);
    break;

    case FOOD:
      if (which==1) if (obj->o_count==1) sprintf(pb, "A%s %s", vowelstr(fruit), fruit); else sprintf(pb, "%d %ss", obj->o_count, fruit);
      else if (obj->o_count==1) strcpy(pb, "Some food"); else sprintf(pb, "%d rations of food", obj->o_count);
    break;

    case WEAPON:
      if (obj->o_count>1) sprintf(pb, "%d ", obj->o_count);
      else sprintf(pb, "A%s ", vowelstr(w_names[which]));
      pb = &prbuf[strlen(prbuf)];
      if (obj->o_flags&ISKNOW) sprintf(pb, "%s %s", num(obj->o_hplus, obj->o_dplus, WEAPON), w_names[which]);
      else sprintf(pb, "%s", w_names[which]);
      if (obj->o_count>1) strcat(pb, "s");
      if (obj->o_enemy && obj->o_flags&ISREVEAL)
      {
        strcat(pb, " of ");
        strcat(pb, monsters[obj->o_enemy-'A'].m_name);
        strcat(pb, " slaying");
      }
    break;

    case ARMOR:
      if (obj->o_flags&ISKNOW) sprintf(pb, "%s %s [armor class %d]", num(a_class[which]-obj->o_ac, 0, ARMOR), a_names[which], -(obj->o_ac-11));
      else sprintf(pb, "%s", a_names[which]);
    break;

    case AMULET:
      strcpy(pb, "The Amulet of Yendor");
    break;

    case STICK:
      sprintf(pb, "A%s %s ", vowelstr(ws_type[which]), ws_type[which]);
      pb = &prbuf[strlen(prbuf)];
      if (ws_know[which]) sprintf(pb, "of %s%s(%s)", ws_magic[which].mi_name, charge_str(obj), ws_made[which]);
      else if (*ws_guess[which]) sprintf(pb, "called %s(%s)", ws_guess[which], ws_made[which]);
      else sprintf(pb = &prbuf[2], "%s %s", ws_made[which], ws_type[which]);
    break;

    case RING:
      if (r_know[which]) sprintf(pb, "A%s ring of %s(%s)", ring_num(obj), r_magic[which].mi_name, r_stones[which]);
      else if (*r_guess[which]) sprintf(pb, "A ring called %s(%s)", r_guess[which], r_stones[which]);
      else sprintf(pb, "A%s %s ring", vowelstr(r_stones[which]), r_stones[which]);
    break;
  }
  if (obj==cur_armor) strcat(pb, " (being worn)");
  if (obj==cur_weapon) strcat(pb, " (weapon in hand)");
  if (obj==cur_ring[LEFT]) strcat(pb, " (on left hand)");
  else if (obj==cur_ring[RIGHT]) strcat(pb, " (on right hand)");
  if (drop && isupper(prbuf[0])) prbuf[0] = tolower(prbuf[0]);
  else if (!drop && islower(*prbuf)) *prbuf = toupper(*prbuf);
  return prbuf;
}

//Put something down
void drop(void)
{
  unsigned char ch;
  THING *nobj, *op;

  ch = chat(hero.y, hero.x);
  if (ch!=FLOOR && ch!=PASSAGE) {msg("there is something there already") return;}
  if ((op = get_item("drop", 0))==0) return;
  if (!can_drop(op)) return;
  //Take it out of the pack
  if (op->o_count>=2 && op->o_type!=WEAPON)
  {
    if ((nobj = new_item())==0) {msg("can't drop it, it appears to be stuck in your pack!") return;}
    op->o_count--;
    bcopy(*nobj, *op);
    nobj->o_count = 1;
    op = nobj;
  }
  else {inpack--; detach(pack, op);}
  //Link it into the level object list
  attach(lvl_obj, op);
  chat(hero.y, hero.x) = op->o_type;
  bcopy(op->o_pos, hero);
  if (op->o_type==AMULET) amulet = 0;
  msg("dropped %s", inv_name(op, 1))
}

//Do special checks for dropping or unweilding|unwearing|unringing
int can_drop(THING *op)
{
  if (op==0) return 1;
  if (op!=cur_armor && op!=cur_weapon && op!=cur_ring[LEFT] && op!=cur_ring[RIGHT]) return 1;
  if (op->o_flags&ISCURSED) {msg("you can't.  It appears to be cursed") return 0;}
  if (op==cur_weapon) cur_weapon = 0;
  else if (op==cur_armor) {waste_time(); cur_armor = 0;}
  else
  {
    int hand;

    if (op!=cur_ring[hand = LEFT]) if (op!=cur_ring[hand = RIGHT]) return 1;
    cur_ring[hand] = 0;
    switch (op->o_which)
    {
      case R_ADDSTR: chg_str(-op->o_ac); break;
      case R_SEEINVIS: unsee(0); extinguish(unsee); break;
    }
  }
  return 1;
}

//Return a new thing
THING *new_thing(void)
{
  THING *cur;
  int j, k;

  if ((cur = new_item())==0) return 0;
  cur->o_hplus = cur->o_dplus = 0;
  cur->o_damage = cur->o_hurldmg = "0d0";
  cur->o_ac = 11;
  cur->o_count = 1;
  cur->o_group = 0;
  cur->o_flags = 0;
  cur->o_enemy = 0;
  //Decide what kind of object it will be. If we haven't had food for a while, let it be food.
  switch (no_food>3?2:pick_one(things, NUMTHINGS))
  {
    case 0:
      cur->o_type = POTION;
      cur->o_which = pick_one(p_magic, MAXPOTIONS);
    break;

    case 1:
      cur->o_type = SCROLL;
      cur->o_which = pick_one(s_magic, MAXSCROLLS);
    break;

    case 2:
      no_food = 0;
      cur->o_type = FOOD;
      if (rnd(10)!=0) cur->o_which = 0; else cur->o_which = 1;
    break;

    case 3:
      cur->o_type = WEAPON;
      cur->o_which = rnd(MAXWEAPONS);
      init_weapon(cur, cur->o_which);
      if ((k = rnd(100))<10) {cur->o_flags |= ISCURSED; cur->o_hplus -= rnd(3)+1;}
      else if (k<15) cur->o_hplus += rnd(3)+1;
    break;

    case 4:
      cur->o_type = ARMOR;
      for (j = 0, k = rnd(100); j<MAXARMORS; j++) if (k<a_chances[j]) break;
      cur->o_which = j;
      cur->o_ac = a_class[j];
      if ((k = rnd(100))<20) {cur->o_flags |= ISCURSED; cur->o_ac += rnd(3)+1;}
      else if (k<28) cur->o_ac -= rnd(3)+1;
    break;

    case 5:
      cur->o_type = RING;
      cur->o_which = pick_one(r_magic, MAXRINGS);
      switch (cur->o_which)
      {
        case R_ADDSTR: case R_PROTECT: case R_ADDHIT: case R_ADDDAM:
          if ((cur->o_ac = rnd(3))==0) {cur->o_ac = -1; cur->o_flags |= ISCURSED;}
        break;

        case R_AGGR: case R_TELEPORT:
          cur->o_flags |= ISCURSED;
        break;
      }
    break;

    case 6:
      cur->o_type = STICK;
      cur->o_which = pick_one(ws_magic, MAXSTICKS);
      fix_stick(cur);
    break;
  }
  return cur;
}

//Pick an item out of a list of nitems possible magic items
int pick_one(struct magic_item *magic, int nitems)
{
  struct magic_item *start, *end;
  int i;

  start = magic;
  for (end = &magic[nitems], i = rnd(100); magic<end; magic++) if (i<magic->mi_prob) break;
  if (magic==end) magic = start;
  return magic-start;
}

//list what the player has discovered in this game of a certain type
void discovered(void)
{
  print_disc(POTION);
  add_line("", " ", 0);
  print_disc(SCROLL);
  add_line("", " ", 0);
  print_disc(RING);
  add_line("", " ", 0);
  print_disc(STICK);
  end_line("");
}

//Print what we've discovered of type 'type'
void print_disc(unsigned char type)
{
  unsigned char *know = 0;
  char **guess = 0;
  int i, maxnum = 0, num_found;

  static THING obj;
  static short order[MAX4(MAXSCROLLS, MAXPOTIONS, MAXRINGS, MAXSTICKS)];

  switch (type)
  {
    case SCROLL: maxnum = MAXSCROLLS; know = s_know; guess = s_guess; break;
    case POTION: maxnum = MAXPOTIONS; know = p_know; guess = p_guess; break;
    case RING: maxnum = MAXRINGS; know = r_know; guess = r_guess; break;
    case STICK: maxnum = MAXSTICKS; know = ws_know; guess = ws_guess; break;
  }
  set_order(order, maxnum);
  obj.o_count = 1;
  obj.o_flags = 0;
  num_found = 0;
  for (i = 0; i<maxnum; i++) if (know[order[i]] || *guess[order[i]])
  {
    obj.o_type = type;
    obj.o_which = order[i];
    add_line("", "%s", inv_name(&obj, 0));
    num_found++;
  }
  if (num_found==0) add_line("", nothing(type), 0);
}

//Set up order for list
void set_order(short *order, int numthings)
{
  int i, r, t;

  for (i = 0; i<numthings; i++) order[i] = i;
  for (i = numthings; i>0; i--)
  {
    r = rnd(i);
    t = order[i-1];
    order[i-1] = order[r];
    order[r] = t;
  }
}

//Add a line to the list of discoveries
int add_line(char *use, char *fmt, char *arg)
{
  int x, y;
  int retchar = ' ';

  if (line_cnt==0)
  {
    wdump();
    wclear();
    set_tile_mode(0);
  }
  if (line_cnt>=24 || fmt==0)
  {
    move(24, 0);
    if (*use) printw("Select item to %s. Esc to cancel.", use)
    else addstr("Press space to continue.");
    do retchar = readchar(); while (retchar!=ESCAPE && retchar!=' ' && (!islower(retchar)));

    wclear();
    set_tile_mode(0);

    newpage = 1;
    line_cnt = 0;
  }
  if (fmt!=0 && !(line_cnt==0 && *fmt=='\0'))
  {
    move(line_cnt, 0);
    printw(fmt, arg)
    getrc(&x, &y);
    //if the line wrapped but nothing was printed on this line you might as well use it for the next item
    if (y!=0) line_cnt = x+1;
  }
  return (retchar);
}

//End the list of lines
int end_line(char *use)
{
  int retchar;

  retchar = add_line(use, 0, 0);

  set_tile_mode(1);
  wrestor();

  line_cnt = 0;
  newpage = 0;

  return (retchar);
}

//Set up prbuf so that message for "nothing found" is there
char *nothing(unsigned char type)
{
  char *sp, *tystr = 0;

  sprintf(prbuf, "Haven't discovered anything");
  sp = &prbuf[strlen(prbuf)];
  switch (type)
  {
    case POTION: tystr = "potion"; break;
    case SCROLL: tystr = "scroll"; break;
    case RING: tystr = "ring"; break;
    case STICK: tystr = "stick"; break;
  }
  sprintf(sp, " about any %ss", tystr);
  return prbuf;
}
//***************************************************************************

//***************************************************************************
//Fire a missile in a given direction
void missile(int ydelta, int xdelta)
{
  THING *obj, *nitem;

  //Get which thing we are hurling
  if ((obj = get_item("throw", WEAPON))==0) return;
  if (!can_drop(obj) || is_current(obj)) return;
  //Get rid of the thing.  If it is a non-multiple item object,
  //or if it is the last thing, just drop it.  Otherwise, create a new item with a count of one.
hack:
  if (obj->o_count<2) {inpack--; detach(pack, obj);}
  else
  {
    if ((nitem = new_item())==0)
    {
      obj->o_count = 1;
      msg("something in your pack explodes!!!")
      goto hack;
    }
    obj->o_count--;
    bcopy(*nitem, *obj);
    nitem->o_count = 1;
    obj = nitem;
  }

  if (obj->o_type==AMULET) amulet = 0;

  do_motion(obj, ydelta, xdelta);

  //AHA! Here it has hit something.  If it is a wall or a door, or if it misses (combat) the monster, put it on the floor
  if (moat(obj->o_pos.y, obj->o_pos.x)==0 || !hit_monster(unc(obj->o_pos), obj)) fall(obj, 1);
}

//Do the actual motion on the screen done by an object travelling across the room
void do_motion(THING *obj, int ydelta, int xdelta)
{
  unsigned char under = '@';

  //Come fly with us ...
  bcopy(obj->o_pos, hero);
  for (;;)
  {
    int ch;

    //Erase the old one
    if (under!='@' && !ce(obj->o_pos, hero) && cansee(unc(obj->o_pos))) mvaddch(obj->o_pos.y, obj->o_pos.x, under);
    //Get the new position
    obj->o_pos.y += ydelta;
    obj->o_pos.x += xdelta;
    if (step_ok(ch = winat(obj->o_pos.y, obj->o_pos.x)) && ch!=DOOR)
    {
      //It hasn't hit anything yet, so display it if alright.
      if (cansee(unc(obj->o_pos)))
      {
        under = chat(obj->o_pos.y, obj->o_pos.x);
        mvaddch(obj->o_pos.y, obj->o_pos.x, obj->o_type);
        tick_pause();
      }
      else under = '@';
      continue;
    }
    break;
  }
}

char *short_name(THING *obj)
{
  switch (obj->o_type)
  {
    case WEAPON: return w_names[obj->o_which];
    case ARMOR: return a_names[obj->o_which];
    case FOOD: return "food";
    case POTION: case SCROLL: case AMULET: case STICK: case RING: return strchr(inv_name(obj, 1), ' ')+1;
    default: return "bizzare thing";
  }
}

//Drop an item someplace around here.
void fall(THING *obj, unsigned char pr)
{
  int index;

  static coord fpos;

  switch (fallpos(obj, &fpos))
  {
    case 1:
      index = INDEX(fpos.y, fpos.x);
      _level[index] = obj->o_type;
      bcopy(obj->o_pos, fpos);
      if (cansee(fpos.y, fpos.x))
      {
        if ((flat(obj->o_pos.y, obj->o_pos.x)&F_PASS) || (flat(obj->o_pos.y, obj->o_pos.x)&F_MAZE)) set_attr(BLACK_ON_GREY);
        mvaddch(fpos.y, fpos.x, obj->o_type);
        set_attr(GREY);
        if (moat(fpos.y, fpos.x)!=0) moat(fpos.y, fpos.x)->t_oldch = obj->o_type;
      }
      attach(lvl_obj, obj);
      return;

    case 2:
      pr = 0;
  }
  if (pr) msg("the %s vanishes as it hits the ground.", short_name(obj))
  discard(obj);
}

//Set up the initial goodies for a weapon
void init_weapon(THING *weap, unsigned char type)
{
  struct init_weps *iwp;

  iwp = &init_dam[type];
  weap->o_damage = iwp->iw_dam;
  weap->o_hurldmg = iwp->iw_hrl;
  weap->o_launch = iwp->iw_launch;
  weap->o_flags = iwp->iw_flags;
  if (weap->o_flags&ISMANY) {weap->o_count = rnd(8)+8; weap->o_group = group++;}
  else weap->o_count = 1;
}

//Does the missile hit the monster?
int hit_monster(int y, int x, THING *obj)
{
  THING *mo;

  static coord mp;

  if ((mo = moat(y, x))) {mp.y = y; mp.x = x; return fight(&mp, mo->t_type, obj, 1);}
  return 0;
}

//Figure out the plus number for armor/weapons
char *num(int n1, int n2, char type)
{
  static char numbuf[10];

  sprintf(numbuf, "%s%d", n1<0?"":"+", n1);
  if (type==WEAPON) sprintf(&numbuf[strlen(numbuf)], ",%s%d", n2<0?"":"+", n2);
  return numbuf;
}

//Pull out a certain weapon
void wield(void)
{
  THING *obj, *oweapon;
  char *sp;

  oweapon = cur_weapon;
  if (!can_drop(cur_weapon)) {cur_weapon = oweapon; return;}
  cur_weapon = oweapon;
  if ((obj = get_item("wield", WEAPON))==0)
  {
bad:
    after = 0;
    return;
  }
  if (obj->o_type==ARMOR) {msg("you can't wield armor") goto bad;}
  if (is_current(obj)) goto bad;
  sp = inv_name(obj, 1);
  cur_weapon = obj;
  msg("you are now wielding %s (%c)", sp, pack_char(obj))
}

//Pick a random position around the given (y, x) coordinates
int fallpos(THING *obj, coord *newpos)
{
  int y, x, cnt = 0, ch;
  THING *onfloor;

  for (y = obj->o_pos.y-1; y<=obj->o_pos.y+1; y++)
  for (x = obj->o_pos.x-1; x<=obj->o_pos.x+1; x++)
  {
    //check to make certain the spot is empty, if it is, put the object there, set it in the level list and re-draw the room if he can see it
    if ((y==hero.y && x==hero.x) || offmap(y,x)) continue;
    if ((ch = chat(y, x))==FLOOR || ch==PASSAGE)
    {
      if (rnd(++cnt)==0) {newpos->y = y; newpos->x = x;}
      continue;
    }
    if (step_ok(ch) && (onfloor = find_obj(y, x)) && onfloor->o_type==obj->o_type && onfloor->o_group && onfloor->o_group==obj->o_group)
    {
      onfloor->o_count += obj->o_count;
      return 2;
    }
  }
  return (cnt!=0);
}
//***************************************************************************

//***************************************************************************
//What a certain object is
void whatis(void)
{
  THING *obj;

  if (pack==0) {msg("You don't have anything in your pack to identify") return;}
  for (;;) if ((obj = get_item("identify", 0))==0)
  {
    msg("You must identify something")
    msg(" ")
    mpos = 0;
  }
  else break;
  switch (obj->o_type)
  {
    case SCROLL:
      s_know[obj->o_which] = 1;
      *s_guess[obj->o_which] = 0;
    break;

    case POTION:
      p_know[obj->o_which] = 1;
      *p_guess[obj->o_which] = 0;
    break;

    case STICK:
      ws_know[obj->o_which] = 1;
      obj->o_flags |= ISKNOW;
      *ws_guess[obj->o_which] = 0;
    break;

    case WEAPON: case ARMOR:
      obj->o_flags |= ISKNOW;
    break;

    case RING:
      r_know[obj->o_which] = 1;
      obj->o_flags |= ISKNOW;
      *r_guess[obj->o_which] = 0;
    break;
  }
  //If it is vorpally enchanted, then reveal what type of monster it is vorpally enchanted against
  if (obj->o_enemy) obj->o_flags |= ISREVEAL;
  msg(inv_name(obj, 0))
}

//Bamf the hero someplace else
int teleport(void)
{
  int rm;
  coord c;

  mvaddch(hero.y, hero.x, chat(hero.y, hero.x));
  do {rm = rnd_room(); rnd_pos(&rooms[rm], &c);} while (!(step_ok(winat(c.y, c.x))));
  if (&rooms[rm]!=proom) {leave_room(&hero); bcopy(hero, c); enter_room(&hero);}
  else {bcopy(hero, c); look(1);}
  mvaddch(hero.y, hero.x, PLAYER);
  //turn off ISHELD in case teleportation was done while fighting a Fungi
  if (on(player, ISHELD)) {player.t_flags &= ~ISHELD; f_restor();}
  no_move = 0;
  count = 0;
  running = 0;
  flush_type();
  //Teleportation can be a confusing experience
  if (on(player, ISHUH)) lengthen(unconfuse, rnd(4)+2); else fuse(unconfuse, 0, rnd(4)+2);
  player.t_flags |= ISHUH;
  return rm;
}

//Wizard: command for getting anything he wants
void create_obj(void)
{
  int type, num, which;
  unsigned char ch, bless;
  THING *obj;

  type = 0;
  num = 0;

  while (type==0)
  {
    msg("type of item ,]:!=?/)")
    ch = readchar();
    clearmsg()

    switch (ch)
    {
      case ESCAPE: return;

      case ',': type = AMULET; num = 1         ; break;
      case ']': type = ARMOR ; num = MAXARMORS ; break;
      case ':': type = FOOD  ; num = 2         ; break;
      case '!': type = POTION; num = MAXPOTIONS; break;
      case '=': type = RING  ; num = MAXRINGS  ; break;
      case '?': type = SCROLL; num = MAXSCROLLS; break;
      case '/': type = STICK ; num = MAXSTICKS ; break;
      case ')': type = WEAPON; num = MAXWEAPONS; break;
    }
  }

  while (1)
  {
    msg("which %c do you want? (0-%c)", type, num-1<10?num-1+'0':num-1-10+'a')
    ch = readchar();
    clearmsg()

    which = -1;

    if (ch>='0' && ch<='9') which = ch-'0';
    if (ch>='a' && ch<='f') which = ch-'a'+10;

    if (which>=0 && which<num) break;
  }



  if ((obj = new_item())==0) {msg("can't create anything now") return;}

  obj->o_type = type;
  obj->o_which = which;
  obj->o_group = 0;
  obj->o_count = 1;
  obj->o_damage = obj->o_hurldmg = "0d0";

  if (obj->o_type==WEAPON || obj->o_type==ARMOR)
  {
    msg("blessing? (+,-,n)")
    bless = readchar();
    mpos = 0;
    if (bless=='-') obj->o_flags |= ISCURSED;
    if (obj->o_type==WEAPON)
    {
      init_weapon(obj, obj->o_which);
      if (bless=='-') obj->o_hplus -= rnd(3)+1;
      if (bless=='+') obj->o_hplus += rnd(3)+1;
    }
    else
    {
      obj->o_ac = a_class[obj->o_which];
      if (bless=='-') obj->o_ac += rnd(3)+1;
      if (bless=='+') obj->o_ac -= rnd(3)+1;
    }
  }
  else if (obj->o_type==RING) switch (obj->o_which)
  {
    case R_PROTECT: case R_ADDSTR: case R_ADDHIT: case R_ADDDAM:
      msg("blessing? (+,-,n)")
      bless = readchar();
      mpos = 0;
      if (bless=='-') obj->o_flags |= ISCURSED;
      obj->o_ac = (bless=='-'?-1:rnd(2)+1);
    break;

    case R_AGGR: case R_TELEPORT:
      obj->o_flags |= ISCURSED;
    break;
  }
  else if (obj->o_type==STICK) fix_stick(obj);

  add_pack(obj, 0);
}

//Wizard: Print out the map
void show_map(void)
{
  int hx, hy, off, x, y, ch;

  wdump();

  wclear();
  set_tile_mode(0);

  get_hero_position(&hx, &hy); if (hx<40) off = 0; else off = 20;

again:
  for (y=1; y<23; y++) for (x=0; x<60; x++)
  {
    if (flat(y, off+x)&F_REAL) set_attr(GREY); else set_attr(BLACK_ON_GREY);
    mvaddch(y, x, chat(y, off+x));
  }
  set_attr(GREY); mvaddstr(0, 0, "<--- Left, Right --->, Space to exit");

  while (1)
  {
    ch = readchar();
    if (ch==' ') break;
    if (ch=='h') {off = 0; goto again;}
    if (ch=='l') {off = 20; goto again;}
  }

  set_tile_mode(1);

  wrestor();
}

//Wizard: Add the passages to the current window
void add_pass(void)
{
  int y, x, ch;

  for (y = 1; y<23; y++) for (x = 0; x<80; x++) if ((ch = chat(y, x))==DOOR || ch==PASSAGE) mvaddch(y, x, ch);
}
//***************************************************************************

//***************************************************************************
//Display a new msg (giving him a chance to see the previous one if it is up there with the -More-)
void endmsg(void)
{
  if (save_msg) strcpy(huh, msgbuf);
  if (mpos) {look(0); move(0, mpos); more(" More ");}
  //All messages should start with uppercase, except ones that start with a pack addressing character
  if (islower(msgbuf[0]) && msgbuf[1]!=')') msgbuf[0] = toupper(msgbuf[0]);
  putmsg(0, msgbuf);
  mpos = io_newpos;
  io_newpos = 0;
}

//tag the end of a line and wait for a space
void more(char *msg)
{
  char mbuf[80];
  int x, y, i, msz, morethere = 1, covered = 0;

  getrc(&x, &y); if (x!=0) {x = 0; y = 80;} //get cursor pos
  msz = strlen(msg); if (y+msz>60) {y = 60-msz; covered = 1;}
  for (i=0; i<msz; i++) {move(x, y+i); mbuf[i] = inch();} mbuf[i] = 0; //store text under msg
  move(x, y); set_attr(BLACK_ON_GREY); addstr(msg); set_attr(GREY); //display msg

  while (readchar()!=' ')
  {
    if (covered && morethere) {move(x, y); addstr(mbuf); morethere = 0;}
    else if (covered) {move(x, y); set_attr(BLACK_ON_GREY); addstr(msg); set_attr(GREY); morethere = 1;}
  }

  move(x, y); addstr(mbuf); //restore text under msg
}

//put a msg on the line, make sure that it will fit, if it won't scroll msg sideways until he has read it all
void putmsg(int msgline, char *msg)
{
  char *curmsg, *lastmsg = 0, *tmpmsg;
  int curlen;

  curmsg = msg;
  do
  {
    scrl(msgline, lastmsg, curmsg);
    io_newpos = curlen = strlen(curmsg);
    if (curlen>60)
    {
      more(" Cont ");
      lastmsg = curmsg;
      while (1)
      {
        tmpmsg = strchr(curmsg, ' ');
        //If there are no blanks in line
        if ((tmpmsg==0 || tmpmsg>=&lastmsg[60]) && lastmsg==curmsg) {curmsg = &lastmsg[60]; break;}
        if (tmpmsg>=lastmsg+60 || strlen(curmsg)<60) break;
        curmsg = tmpmsg+1;
      }
    }
  } while (curlen>60);
}

//scroll a message across the line
void scrl(int msgline, char *str1, char *str2)
{
  if (str1==0)
  {
    move(msgline, 0);
    if (strlen(str2)<60) clrtoeol();
    printw("%.60s", str2)
  }
  else while (str1<=str2)
  {
    move(msgline, 0);
    printw("%.60s", str1++)
    if (strlen(str1)<60-1) clrtoeol();
  }
}

//Print a readable version of a certain character
char *unctrl(unsigned char ch)
{
  static char chstr[9]; //Defined in curses library

  if (isspace(ch)) strcpy(chstr, " ");
  else if (!isprint(ch)) if (ch<' ') sprintf(chstr, "^%c", ch+'@'); else sprintf(chstr, "\\x%x", ch);
  else {chstr[0] = ch; chstr[1] = 0;}
  return chstr;
}

//format a string with attributes.
void str_attr(char *str)
{
  while (*str)
  {
    if (*str=='%') {str++; set_attr(BLACK_ON_GREY);}
    addch(*str++);
    set_attr(GREY);
  }
}
//***************************************************************************

//***************************************************************************
//the following functions access data in SRAM



//when defined, first byte of SRAM is left unused
#define SRAM_SKIP_FIRST_BYTE



#ifdef SRAM_SKIP_FIRST_BYTE
  #define SRAM       (0x0E000000+1)
  #define SRAM_SIZE  (65536-1)
#else
  #define SRAM       0x0E000000
  #define SRAM_SIZE  65536
#endif



//----------------------------------------------------------------------------



#define SAVE_STATE \
\
PTR(savewin, 2*80*25) \
\
PTR(_flags, 1*80*(25-3)) \
PTR(_level, 1*80*(25-3)) \
\
VAR(amulet) \
VAR(saw_amulet) \
VAR(door_stop) \
VAR(fastmode) \
VAR(faststate) \
VAR(firstmove) \
VAR(playing) \
VAR(running) \
VAR(was_trapped) \
VAR(newpage) \
VAR(maxitems) \
VAR(bailout) \
VAR(max_level) \
VAR(level) \
VAR(purse) \
VAR(no_move) \
VAR(no_command) \
VAR(inpack) \
VAR(total) \
VAR(no_food) \
VAR(fung_hit) \
VAR(quiet) \
VAR(food_left) \
VAR(group) \
VAR(hungry_state) \
VAR(line_cnt) \
VAR(oldpos) \
VAR(delta) \
VAR(nh) \
VAR(ch_ret) \
VAR(slimy) \
VAR(oldrp) \
VAR(max_stats) \
VAR(player) \
VAR(cur_armor) \
VAR(cur_weapon) \
VAR(lvl_obj) \
VAR(mlist) \
\
ARR(_t_alloc) \
ARR(r_know) \
ARR(s_know) \
ARR(p_know) \
ARR(ws_know) \
ARR(r_stoneworth) \
ARR(whoami) \
ARR(fruit) \
ARR(macro) \
ARR(f_damage) \
ARR(r_guess) \
ARR(s_guess) \
ARR(p_guess) \
ARR(ws_guess) \
ARR(r_stones) \
ARR(p_colors) \
ARR(ws_made) \
ARR(ws_type) \
ARR(s_names) \
ARR(_guesses) \
ARR(rooms) \
ARR(passages) \
ARR(d_list) \
ARR(cur_ring) \
ARR(_things)



char save_signature[] = "ROGUE";



#define VAR(x)    n = sizeof(x); for (i=0; i<n; i++) *p++ = *((unsigned char *)&x+i);
#define ARR(x)    n = sizeof(x); for (i=0; i<n; i++) *p++ = *((unsigned char *) x+i);
#define PTR(x,y)                 for (i=0; i<y; i++) *p++ = *((unsigned char *) x+i);

void save_game(void)
{
  unsigned char *p;
  int n, i;

  wdump();

  clearmsg() msg("Saving game. Please do not turn off power.")

  p = (unsigned char *)SRAM;
  p += sizeof(save_signature); //skip save signature
  SAVE_STATE
  p = (unsigned char *)SRAM;
  ARR(save_signature) //write save signature

  clearmsg() msg("Game was saved and halted. It is now safe to turn off power.")

  while (1) tick_pause(); //infinite loop
}

#undef VAR
#undef ARR
#undef PTR



#define VAR(x)    n = sizeof(x); for (i=0; i<n; i++) *((unsigned char *)&x+i) = *p++;
#define ARR(x)    n = sizeof(x); for (i=0; i<n; i++) *((unsigned char *) x+i) = *p++;
#define PTR(x,y)                 for (i=0; i<y; i++) *((unsigned char *) x+i) = *p++;

//return!=0: success
int restore_game(void)
{
  unsigned char *p, c;
  int n, i;

  p = (unsigned char *)SRAM;
  n = sizeof(save_signature); for (i=0; i<n; i++) {c = *p; *p++ = 0; if (c!=save_signature[i]) return 0;}
  SAVE_STATE

  set_tile_mode(1);
  wrestor();

  clearmsg() msg("Saved game was restored. Hello %s, welcome back to the Dungeons of Doom!", whoami)
  seedMT(get_seed());

  return 1;
}

#undef VAR
#undef ARR
#undef PTR



//----------------------------------------------------------------------------



char score_signature[] = "ROGUE";



void score(int amount, int flags, char monst)
{
  unsigned char *p;
  int i, j, n, badsig, rank = 0;
  struct sc_ent his_score, top_ten[TOPSCORES];

  if (amount || flags || monst)
  {
    move(24, 0); printw("[Press Enter to see rankings]")
    flush_type();
    while (readchar()!='\r') ;
  }

  p = (unsigned char *)SRAM;
  p += SRAM_SIZE;
  p -= (sizeof(struct sc_ent)+sizeof(score_signature))*TOPSCORES;

  for (i = 0; i<TOPSCORES; i++)
  {
    n = sizeof(struct sc_ent); for (j=0; j<n; j++) *((unsigned char *)&top_ten[i]+j) = *p++;
    badsig = 0; n = sizeof(score_signature); for (j=0; j<n; j++) if (*p++!=score_signature[j]) badsig = 1;
    if (badsig) top_ten[i].sc_gold = 0;
  }

  strcpy(his_score.sc_name, whoami);
  his_score.sc_gold = amount;
  his_score.sc_fate = flags?flags:monst;
  his_score.sc_level = max_level;
  his_score.sc_rank = pstats.s_lvl;
  rank = add_scores(&his_score, &top_ten[0]);

  if (rank>0)
  {
    p = (unsigned char *)SRAM;
    p += SRAM_SIZE;
    p -= (sizeof(struct sc_ent)+sizeof(score_signature))*TOPSCORES;

    for (i = 0; (i<TOPSCORES) && top_ten[i].sc_gold; i++)
    {
      n = sizeof(struct sc_ent); for (j=0; j<n; j++) *p++ = *((unsigned char *)&top_ten[i]+j);
      n = sizeof(score_signature); for (j=0; j<n; j++) *p++ = score_signature[j];
    }
  }

  pr_scores(rank, &top_ten[0]);

  move(24, 0); printw("[Press Enter to continue]")
  flush_type();
  while (readchar()!='\r') ;

  soft_reset();
}

void pr_scores(int newrank, struct sc_ent *top10)
{
  int i;

  wclear();
  set_tile_mode(0);

  set_attr(WHITE); mvaddstr(0, 0, "Guildmaster's Hall Of Fame:");
  set_attr(YELLOW); mvaddstr(2, 0, "Gold");

  for (i=0; i<TOPSCORES; i++, top10++)
  {
    if (top10->sc_gold<=0) break;

    if (newrank-1!=i) set_attr(BROWN); else set_attr(YELLOW);
    move(3+2*i, 0); printw("%d", top10->sc_gold)
    if (newrank-1!=i) set_attr(RED);
    move(3+2*i, 6); printw("%s", top10->sc_name)
    if (newrank-1!=i) set_attr(BROWN);
    if (top10->sc_rank>1) printw(" \"%s\"", he_man[top10->sc_rank-1])
    move(4+2*i, 6);

    if (top10->sc_level>=26) printw("Honored by the Guild")
    else if (top10->sc_fate==1) printw("quit on level %d", top10->sc_level)
    else if (top10->sc_fate==2) printw("A total winner!")
    else if (isalpha(top10->sc_fate)) printw("killed by %s on level %d", killname(top10->sc_fate&0xff, 1), top10->sc_level)
  }
  set_attr(GREY);
}

int add_scores(struct sc_ent *newscore, struct sc_ent *oldlist)
{
  struct sc_ent *sentry, *insert = 0;
  int retcode = TOPSCORES+1;

  for (sentry = &oldlist[TOPSCORES-1]; sentry>=oldlist; sentry--)
  {
    if ((unsigned)newscore->sc_gold>(unsigned)sentry->sc_gold)
    {
      insert = sentry;
      retcode--;
      if ((insert<&oldlist[TOPSCORES-1]) && sentry->sc_gold) sentry[1] = *sentry;
    }
    else break;
  }
  if (retcode==11) return 0;
  *insert = *newscore;
  return retcode;
}
//***************************************************************************
