//AGB_Rogue was adapted from IBM(TM) PC Rogue version 1.48
//by Donnie Russell, Copyright (C) 2007



#include "../compsound/sound_def.h"

#include "../compgraph/title_def.h"
#include "../compgraph/tile_def.h"
#include "../compgraph/cave_def.h"

#include "../comptables/table_def.h"



#define CLIENTW  240
#define CLIENTH  160

#define TILE_W  16
#define TILE_H  16



#define BLACK           0
#define BLUE            1
#define GREEN           2
#define CYAN            3
#define RED             4
#define MAGENTA         5
#define BROWN           6
#define GREY            7
#define DGREY           8
#define LBLUE           9
#define LGREEN          10
#define LCYAN           11
#define LRED            12
#define LMAGENTA        13
#define YELLOW          14
#define WHITE           15

#define BLACK_ON_BLUE   16
#define BLACK_ON_GREEN  32
#define BLACK_ON_CYAN   48
#define BLACK_ON_RED    64
#define BLACK_ON_GREY   112
#define FLASH           128



#define CTRL(ch)  (ch&037)



//............................................................................
extern const unsigned long fntdata_4x6[];
extern const unsigned char fntdata_6x8[];

extern const unsigned long TitlePalette[];
extern const unsigned char TitleData[];

extern const unsigned long TilePalette[];
extern const unsigned char TileData[];

extern const unsigned long CavePalette[];
extern const unsigned char CaveData[];

extern const short EllipseData[];
extern const unsigned char MinimapColorData[];
//............................................................................



//////////////////////////////////////////////////////////////////////////////
void PlaySoundByNumber(int i); //from sound_data.c



void soft_reset(void); //from bios.s



int command_menu(void);
void display_credits(void);

void startup(void);
int get_input(void);
void tick_pause(void);
void move(int y, int x);
void getrc(int *y, int *x);
void set_attr(int a);
int get_attr(void);
void putchr(int i);
int curch(void);
void wclear(void);
void wdump(void);
void wrestor(void);
void clrtoeol(void);
void set_tile_mode(int mode);
unsigned short get_seed(void);
void play_sound(int n);

void drop_curtain(void);
void raise_curtain(void);
void start_transition(void);
void end_transition(void);

void toggle_tiles(void);

void display_cave_exit(void);
//////////////////////////////////////////////////////////////////////////////
