#define VAR_IN_EWRAM   __attribute__ ((section (".ewram")))

#define CODE_IN_IWRAM  __attribute__ ((section (".iwram"), long_call))



typedef volatile unsigned short  vu16;
typedef volatile unsigned long   vu32;

typedef          unsigned short   u16;
typedef          unsigned long    u32;



#define BIT(x)  (1<<(x))



#define BG_PALETTE       (( u16*)0x05000000)

#define VIDEO_FRAME0     (( u16*)0x06000000)
#define VIDEO_FRAME1     (( u16*)0x0600A000)



//i/o registers
#define REG_DISPCNT     (*( u16*)0x04000000) //R/W  LCD Control
#define REG_VCOUNT      (*(vu16*)0x04000006) //R    Vertical Counter
#define REG_SOUNDCNT_L  (*( u16*)0x04000080)
#define REG_SOUNDCNT_H  (*( u16*)0x04000082)
#define REG_SOUNDCNT_X  (*( u16*)0x04000084) //R/W  Control Sound on/off
#define REG_DMA1SAD     (*( u32*)0x040000BC)
#define REG_DMA1DAD     (*( u32*)0x040000C0)
#define REG_DMA1CNT     (*( u32*)0x040000C4)
#define REG_TM0D        (*( u16*)0x04000100) //R/W  Timer 0 Counter/Reload
#define REG_TM0CNT      (*( u16*)0x04000102) //R/W  Timer 0 Control
#define REG_TM1D        (*( u16*)0x04000104) //R/W  Timer 1 Counter/Reload
#define REG_TM1CNT      (*( u16*)0x04000106) //R/W  Timer 1 Control
#define REG_TM3D        (*( u16*)0x0400010C) //R/W  Timer 3 Counter/Reload
#define REG_TM3CNT      (*( u16*)0x0400010E) //R/W  Timer 3 Control
#define REG_P1          (*(vu16*)0x04000130) //R    Key Status
#define REG_P1CNT       (*( u16*)0x04000132) //R/W  Key Interrupt Control
#define REG_IE          (*( u16*)0x04000200) //R/W  Interrupt Enable Register
#define REG_IF          (*( u16*)0x04000202)
#define REG_IME         (*( u16*)0x04000208) //R/W  Interrupt Master Enable Register



#define REG_FIFO_A               0x040000A0
#define REG_FIFO_B               0x040000A4



//interrupt handler address
#define REG_INTERRUPT   (*( u32*)0x03007FFC)



//graphics mode settings
#define MODE_0         0x0
#define MODE_1         0x1
#define MODE_2         0x2
#define MODE_3         0x3
#define MODE_4         0x4
#define MODE_5         0x5
#define BACKBUFFER     BIT(0x4)
#define H_BLANK_OAM    BIT(0x5)
#define OBJ_MAP_2D     0
#define OBJ_MAP_1D     BIT(0x6)
#define FORCE_BLANK    BIT(0x7)
#define BG0_ENABLE     BIT(0x8)
#define BG1_ENABLE     BIT(0x9)
#define BG2_ENABLE     BIT(0xA)
#define BG3_ENABLE     BIT(0xB)
#define OBJ_ENABLE     BIT(0xC)
#define WIN1_ENABLE    BIT(0xD)
#define WIN2_ENABLE    BIT(0xE)
#define WINOBJ_ENABLE  BIT(0xF)



//timer settings
#define TIME_FREQUENCY_SYSTEM  0x0
#define TIME_FREQUENCY_64      0x1
#define TIME_FREQUENCY_256     0x2
#define TIME_FREQUENCY_1024    0x3
#define TIME_OVERFLOW          0x4
#define TIME_IRQ_ENABLE        0x40
#define TIME_ENABLE            0x80



//input settings
#define KEY_A       1
#define KEY_B       2
#define KEY_SELECT  4
#define KEY_START   8
#define KEY_RIGHT   16
#define KEY_LEFT    32
#define KEY_UP      64
#define KEY_DOWN    128
#define KEY_R       256
#define KEY_L       512
#define ALL_KEYS    (KEY_A|KEY_B|KEY_SELECT|KEY_START|KEY_RIGHT|KEY_LEFT|KEY_UP|KEY_DOWN|KEY_R|KEY_L)



//sound settings
#define SND_ENABLED           0x00000080
#define SND_OUTPUT_RATIO_25   0x0000
#define SND_OUTPUT_RATIO_50   0x0001
#define SND_OUTPUT_RATIO_100  0x0002
#define DSA_OUTPUT_RATIO_50   0x0000
#define DSA_OUTPUT_RATIO_100  0x0004
#define DSB_OUTPUT_RATIO_50   0x0000
#define DSB_OUTPUT_RATIO_100  0x0008
#define DSA_OUTPUT_TO_RIGHT   0x0100
#define DSA_OUTPUT_TO_LEFT    0x0200
#define DSA_TIMER0            0x0000
#define DSA_TIMER1            0x0400
#define DSA_FIFO_RESET        0x0800
#define DSB_OUTPUT_TO_RIGHT   0x1000
#define DSB_OUTPUT_TO_LEFT    0x2000
#define DSB_TIMER0            0x0000
#define DSB_TIMER1            0x4000
#define DSB_FIFO_RESET        0x8000



//dma settings
#define DST_INCREMENT        0x00000000
#define DST_DECREMENT        0x00200000
#define DST_FIXED            0x00400000
#define DST_INVALID          0x00600000
#define SRC_INCREMENT        0x00000000
#define SRC_DECREMENT        0x00800000
#define SRC_FIXED            0x01000000
#define SRC_INVALID          0x01800000
#define DMA_REPEAT           0x02000000
#define TRANSFER_16_BITS     0x00000000
#define TRANSFER_32_BITS     0x04000000
#define START_ON_FIFO_EMPTY  0x30000000
#define DMA_ENABLE           0x80000000
