//AGB_Rogue was adapted from IBM(TM) PC Rogue version 1.48
//by Donnie Russell, Copyright (C) 2007



#include "gba.h"
#include "inc.h"



//the following are arm functions that go into iwram for faster execution



//****************************************************************************
void IntHandler(void)
{
  unsigned short i;

  REG_IME = 0;
  i = REG_IF;



  if (i&BIT(4)) //timer 1 overflow
  {
    //stop playing sound
    REG_TM0CNT = 0; //timer 0 off
    REG_TM1CNT = 0; //timer 1 off
    REG_DMA1CNT = 0; //dma 1 off
  }



  REG_IF = i;
  REG_IME = 1;
}
//****************************************************************************



//****************************************************************************
unsigned long *VideoFrame = (unsigned long *)VIDEO_FRAME0;



void SelectVideoFrame(int frame)
{
  VideoFrame = frame?(unsigned long *)VIDEO_FRAME1:(unsigned long *)VIDEO_FRAME0;
}



void Clear(void)
{
  unsigned long *d;
  int i;

  d = (unsigned long *)VideoFrame;
  i = (CLIENTW*CLIENTH)>>2; while (i--) *d++ = 0;
}



//mode: 0 save 1 restore
void SaveRestoreScreen(int mode)
{
  unsigned long *s, *d;
  int i;

  if (mode==0) {s = (unsigned long *)VIDEO_FRAME0; d = (unsigned long *)VIDEO_FRAME1;}
  else         {s = (unsigned long *)VIDEO_FRAME1; d = (unsigned long *)VIDEO_FRAME0;}

  i = (CLIENTW*CLIENTH)>>2; while (i--) *d++ = *s++;
}



void PutChar_4x6(int ch, int attr, int x, int y)
{
  unsigned long fore, back, *d, a;

  if (x<0 || x>=60 || y<0 || y>=25) return;

  fore = attr&15; back = (attr&240)>>4;

  d = (unsigned long *)VideoFrame+(CLIENTW>>2)*(6*y+5)+x;
  a = fntdata_4x6[ch];

  *d = ((a&(1    )?fore:back)<<24)|((a&(1<< 1)?fore:back)<<16)|((a&(1<< 2)?fore:back)<<8)|(a&(1<< 3)?fore:back); d -= CLIENTW>>2;
  *d = ((a&(1<< 4)?fore:back)<<24)|((a&(1<< 5)?fore:back)<<16)|((a&(1<< 6)?fore:back)<<8)|(a&(1<< 7)?fore:back); d -= CLIENTW>>2;
  *d = ((a&(1<< 8)?fore:back)<<24)|((a&(1<< 9)?fore:back)<<16)|((a&(1<<10)?fore:back)<<8)|(a&(1<<11)?fore:back); d -= CLIENTW>>2;
  *d = ((a&(1<<12)?fore:back)<<24)|((a&(1<<13)?fore:back)<<16)|((a&(1<<14)?fore:back)<<8)|(a&(1<<15)?fore:back); d -= CLIENTW>>2;
  *d = ((a&(1<<16)?fore:back)<<24)|((a&(1<<17)?fore:back)<<16)|((a&(1<<18)?fore:back)<<8)|(a&(1<<19)?fore:back); d -= CLIENTW>>2;
  *d = ((a&(1<<20)?fore:back)<<24)|((a&(1<<21)?fore:back)<<16)|((a&(1<<22)?fore:back)<<8)|(a&(1<<23)?fore:back); d -= CLIENTW>>2;
}



void PutChar_6x8(int ch, int attr, int x, int y)
{
  unsigned short *d, fore, back;
  unsigned char *f, a, i;

  if (x<0 || x>=40 || y<0 || y>=20) return;

  fore = attr&15; back = (attr&240)>>4;

  d = (unsigned short *)VideoFrame+(CLIENTW>>1)*(8*y)+(3*x+2);
  f = (unsigned char *)fntdata_6x8+(8*ch);

  i = 8; while (i--)
  {
    a = *f++;

    *d-- = ((a&(1   )?fore:back)<<8)|(a&(1<<1)?fore:back);
    *d-- = ((a&(1<<2)?fore:back)<<8)|(a&(1<<3)?fore:back);
    *d-- = ((a&(1<<4)?fore:back)<<8)|(a&(1<<5)?fore:back);

    d += (CLIENTW>>1)+3;
  }
}



//assumes TILE_W and TILE_H are 16
//x,TILE_DATA_W,TILE_W,CLIENTW must be multiple of 4
#define DT  *d++ = *s++; *d++ = *s++; *d++ = *s++; *d++ = *s++; s += (-TILE_DATA_W-TILE_W)>>2; d += (CLIENTW-TILE_W)>>2;
void DrawTile(int x, int y, int tile)
{
  unsigned long *s = (unsigned long *)TileData+(TILE_DATA_W>>2)*(TILE_DATA_H-1)+(TILE_W>>2)*tile;
  unsigned long *d = (unsigned long *)VideoFrame+(CLIENTW>>2)*y+(x>>2);

  DT DT DT DT DT DT DT DT DT DT DT DT DT DT DT DT
}
#undef DT



//assumes TILE_W and TILE_H are 16
//x,TILE_W,CLIENTW must be multiple of 4
#define DT  *d++ = 0; *d++ = 0; *d++ = 0; *d++ = 0; d += (CLIENTW-TILE_W)>>2;
void DrawBlankTile(int x, int y)
{
  unsigned long *d = (unsigned long *)VideoFrame+(CLIENTW>>2)*y+(x>>2);

  DT DT DT DT DT DT DT DT DT DT DT DT DT DT DT DT
}
#undef DT



//copies elliptical area from VIDEO_FRAME1 to VIDEO_FRAME0
void CopyEllipse(int x, int y, int rx, int ry, int step)
{
  int yl, yh, pos, off, dx, xl, xh, i, j;
  unsigned short *d;

  yl = y-ry; yh = y+ry; if (rx<1 || ry<1 || yh<0 || yl>CLIENTH-1) return;
  pos = 0; if (yl<0) {pos += (0-yl)*step; yl = 0;}
  if (yh>CLIENTH-1) yh = CLIENTH-1;

  off = (CLIENTW>>1)*yl;

  for (j=yh-yl+1; j>0; j--,pos+=step,off+=CLIENTW>>1)
  {
    dx = (rx*EllipseData[pos>>16])>>ELLIPSE_BITS;
    xl = x-dx; xh = x+dx; if (xh<0 || xl>CLIENTW-1) continue; if (xl<0) xl = 0; if (xh>CLIENTW-1) xh = CLIENTW-1;

    d = VIDEO_FRAME0+off+(xl>>1);
    i = (xh>>1)-(xl>>1)+1; while (i--) {*d = *(d+(0xA000>>1)); d++;}
  }
}



void DrawMinimapRoutine(unsigned short *p, int hx, int hy)
{
  unsigned long *d, a, color;
  int x, y;

  d = (unsigned long *)VideoFrame+(CLIENTW>>2)*(CLIENTH-22)+((CLIENTW-80)>>2);

  a = 0;

  for (y=0; y<22; y++)
  {
    for (x=0; x<80; x++)
    {
      color = MinimapColorData[(*p++)&255]; if (color==16) {if (x>=hx && x<hx+15 && y>=hy && y<hy+8) color = BLACK; else color = DGREY;}

      a = (a>>8)|(color<<24);

      if ((x&3)==3) {*d++ = a; a = 0;}
    }
    d += (CLIENTW-80)>>2;
  }
}
//****************************************************************************
