#include <stdio.h>
#include <math.h>



#define ELLIPSE_BITS  9
#define ELLIPSE_RAD   (1<<ELLIPSE_BITS)



#define BLACK     0
#define BLUE      1
#define GREEN     2
#define CYAN      3
#define RED       4
#define MAGENTA   5
#define BROWN     6
#define GREY      7
#define DGREY     8
#define LBLUE     9
#define LGREEN    10
#define LCYAN     11
#define LRED      12
#define LMAGENTA  13
#define YELLOW    14
#define WHITE     15



int main(void)
{
  FILE *out;
  int i;
  short c[256];



  out = fopen("table_def.h", "wb"); if (out==0) return 1;

  fprintf(out, "#define ELLIPSE_BITS  %i\n", ELLIPSE_BITS);
  fprintf(out, "#define ELLIPSE_RAD   (1<<ELLIPSE_BITS)\n\n");

  fclose(out);



  out = fopen("table_data.c", "wb"); if (out==0) return 1;



  fprintf(out, "const short EllipseData[%i] =\n{\n", 2*ELLIPSE_RAD+1);
  for (i=-ELLIPSE_RAD; i<=ELLIPSE_RAD; i++) fprintf(out, "%i,", (short)sqrt((double)(ELLIPSE_RAD*ELLIPSE_RAD-i*i)));
  fprintf(out, "\n};\n\n");



  for (i=0; i<256; i++) c[i] = 16; //16 means color is undefined

  for (i='A'; i<='Z'; i++) c[i] = LRED; //monsters
  c[0xc9] = c[0xbb] = c[0xc8] = c[0xbc] = c[0xcd] = c[0xba] = GREY; //ulwall urwall llwall lrwall hwall vwall
  c[0xb1] = WHITE; //passage
  c[0xce] = BLACK; //door
  c[0x0c] = c[0x08] = c[0xad] = c[0x09] = c[0x0d] = c[0xe7] = c[0x18] = c['$'] = c['+'] = LBLUE; //amulet armor potion ring scroll stick weapon magic bmagic
  c[0x0f] = YELLOW; //gold
  c[0x05] = BROWN; //food
  c[0x04] = MAGENTA; //trap
  c[0xf0] = LGREEN; //stairs
  c[0x01] = LCYAN; //player

  fprintf(out, "const unsigned char MinimapColorData[256] =\n{\n");
  for (i=0; i<256; i++) fprintf(out, "%i,", c[i]);
  fprintf(out, "\n};\n\n");



  fclose(out);

  return 0;
}
