#include <stdio.h>
#include <stdlib.h>
#include <string.h>



struct {char *filename; char *tag;} Sound[] =
{
  {"../data/hit1.wav"  , "  HIT1_SOUND"},
  {"../data/hit2.wav"  , "  HIT2_SOUND"},
  {"../data/miss1.wav" , " MISS1_SOUND"},
  {"../data/miss2.wav" , " MISS2_SOUND"},
  {"../data/gold.wav"  , "  GOLD_SOUND"},
  {"../data/eat.wav"   , "   EAT_SOUND"},
  {"../data/level.wav" , " LEVEL_SOUND"},
  {"../data/trap.wav"  , "  TRAP_SOUND"},
  {"../data/fire.wav"  , "  FIRE_SOUND"},
  {"../data/ice.wav"   , "   ICE_SOUND"},
  {"../data/stairs.wav", "STAIRS_SOUND"},
  {"../data/medusa.wav", "MEDUSA_SOUND"},
  {"../data/zap.wav"   , "   ZAP_SOUND"},

  {0, 0}
};



typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned long u32;

#define WAVEHDRSIZE  (4+4+4+4+4+2+2+4+4+2+2+4+4)

typedef struct
{
  char riff_id[4];
  u32 riff_len;
  char wave_id[4];
  char fmt_id[4];
  u32 fmt_len;
  u16 fmt_tag;
  u16 channels;
  u32 samplerate;
  u32 samplerate2;
  u16 u8s_per_sample;
  u16 bits;
  char data_id[4];
  u32 data_len;
} WAVEHDR;



void ConvertChannel(FILE *in, FILE *out, int index, WAVEHDR *hdr, int num_channels, int channel)
{
  int size, freq, i, c1, c2;
  unsigned char uc1, uc2;

  fprintf(out, "static const signed char Sound%iData[] =\n{\n", index);

  size = hdr->data_len/num_channels;
  freq = hdr->samplerate;
  fseek(in, WAVEHDRSIZE, SEEK_SET);
  for (i=0; i<size; i++)
  {
    fread(&uc1, 1, 1, in); if (num_channels==2) fread(&uc2, 1, 1, in);
    c1 = uc1-128; c2 = uc2-128;

    fprintf(out, "%i,", channel==0?c1:c2); if (i==size-1 || i%32==31) fprintf(out, "\n");
  }

  fprintf(out, "};\n\nstatic const unsigned int Sound%iDataLength = %i;\n\n", index, size);
  fprintf(out, "static const unsigned int Sound%iDataFreq = %i;\n\n", index, freq);
  fprintf(out, "//----------------------------------------------------------------------------\n\n");
}



int main(void)
{
  FILE *out, *in;
  int index;
  WAVEHDR hdr;
  int num_channels, channel;



  out = fopen("sound_data.c", "wb"); if (out==0) {printf("Failed to open output file.\n"); return 1;}



  index = 0;
  while (Sound[index].filename)
  {
    in = fopen(Sound[index].filename, "rb"); if (in==0) {fclose(out); printf("Failed to open input file.\n"); return 1;}

    fread(&hdr, sizeof(hdr), 1, in);

    if (strncmp(hdr.riff_id, "RIFF", 4)!=0) {fclose(in); fclose(out); printf("'RIFF' not found.\n"); return 1;}
    if (strncmp(hdr.wave_id, "WAVE", 4)!=0) {fclose(in); fclose(out); printf("'WAVE' not found.\n"); return 1;}
    if (strncmp(hdr.fmt_id,  "fmt ", 4)!=0) {fclose(in); fclose(out); printf("'fmt ' not found.\n"); return 1;}
    if (strncmp(hdr.data_id, "data", 4)!=0) {fclose(in); fclose(out); printf("'data' not found.\n"); return 1;}

    if (hdr.bits!=8) {fclose(in); fclose(out); printf("8 bit wav file required.\n"); return 1;}

    num_channels = hdr.channels;
    for (channel=0; channel<num_channels; channel++)
    {
      if (channel!=0) continue; //we only need the first channel

      ConvertChannel(in, out, index, &hdr, num_channels, channel);
    }

    fclose(in);

    index++;
  }



  fprintf(out, "void PlaySound(const signed char *pData, unsigned int length, unsigned int freq);\n\n");
  fprintf(out, "void PlaySoundByNumber(int i)\n{\n  switch (i)\n  {\n");
  index = 0;
  while (Sound[index].filename)
  {
    fprintf(out, "    case %3i: PlaySound(Sound%iData, Sound%iDataLength, Sound%iDataFreq); break;\n", index, index, index, index);
    index++;
  }
  fprintf(out, "  }\n}\n");



  fclose(out);



  out = fopen("sound_def.h", "wb"); if (out==0) {printf("Failed to open output file.\n"); return 1;}

  index = 0;
  while (Sound[index].filename)
  {
    fprintf(out, "#define %s  %i\n", Sound[index].tag, index);
    index++;
  }

  fclose(out);



  return 0;
}
