#include <stdio.h>



#define COLOR16(r,g,b)  (((r)>>3)|(((g)>>3)<<5)|(((b)>>3)<<10))



unsigned short Palette[256];



//only loads 4bpp and 8bpp (with palette)
int ConvertData(char *in_filename, char *name1, char *name2, char *out_filename1, char *out_filename2, int palette_index_offset)
{
  unsigned short bfType;          // 0 Specifies the type of file. This member must be BM.
  unsigned long  bfSize;          // 2 Specifies the size of the file, in bytes.
  unsigned short bfReserved1;     // 6 Reserved; must be set to zero.
  unsigned short bfReserved2;     // 8 Reserved; must be set to zero.
  unsigned long  bfOffBits;       //10 Specifies the byte offset from the BITMAPFILEHEADER structure to the actual bitmap data in the file.

  unsigned long  biSize;          //14 Specifies the number of bytes required by the BITMAPINFOHEADER structure.
  long           biWidth;         //18 Specifies the width of the bitmap, in pixels.
  long           biHeight;        //22 Specifies the height of the bitmap, in pixels.
  unsigned short biPlanes;        //26 Specifies the number of planes for the target device. This member must be set to 1.
  unsigned short biBitCount;      //28 Specifies the number of bits per pixel. This value must be 1, 4, 8, or 24.
  unsigned long  biCompression;   //30 Specifies the type of compression for a compressed bitmap.
  unsigned long  biSizeImage;     //34 Specifies the size, in bytes, of the image.
  long           biXPelsPerMeter; //38 Specifies the horizontal resolution, in pixels per meter, of the target device for the bitmap.
  long           biYPelsPerMeter; //42 Specifies the vertical resolution, in pixels per meter, of the target device for the bitmap.
  unsigned long  biClrUsed;       //46 Specifies the number of color indexes in the color table actually used by the bitmap.
  unsigned long  biClrImportant;  //50 Specifies the number of color indexes that are considered important for displaying the bitmap.

  FILE *in, *out;
  int palette_size, r, g, b, x, y, i = 0, j = 0;



  in = fopen(in_filename, "rb"); if (in==0) return 1;

  fseek(in,  0, SEEK_SET); fread(&bfType         , 2, 1, in);
  fseek(in,  2, SEEK_SET); fread(&bfSize         , 4, 1, in);
  fseek(in,  6, SEEK_SET); fread(&bfReserved1    , 2, 1, in);
  fseek(in,  8, SEEK_SET); fread(&bfReserved2    , 2, 1, in);
  fseek(in, 10, SEEK_SET); fread(&bfOffBits      , 4, 1, in);

  fseek(in, 14, SEEK_SET); fread(&biSize         , 4, 1, in);
  fseek(in, 18, SEEK_SET); fread(&biWidth        , 4, 1, in);
  fseek(in, 22, SEEK_SET); fread(&biHeight       , 4, 1, in);
  fseek(in, 26, SEEK_SET); fread(&biPlanes       , 2, 1, in);
  fseek(in, 28, SEEK_SET); fread(&biBitCount     , 2, 1, in);
  fseek(in, 30, SEEK_SET); fread(&biCompression  , 4, 1, in);
  fseek(in, 34, SEEK_SET); fread(&biSizeImage    , 4, 1, in);
  fseek(in, 38, SEEK_SET); fread(&biXPelsPerMeter, 4, 1, in);
  fseek(in, 42, SEEK_SET); fread(&biYPelsPerMeter, 4, 1, in);
  fseek(in, 46, SEEK_SET); fread(&biClrUsed      , 4, 1, in);
  fseek(in, 50, SEEK_SET); fread(&biClrImportant , 4, 1, in);

       if (biBitCount==4) palette_size = 16;
  else if (biBitCount==8) palette_size = 256;
  else {fclose(in); return 1;}



  out = fopen(out_filename1, "wb"); if (out==0) {fclose(in); return 1;}

  fprintf(out, "#define %s_W  %i\n", name1, (int)biWidth);
  fprintf(out, "#define %s_H  %i\n\n", name1, (int)biHeight);

  fclose(out);



  out = fopen(out_filename2, "wb"); if (out==0) {fclose(in); return 1;}

  fprintf(out, "const unsigned long %sPalette[256] =\n{\n", name2);

  fseek(in, 14+biSize, SEEK_SET);
  for (i=0; i<256; i++)
  {
    if (i<palette_size)
    {
      b = fgetc(in); g = fgetc(in); r = fgetc(in); fgetc(in);
      Palette[i] = COLOR16(r,g,b);
    }
    else Palette[i] = 0;

    fprintf(out, "%i,", Palette[i]);
  }

  fprintf(out, "\n};\n\n");



  fprintf(out, "const unsigned char %sData[%i] =\n{\n", name2, (int)(biWidth*biHeight));

  fseek(in, bfOffBits, SEEK_SET);
  for (y=0; y<biHeight; y++)
  {
    for (x=0; x<biWidth; x++)
    {
      if (biBitCount==4) {if ((x&1)==0) {j = fgetc(in); i = j>>4;} else i = j&15;}
      else if (biBitCount==8) i = fgetc(in);

      fprintf(out, "%i,", palette_index_offset+i);
    }
    while (x&3) {fgetc(in); x++;}
    fprintf(out, "\n");
  }

  fprintf(out, "};\n\n");

  fclose(out);



  fclose(in);

  return 0;
}



int main(void)
{
  ConvertData("../data/title.bmp", "TITLE_DATA", "Title", "title_def.h", "title_data.c", 16);
  ConvertData("../data/tiles.bmp",  "TILE_DATA", "Tile" ,  "tile_def.h",  "tile_data.c", 32);
  ConvertData("../data/cave.bmp" ,  "CAVE_DATA", "Cave" ,  "cave_def.h",  "cave_data.c", 0 );

  return 0;
}
