--------------------------------------------
--                                        --
-- @name:		File manager              --
-- @version:	0.3 Beta                  --
-- @author: 	SWAT                      --
-- @url:		http://www.dc-swat.ru     --
--                                        --
--------------------------------------------


if not FileManager then


FileManager = {

	app = nil,
    font = nil,
	title = nil,

    params = {

		item = {

    		w = 275,
    		h = 20,

			normal = nil,
			focus = nil,
			selected = nil
    	}
    },
    
    res = {
    
    	modules = {}
    
    },


	toolbar = {

        left = nil,
        right = nil 
        
	},


	win = {

		left = {

			path = {},
			widget = nil,
			scroll = mil,
			list = {},
			focus = true,
			selected = -1,
			name = "left"

		},

	    right = {

			path = {},
			widget = nil,
			scroll = nil,
			list = {},
			focus = false,
			selected = -1,
			name = "right"

		},
		
		
		bg = {
		 	normal = nil,
		 	focus = nil
		}

	},
	
	
	modal = {
	
		widget = nil,
		label = nil,
		input = nil,
		ok = nil,
		cancel = nil,
		visible = true,
		func = nil,
		mode = "prompt"
	}
}






function FileManager:ShowModal(mode, label, func, input)

	
	if self.modal.visible then 
		self:HideModal(); 
	end
	
	if mode == "alert" then
	
		DS.GUI_LabelSetText(self.modal.label, label);
		DS.GUI_WidgetUpdate(self.modal.label, 1);
		
		if self.modal.mode ~= "alert" then
			DS.GUI_WidgetSetEnabled(self.modal.cancel, 0);
			DS.GUI_WidgetSetPosition(self.modal.ok, 145, 116);
		end
		
		if self.modal.mode == "prompt" then
			DS.GUI_ContainerRemove(self.modal.widget, self.modal.input);
		end	
	
	elseif mode == "confirm" then
	
		if self.modal.mode == "prompt" then
			DS.GUI_ContainerRemove(self.modal.widget, self.modal.input);
		end
		
		DS.GUI_LabelSetText(self.modal.label, label);
		DS.GUI_WidgetUpdate(self.modal.label, 1);

		DS.GUI_WidgetSetPosition(self.modal.ok, 110, 116);
		DS.GUI_WidgetSetEnabled(self.modal.cancel, 1);
		
	
	elseif mode == "prompt" then
	
		if self.modal.mode ~= "prompt" then
			DS.GUI_ContainerAdd(self.modal.widget, self.modal.input);
		end
		
		DS.GUI_LabelSetText(self.modal.label, label);
		DS.GUI_TextEntrySetText(self.modal.input, input);
		
		if self.modal.mode == "alert" then
			DS.GUI_WidgetSetPosition(self.modal.ok, 110, 116);
			DS.GUI_WidgetSetEnabled(self.modal.cancel, 1);
		end
	
	else
		return false;
	end
	
	DS.GUI_WidgetSetEnabled(self.win.left.widget, 0);
	DS.GUI_WidgetSetEnabled(self.win.right.widget, 0);

	DS.GUI_ContainerAdd(self.app.body, self.modal.widget);
	DS.GUI_WidgetUpdate(self.modal.widget, 1);
	
	self.modal.func = func;
	self.modal.visible = true;
	self.modal.mode = mode;
	
	return true;
end


function FileManager:HideModal()

	if self.modal.visible then
	
		DS.GUI_ContainerRemove(self.app.body, self.modal.widget);
		DS.GUI_WidgetErase(self.app.body, DS.GUI_WidgetGetArea(self.modal.widget));
		DS.GUI_WidgetUpdate(self.win.right.widget, 1);
		DS.GUI_WidgetUpdate(self.win.left.widget, 1);
		DS.GUI_WidgetUpdate(self.win.right.scroll, 1);
		DS.GUI_WidgetUpdate(self.win.left.scroll, 1);
	
		self.modal.visible = false;
		self.modal.func = nil;
		
	end
end


function FileManager:ModalClick(s)

	
	if s and self.modal.visible and self.modal.func then 
		
		
		if self.modal.func == "delete" then
		
			self:toolbarDelete();
			
		elseif self.modal.func == "rip" then
		
			self:toolbarGDRIP();
			
		elseif self.modal.func == "copy" then
		    
			self:toolbarCopy();
			
		elseif self.modal.func == "rename" then

			self:toolbarRename();
			
		elseif self.modal.func == "exec" then
		    
			self:openFile();
			
		elseif self.modal.func == "archive" then
		    
			self:toolbarArchive();
		else
		
			return self:ShowModal("alert", "Uknown command", nil);
		
		end 

	end
	
	self:HideModal();
end






function FileManager:toolbarCopy()

	local wf = self:getFocusedWin();
	local wt = nil;
	
	if wf and wf.name == "right" then
	     wt = self:getWin("left");
	else
		 wt = self:getWin("right");
	end
	
	if not self.modal.visible then 
		return self:ShowModal("confirm", "Copy '" .. wf.list[wf.selected].name .. "' to '" .. self:parsePath(wt.path) .. "'?", "copy");
	else
		self:HideModal();
	end
	
	local from = self:parsePath(wf.path) .. "/" .. wf.list[wf.selected].name;
	local to = self:parsePath(wt.path) .. "/" .. wf.list[wf.selected].name;
	
	
	if DS.dsystem("cp " .. from .. " " .. to) ~= DS.CMD_OK then
		return DS.ToggleConsole();
	end
	
 	return self:buildFileList(self:parsePath(wt.path), wt.name);
end



function FileManager:toolbarRename()

	local win = self:getFocusedWin();
	local src = self:parsePath(win.path) .. "/" .. win.list[win.selected].name;

	if not self.modal.visible then 
		return self:ShowModal("prompt", "Enter new name:", "rename", win.list[win.selected].name);
	else
		self:HideModal();
	end
	
	local dst = self:parsePath(win.path) .. "/" .. DS.GUI_TextEntryGetText(self.modal.input);
	
	if DS.dsystem("rename " .. src .. " " .. dst) ~= DS.CMD_OK then
		return DS.ToggleConsole();
	end
	
	return self:buildFileList(self:parsePath(win.path), win.name);
end




function FileManager:toolbarDelete()

	local win = self:getFocusedWin();
	local file = self:parsePath(win.path) .. "/" .. win.list[win.selected].name;
	
	if not self.modal.visible then 
		return self:ShowModal("confirm", 'Delete "' .. win.list[win.selected].name .. '"?', "delete");
	else
		self:HideModal();
	end
	
	if DS.dsystem("rm " .. file) ~= DS.CMD_OK then
		DS.ToggleConsole();
		return false;
	end
	
	return self:buildFileList(self:parsePath(win.path), win.name);
end



function FileManager:toolbarArchive()

	local win = self:getFocusedWin();
	local wt = nil;
	local file = self:parsePath(win.path) .. "/" .. win.list[win.selected].name;
	local ext = string.lower(string.sub(win.list[win.selected].name, -3));
	
	if win.name == "right" then
	     wt = self:getWin("left");
	else
		 wt = self:getWin("right");
	end
	
	
	local dst = self:parsePath(wt.path) .. "/";
	local msg = "Uknown";
	local cmd = "";
	
	if ext == ".gz" then
	
	    msg = "Extract ";
	    cmd = "gzip -d " .. file .. " " .. dst .. string.sub(win.list[win.selected].name, 1, -4);
	    
	elseif ext == "bz2" then
	
	    msg = "Extract ";
	    cmd = "bzip2 -d " .. file .. " " .. dst .. string.sub(win.list[win.selected].name, 1, -5);
	
	elseif ext == "zip" then
	
	    msg = "Extract ";
	    cmd = "unzip -e -o " .. file .. " -d " .. dst;

	else

		msg = "Compress ";
		cmd = "gzip -9 " .. file .. " " .. dst .. win.list[win.selected].name .. ".gz";

	end

	if not self.modal.visible then 
		return self:ShowModal("confirm", msg .. '"' .. win.list[win.selected].name .. '"?', "archive");
	else
		self:HideModal();
	end
	
	DS.ShowConsole();
	if DS.dsystem(cmd) ~= DS.CMD_OK then
		--return DS.ToggleConsole();
	end
	DS.ds_sleep(1000);
	DS.HideConsole();
	
	return self:buildFileList(self:parsePath(wt.path), wt.name);
end



function FileManager:toolbarGDRIP()

	local win = self:getFocusedWin();
	local path = self:parsePath(win.path);
	
	if not self.modal.visible then 
		return self:ShowModal("confirm", 'Start ripping GD-ROM to "' .. path .. '"?', "rip");
	else
		self:HideModal();
	end
	
	DS.ShowConsole();
	if DS.dsystem("gdrip " .. path) ~= DS.CMD_OK then
		return false;
	end
	DS.HideConsole();
	
	return self:buildFileList(path, win.name);
end





function FileManager:loadModule(type, name)

	
	local file = "";
	
	if type then
		file = DS.GetWorkPath() .. "/modules/".. type .. "/" .. name .. ".klf";
	else
	    file = DS.GetWorkPath() .. "/modules/" .. name .. ".klf";
	end
	
	local m = DS.OpenModule(file);
	
	if m ~= nil then
		table.insert(self.res.modules, m);
		return true;
	end
	
	return false;	
end


function FileManager:unloadModules()

    if table.getn(self.res.modules) > 0 then
    
		for i = 1, table.getn(self.res.modules) do
		
			if self.res.modules[i] ~= nil then
				DS.CloseModule(self.res.modules[i]);
			end
			
			table.remove(self.res.modules, i);
			
		end
	end
end



function FileManager:getWin(name)

	if name == "right" then
		return self.win.right;
	end

	return self.win.left;
end



function FileManager:focusWin(name)


     local w = self:getWin(name);
     local o = nil;

     w.focus = true;
     
	 if self.win.bg.focus then
		 DS.GUI_PanelSetBackground(w.widget, self.win.bg.focus);
		 DS.GUI_WidgetUpdate(w.widget, 1);
		 DS.GUI_WidgetUpdate(w.scroll, 1);
	 end


     if name == "right" then
        o = self:getWin("left");
     else
        o = self:getWin("right");
	 end

	 o.focus = false;
	 
	 if self.win.bg.normal then
		 DS.GUI_PanelSetBackground(o.widget, self.win.bg.normal);
		 DS.GUI_WidgetUpdate(o.widget, 1);
		 DS.GUI_WidgetUpdate(o.scroll, 1);
	 end
	 
end


function FileManager:getFocusedWin()

	if self.win.right.focus then
	
	   return self.win.right;
	   
	elseif self.win.left.focus then
	   
	   return self.win.left;
	
	else
	   return self.win.left;
    end
end


function FileManager:focusItem(wname, index)

	 local win = self:getWin(wname);
	 local fw = self:getFocusedWin();

     win.selected = index;
     
	 if not fw or fw.name ~= wname then 
	 	self:focusWin(wname);
	 end
     
     DS.GUI_ButtonSetNormalImage(win.list[index].button, self.params.item.selected);

     for i = 1, table.getn(win.list) do

        if i ~= index then
			DS.GUI_ButtonSetNormalImage(win.list[i].button, self.params.item.normal);
		end

     end
end


function FileManager:unfocusItem(wname, index)

	local win = self:getWin(wname);

	return DS.GUI_ButtonSetNormalImage(win.list[index].button, self.params.item.normal);
end



function FileManager:parsePath(path)

     if table.getn(path) > 1 then
	 	return string.sub(table.concat(path, '/'), 2);
	 else
	    return path[1];
	 end
end



function FileManager:changeDir(dir, wname)

   	local win = self:getWin(wname);


	if dir == ".." then

		table.remove(win.path);

	elseif dir == "/" or string.sub(dir, 1, 1) == "/" then
	
        if table.getn(win.path) > 0 then
			for i = 1, table.getn(win.path) do
				table.remove(win.path);
			end
		end
		
		table.insert(win.path, dir);
	
	else

        table.insert(win.path, dir);
	end

	return self:parsePath(win.path);
end



function FileManager:openFile()

	
	local win = self:getFocusedWin();
	local file = self:parsePath(win.path) .. "/" .. win.list[win.selected].name;
	
	local ext = string.lower(string.sub(win.list[win.selected].name, -4));

	
--	print("Open file " ..file);

	if ext == ".bin" or ext == ".elf" then

		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Execute "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		local flag = "-b";
		
  		if ext == ".elf" then
  		   flag = "-e";
  		end

		DS.ShowConsole();
		if DS.dsystem("exec "..flag.." -f " .. file) ~= DS.CMD_OK then
			--DS.ToggleConsole();
		end
		DS.ds_sleep(1000);
		DS.HideConsole();
	
	elseif ext == ".txt" then
	
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Cat file "' .. win.list[win.selected].name .. '" to console?', "exec");
		else
			self:HideModal();
		end
		
		DS.ShowConsole();
		DS.dsystem("cat " .. file);
	
	elseif ext == ".klf" then
	
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Load module "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		if DS.GetModuleByFileName(file) then return file end
		
		DS.ShowConsole();
		if DS.dsystem("module -o -f " .. file) ~= DS.CMD_OK then
			--DS.ToggleConsole();
		end
		DS.ds_sleep(1000);
		DS.HideConsole();
		
	elseif ext == ".lua" then
	
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Run lua script "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		DS.ShowConsole();
		if DS.dsystem("lua " .. file) ~= DS.CMD_OK then
			--DS.ToggleConsole();
		end
		DS.ds_sleep(1000);
		DS.HideConsole();
--		dofile(file);

	elseif ext == ".dsi" then
	
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Install pack "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		DS.ShowConsole();
		
		if DS.dsystem("install " .. file) ~= DS.CMD_OK then
			--DS.ToggleConsole();
		end
		DS.ds_sleep(1000);
		DS.HideConsole();
	
	elseif ext == ".dsc" then
	
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Run cmd script "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		DS.ShowConsole();
		if DS.dsystem("dsc " .. file) ~= DS.CMD_OK then
			--DS.ToggleConsole();
		end
		DS.ds_sleep(1000);
		DS.HideConsole();
		
	elseif ext == ".xml" then
	
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Add application "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		DS.ShowConsole();
		if DS.dsystem("app -a -f " .. file) ~= DS.CMD_OK then
			--DS.ToggleConsole();
		end
		DS.ds_sleep(1000);
		DS.HideConsole();
		
	elseif ext == ".dsr" or ext == ".img" then
	
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Mount romdisk image "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		DS.ShowConsole();
		if DS.dsystem("romdisk -m " .. file) ~= DS.CMD_OK then
			DS.ToggleConsole();
		end
		DS.ds_sleep(1000);
		DS.HideConsole();
		
	  elseif ext == ".mp3" or ext == ".ogg" then
	--elseif ext == ".ogg" then
		
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Play file "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		if not DS.GetCmdByName(ext) then
		
			 if not self:loadModule("audio", ext) then
			 
			 	DS.ToggleConsole();
			 	return file; 
			 	
			 end
		end
		
		if DS.dsystem(ext .. " -p -f " .. file) ~= DS.CMD_OK then
			DS.ToggleConsole();
		end
		
	elseif ext == ".mpg" or ext == ".mp1" or ext == ".mp2" or ext == "_mp3" or ext == ".m1v" or ext == ".m2v" or ext == ".sfd" or ext == ".pss" or ext == "mpeg" then
		
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Play file "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		if not DS.GetCmdByName("vcdc") then
		
			 if not self:loadModule("video", "vcdc") then
			 
			 	DS.ToggleConsole();
			 	return file; 
			 	
			 end
		end
		
		if DS.dsystem("vcdc " .. file) ~= DS.CMD_OK then
			DS.ToggleConsole();
		end
		
	elseif ext == ".iso" then
		
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Run ISO "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		if DS.dsystem("sdiso " .. file) ~= DS.CMD_OK then
			DS.ToggleConsole();
		end
			
	elseif ext == "bios" then
		
		if not self.modal.visible then 
			return self:ShowModal("confirm", 'Flashing to alternate bios "' .. win.list[win.selected].name .. '" ?', "exec");
		else
			self:HideModal();
		end
		
		DS.ShowConsole();
		if DS.dsystem("bios -w -f " .. file) ~= DS.CMD_OK then
			--DS.ToggleConsole();
		end
		DS.ds_sleep(1000);
		DS.HideConsole();
	end
	
       
	return file;
end




function FileManager:openDir(dir, wname)

    local d = self:changeDir(dir, wname);
	if d ~= "/" then
		self:tooltip(d);
	else 
		self:tooltip(false);
	end
--  print("Opening directory - " .. d);
	return self:buildFileList(d, wname);
end




function FileManager:itemAction(wname, index)


    local win = self:getWin(wname);
    

	if win.selected ~= index then

  		self:focusItem(wname, index);
		return win.list[index].name;
	end

    local fw = self:getFocusedWin();
	
	if fw and fw.name == wname then
		self:unfocusItem(wname, index);
	end

	if win.list[index].size < 0 then
	    return self:openDir(win.list[index].name, wname);
	end

	return self:openFile();
end






function FileManager:buildFileList(dir, wname)

	local i = nil;
	local win = self:getWin(wname);

	local x = 0;
	local y = 0;

--	print("Building file list for window '"..wname.."'....");


    local hnd = KOS.fs_open(dir, DS.bit_or(KOS.O_RDONLY, KOS.O_DIR));


	if hnd < 0 then
		self:showError("DS_ERROR_FM: Can't open directory " .. dir);
		self:openDir("/", wname);
		return false;
	end


	local ent = true;
	local index = 1;


	if dir ~= "/" and dir ~= "" then


		if index > table.getn(win.list) then
			
			i = self:CreateItem("..", -1, 1, wname, x, y);
			DS.GUI_ContainerAdd(win.widget, i.button);
			table.insert(win.list, i);
		else

			self:UpdateItem("..", -1, index, win, true);
		end
		
		index = index + 1;
		y = self.params.item.h;

	end


	while (ent) do

		ent = KOS.fs_readdir(hnd)

		if ent ~= nil and ent.name ~= "." and ent.name ~= ".." then

--   		print(string.format("item %s %d", ent.name, ent.size));

			if index > table.getn(win.list) then
				
				i = self:CreateItem(ent.name, ent.size, index, wname, x, y);
				DS.GUI_ContainerAdd(win.widget, i.button);
				table.insert(win.list, i);
			else

				self:UpdateItem(ent.name, ent.size, index, win, true);
			end

			y = y + self.params.item.h;
			index = index + 1;

		end
	end

	KOS.fs_close(hnd);
	
	
	
	if index <= table.getn(win.list) then
		 
		 for idx = index, table.getn(win.list) do
            self:UpdateItem(" ", 0, idx, win, false);
	     end
	end
	
	
--	DS.GUI_WidgetUpdate(win.widget, 1);
	return true;
end






function FileManager:CreateItem(name, size, index, wname, x, y)


	local w = self.params.item.w;
	local h = self.params.item.h;
	local i = {};
	
	i.name = name;
	i.size = size;

--	print(string.format("Creating button %s %s %d (%d %d %d %d)", wname, name, size, x, y, w, h));

	i.button = DS.GUI_ButtonCreate(string.format("button %s %s", wname, name), x, y, w, h);

	DS.GUI_ButtonSetNormalImage(i.button, self.params.item.normal);
	DS.GUI_ButtonSetHighlightImage(i.button, self.params.item.focus);
	DS.GUI_ButtonSetPressedImage(i.button, self.params.item.normal);
	DS.GUI_ButtonSetDisabledImage(i.button, NULL);


	i.callback = DS.GUI_LuaCallbackCreate(self.app.id, string.format("FileManager:itemAction(\"%s\", %d)", wname, index));
	DS.GUI_ButtonSetClick(i.button, i.callback);

	i.label = DS.GUI_LabelCreate(string.format("label %s %s", wname, name), 10, 0, w-10, h, self.font, name);
	DS.GUI_LabelSetTextColor(i.label, 0, 0, 0);
	DS.GUI_WidgetSetAlign(i.label, DS.WIDGET_HORIZ_LEFT);
	DS.GUI_WidgetSetAlign(i.label, DS.WIDGET_VERT_CENTER);
	DS.GUI_ButtonSetCaption(i.button, i.label);
	
--	DS.listAddItem(self.app.elements, DS.LIST_ITEM_GUI_WIDGET, string.format("button %s %s", wname, name), i.button);
--	DS.listAddItem(self.app.elements, DS.LIST_ITEM_GUI_WIDGET, string.format("callback %s %s", wname, name), i.callback);
--	DS.listAddItem(self.app.elements, DS.LIST_ITEM_GUI_WIDGET, string.format("label %s %s", wname, name), i.label);

	return i;
end



function FileManager:UpdateItem(name, size, index, win, enabled)

    if enabled then
    
		local state = DS.GUI_WidgetGetState(win.list[index].button);
		
		if DS.bit_and(state, DS.WIDGET_DISABLED) then
			
			DS.GUI_WidgetClearFlags(win.list[index].button, DS.bit_or(DS.WIDGET_HIDDEN, DS.WIDGET_DISABLED));
		end
		
	else
	
		DS.GUI_WidgetSetFlags(win.list[index].button, DS.bit_or(DS.WIDGET_HIDDEN, DS.WIDGET_DISABLED));
	end
	
	DS.GUI_LabelSetText(win.list[index].label, name);
	win.list[index].name = name;
	win.list[index].size = size;
	DS.GUI_WidgetUpdate(win.list[index].button, 1);
	DS.GUI_WidgetUpdate(win.list[index].label, 1);

end




function FileManager:RemoveItem(win, index)

--	print("Removing item: " ..win.list[index].name);
	DS.GUI_ObjectDecRef(DS.GUI_AnyToObject(win.list[index].button));
	DS.GUI_ObjectDecRef(DS.GUI_AnyToObject(win.list[index].label));
	DS.GUI_ObjectDecRef(DS.GUI_AnyToObject(win.list[index].callback));
    table.remove(win.list, index);
end




function FileManager:scrollWin(wname)

   local win = self:getWin(wname);
   local p = DS.GUI_ScrollBarGetPosition(win.scroll);
   
   DS.GUI_PanelSetYOffset(win.widget, p);
end




function FileManager:showError(str)
	
	print(str);
	self:ShowModal("alert", str, nil);
	return false;
end


function FileManager:tooltip(msg)
	
	DS.GUI_WidgetErase(self.app.body, DS.GUI_WidgetGetArea(self.title));
	
	if msg then
		DS.GUI_LabelSetText(self.title, msg);
	else
		
		local win = self:getFocusedWin();
		local path = self:parsePath(win.path);
		
		if path == "/" then
			DS.GUI_LabelSetText(self.title, "File Manager v0.3 Beta");
		else
			DS.GUI_LabelSetText(self.title, path);
		end
	end
	
	DS.GUI_WidgetUpdate(self.title, 1);
end




function FileManager:getResource(name, type)

	local r = DS.listGetItemByName(self.app.resources, name);

	if r ~= nil then

	    if type == DS.LIST_ITEM_GUI_FONT then

	    	return DS.GUI_AnyToFont(r.data);

		elseif type == DS.LIST_ITEM_GUI_SURFACE then

		    return DS.GUI_AnyToSurface(r.data);

		else

            self:showError("DS_ERROR_FM: Uknown resource type - " .. type);
			return nil;

		end
	end

	self:showError("DS_ERROR_FM: Can't find resource - " .. name);
	return nil;
end



function FileManager:getElement(name)

	local r = DS.listGetItemByName(self.app.elements, name);

	if r ~= nil then
		return DS.GUI_AnyToWidget(r.data);
	end

	self:showError("DS_ERROR_FM: Can't find element - " .. name);
	return nil;
end




function FileManager:Initialize()

	if self.app == nil then
	
		self.app = DS.GetAppById(THIS_APP_ID);
	
		if self.app ~= nil then
	
	
	        self.font = self:getResource("arial", DS.LIST_ITEM_GUI_FONT);
	
			if not self.font then
				return false;
			end
	
	
			self.params.item.normal = self:getResource("item-normal", DS.LIST_ITEM_GUI_SURFACE);
	
			if not self.params.item.normal then
				return false;
			end
	
	
			self.params.item.focus = self:getResource("item-focus", DS.LIST_ITEM_GUI_SURFACE);
	
			if not self.params.item.focus then
				return false;
			end
	
	
			self.params.item.selected = self:getResource("item-selected", DS.LIST_ITEM_GUI_SURFACE);
	
			if not self.params.item.selected then
				return false;
			end
			
			self.win.bg.normal = self:getResource("white-bg", DS.LIST_ITEM_GUI_SURFACE);
	
			if not self.win.bg.normal then
				return false;
			end
			
			self.win.bg.focus = self:getResource("blue-bg", DS.LIST_ITEM_GUI_SURFACE);
	
			if not self.win.bg.focus then
				return false;
			end
	
	
			self.title = self:getElement("title");
	
			if not self.title then
				return false;
			end
	
			self.win.left.widget = self:getElement("left-win");
	
			if not self.win.left.widget then
				return false;
			end
	
	
			self.win.right.widget = self:getElement("right-win");
	
			if not self.win.right.widget then
				return false;
			end
			
			
			self.win.left.scroll = self:getElement("scroll-left-win");
	
			if not self.win.left.scroll then
				return false;
			end
			
			
			self.win.right.scroll = self:getElement("scroll-right-win");
	
			if not self.win.right.scroll then
				return false;
			end
			
	
			self.toolbar.left = self:getElement("left-tool");
	
			if not self.toolbar.left then
				return false;
			end
	
	
			self.toolbar.right = self:getElement("right-tool");
	
			if not self.toolbar.right then
				return false;
			end
			
			self.modal.widget = self:getElement("modal-win");
	
			if not self.modal.widget then
				return false;
			end

			
			self.modal.label = self:getElement("modal-label");
	
			if not self.modal.label then
				return false;
			end
			
			self.modal.input = self:getElement("modal-input");
	
			if not self.modal.input then
				return false;
			end
			
			self.modal.ok = self:getElement("modal-ok");
	
			if not self.modal.ok then
				return false;
			end
			
			self.modal.cancel = self:getElement("modal-cancel");
	
			if not self.modal.cancel then
				return false;
			end
			
			self:HideModal();

	--		print("File Manager initialized.");
	
			self:openDir("/", "left");
			self:openDir("/", "right");
	
		end
	end
end



function FileManager:Shutdown()

		
	for idx = 1, table.getn(self.win.left.list) do

        self:RemoveItem(self.win.left, idx);
    end	
    
    for idx = 1, table.getn(self.win.right.list) do
        
        self:RemoveItem(self.win.right, idx);
    end

	self:unloadModules();
end


function FileManager:Close(unload)


	local app = DS.GetAppByName("Main");

	if app ~= nil then
        
		if unload == 0 then 
			DS.CloseApp(self.app, unload); 
		end
		DS.OpenApp(app);
	end
end


end

