#if !defined(COMMON_H)
#define COMMON_H

using namespace std;

#include "osdepend.h"
#include "helper.h"
#include "types.h"

#define KILOBYTE 1024
#define MEGABYTE (KILOBYTE*1024)
#define GIGABYTE (MEGABYTE*1024)

#define F_EPSILON 0.00001

#define FORWARD_DECLARE_TYPEDEF_STRUCT(type) \
	struct _##type;	\
	typedef _##type type

std::wstring StringToUpper(std::wstring myString);
std::wstring StringToLower(std::wstring myString);

/**
Converts a std::string to any class with a proper overload of the >> opertor
@param temp			The string to be converted
@param out	[OUT]	The container for the returned value
*/
template < class T >
	void FromString( const std::string& temp, T* out )
{
	std::istringstream val( temp );
	val >> *out;

	assert(! val.fail() );
}

U32 StringToHex( const std::string& str );

inline string wstring2string(wstring wstr)
{
	string str(wstr.length(),' ');
	copy(wstr.begin(),wstr.end(),str.begin());
	return str;
}

inline wstring string2wstring(string str)
{
	wstring wstr(str.length(),L' ');
	copy(str.begin(),str.end(),wstr.begin());
	return wstr;
}

inline int CountBytesOfVal(BYTE* buf, UINT numBytes, BYTE val)
{
	int count = 0;
	for (UINT i=0; i<numBytes; i++)
		if (buf[i] == val)
			count++;
	return count;
}

 inline bool isEqual(float x, float y)
 {
   //const double epsilon = 0.00001/* some small number such as 1e-5 */;
   return std::abs(x - y) <= F_EPSILON * std::abs(x);
   // see Knuth section 4.2.2 pages 217-218
 } 

#endif // !defined(COMMON_H)
