#include "stdafx.h"
#include "VGMSeqNoTrks.h"
#include "SeqEvent.h"
#include "Root.h"

VGMSeqNoTrks::VGMSeqNoTrks(const string& format, RawFile* file, ULONG offset)
: VGMSeq(format, file, offset),
  SeqTrack(this)
{
	AddContainer<SeqEvent>(aEvents);
}

VGMSeqNoTrks::~VGMSeqNoTrks(void)
{
}

//LoadMain() - loads all sequence data into the class
int VGMSeqNoTrks::LoadMain()
{
	if (!GetHeaderInfo())
		return false;

	//if (name == "")
	//	name.Format(_T("Sequence %d"), GetCount());

	if (!LoadEvents())
		return false;
	if (length() == 0)
		length() = (aEvents.back()->dwOffset+aEvents.back()->unLength) - offset();			//length == to the end of the last event
	
	return true;
}

bool VGMSeqNoTrks::LoadEvents(void)
{
	if (bAlwaysWriteInitialVol)
		for (int i=0; i<16; i++) { channel = i; AddVolNoItem(initialVol); }
	if (bAlwaysWriteInitialExpression)
		for (int i=0; i<16; i++) { channel = i; AddExpressionNoItem(initialExpression); }
	if (bAlwaysWriteInitialPitchBendRange)
		for (int i=0; i<16; i++) 
		{
			channel = i;
			AddPitchBendRangeNoItem(initialPitchBendRangeSemiTones, initialPitchBendRangeCents);
		}
	channel = 0;


	bInLoop = false;
	curOffset = eventsOffset();	//start at beginning of track
	while (curOffset < rawfile->size() && ReadEvent())
	{
	}
	if (VGMSeq::unLength == 0)
		VGMSeq::unLength = curOffset - VGMSeq::dwOffset;
	return true;
}

bool VGMSeqNoTrks::SaveAsMidi(const wchar_t* filepath)
{
	return midi.SaveMidiFile(filepath);
}


// checks whether or not we have already created the given number of MidiTracks.  If not, it appends the extra tracks.
// doesn't ever need to be called directly by format code, since SetCurMidiTrack does so automatically.
void VGMSeqNoTrks::TryExpandMidiTracks(int numTracks)
{
	if (midiTracks.size() < numTracks)
	{
		int initialTrackSize = midiTracks.size();
		for (UINT i=0; i<numTracks-initialTrackSize; i++)
			midiTracks.push_back( midi.AddTrack());
	}
}

void VGMSeqNoTrks::SetCurTrack(int trackNum)
{
	TryExpandMidiTracks(trackNum+1);
	pMidiTrack = midiTracks[trackNum];
}


void VGMSeqNoTrks::AddDelta(ULONG delta)
{
	for (UINT i=0; i<midiTracks.size(); i++)
		midiTracks[i]->AddDelta(delta);
}


void VGMSeqNoTrks::AddEndOfTrack(unsigned long offset, unsigned long length, const wchar_t* sEventName)
{
	if (bInLoop == false)
		AddEvent(new TrackEndSeqEvent(this, offset, length, sEventName));
}