#include "stdafx.h"
#include "common.h"
#include "VGMSeq.h"
#include "SeqTrack.h"
#include "SeqEvent.h"
#include "Root.h"
#include <math.h>


DECLARE_MENU(VGMSeq)

VGMSeq::VGMSeq(const string& format, RawFile* file, ULONG offset, ULONG length, wstring name)
: VGMFile(FILETYPE_SEQ, format, file, offset, length, name),
  midi(this),
  globTranspose(0),
  bReverb(false),
  bUseLinearAmplitudeScale(false),
  bWriteInitialTempo(false),
  bAlwaysWriteInitialVol(false),
  bAlwaysWriteInitialExpression(false),
  bAlwaysWriteInitialPitchBendRange(false),
  initialVol(100),					//GM standard (dls1 spec p16)
  initialExpression(127),			//''
  initialPitchBendRangeSemiTones(2), //borg midi says this is GM standard.  Means +/- 2 semitones (4 total range)
  initialPitchBendRangeCents(0)
{
	AddContainer<SeqTrack>(aTracks);
}

VGMSeq::~VGMSeq(void)
{
	DeleteVect<SeqTrack>(aTracks);
}

/*VGMItem* VGMSeq::GetItemFromOffset(ULONG offset)
{
	if (IsItemAtOffset(offset))				//if the offset is within the seqfile
	{
		int nNumTracks = (int)aTracks.size();
		for (int i=0; i<nNumTracks; i++)
		{
			//if (offset > aTracks[i]->dwOffset+aTracks[i]->unLength)
			if (!aTracks[i]->IsItemAtOffset(offset))
				continue;
			VGMItem* foundItem = GetItemAtOffsetInItemVector<SeqEvent>(offset, aTracks[i]->aEvents);
			if (foundItem)
				return foundItem;
		}
	}
	return NULL;
}*/


int VGMSeq::Load()
{
	if (!LoadMain())
		return false;
	if (!PostLoad())
		return false;
}

//Load() - Function to load all the sequence data into the class
int VGMSeq::LoadMain()
{
	if (!GetHeaderInfo())
		return false;
	if (!GetTrackPointers())
		return false;
	nNumTracks = aTracks.size();
	if (nNumTracks == 0)
		return false;

	//if (name == "")
	//	name.Format(_T("Sequence %d"), GetCount());
	//AddToTree(name, ICON_SEQ, 0);

	sort(aTracks.begin(), aTracks.end(), ItemPtrOffsetCmp());
	if (!LoadTracks())
		return false;
	if (unLength == 0) {		//length will extend to the end of the last track (last by offset)
		SeqTrack* lastTrk = *((vector<SeqTrack*>::const_iterator)max_element(aTracks.begin(), aTracks.end()));
		unLength = lastTrk->dwOffset + lastTrk->unLength - dwOffset;
	}
		//unLength = (aTracks.back()->dwOffset+aTracks.back()->unLength) - dwOffset;			//length will extend to the end of the last track
	
	//Get CRC and check for table files
	//ccrc=crc32g(crc32g(0L, Z_NULL, 0), assocDoc->m_pFileData+dwOffset, unLength);
	//ApplyTable();
	return true;
}

int VGMSeq::PostLoad()
{
	for (UINT i=0; i<aTracks.size(); i++)
		sort(aTracks[i]->aEvents.begin(), aTracks[i]->aEvents.end(), ItemPtrOffsetCmp());
	midi.Sort();
	LoadLocalData();
	UseLocalData();
	pRoot->AddVGMFile(this);
	return true;
}

int VGMSeq::LoadTracks(void)
{
	for (UINT i=0; i<nNumTracks; i++)
	{
		if (!aTracks[i]->LoadTrack(i, (i != aTracks.size()-1) ? aTracks[i+1]->dwOffset :  ((unLength) ? dwOffset+unLength : 0xFFFFFFFF)))
			return false;
	}
}

int VGMSeq::GetHeaderInfo(void)
{
	return true;
}


//GetTrackPointers() should be defined to find all of the track pointers and create new SeqTracks for them
int VGMSeq::GetTrackPointers(void)
{
	return true;
}

void VGMSeq::SetPPQN(UINT ppqn)
{
	midi.SetPPQN(ppqn);
}

UINT VGMSeq::GetPPQN(void)
{
	return midi.GetPPQN();
}

//void VGMSeq::AddTrack(SeqTrack* track)
//{
//	aTracks.push_back(track);
//	AddItem(track, NULL, "Track");
//}

bool VGMSeq::OnSaveAsMidi(void)
{
	wstring filepath = pRoot->UI_GetSaveFilePath(name.c_str(), L"mid");
	if (filepath.length() != 0)
		return SaveAsMidi(filepath.c_str());
	return false;
}


bool VGMSeq::SaveAsMidi(const wchar_t* filepath)
{
	return midi.SaveMidiFile(filepath);
}
