#pragma once

#include "common.h"
#include "Menu.h"

class VGMSeq;
class VGMInstrSet;
class VGMSampColl;
class VGMSamp;
class DLSFile;

class VGMColl
	: public VGMItem
{
public:
	BEGIN_MENU(VGMColl)
		MENU_ITEM(VGMColl, OnSaveAll, L"Save as MIDI and DLS.")
		//MENU_ITEM(VGMFile, OnSaveAllAsRaw, L"Save all as original format")
	END_MENU()

	VGMColl(wstring name = L"Unnamed Collection");
	virtual ~VGMColl(void);
	
	void RemoveFileAssocs();
	const wstring* GetName(void) const;
	void SetName(const wstring* newName);
	VGMSeq* GetSeq();
	void UseSeq(VGMSeq* theSeq);
	void AddInstrSet(VGMInstrSet* theInstrSet);
	void AddSampColl(VGMSampColl* theSampColl);
	bool Load();
	virtual bool LoadMain() {return true;}
	virtual void CreateDLSFile(DLSFile& dls);
	virtual bool PreDLSMainCreation(DLSFile& dls) { return true; }
	virtual void MainDLSCreation(DLSFile& dls);
	virtual bool PostDLSMainCreation(DLSFile& dls) { return true; }

	bool OnSaveAll();

	VGMSeq* seq;
	vector<VGMInstrSet*> instrsets;
	vector<VGMSampColl*> sampcolls;

protected:
	void UnpackSampColl(DLSFile& dls, VGMSampColl* sampColl, vector<VGMSamp*>& finalSamps);

protected:
	wstring name;
};
