#include "stdafx.h"
#include "SeqEvent.h"
#include "SeqTrack.h"

//  ********
//  SeqEvent
//  ********

DECLARE_MENU(SeqEvent)

SeqEvent::SeqEvent(SeqTrack* pTrack, ULONG offset, ULONG length, const wchar_t* name)
: VGMItem((VGMFile*)pTrack->parentSeq, offset, length, name), parentTrack(pTrack)
{
}

// ***************
// DurNoteSeqEvent
// ***************

DurNoteSeqEvent::DurNoteSeqEvent(SeqTrack* pTrack, BYTE absoluteKey, BYTE velocity, ULONG duration, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), absKey(absoluteKey), vel(velocity), dur(duration)
{}


// ************
// NoteOnSeqEvent
// ************

NoteOnSeqEvent::NoteOnSeqEvent(SeqTrack* pTrack, BYTE absoluteKey, BYTE velocity, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), absKey(absoluteKey), vel(velocity)
{}



// ************
// NoteOffSeqEvent
// ************

NoteOffSeqEvent::NoteOffSeqEvent(SeqTrack* pTrack, BYTE absoluteKey, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), absKey(absoluteKey)
{}

// ************
// RestSeqEvent
// ************

RestSeqEvent::RestSeqEvent(SeqTrack* pTrack, ULONG duration, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), dur(duration)
{}

// *****************
// SetOctaveSeqEvent
// *****************

SetOctaveSeqEvent::SetOctaveSeqEvent(SeqTrack* pTrack, BYTE theOctave, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), octave(theOctave)
{}

// ***********
// VolSeqEvent
// ***********

VolSeqEvent::VolSeqEvent(SeqTrack* pTrack, BYTE volume, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), vol(volume)
{}

// ****************
// VolSlideSeqEvent
// ****************

VolSlideSeqEvent::VolSlideSeqEvent(SeqTrack* pTrack, BYTE targetVolume, ULONG duration, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), targVol(targetVolume), dur(duration)
{}

// ***********
// MastVolSeqEvent
// ***********

MastVolSeqEvent::MastVolSeqEvent(SeqTrack* pTrack, BYTE volume, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), vol(volume)
{}

// ****************
// MastVolSlideSeqEvent
// ****************

MastVolSlideSeqEvent::MastVolSlideSeqEvent(SeqTrack* pTrack, BYTE targetVolume, ULONG duration, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), targVol(targetVolume), dur(duration)
{}

// ******************
// ExpressionSeqEvent
// ******************

ExpressionSeqEvent::ExpressionSeqEvent(SeqTrack* pTrack, BYTE theLevel, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), level(theLevel)
{}

// ***********************
// ExpressionSlideSeqEvent
// ***********************

ExpressionSlideSeqEvent::ExpressionSlideSeqEvent(SeqTrack* pTrack, BYTE targetExpression, ULONG duration, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), targExpr(targetExpression), dur(duration)
{}



// ***********
// PanSeqEvent
// ***********

PanSeqEvent::PanSeqEvent(SeqTrack* pTrack, BYTE thePan, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), pan(thePan)
{}

// ****************
// PanSlideSeqEvent
// ****************

PanSlideSeqEvent::PanSlideSeqEvent(SeqTrack* pTrack, BYTE targetPan, ULONG duration, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), targPan(targetPan), dur(duration)
{}

// *****************
// PitchBendSeqEvent
// *****************

PitchBendSeqEvent::PitchBendSeqEvent(SeqTrack* pTrack, short thePitchBend, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), pitchbend(thePitchBend)
{}

// **********************
// PitchBendRangeSeqEvent
// **********************

PitchBendRangeSeqEvent::PitchBendRangeSeqEvent(SeqTrack* pTrack, BYTE theSemiTones, BYTE theCents,
											   ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), semitones(theSemiTones), cents(theCents)
{}

// *****************
// TransposeSeqEvent
// *****************

TransposeSeqEvent::TransposeSeqEvent(SeqTrack* pTrack, int theTranspose, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), transpose(theTranspose)
{}

// ******************
// ModulationSeqEvent
// ******************

ModulationSeqEvent::ModulationSeqEvent(SeqTrack* pTrack, BYTE theDepth, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), depth(theDepth)
{}

// **************
// BreathSeqEvent
// **************

BreathSeqEvent::BreathSeqEvent(SeqTrack* pTrack, BYTE theDepth, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), depth(theDepth)
{}

// ***************
// SustainSeqEvent
// ***************

SustainSeqEvent::SustainSeqEvent(SeqTrack* pTrack, bool bSustain, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), bOn(bSustain)
{}

// ******************
// PortamentoSeqEvent
// ******************

PortamentoSeqEvent::PortamentoSeqEvent(SeqTrack* pTrack, bool bPortamento, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), bOn(bPortamento)
{}

// **********************
// PortamentoTimeSeqEvent
// **********************

PortamentoTimeSeqEvent::PortamentoTimeSeqEvent(SeqTrack* pTrack, BYTE theTime, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), time(theTime)
{}

// ******************
// ProgChangeSeqEvent
// ******************

ProgChangeSeqEvent::ProgChangeSeqEvent(SeqTrack* pTrack, BYTE programNumber, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), progNum(programNumber)
{}

// *************
// TempoSeqEvent
// *************

TempoSeqEvent::TempoSeqEvent(SeqTrack* pTrack, double beatsperminute, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), bpm(beatsperminute)
{}

// ******************
// TempoSlideSeqEvent
// ******************

TempoSlideSeqEvent::TempoSlideSeqEvent(SeqTrack* pTrack, double targBPM, ULONG duration, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), targbpm(targBPM), dur(duration)
{}

// ***************
// TimeSigSeqEvent
// ***************

TimeSigSeqEvent::TimeSigSeqEvent(SeqTrack* pTrack, BYTE numerator, BYTE denominator, BYTE theTicksPerQuarter, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name), numer(numerator), denom(denominator), ticksPerQuarter(theTicksPerQuarter)
{}

// ****************
// TrackEndSeqEvent
// ****************

TrackEndSeqEvent::TrackEndSeqEvent(SeqTrack* pTrack, ULONG offset, ULONG length, const wchar_t* name)
: SeqEvent(pTrack, offset, length, name)
{}



