#pragma once
#include "VGMSeq.h"
#include "SeqTrack.h"
#include "QSoundFormat.h"

class QSoundSeq :
	public VGMSeq
{
public:
	QSoundSeq(RawFile* file, ULONG offset, float fmt_version);
	virtual ~QSoundSeq(void);

	virtual int GetHeaderInfo(void);
	virtual int GetTrackPointers(void);
	virtual int LoadTracks(void);

public:
	float fmt_version;
};


class QSoundTrack
	: public SeqTrack
{
public:
	QSoundTrack(QSoundSeq* parentSeq, long offset = 0, long length = 0);

	virtual int ReadEvent(void);

private:
	BYTE curDeltaTable;
	BYTE noteState;
	BYTE loop[4];
};