#include "stdafx.h"
#include "QSoundScanner.h"
#include "QSoundSeq.h"
#include "QSoundInstr.h"
#include "MAMELoader.h"
#include "common.h"

//#define PROG_INFO_TABLE_OFFSET 0x7000
//#define SAMP_INFO_TABLE_OFFSET 0x8000

void QSoundScanner::Scan(RawFile* file, void* info)
{
	MAMEGameEntry* gameentry = (MAMEGameEntry*)info;
	MAMERomGroupEntry* seqRomGroupEntry = gameentry->GetRomGroupOfType("sequence");
	MAMERomGroupEntry* sampsRomGroupEntry = gameentry->GetRomGroupOfType("sample");
	if (!seqRomGroupEntry || !sampsRomGroupEntry)
		return;
	U32 seq_table_offset;
	U32 instr_table_offset;
	U32 samp_table_offset;
	U32 samp_table_length = 0;
	U32 artic_table_offset = 0;
	U32 num_instr_banks;
	U32 instr_tables_end = 0;
	if (!seqRomGroupEntry->file || !sampsRomGroupEntry->file ||
		!seqRomGroupEntry->GetHexAttribute("seq_table", &seq_table_offset) ||
		!seqRomGroupEntry->GetHexAttribute("samp_table", &samp_table_offset) ||
		!seqRomGroupEntry->GetAttribute("num_instr_banks", &num_instr_banks))
		return;
	if (gameentry->fmt_version + F_EPSILON < 1.16)
	{
		if (!seqRomGroupEntry->GetHexAttribute("instr_table", &instr_table_offset))
			return;
	}
	else if (!seqRomGroupEntry->GetHexAttribute("instr_table_ptrs", &instr_table_offset) ||
			 !seqRomGroupEntry->GetHexAttribute("samp_table_length", &samp_table_length))// ||
			 //!seqRomGroupEntry->GetHexAttribute("instr_tables_end", &instr_tables_end))
		return;
	if (gameentry->fmt_version + F_EPSILON >= 1.30 &&
		!seqRomGroupEntry->GetHexAttribute("artic_table", &artic_table_offset))
		return;
	

	QSoundInstrSet* instrset = 0;
	QSoundSampColl* sampcoll = 0;
	LoadInstrumentsAndSamples(gameentry->fmt_version, seqRomGroupEntry->file, sampsRomGroupEntry->file,
		&instrset, &sampcoll, instr_table_offset, num_instr_banks, samp_table_offset, samp_table_length);
	LoadSeqTable(gameentry->fmt_version, seqRomGroupEntry->file, seq_table_offset, instrset, sampcoll);
	return;
}


void QSoundScanner::LoadSeqTable(float fmt_version, RawFile* file, U32 offset, QSoundInstrSet* instrset,
								 QSoundSampColl* sampcoll)
{
	UINT nFileLength;
	nFileLength = file->size();
	
	UINT seqPointer;
	for (int k=0; ; k+=4)
	{
		seqPointer = (file->GetByte(offset+k)<<16)+(file->GetByte(offset+1+k)<<8)+(file->GetByte(offset+2+k));
		if (seqPointer == 0)
			break;
		if (isEqual(fmt_version, 1.03))		
			seqPointer -= 0x100000;		//SSF2, not sure yet if this memory addressing applies to other games.
		//text.Format(_T("QSound Sequence #%d/%d"),k,seqcount);
		//pDoc->SetDLLProgText(text);

		VGMColl* coll = new VGMColl(_T("Song"));
		QSoundSeq* newSeq = new QSoundSeq(file, seqPointer, fmt_version);
		if (newSeq->LoadVGMFile())
		{
			coll->UseSeq(newSeq);
			coll->AddInstrSet(instrset);
			coll->AddSampColl(sampcoll);
			coll->Load();
		}
		else
		{
			delete newSeq;
			delete coll;
		}
	}

}


void QSoundScanner::LoadInstrumentsAndSamples(float fmt_version, RawFile* instrfile, RawFile* sampfile,
											  QSoundInstrSet** instrset, QSoundSampColl** sampcoll,
											  U32 pi_table_offset, U32 num_instr_banks, U32 si_table_offset,
											  U32 samp_table_length)
{
	UINT nFileLength = instrfile->size();
	//if (nFileLength < pi_table_offset+0x1000 || nFileLength < si_table_offset+0x1000)
	//	return;

	*instrset = new QSoundInstrSet(instrfile, fmt_version, pi_table_offset, num_instr_banks,
								   si_table_offset, samp_table_length);
	(*instrset)->LoadVGMFile();
	*sampcoll = new QSoundSampColl(sampfile, *instrset, 0);
	(*sampcoll)->LoadVGMFile();
}