#include "stdafx.h"
#include "MidiFile.h"
#include "common.h"
#include "Root.h"
#include <math.h>
#include <algorithm>

using namespace std;


MidiFile::MidiFile(VGMSeq* theAssocSeq)
: assocSeq(theAssocSeq) //: bAddedTempo(false), bAddedTimeSig(false)
{	
}

//MidiFile::MidiFile(ULONG thePpqn)
//: ppqn(thePpqn)//, bAddedTempo(false), bAddedTimeSig(false)
//{
//}

MidiFile::~MidiFile(void)
{
	DeleteVect<MidiTrack>(aTracks);
}

MidiTrack* MidiFile::AddTrack(void)
{
	aTracks.push_back(new MidiTrack());
		return aTracks.back();
}

MidiTrack* MidiFile::InsertTrack(int trackNum)
{
	if (trackNum+1 > aTracks.size())
		aTracks.resize(trackNum+1, NULL);
	//else
	//	AfxMessageBox("Inserting New Track into occupied track!", MB_OK, NULL);
	aTracks[trackNum] = new MidiTrack();
		return aTracks[trackNum];
}

void MidiFile::SetPPQN(UINT thePpqn)
{
	ppqn = thePpqn;
}

UINT MidiFile::GetPPQN()
{
	return ppqn;
}

void MidiFile::Sort(void)
{
	for (UINT i=0; i < aTracks.size(); i++)
	{
		if (aTracks[i])
		{
			if (aTracks[i]->aEvents.size() == 0)
			{
				delete aTracks[i];
				aTracks.erase(aTracks.begin() + i--);
			}
			else
				aTracks[i]->Sort();
		}
	}
}


bool MidiFile::SaveMidiFile(const wchar_t* filepath)
{
	vector<BYTE> midiBuf;
	WriteMidiToBuffer(midiBuf);
	return pRoot->UI_WriteBufferToFile(filepath, &midiBuf[0], midiBuf.size());
	//try { theFile.Write(&midiBuf[0], midiBuf.size()); }
	//catch(...) {
	//	AfxMessageBox("Error during write to midi file", MB_OK, NULL);
	//}
}

void MidiFile::WriteMidiToBuffer(vector<BYTE> & buf)
{
	int nNumTracks = 0;
	for (UINT i=0; i < aTracks.size(); i++)
	{
	//	if (aTracks[i])
			nNumTracks++;
	}
	buf.push_back('M');
	buf.push_back('T');
	buf.push_back('h');
	buf.push_back('d');
	buf.push_back(0);
	buf.push_back(0);
	buf.push_back(0);
	buf.push_back(6);				//MThd length - always 6
	buf.push_back(0);
	buf.push_back(1);				//Midi format - type 1
	buf.push_back((nNumTracks & 0xFF00) >> 8);		//num tracks hi
	buf.push_back(nNumTracks & 0x00FF);				//num tracks lo
	buf.push_back((ppqn & 0xFF00) >> 8);
	buf.push_back(ppqn & 0xFF);

	//if (!bAddedTimeSig)
	//	aTracks[0]->InsertTimeSig(4, 4, 16, 0);
	//if (!bAddedTempo)
	//	aTracks[0]->InsertTempoBPM(148, 0);

	Sort();

	for (UINT i=0; i < aTracks.size(); i++)
	{
		if (aTracks[i])
		{
			vector<BYTE> trackBuf;
			aTracks[i]->WriteTrack(trackBuf);
			buf.insert(buf.end(), trackBuf.begin(), trackBuf.end());
		}
	}
}


//  *********
//  MidiTrack
//  *********

MidiTrack::MidiTrack(void)
: DeltaTime(0), prevDurEvent(NULL), prevDurNoteOff(NULL),  channelGroup(0), bHasEndOfTrack(false) /*mastVol(255), vol(90),*/
{

}

MidiTrack::~MidiTrack(void)
{
	DeleteVect<MidiEvent>(aEvents);
}

//UINT MidiTrack::GetSize(void)
//{
//	ULONG size = 0;
//	int nNumEvents = aEvents.size();
//	for (int i=0; i < nNumEvents; i++)
//		size += aEvents[i]->GetSize();
//	return size;
//}

void MidiTrack::Sort(void)
{
	sort(aEvents.begin(), aEvents.end(), PriorityCmp());	//Sort all the events by priority
	stable_sort(aEvents.begin(), aEvents.end(), AbsTimeCmp());	//Sort all the events by absolute time, so that delta times can be recorded correctly
	if (!bHasEndOfTrack && aEvents.size())
	{
		aEvents.push_back(new EndOfTrackEvent(this, aEvents.back()->AbsTime));
		bHasEndOfTrack = true;
	}
}

void MidiTrack::WriteTrack(vector<BYTE> & buf)
{
	//vector<MidiEvent*> aFinalEvents;

	buf.push_back('M');
	buf.push_back('T');
	buf.push_back('r');
	buf.push_back('k');
	buf.push_back(0);
	buf.push_back(0);
	buf.push_back(0);
	buf.push_back(0);
	UINT time = 0;				//start at 0 ticks

	//For all the events, call their preparewrite function to put appropriate (writable) events in aFinalEvents
	int nNumEvents = aEvents.size();
	//for (int i=0; i<nNumEvents; i++)
	//	aEvents[i]->PrepareWrite(aFinalEvents);

	//sort(aFinalEvents.begin(), aFinalEvents.end(), PriorityCmp());	//Sort all the events by priority
	//stable_sort(aFinalEvents.begin(), aFinalEvents.end(), AbsTimeCmp());	//Sort all the events by absolute time, so that delta times can be recorded correctly
	//if (!bHasEndOfTrack && aFinalEvents.size())
	//	aFinalEvents.push_back(new EndOfTrackEvent(this, aFinalEvents.back()->AbsTime));
	//int nNumEvents = aEvents.size();
	for (int i=0; i<nNumEvents; i++)
		time = aEvents[i]->WriteEvent(buf, time);		//write all events into the buffer
	//DeleteVect<MidiEvent>(aFinalEvents);							//done with aFinalEvents now that we filled the buf, so delete it

	ULONG trackSize = buf.size() - 8;						//-8 for MTrk and size that shouldn't be accounted for
	buf[4] = (BYTE)((trackSize & 0xFF000000) >> 24);
	buf[5] = (BYTE)((trackSize & 0x00FF0000) >> 16);
	buf[6] = (BYTE)((trackSize & 0x0000FF00) >> 8);
	buf[7] = (BYTE)(trackSize & 0x000000FF);
}

//MidiTrack::WriteToFile(CFile &theFile)
//{
//	sort(aEvents.begin(), aEvents.end(), MidiEventCmp());
//	GetSize();
//}

//void MidiTrack::SetChannel(int theChannel)
//{
//	channel = theChannel;
//}

void MidiTrack::SetChannelGroup(int theChannelGroup)
{
	channelGroup = theChannelGroup;
}

//Delta Time Functions
ULONG MidiTrack::GetDelta(void)
{
	return DeltaTime;
}

void MidiTrack::SetDelta(ULONG NewDelta)
{
	DeltaTime = NewDelta;
}

void MidiTrack::AddDelta(ULONG AddDelta)
{
	DeltaTime += AddDelta;
}

void MidiTrack::SubtractDelta(ULONG SubtractDelta)
{
	DeltaTime -= SubtractDelta;
}

void MidiTrack::ResetDelta(void)
{
	DeltaTime = 0;
}


void MidiTrack::AddNoteOn(BYTE channel, char key, char vel)
{
	aEvents.push_back(new NoteEvent(this, channel, GetDelta(), true, key, vel));

	//WriteVarLen(delta_time+rest_time, hFile);
	//aMidi.Add(0x90 + channel_num);
	//aMidi.Add(key);
	//aMidi.Add(vel);
	//}
	//current_vel = vel;	
	//prev_key = key;
	//rest_time = 0;
}

void MidiTrack::InsertNoteOn(BYTE channel, char key, char vel, ULONG absTime)
{
	aEvents.push_back(new NoteEvent(this, channel, absTime, true, key, vel));
}

void MidiTrack::AddNoteOff(BYTE channel, char key)
{
	aEvents.push_back(new NoteEvent(this, channel, GetDelta(), false, key));
}

void MidiTrack::InsertNoteOff(BYTE channel, char key, ULONG absTime)
{
	aEvents.push_back(new NoteEvent(this, channel, absTime, false, key));
}

void MidiTrack::AddNoteByDur(BYTE channel, char key, char vel, ULONG duration)
{
	aEvents.push_back(new NoteEvent(this, channel, GetDelta(), true, key, vel));		//add note on
	prevDurNoteOff = new NoteEvent(this, channel, GetDelta()+duration, false, key);
	aEvents.push_back(prevDurNoteOff);	//add note off at end of dur


	//prevDurEvent = new DurNoteEvent(this, channel, GetDelta(), key, vel, duration);
	//aEvents.push_back(prevDurEvent);
	/*MidiEvent* newEvent = new NoteEvent(GetDelta(), true, key, vel);
	aEvents.push_back(newEvent);

	MidiEvent* noteOffEvent = new NoteEvent(GetDelta()+dur, false, key);
	aEvents.push_back(noteOffEvent);*/
}

void MidiTrack::InsertNoteByDur(BYTE channel, char key, char vel, ULONG duration, ULONG absTime)
{
	aEvents.push_back(new NoteEvent(this, channel, absTime, true, key, vel));		//add note on
	prevDurNoteOff = new NoteEvent(this, channel, absTime+duration, false, key);
	aEvents.push_back(prevDurNoteOff);	//add note off at end of dur
	//prevDurEvent = new DurNoteEvent(this, channel, absTime, key, vel, duration);
	//aEvents.push_back(prevDurEvent);
	/*MidiEvent* newEvent = new NoteEvent(absTime, true, key, vel);
	aEvents.push_back(newEvent);

	MidiEvent* noteOffEvent = new NoteEvent(absTime+dur, false, key);
	aEvents.push_back(noteOffEvent);*/
}

/*void MidiTrack::AddVolMarker(BYTE channel, BYTE vol, char priority)
{
	MidiEvent* newEvent = new VolMarkerEvent(this, channel, GetDelta(), vol);
	aEvents.push_back(newEvent);
}

void MidiTrack::InsertVolMarker(BYTE channel, BYTE vol, ULONG absTime, char priority)
{
	MidiEvent* newEvent = new VolMarkerEvent(this, channel, absTime, vol);
	aEvents.push_back(newEvent);
}*/

void MidiTrack::AddVol(BYTE channel, BYTE vol)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 7, vol));
}

void MidiTrack::InsertVol(BYTE channel, BYTE vol, ULONG absTime)
{
	aEvents.push_back(new ControllerEvent(this, channel, absTime, 7, vol));
}

//mast volume has a full byte of resolution
void MidiTrack::AddMasterVol(BYTE channel, BYTE mastVol)
{
	MidiEvent* newEvent = new MastVolEvent(this, channel, GetDelta(), mastVol);
	aEvents.push_back(newEvent);
}

void MidiTrack::InsertMasterVol(BYTE channel, BYTE mastVol, ULONG absTime)
{
	MidiEvent* newEvent = new MastVolEvent(this, channel, absTime, mastVol);
	aEvents.push_back(newEvent);
}

void MidiTrack::AddExpression(BYTE channel, BYTE expression)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 11, expression));
}

void MidiTrack::InsertExpression(BYTE channel, BYTE expression, ULONG absTime)
{
	aEvents.push_back(new ControllerEvent(this, channel, absTime, 11, expression));
}

void MidiTrack::AddSustain(BYTE channel, bool bOn)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 64, (bOn)?0x7F:0));
}

void MidiTrack::InsertSustain(BYTE channel, bool bOn, ULONG absTime)
{
	aEvents.push_back(new ControllerEvent(this, channel, absTime, 64, (bOn)?0x7F:0));
}

void MidiTrack::AddPortamento(BYTE channel, bool bOn)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 65, (bOn)?0x7F:0));
}

void MidiTrack::InsertPortamento(BYTE channel, bool bOn, ULONG absTime)
{
	aEvents.push_back(new ControllerEvent(this, channel, absTime, 65, (bOn)?0x7F:0));
}

void MidiTrack::AddPortamentoTime(BYTE channel, BYTE time)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 5, time));
}

void MidiTrack::InsertPortamentoTime(BYTE channel, BYTE time, ULONG absTime)
{
	aEvents.push_back(new ControllerEvent(this, channel, absTime, 5, time));
}

void MidiTrack::AddPan(BYTE channel, BYTE pan)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 10, pan));
}

void MidiTrack::InsertPan(BYTE channel, BYTE pan, ULONG absTime)
{
	aEvents.push_back(new ControllerEvent(this, channel, absTime, 10, pan));
}

void MidiTrack::AddModulation(BYTE channel, BYTE depth)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 1, depth));
}

void MidiTrack::AddBreath(BYTE channel, BYTE depth)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 2, depth));
}

void MidiTrack::AddPitchBend(BYTE channel, SHORT bend)
{
	aEvents.push_back(new PitchBendEvent(this, channel, GetDelta(), bend));
}

void MidiTrack::AddPitchBendRange(BYTE channel, BYTE semitones, BYTE cents)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 101, 0));
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 100, 0));
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(),  6, semitones));
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 38, cents));
}

void MidiTrack::AddTranspose(BYTE channel, int transpose)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 101, 0));
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 100, 2));
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 6, 64 - transpose));
}

void MidiTrack::AddProgramChange(BYTE channel, BYTE progNum)
{
	aEvents.push_back(new ProgChangeEvent(this, channel, GetDelta(), progNum));
}

void MidiTrack::AddBankSelect(BYTE channel, BYTE bank)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 0, bank, PRIORITY_HIGH));
}

void MidiTrack::AddBankSelectFine(BYTE channel, BYTE lsb)
{
	aEvents.push_back(new ControllerEvent(this, channel, GetDelta(), 32, lsb, PRIORITY_HIGH));
}

void MidiTrack::InsertBankSelect(BYTE channel, BYTE bank, ULONG absTime)
{
	aEvents.push_back(new ControllerEvent(this, channel, absTime, 0, bank));
}


void MidiTrack::AddTempo(ULONG microSeconds)
{
	aEvents.push_back(new TempoEvent(this, GetDelta(), microSeconds));
	//bAddedTempo = true;
}

void MidiTrack::AddTempoBPM(double BPM)
{
	ULONG microSecs = (ULONG)ceil((double)60000000/BPM);  //ceil rounds the value.  rounds up on .5
	aEvents.push_back(new TempoEvent(this, GetDelta(), microSecs));
	//bAddedTempo = true;
}

void MidiTrack::InsertTempo(ULONG microSeconds, ULONG absTime)
{
	aEvents.push_back(new TempoEvent(this, absTime, microSeconds));
	//bAddedTempo = true;
}

void MidiTrack::InsertTempoBPM(double BPM, ULONG absTime)
{
	ULONG microSecs = (ULONG)ceil((double)60000000/BPM);  //ceil rounds the value.  rounds up on .5
	aEvents.push_back(new TempoEvent(this, absTime, microSecs));
	//bAddedTempo = true;
}


void MidiTrack::AddTimeSig(BYTE numer, BYTE denom, BYTE ticksPerQuarter)
{
	aEvents.push_back(new TimeSigEvent(this, GetDelta(), numer, denom, ticksPerQuarter));
	//bAddedTimeSig = true;
}

void MidiTrack::InsertTimeSig(BYTE numer, BYTE denom, BYTE ticksPerQuarter, ULONG absTime)
{
	aEvents.push_back(new TimeSigEvent(this, absTime, numer, denom, ticksPerQuarter));
	//bAddedTimeSig = true;
}

void MidiTrack::AddEndOfTrack(void)
{
	aEvents.push_back(new EndOfTrackEvent(this, GetDelta()));
	bHasEndOfTrack = true;
}

void MidiTrack::InsertEndOfTrack(ULONG absTime)
{
	aEvents.push_back(new EndOfTrackEvent(this, absTime));
	bHasEndOfTrack = true;
}

//  *********
//  MidiEvent
//  *********

MidiEvent::MidiEvent(MidiTrack* thePrntTrk, ULONG absoluteTime, BYTE theChannel, char thePriority)
: prntTrk(thePrntTrk), AbsTime(absoluteTime), channel(theChannel), priority(thePriority)
{
}

MidiEvent::~MidiEvent(void)
{
}

void MidiEvent::WriteVarLength(vector<BYTE> & buf, ULONG time)
{
   register unsigned long buffer;
   buffer = time & 0x7F;

   while ( (time >>= 7) )
   {
     buffer <<= 8;
     buffer |= ((time & 0x7F) | 0x80);
   }

   while (true)
   {
	  buf.push_back((BYTE)buffer);
      if (buffer & 0x80)
          buffer >>= 8;
      else
          break;
   }
}

//void MidiEvent::PrepareWrite(vector<MidiEvent*> & aEvents)
//{
	//aEvents.push_back(MakeCopy());
//}


bool MidiEvent::operator<(const MidiEvent &theMidiEvent) const
{
	return (AbsTime < theMidiEvent.AbsTime);
}

bool MidiEvent::operator>(const MidiEvent &theMidiEvent) const
{
	return (AbsTime > theMidiEvent.AbsTime);
}


//  *********
//  NoteEvent
//  *********


NoteEvent::NoteEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, bool bnoteDown, BYTE theKey, BYTE theVel)
: MidiEvent(prntTrk, absoluteTime, channel, PRIORITY_LOWER), bNoteDown(bnoteDown), key(theKey), vel(theVel)
{
}

//NoteEvent* NoteEvent::MakeCopy()
//{
//	return new NoteEvent(prntTrk, channel, AbsTime, bNoteDown, key, vel);
//}

ULONG NoteEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
	WriteVarLength(buf, AbsTime-time);
	if (bNoteDown)
		buf.push_back(0x90+channel);
	else
		buf.push_back(0x80+channel);
	buf.push_back(key);
	buf.push_back(vel);
	return AbsTime;
}

//  ************
//  DurNoteEvent
//  ************

//DurNoteEvent::DurNoteEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE theKey, BYTE theVel, ULONG theDur)
//: MidiEvent(prntTrk, absoluteTime, channel, PRIORITY_LOWER), key(theKey), vel(theVel), duration(theDur)
//{
//}
/*
DurNoteEvent* DurNoteEvent::MakeCopy()
{
	return new DurNoteEvent(prntTrk, channel, AbsTime, key, vel, duration);
}*/

/*void DurNoteEvent::PrepareWrite(vector<MidiEvent*> & aEvents)
{
	prntTrk->aEvents.push_back(new NoteEvent(prntTrk, channel, AbsTime, true, key, vel));	//add note on
	prntTrk->aEvents.push_back(new NoteEvent(prntTrk, channel, AbsTime+duration, false, key, vel));  //add note off at end of dur
}*/

//ULONG DurNoteEvent::WriteEvent(vector<BYTE> & buf, UINT time)		//we do note use WriteEvent on DurNoteEvents... this is what PrepareWrite is for, to create NoteEvents in substitute
//{
//	return false;
//}


//  ********
//  VolEvent
//  ********

/*VolEvent::VolEvent(MidiTrack *prntTrk, BYTE channel, ULONG absoluteTime, BYTE theVol, char thePriority)
: ControllerEvent(prntTrk, channel, absoluteTime, 7), vol(theVol)
{
}

VolEvent* VolEvent::MakeCopy()
{
	return new VolEvent(prntTrk, channel, AbsTime, vol, priority);
}*/


//  ************
//  MastVolEvent
//  ************

MastVolEvent::MastVolEvent(MidiTrack *prntTrk, BYTE channel, ULONG absoluteTime, BYTE theMastVol)
: MidiEvent(prntTrk, absoluteTime, channel, PRIORITY_HIGHER), mastVol(theMastVol)
{
}

/*MastVolEvent* MastVolEvent::MakeCopy()
{
	return new MastVolEvent(prntTrk, channel, AbsTime, mastVol);
}

void DurNoteEvent::PrepareWrite(vector<MidiEvent*> & aEvents)
{
	aEvents.push_back(new NoteEvent(prntTrk, channel, AbsTime, true, key, vel));	//add note on
	aEvents.push_back(new NoteEvent(prntTrk, channel, AbsTime+duration, false, key, vel));  //add note off at end of dur
}

ULONG MastVolEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
	prntTrk->mastVol = mastVol;

	WriteVarLength(buf, AbsTime-time);
	buf.push_back(0xB0+channel);
	buf.push_back(controlNum);
	//if (controlNum == 7)		// if it's a volume event
	//{
	//	BYTE writeVol = dataByte;//prntTrk->vol;
	//	if (prntTrk->mastVol < 255)		//if mastVol isn't at its max value (default)
	//		writeVol *= (float)(prntTrk->mastVol/255);		//then 
	//	buf.push_back(writeVol);
	//}
	//else
		buf.push_back(dataByte);
	return AbsTime;
}*/

ULONG MastVolEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
	//prntTrk->mastVol = mastVol;

	WriteVarLength(buf, AbsTime-time);
	buf.push_back(0xF0);   //F0 7F 7F 04 01 ll mm F7
	buf.push_back(0x7F);
	buf.push_back(0x7F);
	buf.push_back(0x04);
	buf.push_back(0x01);
	buf.push_back(mastVol);		//bits 0-6 of a 14 bit volume
	buf.push_back(mastVol);		//bits 7-13 of a 14 bit volume
	buf.push_back(0xF7);
	//buf.push_back(0xB0+channel);
	//buf.push_back(controlNum);
	//if (controlNum == 7)		// if it's a volume event
	//{
	//	BYTE writeVol = dataByte;//prntTrk->vol;
	//	if (prntTrk->mastVol < 255)		//if mastVol isn't at its max value (default)
	//		writeVol *= (float)(prntTrk->mastVol/255);		//then 
	//	buf.push_back(writeVol);
	//}
	//else
	//	buf.push_back(dataByte);
	return AbsTime;
}

//  ***************
//  ControllerEvent
//  ***************

ControllerEvent::ControllerEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE controllerNum, BYTE theDataByte, char thePriority)
: MidiEvent(prntTrk, absoluteTime, channel, thePriority), controlNum(controllerNum), dataByte(theDataByte)
{
}
/*
ControllerEvent* ControllerEvent::MakeCopy()
{
	return new ControllerEvent(prntTrk, channel, AbsTime, controlNum, dataByte, priority);
}*/

ULONG ControllerEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
 	WriteVarLength(buf, AbsTime-time);
	buf.push_back(0xB0+channel);
	buf.push_back(controlNum);
	//if (controlNum == 7)		// if it's a volume event
	//{
	//	BYTE writeVol = dataByte;//prntTrk->vol;
	//	if (prntTrk->mastVol < 255)		//if mastVol isn't at its max value (default)
	//		writeVol *= (float)(prntTrk->mastVol/255);		//then 
	//	buf.push_back(writeVol);
	//}
	//else if (controlNum == 11)	// if it's an expression event
	//	buf.push_back(prntTrk->expression);
	//else if (controlNum == 64)	// if it's a sustain event
	//	buf.push_back((bSustain)?0x7F:0);
	//else
		buf.push_back(dataByte);
	return AbsTime;
}

//  ***************
//  ProgChangeEvent
//  ***************

ProgChangeEvent::ProgChangeEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE progNum)
: MidiEvent(prntTrk, absoluteTime, channel, PRIORITY_HIGH), programNum(progNum)
{
}
/*
ProgChangeEvent* ProgChangeEvent::MakeCopy()
{
	return new ProgChangeEvent(prntTrk, channel, AbsTime, programNum);
}*/

ULONG ProgChangeEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
	WriteVarLength(buf, AbsTime-time);
	buf.push_back(0xC0+channel);
	buf.push_back(programNum);
	return AbsTime;
}


//  **************
//  PitchBendEvent
//  **************

PitchBendEvent::PitchBendEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, SHORT bendAmt)
: MidiEvent(prntTrk, absoluteTime, channel, PRIORITY_MIDDLE), bend(bendAmt)
{
}
/*
PitchBendEvent* PitchBendEvent::MakeCopy()
{
	return new PitchBendEvent(prntTrk, channel, AbsTime, bend);
}*/

ULONG PitchBendEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
	BYTE loByte = (bend+0x2000) & 0x7F;
	BYTE hiByte = ((bend+0x2000) & 0x3F80) >> 7;
	WriteVarLength(buf, AbsTime-time);
	buf.push_back(0xE0+channel);
	buf.push_back(loByte);
	buf.push_back(hiByte);
	return AbsTime;
}

//  **********
//  TempoEvent
//  **********

TempoEvent::TempoEvent(MidiTrack* prntTrk, ULONG absoluteTime, ULONG microSeconds)
: MidiEvent(prntTrk, absoluteTime, 0, PRIORITY_HIGHEST), microSecs(microSeconds)
{
}
/*
TempoEvent* TempoEvent::MakeCopy()
{
	return new TempoEvent(prntTrk, AbsTime, microSecs);
}*/

ULONG TempoEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
	WriteVarLength(buf, AbsTime-time);
	buf.push_back(0xFF);
	buf.push_back(0x51);
	buf.push_back(0x03);
	buf.push_back( (BYTE)((microSecs & 0xFF0000) >> 16));
	buf.push_back( (BYTE)((microSecs & 0x00FF00) >> 8));
	buf.push_back(  (BYTE)(microSecs & 0x0000FF));
	return AbsTime;
}


//  ************
//  TimeSigEvent
//  ************

TimeSigEvent::TimeSigEvent(MidiTrack* prntTrk, ULONG absoluteTime, BYTE numerator, BYTE denominator, BYTE clicksPerQuarter)
: MidiEvent(prntTrk, absoluteTime, 0, PRIORITY_HIGHEST), numer(numerator), denom(denominator), ticksPerQuarter(clicksPerQuarter)
{
}
/*
TimeSigEvent* TimeSigEvent::MakeCopy()
{
	return new TimeSigEvent(prntTrk, AbsTime, numer, denom, ticksPerQuarter);
}*/

ULONG TimeSigEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
	WriteVarLength(buf, AbsTime-time);
	buf.push_back(0xFF);
	buf.push_back(0x58);
	buf.push_back(0x04);
	buf.push_back(numer);
	buf.push_back((BYTE)(log((double)denom)/0.69314718055994530941723212145818));				//denom is expressed in power of 2... so if we have 6/8 time.  it's 6 = 2^x  ==  ln6 / ln2
	buf.push_back(ticksPerQuarter/*/4*/);
	buf.push_back(8);
	return AbsTime;
}


//  ***************
//  EndOfTrackEvent
//  ***************

EndOfTrackEvent::EndOfTrackEvent(MidiTrack* prntTrk, ULONG absoluteTime)
: MidiEvent(prntTrk, absoluteTime, 0, PRIORITY_LOWEST)
{
}
/*
EndOfTrackEvent* EndOfTrackEvent::MakeCopy()
{
	return new EndOfTrackEvent(prntTrk, AbsTime);
}*/


ULONG EndOfTrackEvent::WriteEvent(vector<BYTE> & buf, UINT time)
{
	WriteVarLength(buf, AbsTime-time);
	buf.push_back(0xFF);
	buf.push_back(0x2F);
	buf.push_back(0x00);
	return AbsTime;
}