#pragma once
#include "VGMFile.h"
#include "RawFile.h"
#include "MidiFile.h"
#include "Menu.h"

class SeqTrack;
class SeqEvent;

class VGMSeq :
	public VGMFile
{
public:
	BEGIN_MENU_SUB(VGMSeq, VGMFile)
		MENU_ITEM(VGMSeq, OnSaveAsMidi, L"Save as MIDI")
	END_MENU()

	VGMSeq(const string& format, RawFile* file, ULONG offset, ULONG length = 0, wstring name = L"VGM Sequence");
	virtual ~VGMSeq(void);

	virtual Icon GetIcon() { return ICON_SEQ; }
			
	virtual int Load();				//Function to load all the information about the sequence
	virtual int LoadMain();
	virtual int PostLoad();
	virtual int GetHeaderInfo(void);
	virtual int GetTrackPointers(void);	//Function to find all of the track pointers.   Returns number of total tracks.
//	virtual void AddTrack(SeqTrack* track);		//should be called for all tracks before LoadTracks.
	virtual int LoadTracks(void);
	//virtual int ApplyTable(void);	//create and apply table handler object for sequence
	void SetPPQN(UINT ppqn);
	UINT GetPPQN(void);

	void UseReverb() { bReverb = true; }
	void UseLinearAmplitudeScale() { bUseLinearAmplitudeScale = true; }
	void AlwaysWriteInitialVol(BYTE theVol = 100) { bAlwaysWriteInitialVol = true; initialVol = theVol; }
	void AlwaysWriteInitialExpression(BYTE level = 127) { bAlwaysWriteInitialExpression = true; initialExpression = level;}
	void AlwaysWriteInitialPitchBendRange(U8 semitones, U8 cents) 
	{ bAlwaysWriteInitialPitchBendRange = true; initialPitchBendRangeSemiTones = semitones;
	  initialPitchBendRangeCents = cents; }

	bool OnSaveAsMidi(void);
	virtual bool SaveAsMidi(const wchar_t* filepath);

public:
	BYTE globTranspose;
	int nNumTracks;
	//USHORT ppqn;		//perhaps shouldn't include this
	MidiFile midi;
	double tempoBPM;

//attributes
	bool bUseLinearAmplitudeScale;  //This will cause all all velocity, volume, and expression events to be
									//automatically converted from a linear scale to MIDI's logarithmic scale
	bool bWriteInitialTempo;
	bool bAlwaysWriteInitialVol;
	bool bAlwaysWriteInitialExpression;
	bool bAlwaysWriteInitialPitchBendRange;
	U8 initialVol;
	U8 initialExpression;
	U8 initialPitchBendRangeSemiTones, initialPitchBendRangeCents;

	bool bReverb;
	float reverbTime;

	vector<SeqTrack*> aTracks;		//array of track pointers

//protected:
	//map<int, InstrAssoc> InstrMap;
	//map<int, DrumAssoc> DrumMap;
	//static int count;
};


extern BYTE mode;