#include "stdafx.h"
#include "QSoundInstr.h"
#include "QSoundFormat.h"
#include "VGMSamp.h"
#include "VGMRgn.h"

// **************
// QSoundInstrSet
// **************

QSoundInstrSet::QSoundInstrSet(RawFile* file,
							   float version,
							   U32 offset,
							   int numInstrBanks,
							   U32 sampTableOffset,
							   U32 sampTableLength)
: VGMInstrSet(QSoundFormat::name, file, offset),
  samp_infos(0),
  num_instr_banks(numInstrBanks),
  samp_table_offset(sampTableOffset),
  samp_table_length(sampTableLength),
  fmt_version(version)
{
}

QSoundInstrSet::~QSoundInstrSet(void)
{
	if (samp_infos)
		delete[] samp_infos;
}


int QSoundInstrSet::GetHeaderInfo()
{
	wostringstream	theName;
	theName << L"QSoundInstrSet " << id;
	name = theName.str();


	// Load the samp_info table

	if (samp_table_length == 0)
	{
		//determine samp_table length
		UINT i=samp_table_offset, test1=1, test2=1;
		while ((test1 || test2)  && ((test1 != 0xFFFF) || (test2 != 0xFFFF)))
		{
			test1 = GetWord(i);
			test2 = GetWord(i+4);
			i += 8;
		}
		samp_table_length = (i-8)-samp_table_offset;
	}
	numSamples = samp_table_length/sizeof(samp_info);
	samp_infos = new samp_info[numSamples];
	GetBytes(samp_table_offset, samp_table_length, samp_infos);

	return true;
}

int QSoundInstrSet::GetInstrPointers()
{
	// Load the instr_info tables.

	if (fmt_version + F_EPSILON < 1.16)
	{
		// In these versions, there are no instr_info_table pointers, it's hard-coded into the assembly code.
		// There are two possible instr_info banks stored next to each other with 256 entries in each,
		// unlike higher versions, where the number of instr_infos in each bank is variable and less than 0x7F.
		
		//dwOffset is the offset to the instr_info_table
		
		for (UINT bank = 0; bank < num_instr_banks; bank++)
			for (UINT i=0; i<256; i++)
			{
				aInstrs.push_back(new QSoundInstr(this, dwOffset+i*8+(bank*256*8), 8, (bank*2)+(i/128), i%128));
			}
	}
	else
	{
		U8 instr_info_length = sizeof(prog_info_ver_130);
		if (fmt_version + F_EPSILON < 1.30)
			instr_info_length = sizeof(prog_info_ver_103);		//1.16 (Xmen vs SF) is like this

		vector<U16> instr_table_ptrs;
		for (int i=0; i<num_instr_banks; i++)
			instr_table_ptrs.push_back(GetShort(dwOffset+i*2));	//get the instr table ptrs
		for (UINT i=0; i<instr_table_ptrs.size(); i++)
		{
			U16 endOffset;
			if (i+1 < instr_table_ptrs.size())	
				endOffset = instr_table_ptrs[i+1];
			else
				endOffset = instr_table_ptrs[i] + 4*0x7F;
			
			int k=0;
			for (int j = instr_table_ptrs[i]; j < endOffset; j+=instr_info_length, k++)
			{
				if (GetShort(j) == 0 && GetByte(j+2) == 0 && i != 0)
					break;
				aInstrs.push_back(new QSoundInstr(this, j, instr_info_length, i, k));
			}
		}
	}

	

	//ULONG j = 0x20+dwOffset;
	//for (UINT i=0; i<dwNumInstrs; i++)
	//{
	//	ULONG instrLength;
	//	if (i != dwNumInstrs-1)	//while not the last instr
	//		instrLength = GetWord(j+((i+1)*4)) - GetWord(j+(i*4));
	//	else
	//		instrLength = sampColl->dwOffset - (GetWord(j+(i*4)) + dwOffset);
	//	QSoundInstr* newQSoundInstr = new QSoundInstr(this, dwOffset+GetWord(j+(i*4)), instrLength, 0, i);//strStr);
	//	aInstrs.push_back(newQSoundInstr);
	//	//newQSoundInstr->dwRelOffset = GetWord(j+(i*4));
	//}
	return true;
}


// ***********
// QSoundInstr
// ***********

QSoundInstr::QSoundInstr(VGMInstrSet* instrSet, ULONG offset, ULONG length, ULONG theBank, ULONG theInstrNum)
 : 	VGMInstr(instrSet, offset, length, theBank, theInstrNum)
{
}

QSoundInstr::~QSoundInstr(void)
{
}


int QSoundInstr::LoadInstr()
{
	VGMRgn* rgn = new VGMRgn(this, dwOffset, unLength);
	rgn->sampNum = GetShort(dwOffset);
	if (rgn->sampNum == 0xFFFF || rgn->sampNum > ((QSoundInstrSet*)parInstrSet)->numSamples)
		rgn->sampNum = 0;
	rgn->SetUnityKey( ((QSoundInstrSet*)parInstrSet)->samp_infos[rgn->sampNum].unity_key);
	aRgns.push_back(rgn);
	return true;
}
 

// **************
// QSoundSampColl
// **************

QSoundSampColl::QSoundSampColl(RawFile* file, QSoundInstrSet* theinstrset, ULONG offset, ULONG length)
: VGMSampColl(QSoundFormat::name, file, offset, length), instrset(theinstrset)
{

}


bool QSoundSampColl::GetHeaderInfo()
{
	unLength = this->rawfile->size();
	//unLength = GetWord(dwOffset+8);
	return true;
}

bool QSoundSampColl::GetSampleInfo()
{
	//QSoundInstrSet* instrset = (QSoundInstrSet*)instrset;
	UINT numSamples = instrset->numSamples;
	for (UINT i=0; i<numSamples; i++)
	{
		wostringstream name;
		name << L"Sample " << i;

		samp_info* sampInfo = &instrset->samp_infos[i];
		UINT sampOffset = (sampInfo->bank<<16) + (sampInfo->start_addr_hi<<8) + sampInfo->start_addr_lo;
		UINT sampLength;
		if (sampInfo->end_addr_hi == 0 && sampInfo->end_addr_lo == 0)
			sampLength = ((sampInfo->bank+1)<<16) - sampOffset;
		else
			sampLength = (sampInfo->bank<<16) + (sampInfo->end_addr_hi<<8) + sampInfo->end_addr_lo - sampOffset;
		//UINT loopOffset = (sampOffset+sampLength)-((sampInfo->bank<<16) + (sampInfo->loop_offset_hi<<8) + sampInfo->loop_offset_lo);
		UINT loopOffset = ((sampInfo->bank<<16) + (sampInfo->loop_offset_hi<<8) + sampInfo->loop_offset_lo) - sampOffset;
		if (sampLength == 0 || sampOffset > unLength)
			break;
		VGMSamp* newSamp = AddSamp(sampOffset, sampLength, sampOffset, sampLength, 1, 8, 22050, name.str());
		newSamp->SetWaveType(WT_PCM8);
		if ( sampLength - loopOffset < 40)
			newSamp->SetLoopStatus(false);
		else
		{
			newSamp->SetLoopStatus(true);
			newSamp->SetLoopOffset(loopOffset);
			newSamp->SetLoopLength(sampLength-loopOffset);
			newSamp->unityKey = sampInfo->unity_key;
		}
	}
	//Find sample offsets
	//for (ULONG j = dwOffset; j < dwOffset+unLength; j+=0x10)		//until we reach the end of the WD file
	//{
	//	int i;
	//	for(i=0; GetByte(j+i) == 0 && j+i < dwOffset+unLength; i++)
	//		;
	//	if (i >= 16 && (j+i+16) < dwOffset+unLength)										//if we found a chunk of 00 bytes 16 bytes in size or greater, then we found the beginning a new sample
	//	{
	//		wostringstream name;
	//		name << L"Sample " << samples.size();
	//		PSXSamp* samp = new PSXSamp(this, j, 0, j, 0, 1, 16, 44100, name.str());
	//		//PSXSamp* newSample = new PSXSamp(this, j);
	//		samples.push_back(samp);
	//	}
	//}

	////Calculate sample sizes
	//UINT i;
	//for (i=0; i<samples.size()-1; i++)
	//{
	//	samples[i]->SetDataLength(samples[i+1]->dwOffset - samples[i]->dwOffset);
	//}
	//samples[i]->SetDataLength(dwOffset+unLength - samples[i]->dwOffset);		//for the last sample size, we compare it's offset with the end of the entire sample section


	//for (i=0; i<parInstrSet->aInstrs.size(); i++) {							//for every instrument
	//	for (UINT k=0; k<parInstrSet->aInstrs[i]->aRgns.size(); k++) {			//for every region of the instrument
	//		for (UINT m=0; m<samples.size(); m++) {						//for every sample
	//			ULONG test1 = (((WDRgn*)parInstrSet->aInstrs[i]->aRgns[k])->sample_offset & 0xFFFFFFF0) + dwOffset /*- hackval*/;
	//			ULONG test2 = samples[m]->dwOffset;
	//			if ((((WDRgn*)parInstrSet->aInstrs[i]->aRgns[k])->sample_offset  & 0xFFFFFFF0) + dwOffset /*- hackval*/ == (samples[m]->dwOffset/*-parInstrSet->dwOffset*/))	//we add sample_section offset because those values are relative to the beginning of the sample section
	//			{
	//				parInstrSet->aInstrs[i]->aRgns[k]->sampNum = m;

	//				samples[m]->loop.loopStart = parInstrSet->aInstrs[i]->aRgns[k]->loop.loopStart;
	//				samples[m]->loop.loopLength = (samples[m]->dataLength) - (parInstrSet->aInstrs[i]->aRgns[k]->loop.loopStart); //[aInstrs[i]->aRegions[k]->sample_num]->dwUncompSize/2) - ((aInstrs[i]->aRegions[k]->loop_point*28)/16); //to end of sample
	//				break;
	//			}
	//		}
	//	}
	//}
	return true;
}
