#include "stdafx.h"
#include "WD.h"
#include "SquarePS2Format.h"
#include "PSXSPU.h"


// **********
// WDInstrSet
// **********

WDInstrSet::WDInstrSet(RawFile* file, ULONG offset)
: VGMInstrSet(SquarePS2Format::name, file, offset)
{
}

WDInstrSet::~WDInstrSet(void)
{
}


int WDInstrSet::GetHeaderInfo()
{
	id =					GetShort(0x2+dwOffset);
	dwSampSectSize =		GetWord(0x4+dwOffset);
	dwNumInstrs =			GetWord(0x8+dwOffset);
	dwTotalRegions =		GetWord(0xC+dwOffset);

	wostringstream	theName;
	theName << L"WD " << id;
	name = theName.str();

	ULONG sampCollOff = (((dwNumInstrs/4)+(dwNumInstrs%4 > 0))* 0x10) + dwTotalRegions * 0x20 + 0x20 + dwOffset;
	sampColl = new PSXSampColl(SquarePS2Format::name, this, sampCollOff, dwSampSectSize);
	unLength = sampCollOff+dwSampSectSize - dwOffset;

	return true;
}

int WDInstrSet::GetInstrPointers()
{
	
	ULONG j = 0x20+dwOffset;
	for (UINT i=0; i<dwNumInstrs; i++)
	{
		ULONG instrLength;
		if (i != dwNumInstrs-1)	//while not the last instr
			instrLength = GetWord(j+((i+1)*4)) - GetWord(j+(i*4));
		else
			instrLength = sampColl->dwOffset - (GetWord(j+(i*4)) + dwOffset);
		WDInstr* newWDInstr = new WDInstr(this, dwOffset+GetWord(j+(i*4)), instrLength, 0, i);//strStr);
		aInstrs.push_back(newWDInstr);
		//newWDInstr->dwRelOffset = GetWord(j+(i*4));
	}
	return true;
}


// *******
// WDInstr
// *******


WDInstr::WDInstr(VGMInstrSet* instrSet, ULONG offset, ULONG length, ULONG theBank, ULONG theInstrNum)
 : 	VGMInstr(instrSet, offset, length, theBank, theInstrNum)
{
}

WDInstr::~WDInstr(void)
{
}


int WDInstr::LoadInstr()
{
	wostringstream	strStr;
	ULONG j=0;
	long startAddress = 0;
	BOOL notSampleStart = false;

	//Read region data 
	

	bool bSecondToLastRgn = 0;
	bool bLastRgn = 0;

	int k = 0;
	while (k*0x20 < unLength)
	{
		if (bSecondToLastRgn)
			bLastRgn = true;

		WDRgn* rgn = new WDRgn(this, k*0x20  + dwOffset);
		aRgns.push_back(rgn);

		rgn->bStereoRegion =  GetByte(k*0x20 + dwOffset) & 0x1;
		rgn->bUnknownFlag2 =  GetByte(k*0x20 + 2 + dwOffset) & 0x1;
		rgn->bFirstRegion =  GetByte(k*0x20 + 1 + dwOffset) & 0x1;
		rgn->bLastRegion =  (GetByte(k*0x20 + 1 + dwOffset) & 0x2) >> 1;
		//rgn->sample_offset =  GetWord(k*0x20 + 0x4 + dwOffset);
		rgn->sampOffset = GetWord(k*0x20 + 0x4 + dwOffset);
		rgn->loop.loopStart =  GetWord(k*0x20 + 0x8 + dwOffset);
		rgn->ADSR1 =  GetShort(k*0x20 + 0xC + dwOffset);
		rgn->ADSR2 =  GetShort(k*0x20 + 0xE + dwOffset);
		rgn->fineTune =  GetByte(k*0x20 + 0x12 + dwOffset);
		rgn->unityKey =  0x3A - GetByte(k*0x20 + 0x13 + dwOffset);
		rgn->keyHigh =  GetByte(k*0x20 + 0x14 + dwOffset);
		rgn->velHigh =  GetByte(k*0x20 + 0x15 + dwOffset);
		{
			//See the explanation for velocity/volume/expression in SquarePS2Seq.cpp - same scale conversion must be applied to velocity regions
			double origAttenInDB = 20*log10((127/(double)rgn->velHigh));
			rgn->velHigh = 127*pow(10.0,-0.025*origAttenInDB);
		}
		rgn->pan =  (double)GetByte(k*0x20 + 0x17 + dwOffset);		//need to convert

		if (rgn->pan == 255)
			rgn->pan = 1.0;
		else if (rgn->pan == 128)
			rgn->pan = -1.0;
		else if (rgn->pan > 0x7F)
			rgn->pan = (double)(rgn->pan-191.5)/(double)64;
		else
			rgn->pan = 0;

		rgn->fineTune = (short)ceil(((finetune_table[rgn->fineTune] - 0x10000) * 0.025766555011594949755217727389848) - 50);
		PSXConvADSR<WDRgn>(rgn, rgn->ADSR1, rgn->ADSR2);

		if (rgn->bLastRegion)
		{
			if (rgn->bStereoRegion)
				bSecondToLastRgn = true;
			else
				bLastRgn = true;
		}
		k++;
	}

	//First, do key and velocity ranges
	for (UINT k=0; k<aRgns.size(); k++)
	{
		if (((WDRgn*)aRgns[k])->bFirstRegion) //&& !instrument[i].region[k].bLastRegion) //used in ffx2 0049 YRP battle 1.  check out first instrument, flags are weird
			aRgns[k]->keyLow = 0;
		else if (k > 0)
		{
			if (aRgns[k]->keyHigh == aRgns[k-1]->keyHigh)
				aRgns[k]->keyLow = aRgns[k-1]->keyLow;//hDLSFile.aInstrs.back()->aRgns.back()->usKeyLow;
			else
				aRgns[k]->keyLow = aRgns[k-1]->keyHigh+1;
		}
		else
			aRgns[k]->keyLow = 0;

		if (((WDRgn*)aRgns[k])->bLastRegion)
			aRgns[k]->keyHigh = 0x7F;

		if (k == 0) //if it's the first region of the instrument
			aRgns[k]->velLow = 0;
		else if (aRgns[k]->velHigh == aRgns[k-1]->velHigh)
		{
			aRgns[k]->velLow = aRgns[k-1]->velLow;
			aRgns[k]->velHigh = 0x7F;		//FFX 0022, aka sight of spira, was giving me problems, hence this
			aRgns[k-1]->velHigh = 0x7F; //hDLSFile.aInstrs.back()->aRgns.back()->usVelHigh = 0x7F;
		}
		else if (aRgns[k-1]->velHigh == 0x7F)
			aRgns[k]->velLow = 0;
		else
			aRgns[k]->velLow = aRgns[k-1]->velHigh+1;
	}
	return TRUE;
}


// *****
// WDRgn
// *****

WDRgn::WDRgn(WDInstr* instr, ULONG offset)
: VGMRgn(instr, offset)
{
}
 