#pragma once
#include "VGMInstrSet.h"
#include "VGMSampColl.h"

class QSoundInstr;

typedef struct _prog_info_ver_103 {
	BYTE samp_info_ptr_lo;
	BYTE samp_info_ptr_hi;
	BYTE unknown;
	BYTE artic_something;
	BYTE sustain_rate;
	BYTE field_5;
	BYTE release_rate;
	BYTE field_7;
} prog_info_ver_103;

typedef struct _prog_info_ver_130 {
	BYTE samp_info_ptr_lo;
	BYTE samp_info_ptr_hi;
	BYTE unknown;
	BYTE artic_index;
} prog_info_ver_130;

typedef struct _samp_info {
	BYTE bank;
	BYTE start_addr_lo;
	BYTE start_addr_hi;
	BYTE loop_offset_lo;
	BYTE loop_offset_hi;
	BYTE end_addr_lo;
	BYTE end_addr_hi;
	BYTE unity_key;
} samp_info;

// **********
// QSoundInstrSet
// **********

class QSoundInstrSet
	: public VGMInstrSet
{
public:
	QSoundInstrSet(RawFile* file,
				   float fmt_version,
				   U32 offset, 
				   int numInstrBanks,
				   U32 sampTableOffset, 
				   U32 sampTableLength);
	virtual ~QSoundInstrSet(void);

	virtual int GetHeaderInfo();
	virtual int GetInstrPointers();

public:
	//prog_info*	prog_infos;
	float fmt_version;
	int num_instr_banks;
	U32 samp_table_offset;
	U32 samp_table_length;
	samp_info*	samp_infos;
	UINT numSamples;

protected:
	
};


// ***********
// QSoundInstr
// ***********

class QSoundInstr
	: public VGMInstr
{
public:
	QSoundInstr(VGMInstrSet* instrSet, ULONG offset, ULONG length, ULONG theBank, ULONG theInstrNum);
	virtual ~QSoundInstr(void);
	virtual int LoadInstr();
public:

protected:
	int info_ptr;		//pointer to start of instrument set block
	int nNumRegions;
};


// *****
// WDRgn
// *****

//class WDRgn
//	: public VGMRgn
//{
//public:
//	WDRgn(QSoundInstr* instr, ULONG offset);
//	//virtual ~WDRgn(void) {}
//	//virtual int OnSelected(void);
//
//public:
//	unsigned short ADSR1;				//raw ps2 ADSR1 value (articulation data)
//	unsigned short ADSR2;				//raw ps2 ADSR2 value (articulation data)
//	unsigned char bStereoRegion;
//	unsigned char StereoPairOrder;
//	unsigned char bFirstRegion;
//	unsigned char bLastRegion;
//	unsigned char bUnknownFlag2;
//	ULONG sample_offset;
//};



// **************
// QSoundSampColl
// **************

class QSoundSampColl
	: public VGMSampColl
{
public:
	QSoundSampColl(RawFile* file, QSoundInstrSet* instrset, ULONG offset, ULONG length = 0);
	virtual bool GetHeaderInfo();		//retrieve any header data
	virtual bool GetSampleInfo();		//retrieve sample info, including pointers to data, # channels, rate, etc.

private:
	QSoundInstrSet* instrset;
};
