#pragma once
#include <iterator>
#include <string>
#include <vector>
#include <list>
using namespace std;

class VGMSeq;

class MidiFile;
class MidiTrack;
class MidiEvent;
class DurNoteEvent;
class NoteEvent;

#define PRIORITY_LOWEST 127
#define PRIORITY_LOWER 96
#define PRIORITY_LOW 64
#define PRIORITY_MIDDLE 0
#define PRIORITY_HIGH -64
#define PRIORITY_HIGHER -96
#define PRIORITY_HIGHEST -128

class MidiFile
{
public:
	MidiFile(VGMSeq* assocSeq);
	MidiFile(ULONG thePpqn);
	~MidiFile(void);
	MidiTrack* AddTrack();
	MidiTrack* InsertTrack(int trackNum);
	void SetPPQN(UINT thePpqn);
	UINT GetPPQN();
	void WriteMidiToBuffer(vector<BYTE> & buf);
	void Sort(void);
	bool SaveMidiFile(const wchar_t* filepath);

protected:
	//bool bAddedTempo;
	//bool bAddedTimeSig;

public:
	VGMSeq* assocSeq;
	UINT ppqn;
	vector<MidiTrack*> aTracks;
};


class MidiTrack
{
public:
	MidiTrack(void);
	virtual ~MidiTrack(void);

	void Sort(void);
	void WriteTrack(vector<BYTE> & buf);

	//void SetChannel(int theChannel);
	void SetChannelGroup(int theChannelGroup);

	ULONG GetDelta(void);
	void SetDelta(ULONG NewDelta);
	void AddDelta(ULONG AddDelta);
	void SubtractDelta(ULONG SubtractDelta);
	void ResetDelta(void);

	//void AddEvent(MidiEvent
	//void InsertEvent(
	void AddNoteOn(BYTE channel, char key, char vel);
	void InsertNoteOn(BYTE channel, char key, char vel, ULONG absTime);
	void AddNoteOff(BYTE channel, char key);
	void InsertNoteOff(BYTE channel, char key, ULONG absTime);
	void AddNoteByDur(BYTE channel, char key, char vel, ULONG duration);
	void InsertNoteByDur(BYTE channel, char key, char vel, ULONG duration, ULONG absTime);
	//void AddVolMarker(BYTE channel, BYTE vol, char priority = PRIORITY_HIGHER);
	//void InsertVolMarker(BYTE channel, BYTE vol, ULONG absTime, char priority = PRIORITY_HIGHER);
	void AddVol(BYTE channel, BYTE vol/*, char priority = PRIORITY_MIDDLE*/);
	void InsertVol(BYTE channel, BYTE vol, ULONG absTime/*, char priority = PRIORITY_MIDDLE*/);
	void AddMasterVol(BYTE channel, BYTE mastVol/*, char priority = PRIORITY_HIGHER*/);
	void InsertMasterVol(BYTE channel, BYTE mastVol, ULONG absTime/*, char priority = PRIORITY_HIGHER*/);
	void AddPan(BYTE channel, BYTE pan);
	void InsertPan(BYTE channel, BYTE pan, ULONG absTime);
	void AddExpression(BYTE channel, BYTE expression);
	void InsertExpression(BYTE channel, BYTE expression, ULONG absTime);
	void AddSustain(BYTE channel, bool bOn);
	void InsertSustain(BYTE channel, bool bOn, ULONG absTime);
	void AddPortamento(BYTE channel, bool bOn);
	void InsertPortamento(BYTE channel, bool bOn, ULONG absTime);
	void AddPortamentoTime(BYTE channel, BYTE time);
	void InsertPortamentoTime(BYTE channel, BYTE time, ULONG absTime);
	//void AddPan(BYTE pan);
	//void InsertPan(BYTE pan, ULONG absTime);
	//void AddPitchBend();
	//void InsertPitchBend();
	//void AddSustainOn();
	//void InsertSustainOn();
	//void AddSustainOff();
	//void InsertSustainOff();
	//void AddSustainDur();
	//void AddVolSlide();
	//void InsertVolSlide();
	//void AddPitchBendSlide();
	//void InsertPitchBendSlide();
	void AddPitchBend(BYTE channel, SHORT bend);
	void AddPitchBendRange(BYTE channel, BYTE semitones, BYTE cents);
	void AddTranspose(BYTE channel, int transpose);
	void AddModulation(BYTE channel, BYTE depth);
	void AddBreath(BYTE channel, BYTE depth);
	void AddProgramChange(BYTE channel, BYTE progNum);
	void AddBankSelect(BYTE channel, BYTE bank);
	void AddBankSelectFine(BYTE channel, BYTE lsb);
	void InsertBankSelect(BYTE channel, BYTE bank, ULONG absTime);

	void AddTempo(ULONG microSeconds);
	void AddTempoBPM(double BPM);
	void InsertTempo(ULONG microSeconds, ULONG absTime);
	void InsertTempoBPM(double BPM, ULONG absTime);
	void AddTimeSig(BYTE numer, BYTE denom, BYTE clicksPerQuarter);
	void InsertTimeSig(BYTE numer, BYTE denom, BYTE ticksPerQuarter, ULONG absTime);
	void AddEndOfTrack(void);
	void InsertEndOfTrack(ULONG absTime);

	//tempo
	//program change
public:
	bool bHasEndOfTrack;

public:
	int channelGroup;

	ULONG DeltaTime;			//a time value to be used for AddEvent
	//BYTE channel;
	DurNoteEvent* prevDurEvent;
	NoteEvent* prevDurNoteOff;
	BYTE mastVol;
	//BYTE vol;
	//BYTE expression;
	bool bSustain;

	vector<MidiEvent*> aEvents;
};


class MidiEvent
{
public:
	MidiEvent(MidiTrack* thePrntTrk, ULONG absoluteTime, BYTE theChannel, char thePriority);
	virtual ~MidiEvent(void);
	void WriteVarLength(vector<BYTE> & buf, ULONG time);
	//virtual MidiEvent* MakeCopy() = 0;			//allocates and creates an identical midievent from the event which calls this
	//virtual void PrepareWrite(void/*vector<MidiEvent*> & aEvents*/);
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time) = 0;
	
	bool operator<(const MidiEvent &) const;
	bool operator>(const MidiEvent &) const;

	MidiTrack* prntTrk;
	char priority;
	BYTE channel;
	ULONG AbsTime;			//absolute time... the number of ticks from the very beginning of the sequence at which this event occurs
};

class PriorityCmp
{
public:
	bool operator() (const MidiEvent* a, const MidiEvent* b) const
	{
		return (a->priority < b->priority);
	}
};

class AbsTimeCmp
{
public:
	bool operator() (const MidiEvent* a, const MidiEvent* b) const
	{
		return (a->AbsTime < b->AbsTime);
	}
};

class NoteEvent
	: public MidiEvent
{
public:
	NoteEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, bool bnoteDown, BYTE theKey, BYTE theVel = 64);
	//virtual NoteEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	bool bNoteDown;
	char key;
	char vel;
	//BYTE 
};

class DurNoteEvent
	: public MidiEvent
{
public:
	DurNoteEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE theKey, BYTE theVel, ULONG theDur);
	//virtual DurNoteEvent* MakeCopy();
	//virtual void PrepareWrite(vector<MidiEvent*> & aEvents);
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	bool bNoteDown;
	char key;
	char vel;
	ULONG duration;
};

class ControllerEvent
	: public MidiEvent
{
public:
	ControllerEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE controllerNum, BYTE theDataByte, char thePriority = PRIORITY_MIDDLE);
	//virtual ControllerEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	BYTE controlNum;
	BYTE dataByte;
	//BYTE 
};

/*
class VolEvent
	: public ControllerEvent
{
public:
	VolEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE theVol, char thePriority = PRIORITY_MIDDLE);
	virtual VolEvent* MakeCopy();
	//virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	BYTE vol;
};

class VolMarkerEvent
	: public MidiEvent
{
public:
	VolMarkerEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE theVol, char thePriority = PRIORITY_HIGHER);
	virtual VolMarkerEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	BYTE vol;
};*/

class MastVolEvent
	: public MidiEvent
{
public:
	MastVolEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE mastVol);
	//virtual MastVolEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	BYTE mastVol;
};
/*
class ExpressionEvent
	: public MidiEvent
{
public:
	ExpressionEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE expression, char thePriority = PRIORITY_HIGHER);
	virtual ExpressionEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	BYTE expression;
};*/

class ProgChangeEvent
	: public MidiEvent
{
public:
	ProgChangeEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, BYTE progNum);
	//virtual ProgChangeEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	BYTE programNum;
};

class PitchBendEvent
	: public MidiEvent
{
public:
	PitchBendEvent(MidiTrack* prntTrk, BYTE channel, ULONG absoluteTime, SHORT bend);
	//virtual PitchBendEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	SHORT bend;
};


class TempoEvent
	: public MidiEvent
{
public:
	TempoEvent(MidiTrack* prntTrk, ULONG absoluteTime, ULONG microSeconds);
	//virtual TempoEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	ULONG microSecs;
};

class TimeSigEvent
	: public MidiEvent
{
public:
	TimeSigEvent(MidiTrack* prntTrk, ULONG absoluteTime, BYTE numerator, BYTE denominator, BYTE clicksPerQuarter);
	//virtual TimeSigEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);

	BYTE numer;
	BYTE denom;
	BYTE ticksPerQuarter;
};

class EndOfTrackEvent
	: public MidiEvent
{
public:
	EndOfTrackEvent(MidiTrack* prntTrk, ULONG absoluteTime);
	//virtual EndOfTrackEvent* MakeCopy();
	virtual ULONG WriteEvent(vector<BYTE> & buf, UINT time);
};




/*
class AFX_EXT_CLASS ProgChangeEvent
	: public MidiEvent
{
	ProgChangeEvent(void);
	~ProgramChangeEvent(void);

	BYTE progNum;
}

class AFX_EXT_CLASS ControllerEvent
	: public MidiEvent
{
public:
	NoteEvent(void);
	~NoteEvent(void);

	char key;
	char vel;
};*/

/*class AFX_EXT_CLASS NoteEventDur
	: public MidiEvent
{
public:
	NoteEvent(void);
	~NoteEvent(void);

	char key;
	char vel;
}*/