#include "stdafx.h"
#include <math.h>
#include "AkaoFormat.h"
#include "AkaoSeq.h"
#include "AkaoInstr.h"
#include "VGMColl.h"
#include "PSXSPU.h"

/*
int AkaoFormat::OnMatch(vector<VGMFile*>& files)
{
	UINT i;
	for (i=0; files[i]->GetFileType() != FILETYPE_SEQ  &&  i<2; i++)
		;

	AkaoSeq* seq = (AkaoSeq*)files[i];
	AkaoInstrSet* instrset = seq->instrset;
	AkaoSampColl* sampcoll = (AkaoSampColl*)files[!i];

	AkaoColl* coll = new AkaoColl(*seq->GetName());
	coll->UseSeq(seq);
	coll->AddInstrSet(instrset);
	coll->AddSampColl(sampcoll);
	coll->Load();
	return true;
}*/


bool AkaoColl::LoadMain()
{
	AkaoInstrSet* instrset = (AkaoInstrSet*)instrsets[0];
	AkaoSampColl* sampcoll = (AkaoSampColl*)sampcolls[0];

	//Set the sample numbers of each region using the articulation data references of each region
	for (UINT i = 0; i<instrset->aInstrs.size(); i++)
	{
		AkaoInstr* instr = (AkaoInstr*)instrset->aInstrs[i];
		vector<VGMRgn*>* rgns = &instr->aRgns;
		for (UINT j=0; j<rgns->size(); j++)
		{
			AkaoRgn* rgn = (AkaoRgn*)(*rgns)[j];


			AkaoArt* art;

			if ( !((rgn->artNum - sampcoll->starting_art_id) >= 0 && 
				rgn->artNum - sampcoll->starting_art_id < 200))
			{
				Alert(L"Articualation reference does not exist in the samp collection");
				art = &sampcoll->akArts.front();
			}
			
			if (rgn->artNum - sampcoll->starting_art_id >= sampcoll->akArts.size() )
			{
				Alert(L"referencing an articulation that was not loaded.");
				art = &sampcoll->akArts.back();
			}
			else
				art = &sampcoll->akArts[rgn->artNum - sampcoll->starting_art_id];
			rgn->SetSampNum(art->sample_num);
			if (art->loop_point != 0)
				rgn->SetLoopInfo(1, art->loop_point, sampcoll->samples[rgn->sampNum]->dataLength -art->loop_point);

			PSXConvADSR<AkaoRgn>(rgn, art->ADSR1, art->ADSR2);
			if (instr->bDrumKit)
				rgn->unityKey = art->unityKey + rgn->keyLow - rgn->drumRelUnityKey;
			else
				rgn->unityKey = art->unityKey;

			short ft = art->fineTune;
			if (ft < 0)
				ft += 0x8000;
			double freq_multiplier = (double) (((ft * 32)  + 0x100000) / (double)0x100000);  //this gives us the pitch multiplier value ex. 1.05946
			double cents = log(freq_multiplier)/log((double)2)*1200;
			if (art->fineTune < 0)
				cents -= 1200;
			rgn->fineTune = cents;
		}
	}
	

	return true;
}

bool AkaoColl::PreDLSMainCreation(DLSFile& dls)
{
	//Before DLS Conversion, we want to add instruments for every single articulation definition
	//in the Akao Sample Collection, so that they can be used with the 0xA1 program change sequence event
	//to do this, we create a copy of the AkaoInstrSet before conversion and add the instruments, then
	//when we finish the dls conversion, we put back the original unchanged AkaoInstrSet.  We don't want to make
	//any permanent changes to the InstrSet, in case the collection gets recreated or something.
	/*origInstrSet = (AkaoInstrSet*)instrsets[0];
	AkaoInstrSet* newInstrSet = new AkaoInstrSet(NULL, 0, 0, 0, L"");
	*newInstrSet = *origInstrSet;
	//copy all of the instruments so that we have copied instruments deleted on the destructor of the Instrument Set
	for (UINT i=0; i<origInstrSet->aInstrs.size(); i++)
	{
		AkaoInstr* cpyInstr = new AkaoInstr(newInstrSet, 0, 0, 0, 0);
		*cpyInstr = *((AkaoInstr*)origInstrSet->aInstrs[i]);
		newInstrSet->aInstrs[i] =  cpyInstr;
		//ditto for all regions in the instruments
		for (UINT j=0; j<cpyInstr->aRgns.size(); j++)
		{
			AkaoRgn* cpyRgn = new AkaoRgn(cpyInstr, 0, 0, L"");
			*cpyRgn = *((AkaoRgn*)cpyInstr->aRgns[j]);
			cpyInstr->aRgns[j] =  cpyRgn;
			cpyRgn->items.clear();
		}
	}
	instrsets[0] = newInstrSet;*/

	if ( !((AkaoSeq*)seq)->bUsesIndividualArts )	//only do this if the 0xA1 event is actually used
		return true;								//otherwise, skip this shit

	AkaoInstrSet* instrSet = (AkaoInstrSet*)instrsets[0];

	AkaoSampColl* sampcoll = (AkaoSampColl*)sampcolls[0];
	const UINT numArts = sampcoll->akArts.size();
	const UINT origNumInstrs = instrSet->aInstrs.size();
	if (origNumInstrs + numArts > 0x7F)
		numAddedInstrs = 0x7F - origNumInstrs;
	else
		numAddedInstrs = numArts;

	for (UINT i=0; i<numAddedInstrs; i++)
	{
		AkaoArt* art = &sampcoll->akArts[i];
		AkaoInstr* newInstr = new AkaoInstr(instrSet, 0, 0, 0, origNumInstrs + sampcoll->starting_art_id + i);

		AkaoRgn* rgn = new AkaoRgn(newInstr, 0, 0);

		rgn->SetSampNum(art->sample_num);
		if (art->loop_point != 0)
			rgn->SetLoopInfo(1, art->loop_point, sampcoll->samples[rgn->sampNum]->dataLength -art->loop_point);

		PSXConvADSR<AkaoRgn>(rgn, art->ADSR1, art->ADSR2);
		rgn->unityKey = art->unityKey;

		short ft = art->fineTune;
		if (ft < 0)
			ft += 0x8000;
		double freq_multiplier = (double) (((ft * 32)  + 0x100000) / (double)0x100000);  //this gives us the pitch multiplier value ex. 1.05946
		double cents = log(freq_multiplier)/log((double)2)*1200;
		if (art->fineTune < 0)
			cents -= 1200;
		rgn->fineTune = cents;
		newInstr->aRgns.push_back(rgn);

		instrSet->aInstrs.push_back(newInstr);
	}
	
	return true;
}

bool AkaoColl::PostDLSMainCreation(DLSFile& dls)
{
	if ( !((AkaoSeq*)seq)->bUsesIndividualArts )	//if the 0xA1 event isn't used in the sequence, then we didn't modify the instrset
		return true;								//so skip this shit

	AkaoInstrSet* instrSet = (AkaoInstrSet*)instrsets[0];
	AkaoSampColl* sampcoll = (AkaoSampColl*)sampcolls[0];
	const UINT numArts = sampcoll->akArts.size();
	ULONG beginOffset = instrSet->aInstrs.size() - numArts;
	for (int i=0; i<numAddedInstrs; i++)
	{
		delete instrSet->aInstrs.back();
		instrSet->aInstrs.pop_back();
	}
	return true;
}
