#include "stdafx.h"
#include "ScaleConversion.h"

BYTE Convert7bitPercentVolValToStdMidiVal(BYTE percentVal)
{
	//In standard MIDI, the attenuation for volume in db is 40*log10(127/val) == 20*log10(127^2/val^2). (dls1 spec page 14)
	//Here, the scale is different.  We get rid of the exponents
	// so it's just 20*log10(127/val).
	//Therefore, we must convert from one scale to the other.
	//The equation for the first line is self-evident.
	//For the second line, I simply solved db = 40*log10(127/val) for val.
	//The result is val = 127*10^(-0.025*db).  So, by plugging in the original val into
	//the original scale equation, we get a db that we can plug into that second equation to get
	//the new val.

	double origAttenInDB = 20*log10((127/(double)percentVal));
	return ceil(127*pow(10.0,-0.025*origAttenInDB) - 0.5);
}

// returns the attenuation in decibel units in the scale provided by maxVal;
long ConvertPercentToLogVolScale(long maxVal, double percent)
{
	double origAttenInDB = 20*log10(percent);
	//negate (because we were given a percent value:  20*log10(127/64) = -20*log10(64/127)
	origAttenInDB = -origAttenInDB;		
	return maxVal*pow(10.0,-0.025*origAttenInDB);
}

// Convert a percent of volume value to it's attenuation in decibals.
double ConvertPercentVolToAttenDB(double percent)
{
	return -20*log10(percent);
}
