#include "stdafx.h"
#include "PSF2Loader.h"
#include "Root.h"
#include "RawFile.h"
#include <zlib.h>

PSF2Loader::PSF2Loader(void)
{
}

PSF2Loader::~PSF2Loader(void)
{
}

int PSF2Loader::Apply(RawFile* file)
{
	UINT sig = file->GetWord(0);
	if ((sig & 0x00FFFFFF) == 0x465350 && ((sig & 0xFF000000) == 0x02000000))	//if the sig is PSF 0x02
	{
		int r;
		int dircount;
		unsigned char hdr[16];

		unsigned long reserved_size;
		unsigned long exe_size;

		//new section put here by me
		//memcpy(hdr, file->data,0x10);
		file->GetBytes(0, 0x10, hdr);

		reserved_size = get32lsb(hdr +  4);
		exe_size      = get32lsb(hdr +  8);

		//memcpy(&dircount, file->data+0x10,4);
		dircount = file->GetWord(0x10);

		r=psf2unpack(file, 0x14, dircount);
		return DELETE_IT;
	}
	return KEEP_IT;
}


uint32 PSF2Loader::get32lsb(uint8 *src) {
  return
    ((((uint32)(src[0])) & 0xFF) <<  0) |
    ((((uint32)(src[1])) & 0xFF) <<  8) |
    ((((uint32)(src[2])) & 0xFF) << 16) |
    ((((uint32)(src[3])) & 0xFF) << 24);
}

/////////////////////////////////////////////////////////////////////////////

int PSF2Loader::psf2_decompress_block(
  RawFile* file,
  unsigned fileoffset,
  unsigned blocknumber,
  unsigned numblocks,
  unsigned char *decompressedblock,
  unsigned blocksize
  ) 
{
	unsigned int i;
	unsigned long destlen;
	unsigned long current_block;
	uint8 *blocks;
	uint8 *zblock;
	//blocks = malloc(numblocks*4);
	blocks = new uint8[numblocks*4];

	if(!blocks)
	{
		Alert(L"Out of Memory");
		return -1;
	}

	//BYTE* filedata = &file->buf[0];//file->data;
	
	file->buf.GetBytes(fileoffset,numblocks*4, blocks);
	//memcpy(blocks, filedata+fileoffset,numblocks*4);
	//fseek(fh,fileoffset,SEEK_SET);
	//fread(blocks,numblocks,4,fh);
	current_block = get32lsb(blocks + (blocknumber * 4));
	//zblock=malloc(current_block);
	zblock = new uint8[current_block];

	if(!zblock)
	{
		Alert(L"Out of Memory");
		//free(blocks);
		delete[] blocks;
		return -1;
	}

	int tempOffset = fileoffset+numblocks*4;
	for (i=0; i<blocknumber; i++)
		tempOffset += get32lsb(blocks + (i *4));
	file->buf.GetBytes(tempOffset, current_block, zblock);
	//memcpy(zblock, filedata+tempOffset, current_block);
	//for (i=0;i<blocknumber;i++)
	//	fseek(fh,get32lsb(blocks + (i * 4)),SEEK_CUR);
	//fread(zblock,1,current_block,fh);


	destlen = blocksize;
	if(uncompress(decompressedblock, &destlen, zblock, current_block) != Z_OK) {
		Alert(L"Decompression failed");
		delete[] zblock;
		//free(zblock);
		delete[] blocks;
		//free(blocks);
		return -1;
	}

	delete[] zblock;
	//free(zblock);
	delete[] blocks;
	//free(blocks);
	return 0;
}



//int VGMDoc::psf2unpack()
int PSF2Loader::psf2unpack(RawFile* file, unsigned long fileoffset, unsigned long dircount) 
{
	//FILE *f;
	unsigned int i,j,k;

	wchar_t wfilename[37];
	unsigned char filename[37];
	unsigned long offset = 0;
	unsigned long filesize = 0;
	unsigned long buffersize = 0;

	int r;

	unsigned int blockcount;
	uint8 *dblock;


	memset(filename, 0, sizeof(filename)/sizeof(filename[0]));



	//BYTE* filedata = &file->buf[0];//file->data;


	//CreateDirectory(directory,0);

	//fileattr = GetFileAttributes(directory);
	//if ((!(fileattr&FILE_ATTRIBUTE_DIRECTORY))||(fileattr==-1))
	//{
	//	printf("Directory %s could not be created\n",directory);
	//	return -1;
	//}

	//SetCurrentDirectory(directory);

	for (i=0;i<dircount;i++)
	{
		file->buf.GetBytes(i*48+fileoffset, 36, filename);
		file->buf.GetBytes(i*48+fileoffset+36, 4, &offset);
		file->buf.GetBytes(i*48+fileoffset+36+4, 4, &filesize);
		file->buf.GetBytes(i*48+fileoffset+36+4+4, 4, &buffersize);
		//memcpy(filename, filedata+i*48+fileoffset,36);
		//memcpy(&offset, filedata+i*48+fileoffset+36,4);
		//memcpy(&filesize, filedata+i*48+fileoffset+36+4,4);
		//memcpy(&buffersize, filedata+i*48+fileoffset+36+4+4,4);
		if ((filesize == 0) && (buffersize == 0))
		{
			file->buf.GetBytes(offset+0x10, 4, &filesize);
			//memcpy(&filesize, filedata+offset+0x10, 4);
			//string.Format("Changing Dir to %s", filename);
			//WriteStatusBar(string);
			r=psf2unpack(file, offset+0x14,filesize);
			if (r)
			{
				Alert(L"Directory decompression failed");
				return -1;
			}
			//AfxMessageBox(_T("Going up one Directory"), MB_OK, NULL);
		}
		else
		{
			//string.Format("Unpacking File %s\n",filename);
			//WriteStatusBar(string);
			blockcount = ((filesize + buffersize) - 1) / buffersize;

			//f=fopen(filename,"wb");

			//bLoadingVirtFile = TRUE;
			//VGMDoc* tempVGMDoc = (VGMDoc*)theApp.OpenDocumentFile((LPCTSTR)filename);
			//bLoadingVirtFile = FALSE;
			BYTE* newdataBuf = new BYTE[filesize];
			UINT actualFileSize = filesize;
			k = 0;

			dblock = new uint8[buffersize];
			//dblock = malloc(buffersize);
			if (!dblock)
			{
				Alert(L"Out of Memory");
				return -1;
			}

			for (j=0;j<blockcount;j++)
			{
				r=psf2_decompress_block(file, offset+0x10,j,blockcount,dblock,buffersize);

				if(r)
				{
					//string.Format("File %s failed to decompress",filename);
					//AfxMessageBox(string, MB_OK, NULL);
					return -1;
				}
				if (filesize > buffersize)
				{
					filesize -= buffersize;
					//fwrite(dblock,1,buffersize,f);
					memcpy(newdataBuf+k, dblock, buffersize);
					k+=buffersize;
				}
				else
				{
					//fwrite(dblock,1,filesize,f);
					memcpy(newdataBuf+k, dblock, filesize);
					k+=filesize;
				}

			}

			mbstowcs(wfilename, (const char*)filename, sizeof(filename)/sizeof(filename[0]));
			pRoot->CreateVirtFile(newdataBuf, actualFileSize, wfilename, file->GetFullPath());
			delete[] dblock;
			//free(dblock);
			//fclose(f);

			//else, Its a file.
		}	
	}
	//SetCurrentDirectory("..");
	return 0;
}