#include "stdafx.h"
#include "NinSnesScanner.h"
#include "NinSnes.h"

#define SRCH_BUF_SIZE 0x20000

NinSnesScanner::NinSnesScanner(void)
{
}

NinSnesScanner::~NinSnesScanner(void)
{
}


void NinSnesScanner::Scan(RawFile* file, void* info)
{
	SearchForNinSnesSeq(file);
	return;
}
/*
void NinSnesScanner::SearchForNinSnesSeq (RawFile* file)
{
	UINT nFileLength = file->size();
	for (UINT i=0; i+6<nFileLength; i++)
	{
		if ((*file)[i] == 'O' && (*file)[i+1] == 'r' && (*file)[i+2] == 'g' && (*file)[i+3] == '-' &&
			  (*file)[i+4] == '0' && (*file)[i+5] == '2')
		{
			if (file->GetShort(i+6))
			{
				OrgSeq* NewOrgSeq = new OrgSeq(file, i);
				NewOrgSeq->Load();
			}
		}
	}
}*/



void NinSnesScanner::SearchForNinSnesSeq (RawFile* file)
{
	ULONG nFileLength = file->size();
	if (nFileLength < 0x10000 || nFileLength > 0x10500)
		return;


	for (ULONG i = 0x100; i+1 < nFileLength; i++)
	{
		USHORT theShort2;
		USHORT theShort = file->GetShort(i);
		if (theShort > i && theShort < i + /*0x150*/0x200)
		{
			bool bFailed = false;
			int m = 0;
			while (true)
			{
				m+=2;
				if (i+m <= nFileLength-2)
				{
					theShort2 = file->GetShort(i+m);
					if (theShort2 > i+m && theShort2 < i+m+0x200/*0x150*/)
						continue;
					else if (theShort2 == 0 || theShort2 < 0x100)//== 0xFF)
						break;
					else
					{
						bFailed = true;
						break;
					}
				}
				else
				{
					bFailed = true;
					break;
				}
			}
			if (!bFailed)
			{
				for (int n=0; n<m; n+=2)
				{
					for (int p=0; p<8; p++)
					{
						theShort = file->GetShort(i+n);
						USHORT tempShort;
						if (theShort+p*2+1 < nFileLength)
							tempShort = file->GetShort(theShort+p*2);
						else
						{
							bFailed = true;
							break;
						}
						if (tempShort+1 < nFileLength)
						{
							if ((tempShort <= i || tempShort >= i+0x3000) && tempShort != 0)
								bFailed = true;
						}
					}
				}
				if (!bFailed)
				{
					NinSnesSeq* newSeq = new NinSnesSeq(file, i);
					newSeq->LoadVGMFile();
					i += m;
				}
			}
		}
	}
}