﻿'-----NDS Save Converter Plugin Template -----
'       7/24/11
'       http://www.uniquegeeks.net/
'       This solution is a template of a plugin for the NDS Save File Converter, by Unique Geeks Media
'       After compilation, put the output dlls (This one and the interface) in the "Plugins" folder in the same folder as the Save File Converter
'
'       All you need to change in this file are as follows:
'       MySaveFormat.ToRaw
'       MySaveFormat.ToType
'       SaveFormatCollection.SaveFormats, on output.add
Public Class SaveFormatCollection
    Implements SaveFormatInterface.Interfaces.SaveFormatCollection
    ''' <summary>
    ''' Returns a list of save formats, all to be added to the main form
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property SaveFormats As System.Collections.Generic.List(Of SaveFormatInterface.Interfaces.SaveFormat) Implements SaveFormatInterface.Interfaces.SaveFormatCollection.SaveFormats
        Get
            Dim output As New Generic.List(Of SaveFormatInterface.Interfaces.SaveFormat)
            output.Add(New MySaveFormat("My Save File Format", "sav", CType({}, Integer())))
            Return output
        End Get
    End Property
End Class
Public Class MySaveFormat
    Implements SaveFormatInterface.Interfaces.SaveFormat
    ''' <summary>
    ''' Specifies whether or not to add this format to the Source Format List
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property CanBeSource As Boolean Implements SaveFormatInterface.Interfaces.SaveFormat.CanBeSource
        Get
            Return True
        End Get
    End Property
    ''' <summary>
    ''' Specifies whether or not to add this format to the Target Format List
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property CanBeTarget As Boolean Implements SaveFormatInterface.Interfaces.SaveFormat.CanBeTarget
        Get
            Return True
        End Get
    End Property
    Dim _extendeddata As String
    ''' <summary>
    ''' Contains Game name, Save name, and Save description if online.
    ''' Will be in format [gamename][ascii 255][savename][ascii 255][savedescription]
    ''' After splitting, replace _y with [ascii 255] and __ with _
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property ExtendedData As String Implements SaveFormatInterface.Interfaces.SaveFormat.ExtendedData
        Get
            Return _extendeddata
        End Get
        Set(ByVal value As String)
            _extendeddata = value
        End Set
    End Property
    Dim _fileextension As String
    ''' <summary>
    ''' Specifies what file extension this format has
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property FileExtension As String Implements SaveFormatInterface.Interfaces.SaveFormat.FileExtension
        Get
            Return _fileextension
        End Get
    End Property
    Dim _filename As String
    ''' <summary>
    ''' Will contain the filename of the file that is being converted, if not online
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property Filename As String Implements SaveFormatInterface.Interfaces.SaveFormat.Filename
        Get
            Return _filename
        End Get
        Set(ByVal value As String)
            _filename = value
        End Set
    End Property
    Dim _filesize As Integer()
    ''' <summary>
    ''' Controls what valid file sizes (in number of bytes) the save format supports.  If just generic multiples of two,
    ''' will be empty, otherwize, will be list of valid sizes.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property FileSize As Integer() Implements SaveFormatInterface.Interfaces.SaveFormat.FileSize
        Get
            Return _filesize
        End Get
    End Property
    Dim _isonline As Boolean
    ''' <summary>
    ''' Specifies whether or not conversion is taking place online or via an offline tool.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property IsOnline As Boolean Implements SaveFormatInterface.Interfaces.SaveFormat.IsOnline
        Get
            Return _isonline
        End Get
        Set(ByVal value As Boolean)
            _isonline = value
        End Set
    End Property
    Dim _name As String
    ''' <summary>
    ''' Display name of the save format.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property Name As String Implements SaveFormatInterface.Interfaces.SaveFormat.Name
        Get
            Return _name
        End Get
    End Property
    ''' <summary>
    ''' Converts a byte array of the save format to a raw save file
    ''' </summary>
    ''' <param name="Type"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ToRaw(ByVal Type() As Byte) As Byte() Implements SaveFormatInterface.Interfaces.SaveFormat.ToRaw
        'Insert your own custom code here

        Return CType({}, Byte()) ' Replace with your output
    End Function

    Public Overrides Function ToString() As String Implements SaveFormatInterface.Interfaces.SaveFormat.ToString
        Return Name
    End Function
    ''' <summary>
    ''' Converts a byte array of a raw save file to this save format
    ''' </summary>
    ''' <param name="RAW"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ToType(ByVal RAW() As Byte) As Byte() Implements SaveFormatInterface.Interfaces.SaveFormat.ToType
        'Insert your own custom code here

        Return CType({}, Byte()) ' Replace with your output
    End Function
    Public Sub New(ByVal Name As String, ByVal FileExtension As String, ByVal FileSize As Integer())
        _name = Name
        _fileextension = FileExtension
        _filesize = FileSize
    End Sub
End Class