﻿using Microsoft.VisualBasic;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
//-----NDS Save Converter Plugin Template -----
//       7/24/11
//       http://www.uniquegeeks.net/
//       This solution is a template of a plugin for the NDS Save File Converter, by Unique Geeks Media
//       After compilation, put the output dlls (This one and the interface) in the "Plugins" folder in the same folder as the Save File Converter
//
//       All you need to change in this file are as follows:
//       MySaveFormat.ToRaw
//       MySaveFormat.ToType
//       SaveFormatCollection.SaveFormats, on output.add
public class SaveFormatCollection : SaveFormatInterface.Interfaces.SaveFormatCollection
{
    /// <summary>
    /// Returns a list of save formats, all to be added to the main form
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public System.Collections.Generic.List<SaveFormatInterface.Interfaces.SaveFormat> SaveFormats
    {
        get {
			System.Collections.Generic.List<SaveFormatInterface.Interfaces.SaveFormat> output = new System.Collections.Generic.List<SaveFormatInterface.Interfaces.SaveFormat>();
			output.Add(new MySaveFormat("My Save File Format", "sav",new int[0]));
			return output;
		}
    }
}
public class MySaveFormat : SaveFormatInterface.Interfaces.SaveFormat
{
    /// <summary>
    /// Specifies whether or not to add this format to the Source Format List
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public bool CanBeSource
    {
        get { return true; }
    }
    /// <summary>
    /// Specifies whether or not to add this format to the Target Format List
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public bool CanBeTarget
    {
        get { return true; }
    }
    string _extendeddata;
    /// <summary>
    /// Contains Game name, Save name, and Save description if online.
    /// Will be in format [gamename][ascii 255][savename][ascii 255][savedescription]
    /// After splitting, replace _y with [ascii 255] and __ with _
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public string ExtendedData
    {
        get { return _extendeddata; }
        set { _extendeddata = value; }
    }
    string _fileextension;
    /// <summary>
    /// Specifies what file extension this format has
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public string FileExtension
    {
        get { return _fileextension; }
    }
    string _filename;
    /// <summary>
    /// Will contain the filename of the file that is being converted, if not online
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public string Filename
    {
        get { return _filename; }
        set { _filename = value; }
    }
    int[] _filesize;
    /// <summary>
    /// Controls what valid file sizes (in number of bytes) the save format supports.  If just generic multiples of two,
    /// will be empty, otherwize, will be list of valid sizes.
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public int[] FileSize
    {
        get { return _filesize; }
    }
    bool _isonline;
    /// <summary>
    /// Specifies whether or not conversion is taking place online or via an offline tool.
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public bool IsOnline
    {
        get { return _isonline; }
        set { _isonline = value; }
    }
    string _name;
    /// <summary>
    /// Display name of the save format.
    /// </summary>
    /// <value></value>
    /// <returns></returns>
    /// <remarks></remarks>
    public string Name
    {
        get { return _name; }
    }
    /// <summary>
    /// Converts a byte array of the save format to a raw save file
    /// </summary>
    /// <param name="Type"></param>
    /// <returns></returns>
    /// <remarks></remarks>
    public byte[] ToRaw(byte[] Type)
	{
		//Insert your own custom code here

        return new byte[0];
		// Replace with your output
	}

    public override string ToString()
    {
        return Name;
    }
    /// <summary>
    /// Converts a byte array of a raw save file to this save format
    /// </summary>
    /// <param name="RAW"></param>
    /// <returns></returns>
    /// <remarks></remarks>
    public byte[] ToType(byte[] RAW)
	{
		//Insert your own custom code here

        return new byte[0];
		// Replace with your output
	}
    public MySaveFormat(string Name, string FileExtension, int[] FileSize)
    {
        _name = Name;
        _fileextension = FileExtension;
        _filesize = FileSize;
    }
}