/* Max Drive Save Converter
   Copyright (C) 2005 ASk, EVASiON & TheImp

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

*/

#ifndef CONVERT_H
#define CONVERT_H
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

typedef unsigned char byte;

#define SAV_HEADER  "DATELGC_SAVE"
#define SAV_HEADER2  "GCSAVE"
#define SAV_HEADER_LENGTH   0x80
#define SAV_HEADER_LENGTH2  0x110

#ifdef WIN32
#define snprintf _snprintf
#else
#define snprintf snprintf
#endif


#define SWAP(a,b)           \
    {                       \
        byte temp = a;      \
        a = b;              \
        b = temp;           \
    }


void usage();

byte* gci2sav(byte *, int buflen);
byte* sav2gci(byte *, int buflen);
byte* gcs2gci(byte *, int buflen);
byte* gci2gcs(byte *, int buflen);

int is_big_endian();

#endif
