/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import util.Common;
import util.struct.CPalette;
import util.struct.DPalette;
import util.struct.DPath;

public class UsentiClrx
extends DPalette {
    public UsentiClrx(DPath path) {
        super(path);
    }

    public void open() {
        byte[] data = this.getPath().read();
        String[] lines = Common.getString(data, 0, data.length).split("\r\n");
        String[] header = lines[0].split(" ");
        int bitDepth = Integer.parseInt(header[1]);
        int colorCount = Integer.parseInt(header[2]);
        int[] colors = new int[colorCount];
        for (int i = 1; i < lines.length; ++i) {
            Common.msg(lines[i] + " | " + lines[i].length());
            String[] blocks = lines[i].split(" ");
            for (int j = 0; j < blocks.length; ++j) {
                int color = Integer.parseInt(blocks[j].substring(2), 16);
                colors[(i - 1) * 4 + j] = color = CPalette.decodeColor(color, CPalette.XBGR8888);
            }
        }
        this.add(new CPalette(colors));
    }

    public void save(DPalette data) {
        Common.msg("Save as Usenti Palette: " + data);
        String buffer = "";
        int colorCount = 0;
        int count = 0;
        for (CPalette pal : data.getPalettes()) {
            colorCount += pal.getColorCount();
            for (int color : pal.getColors()) {
                color = CPalette.encodeColor(color, CPalette.XBGR8888);
                buffer = buffer + "0x" + Common.getHex(color, 4);
                buffer = ++count % 4 == 0 ? buffer + "\r\n" : buffer + " ";
            }
        }
        this.getPath().empty();
        this.getPath().write(("CLRX 8 " + colorCount + "\r\n").getBytes());
        this.getPath().write(buffer.getBytes());
    }
}

