/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import util.Common;
import util.gui.panels.CComboBoxModel;
import util.struct.DArchive;
import util.struct.DFile;
import util.struct.DPath;
import util.struct.formats.NitroNarc;

public class NitroRom
extends DArchive {
    private static final String[] cardRange = new String[]{"1 MBit", "2 MBit", "4 MBit", "8 MBit", "16 MBit", "32 MBit", "64 MBit", "128 MBit", "256 MBit", "512 MBit", "1024 Mbit", "2048 Mbit"};

    public NitroRom(DPath path) {
        super(path);
    }

    public void open() {
        byte[] data = this.getPath().read(0L, 512L);
        String gameTitle = Common.getString(data, 0, 12);
        String gameCode = Common.getString(data, 12, 4);
        String makerCode = Common.getString(data, 16, 2);
        int unitCode = Common.getInt(data, 18, 1);
        int deviceCode = Common.getInt(data, 19, 1);
        int cardSize = Common.getInt(data, 20, 1);
        byte[] cardInfo = Common.getBytes(data, 21, 10);
        int flags = Common.getInt(data, 31, 1);
        int arm9Source = Common.getInt(data, 32, 4);
        int arm9ExeAddr = Common.getInt(data, 36, 4);
        int arm9CopyAddr = Common.getInt(data, 40, 4);
        int arm9Size = Common.getInt(data, 44, 4);
        int arm7Source = Common.getInt(data, 48, 4);
        int arm7ExeAddr = Common.getInt(data, 52, 4);
        int arm7CopyAddr = Common.getInt(data, 56, 4);
        int arm7Size = Common.getInt(data, 60, 4);
        int fntOffset = Common.getInt(data, 64, 4);
        int fntSize = Common.getInt(data, 68, 4);
        int fatOffset = Common.getInt(data, 72, 4);
        int fatSize = Common.getInt(data, 76, 4);
        int arm9OvrSource = Common.getInt(data, 80, 4);
        int arm9OvrSize = Common.getInt(data, 84, 4);
        int arm7OvrSource = Common.getInt(data, 88, 4);
        int arm7OvrSize = Common.getInt(data, 92, 4);
        int ctrlReadFlag = Common.getInt(data, 96, 4);
        int ctrlInitFlag = Common.getInt(data, 100, 4);
        int ndsHdrSource = Common.getInt(data, 104, 4);
        int crc16 = Common.getInt(data, 108, 2);
        int romTimeOut = Common.getInt(data, 110, 2);
        int arm9UnkAddr = Common.getInt(data, 112, 4);
        int arm7UnkAddr = Common.getInt(data, 116, 4);
        byte[] unencryptMode = Common.getBytes(data, 120, 8);
        int romSize = Common.getInt(data, 128, 4);
        int headerSize = Common.getInt(data, 132, 4);
        byte[] unknown = Common.getBytes(data, 136, 56);
        byte[] gbaLogo = Common.getBytes(data, 192, 156);
        int logoCrc16 = Common.getInt(data, 348, 2);
        int headerCrc16 = Common.getInt(data, 350, 2);
        byte[] reserved = Common.getBytes(data, 352, 160);
        this.getModel().addRow("Game Title", gameTitle, false);
        this.getModel().addRow("Game Code", gameCode, false);
        this.getModel().addRow("Maker Code", makerCode, false);
        this.getModel().addRow("Unit Code", unitCode, false);
        this.getModel().addRow("Device Code", deviceCode, false);
        this.getModel().addRow("Card Size", new CComboBoxModel(cardRange, cardRange[cardSize]), false);
        Common.msg("Game Title: " + gameTitle + " | Code: " + gameCode + " | Maker: " + makerCode + " | Unit: " + unitCode + " | Device: " + deviceCode + " | Card Size: " + cardSize + " | Card Info: " + Common.getHex(cardInfo) + " | Flags: " + flags);
        Common.msg("ARM9 Source: " + Common.getHex(arm9Source, 2) + " | Exe: " + Common.getHex(arm9ExeAddr, 4) + " | Copy: " + Common.getHex(arm9CopyAddr, 4) + " | Size: " + arm9Size);
        Common.msg("ARM7 Source: " + Common.getHex(arm7Source, 2) + " | Exe: " + Common.getHex(arm7ExeAddr, 4) + " | Copy: " + Common.getHex(arm7CopyAddr, 4) + " | Size: " + arm7Size);
        Common.msg("FNT Offset: " + Common.getHex(fntOffset, 2) + " | Size: " + fntSize);
        Common.msg("FAT Offset: " + Common.getHex(fatOffset, 2) + " | Size: " + fatSize);
        Common.msg("ARM9Overlay Source: " + Common.getHex(arm9OvrSource, 2) + " | Size: " + Common.getHex(arm9OvrSize, 2));
        Common.msg("ARM7Overlay Source: " + Common.getHex(arm7OvrSource, 2) + " | Size: " + Common.getHex(arm7OvrSize, 2));
        Common.msg("Control register flags for read: " + ctrlReadFlag);
        Common.msg("Control register flags for init: " + ctrlInitFlag);
        Common.msg("Icon+Tiles Offset: " + Common.getHex(ndsHdrSource, 2));
        Common.msg("CRC16: " + Common.getHex(crc16, 2));
        Common.msg("ROM Timeout: " + romTimeOut);
        Common.msg("ARM9 Unknown: " + Common.getHex(arm9UnkAddr, 2));
        Common.msg("ARM7 Unknown: " + Common.getHex(arm7UnkAddr, 2));
        Common.msg("UnencrptMode: " + Common.getHex(unencryptMode));
        Common.msg("ROM Size: " + Common.getHex(romSize, 2));
        Common.msg("Header Size: " + Common.getHex(headerSize, 2));
        Common.msg("Unknown: " + Common.getHex(unknown));
        Common.msg("Logo CRC16: " + Common.getHex(logoCrc16, 2));
        Common.msg("Header CRC16: " + Common.getHex(headerCrc16, 2));
        ArrayList<DFile> root = new ArrayList<DFile>();
        root.add(new DFile("header", 0L, headerSize));
        root.add(new DFile("arm9", arm9Source, arm9Size));
        root.add(new DFile("arm7", arm7Source, arm7Size));
        root.add(new DFile("banner", ndsHdrSource, 2112L));
        DPath contents = new DPath(this.getPath(), new DFile("contents"));
        contents.getFile().setReference(1);
        root.add(contents.getFile());
        this.addFolder(0, this.getPath(), root);
        ArrayList<DPath> dirPaths = new ArrayList<DPath>();
        dirPaths.add(this.getPath());
        dirPaths.add(contents);
        int[][] fatTable = NitroNarc.readFATB(this.getPath().read(fatOffset, fatSize));
        NitroNarc.readFNTB(this, dirPaths, this.getPath().read(fntOffset, fntSize), fatTable, 0);
    }
}

