/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.awt.Dimension;
import java.util.ArrayList;
import util.Common;
import util.struct.CCell;
import util.struct.CCellOAM;
import util.struct.DCell;
import util.struct.DPath;
import util.struct.formats.Nitro;

public class NitroNcer
extends DCell {
    private int tileShift;
    private ArrayList<String> labels;

    public NitroNcer(DPath path) {
        super(path);
    }

    public void open() {
        Nitro blocks = new Nitro(this.getPath());
        byte[] data = blocks.getBlockData("KBEC");
        this.labels = blocks.getLabels();
        int cellCount = Common.getInt(data, 8, 2);
        int extendedCells = Common.getInt(data, 10, 2);
        int cellDataOffset = Common.getInt(data, 12, 4);
        int flags = Common.getInt(data, 16, 4);
        int partitionDataOffset = Common.getInt(data, 20, 4);
        int padding = Common.getInt(data, 24, 4);
        int padding2 = Common.getInt(data, 28, 4);
        if (flags > 4) {
            Common.error("Cell Flags: " + flags);
        }
        if (padding != 0) {
            Common.error("Padding: " + padding);
        }
        if (padding2 != 0) {
            Common.error("Padding2: " + padding2);
        }
        this.tileShift = flags & 3;
        this.setSubImage((flags & 4) != 0);
        this.getModel().addRow("Cells", cellCount, false);
        this.getModel().addRow("Extended", extendedCells == 1, false);
        this.getModel().addRow("Tile Shift", this.tileShift, false);
        this.getModel().addRow("Sub Image", this.isSubImage(), false);
        this.getModel().addRow("Partition Offset", partitionDataOffset, false);
        if (extendedCells == 0) {
            this.readCells(data, cellDataOffset + 8, cellCount);
        } else {
            this.readExCells(data, cellDataOffset + 8, cellCount, partitionDataOffset + 8);
        }
        this.getModel().addRow("Labels", this.labels.size(), false);
        blocks.readUEXT(this);
    }

    private void readCells(byte[] data, int cellDataOffset, int cellCount) {
        for (int i = 0; i < cellCount; ++i) {
            CCell cell = new CCell();
            int jump = cellDataOffset + i * 8;
            int oamCount = Common.getInt(data, jump, 2);
            int unknown = Common.getInt(data, jump + 2, 2);
            int oamOffset = Common.getInt(data, jump + 4, 4);
            Common.line();
            Common.msg("Cell #" + i + " | # OAMs: " + oamCount + " | Unknown: " + unknown + " | OAM Offset: 0x" + Common.getHex(oamOffset, 2));
            Common.line();
            if (i < this.labels.size()) {
                cell.setName(this.labels.get(i));
            }
            cell.getModel().addRow("Unknown", unknown);
            for (int j = 0; j < oamCount; ++j) {
                byte[] oamData = Common.getBytes(data, cellDataOffset + cellCount * 8 + oamOffset + j * 6, 6);
                int shift = 1;
                if (!this.isSubImage()) {
                    shift = 64 << this.tileShift;
                }
                CCellOAM oam = this.readOAM(j, oamData, shift, 0);
                oam.setTileOffset(oam.getTileOffset());
                cell.add(oam);
            }
            this.add(cell);
        }
    }

    private void readExCells(byte[] data, int cellDataOffset, int cellCount, int partitionDataOffset) {
        int maxPartitionSize = Common.getInt(data, partitionDataOffset, 4);
        int partitionHeaderSize = Common.getInt(data, partitionDataOffset, 4);
        Common.msg("Partition Offset: " + Common.getHex(partitionDataOffset, 2) + " | MaxSize: " + maxPartitionSize + " | HeaderSize: " + partitionHeaderSize);
        for (int i = 0; i < cellCount; ++i) {
            CCell cell = new CCell();
            int jump = cellDataOffset + i * 16;
            int oamCount = Common.getInt(data, jump, 2);
            int unknown = Common.getInt(data, jump + 2, 2);
            int oamOffset = Common.getInt(data, jump + 4, 4);
            int xmax = Common.getSign(data, jump + 8, 2);
            int ymax = Common.getSign(data, jump + 10, 2);
            int xmin = Common.getSign(data, jump + 12, 2);
            int ymin = Common.getSign(data, jump + 14, 2);
            int partitionOffset = partitionDataOffset + 8 + i * 8;
            int partitionStart = 0;
            int partitionLength = 0;
            if (partitionDataOffset > 8) {
                partitionStart = Common.getInt(data, partitionOffset, 4);
                partitionLength = Common.getInt(data, partitionOffset + 4, 4);
            }
            Common.line();
            Common.msg("Cell #" + i + " | # OAMs: " + oamCount + " | Unknown: " + unknown + " | OAM Offset: 0x" + Common.getHex(oamOffset, 2) + " | X: " + Common.padLeft(xmin, 3) + " | Y: " + Common.padLeft(ymin, 3) + " | X2: " + Common.padLeft(xmax, 3) + " | Y2: " + Common.padLeft(ymax, 3) + " | Partition Start: " + Common.getHex(partitionStart, 2) + " | Length: " + partitionLength);
            Common.line();
            if (i < this.labels.size()) {
                cell.setName(this.labels.get(i));
            }
            cell.getModel().addRow("Unknown", unknown);
            cell.getModel().addRow("xMax", xmax);
            cell.getModel().addRow("yMax", ymax);
            cell.getModel().addRow("xMin", xmin);
            cell.getModel().addRow("yMin", ymin);
            for (int j = 0; j < oamCount; ++j) {
                byte[] oamData = Common.getBytes(data, cellDataOffset + cellCount * 16 + oamOffset + j * 6, 6);
                CCellOAM oam = this.readOAM(j, oamData, 64 << this.tileShift, partitionStart);
                cell.add(oam);
            }
            this.add(cell);
        }
    }

    private CCellOAM readOAM(int index, byte[] data, int tileShift, int partitionStart) {
        CCellOAM oam = new CCellOAM();
        int attr0 = Common.getInt(data, 0, 2);
        int attr1 = Common.getInt(data, 2, 2);
        int attr2 = Common.getInt(data, 4, 2);
        int y = Common.getSign(attr0 & 0xFF, 1);
        int hflag = attr0 >> 8 & 1;
        int gflag = attr0 >> 9 & 1;
        int objMode = attr0 >> 10 & 3;
        int mosiacFlag = attr0 >> 12 & 1;
        int colorDepth = attr0 >> 13 & 1;
        int objShape = attr0 >> 14 & 3;
        int x = attr1 & 0x1FF;
        if (x >= 256) {
            x -= 512;
        }
        int unused = attr1 >> 9 & 7;
        int hflip = attr1 >> 12 & 1;
        int vflip = attr1 >> 13 & 1;
        int objSize = attr1 >> 14 & 3;
        int tileIndex = attr2 & 0x3FF;
        int priority = attr2 >> 10 & 3;
        int palIndex = attr2 >> 12 & 0xF;
        Dimension size = this.getShapeSize(objShape, objSize);
        tileShift >>= colorDepth;
        if (gflag == 1) {
            x += size.width / 2;
            y += size.height / 2;
        }
        Common.msg(" -> OAM #" + Common.padNum(index, 2) + " | X: " + Common.padLeft(x, 3) + " | Y: " + Common.padLeft(y, 3) + " | " + Common.padNum(size.width, 2) + "x" + Common.padNum(size.height, 2) + " | HFlag: " + hflag + " | GFlag: " + gflag + " | OBJMode: " + objMode + " | MosiacFlag: " + mosiacFlag + " | ColorDepth: " + colorDepth + " | Unused: " + unused + " | Flip: " + hflip + "x" + vflip + " | Tile: " + tileIndex + "(" + tileIndex * tileShift + ")" + " | Priority: " + priority + " | Pal: " + palIndex + "(" + palIndex * 16 + ")");
        oam.setLocation(x, y);
        oam.setSize(size);
        oam.setPaletteOffset(palIndex * 16);
        oam.setTileOffset(partitionStart * (2 >> colorDepth) + tileIndex * tileShift);
        oam.setMirrorX(hflip == 1);
        oam.setMirrorY(vflip == 1);
        return oam;
    }

    private String getShapeName(int shape) {
        switch (shape) {
            case 0: {
                return "Square";
            }
            case 1: {
                return "Horizontal";
            }
            case 2: {
                return "Vertical";
            }
        }
        return "Invalid";
    }

    private Dimension getShapeSize(int objShape, int objSize) {
        int[][] table = new int[][]{{8, 8}, {16, 16}, {32, 32}, {64, 64}, {16, 8}, {32, 8}, {32, 16}, {64, 32}, {8, 16}, {8, 32}, {16, 32}, {32, 64}};
        int row = objShape * 4 + objSize;
        return new Dimension(table[row][0], table[row][1]);
    }

    private CCellOAM readOAM2(int index, byte[] data) {
        CCellOAM oam = new CCellOAM();
        int y = Common.getSign(data, 0, 1);
        int xflags = Common.getInt(data, 1, 1);
        int width = xflags >> 6 & 3;
        int vu1 = xflags >> 2 & 3;
        int vu2 = xflags >> 4 & 3;
        int vflag = xflags & 3;
        int x = Common.getSign(data, 2, 1);
        int yflags = Common.getInt(data, 3, 1);
        int height = yflags >> 6 & 3;
        int ymirror = yflags >> 5 & 1;
        int xmirror = yflags >> 4 & 1;
        int hu1 = yflags >> 2 & 3;
        int hflag = yflags & 3;
        Dimension size = this.getSize(width, height);
        int offsets = Common.getInt(data, 4, 2);
        int tileOffset = offsets & 0x7FF;
        int palOffset = offsets >> 11 & 0xF;
        int x2 = 0;
        int y2 = 0;
        if (vflag == 0) {
            if (x >= 64 && hflag == 1) {
                x2 -= 256;
            }
            if (x <= -64 && hflag == 0) {
                x2 += 256;
            }
        }
        if (vflag == 3) {
            // empty if block
        }
        oam.setLocation(x + x2, y + y2);
        oam.setSize(size);
        oam.setPaletteOffset(palOffset * 8);
        oam.setTileOffset(tileOffset << this.tileShift);
        oam.setMirrorX(xmirror == 1);
        oam.setMirrorY(ymirror == 1);
        Common.msg(" -> OAM #" + Common.padNum(index, 2) + " | X: " + Common.padLeft(x, 3) + " | Y: " + Common.padLeft(y, 3) + " | " + Common.padNum(size.width, 2) + "x" + Common.padNum(size.height, 2) + " | " + width + " | " + height + " | Flip: " + xmirror + " x " + ymirror + " | V1: " + vu1 + " | V2: " + vu2 + " | VFlag: " + vflag + " | H1: " + hu1 + " | HFlag: " + hflag + " | Tile: " + Common.getHex(tileOffset, 2) + " (" + Common.getHex(oam.getTileOffset(), 2) + ")" + " | Pal: " + Common.getHex(palOffset, 2));
        return oam;
    }

    private Dimension getSize(int width, int height) {
        int[][] table = new int[][]{{8, 8}, {16, 16}, {32, 32}, {64, 64}, {16, 8}, {32, 8}, {32, 16}, {64, 32}, {8, 16}, {8, 32}, {16, 32}, {32, 64}};
        int row = width * 4 + height;
        return new Dimension(table[row][0], table[row][1]);
    }
}

