/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import java.util.ArrayList;
import util.CIcon;
import util.Common;
import util.Plugin;
import util.gui.panels.CTableModel;
import util.struct.DPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DFormat {
    public static final String FIELD_BANKS = "Banks";
    public static final int NONE = 0;
    public static final int ARCHIVE = 3;
    public static final int PALETTE = 5;
    public static final int TILE = 6;
    public static final int CELL = 7;
    public static final int ANIM = 8;
    public static final int MAP = 9;
    public static final int IMAGE = 20;
    public static final int MAP_CELL = 50;
    public static final int MAP_ANIM = 51;
    public static final int BIT4 = 4;
    public static final int BIT8 = 8;
    private DPath path;
    private CTableModel model;

    public DFormat(DPath path) {
        this.path = path;
        this.checkModel();
    }

    public DPath getPath() {
        return this.path;
    }

    public int getType() {
        return 0;
    }

    public CIcon getIcon() {
        return this.path.getPlugin().getIcon();
    }

    public final ArrayList<Plugin> getPlugins() {
        return Plugin.get(this.getType());
    }

    public String getName() {
        switch (this.getType()) {
            case 3: {
                return "Archives";
            }
            case 5: {
                return "Palettes";
            }
            case 6: {
                return "Tiled";
            }
            case 7: {
                return "Sprites";
            }
            case 8: {
                return "Sprite Animations";
            }
            case 9: {
                return "Maps";
            }
            case 50: {
                return "Mapped Cell";
            }
            case 51: {
                return "Mapped Animation";
            }
            case 20: {
                return "Image";
            }
        }
        return "Unknown";
    }

    public String toString() {
        return this.getPath().getFile().getFullName();
    }

    public void open() {
    }

    private void checkModel() {
        this.model = new CTableModel("Format Information");
        this.model.addRow("Type", this.getName(), false);
    }

    public CTableModel getModel() {
        return this.model;
    }

    public void save(DFormat source) {
        Common.msg("Save: " + source.getPath());
    }
}

