/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import java.io.File;
import java.util.ArrayList;
import util.Common;
import util.FileAccess;
import util.gui.COptionPane;
import util.struct.CArchiveFolder;
import util.struct.DFile;
import util.struct.DFormat;
import util.struct.DPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DArchive
extends DFormat {
    public static final int CANCEL = 0;
    public static final int DECOMPRESSED = 1;
    public static final int COMPRESSED = 2;
    public static final int SKIP = 3;
    private ArrayList<CArchiveFolder> folders = new ArrayList();
    private int decompMode;
    private boolean prompt;

    public DArchive(DPath path) {
        super(path);
        this.resetSettings();
    }

    @Override
    public int getType() {
        return 3;
    }

    public void addFolder(int id, DPath path) {
        this.addFolder(id, path, new ArrayList<DFile>());
    }

    public void addFolder(int id, DPath path, ArrayList<DFile> folder) {
        this.folders.add(new CArchiveFolder(id, path, folder));
    }

    public void addFile(int id, DFile file) {
        boolean added = false;
        for (CArchiveFolder folder : this.folders) {
            if (folder.getId() != id) continue;
            folder.add(file);
            added = true;
        }
        if (!added) {
            Common.msg("Cannot Add File to Folder!! " + file.getFullName());
        }
    }

    public ArrayList<CArchiveFolder> getContents() {
        return this.folders;
    }

    public CArchiveFolder getFolder(int index) {
        return this.folders.get(index);
    }

    public int getFolderCount() {
        return this.folders.size();
    }

    public void resetSettings() {
        this.prompt = true;
        this.decompMode = 1;
    }

    public void extractFolder(String saveFolder, CArchiveFolder folder, int optionType) {
        File dir = new File(saveFolder);
        if (this.decompMode != 0) {
            if (dir.mkdir() || dir.exists()) {
                for (DPath path : folder.getPaths()) {
                    if (path.getFile().isFile()) {
                        this.extractFile(saveFolder, path, optionType);
                        if (this.decompMode != 0) continue;
                        break;
                    }
                    this.extractFolder(saveFolder + "\\" + path.getFile().getName(), this.getFolder(path.getFile().getReference()), optionType);
                }
            } else {
                Common.msg("Failed to create folder..." + saveFolder);
            }
        }
    }

    public void extractFile(String saveFolder, DPath path, int optionType) {
        byte[] data = null;
        if (!path.isChecked()) {
            path.check();
        }
        if (path.getFile().isCompressed()) {
            this.decompMode = this.extractMode(path, optionType);
        }
        switch (this.decompMode) {
            case 1: {
                data = path.read();
                break;
            }
            case 2: {
                data = path.read(false);
            }
        }
        if (data != null) {
            FileAccess.write(saveFolder + "\\" + path.getFile().getFullName(), data);
        }
    }

    public int extractMode(DPath path, int optionType) {
        int decomp = this.decompMode;
        if (this.prompt) {
            String message = "The file '" + path.getFile().getFullName() + "' appears to be compressed.";
            message = message + "\nWhat action should be taken?";
            String[] options = new String[]{"Decompress", "Leave Compressed"};
            int mode = COptionPane.showDialog(message, "Extract File", options, optionType);
            this.prompt = (mode & 0x10) == 0;
            decomp = mode & 0xF;
        }
        return decomp;
    }
}

