/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import util.struct.CBank;
import util.struct.CPalette;

public class CGraphic
extends CBank {
    public static final int PALETTE_ERROR = -16711936;
    public static final int IMAGE_ERROR = -16776961;
    private int[] pixels;
    private int bitDepth;
    private int tiled;
    private int partitioned;
    private Dimension size;
    private Dimension tileSize;

    public CGraphic(int[] pixels, int bitDepth, Dimension size, int tiled, Dimension tileSize) {
        this(pixels, bitDepth, size, tiled, 0, tileSize);
    }

    public CGraphic(int[] pixels, int bitDepth, Dimension size, int tiled, int partitioned, Dimension tileSize) {
        this.pixels = pixels;
        this.bitDepth = bitDepth;
        this.size = size;
        this.tiled = tiled;
        this.partitioned = partitioned;
        this.tileSize = tileSize;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void setDepth(int bitDepth) {
        this.bitDepth = bitDepth;
    }

    public int getDepth() {
        return this.bitDepth;
    }

    public static BufferedImage newImage(Dimension size) {
        return CGraphic.newImage(size.width, size.height);
    }

    public static BufferedImage newImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image.setRGB(x, y, -16776961);
            }
        }
        return image;
    }

    public BufferedImage getImage(int[] colors) {
        return this.getImage(colors, false);
    }

    public BufferedImage getImage(int[] colors, boolean alpha) {
        return this.getImage(colors, this.pixels, 0, this.size.width, this.size.height, alpha);
    }

    public BufferedImage getImage(int[] colors, int[] pixels, int offset, int width, int height, boolean alpha) {
        BufferedImage image = CGraphic.newImage(width, height);
        switch (this.tiled) {
            case 0: {
                int divider = 256;
                if (width < 256) {
                    divider = 64;
                }
                int col = (int)Math.ceil((double)width / (double)divider);
                int row = (int)Math.ceil((double)height / (double)divider);
                int twidth = width;
                int theight = height;
                for (int y = 0; y < row; ++y) {
                    int th = divider;
                    if (theight < th) {
                        th = theight;
                    }
                    for (int x = 0; x < col; ++x) {
                        int tw = divider;
                        if (twidth < tw) {
                            tw = twidth;
                        }
                        BufferedImage tile = this.drawTile(colors, pixels, offset, new Dimension(tw, th), this.tileSize, alpha);
                        for (int ty = 0; ty < tile.getHeight(); ++ty) {
                            for (int tx = 0; tx < tile.getWidth(); ++tx) {
                                image.setRGB(x * divider + tx, y * divider + ty, tile.getRGB(tx, ty));
                            }
                        }
                        offset += tw * th;
                        twidth -= tw;
                    }
                    twidth = width;
                    theight -= th;
                }
                break;
            }
            case 1: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        int color = -16776961;
                        int pixelIndex = offset + y * width + x;
                        if (pixelIndex < pixels.length) {
                            color = -16711936;
                            int colorIndex = pixels[pixelIndex];
                            if (colorIndex >= 0 && colorIndex < colors.length) {
                                color = colors[colorIndex];
                            }
                            if (colorIndex == 0 && alpha) {
                                color &= 0xFFFFFF;
                            }
                        }
                        image.setRGB(x, y, color);
                    }
                }
                break;
            }
        }
        return image;
    }

    public BufferedImage getTile(CPalette palette, int palOffset, int tileOffset, int width, int height, boolean subImage, boolean alpha) {
        int[] colors = palette.getColors();
        if (this.getDepth() == 4) {
            colors = palette.getColors(palOffset);
        }
        return this.getTile(colors, tileOffset, width, height, subImage, alpha);
    }

    public BufferedImage getTile(int[] colors, int offset, int width, int height, boolean subImage, boolean alpha) {
        BufferedImage image = CGraphic.newImage(width, height);
        switch (this.tiled) {
            case 0: {
                image = this.getImage(colors, this.pixels, offset, width, height, alpha);
                break;
            }
            case 1: {
                if (!subImage) {
                    if (this.partitioned != 1 || this.bitDepth == 4) {
                        // empty if block
                    }
                    image = this.getImage(colors, this.pixels, offset, width, height, alpha);
                    break;
                }
                int x = offset & 0x1F;
                int y = offset >> 5 & 0x1F;
                Rectangle rect = new Rectangle(x * 8, y * 8, width, height);
                try {
                    image = this.getImage(colors, alpha).getSubimage(rect.x, rect.y, rect.width, rect.height);
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return image;
    }

    private BufferedImage drawTile(int[] colors, int[] pixels, int offset, Dimension size, Dimension tileSize, boolean alpha) {
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        int pos = 0;
        for (int ty = 0; ty < size.height / tileSize.height; ++ty) {
            for (int tx = 0; tx < size.width / tileSize.width; ++tx) {
                for (int y = 0; y < tileSize.height; ++y) {
                    for (int x = 0; x < tileSize.width; ++x) {
                        int pixelIndex = offset + pos;
                        int color = -16776961;
                        if (pixelIndex < pixels.length) {
                            int colorIndex = pixels[pixelIndex];
                            color = -16711936;
                            if (colorIndex >= 0 && colorIndex < colors.length) {
                                color = colors[colorIndex];
                            }
                            if (colorIndex == 0 && alpha) {
                                color &= 0xFFFFFF;
                            }
                        }
                        image.setRGB(tx * tileSize.width + x, ty * tileSize.height + y, color);
                        ++pos;
                    }
                }
            }
        }
        return image;
    }

    public static BufferedImage mirrorImage(BufferedImage image, boolean mirrorx, boolean mirrory) {
        int color2;
        int color1;
        int x;
        int y;
        if (mirrorx) {
            for (y = 0; y < image.getHeight(); ++y) {
                for (x = 0; x < image.getWidth() / 2; ++x) {
                    int x2 = image.getWidth() - x - 1;
                    color1 = image.getRGB(x, y);
                    color2 = image.getRGB(x2, y);
                    image.setRGB(x2, y, color1);
                    image.setRGB(x, y, color2);
                }
            }
        }
        if (mirrory) {
            for (y = 0; y < image.getHeight() / 2; ++y) {
                for (x = 0; x < image.getWidth(); ++x) {
                    int y2 = image.getHeight() - y - 1;
                    color1 = image.getRGB(x, y);
                    color2 = image.getRGB(x, y2);
                    image.setRGB(x, y2, color1);
                    image.setRGB(x, y, color2);
                }
            }
        }
        return image;
    }
}

