/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.BufferedImage;
import util.Common;
import util.struct.CBankItem;
import util.struct.CCellBuffer;
import util.struct.CGraphic;
import util.struct.CPalette;

public class CCellOAM
extends CBankItem {
    private Dimension size;
    private Point pos;
    private int palOffset;
    private int tileOffset;
    private boolean mirrorX;
    private boolean mirrorY;

    public BufferedImage getImage(CPalette palette, CGraphic tile, boolean subImage, boolean alpha) {
        BufferedImage image = new BufferedImage(this.size.width, this.size.height, 2);
        image = tile.getTile(palette, this.getPaletteOffset(), this.getTileOffset(), this.size.width, this.size.height, subImage, alpha);
        image = CGraphic.mirrorImage(image, this.isMirrorX(), this.isMirrorY());
        return image;
    }

    public CCellBuffer getBuffer(CPalette palette, CGraphic image, boolean subImage, boolean alpha) {
        return new CCellBuffer(palette, image, this, subImage, alpha);
    }

    public BufferedImage getOutline() {
        BufferedImage outline = new BufferedImage(this.size.width + 1, this.size.height + 1, 2);
        Graphics g = outline.getGraphics();
        String text = Common.padNum(this.getIndex(), 2);
        g.setColor(new Color(0, 0, 0));
        g.drawRect(0, 0, this.getWidth(), this.getHeight());
        g.setFont(new Font("Tahoma", 0, 10));
        g.drawString(text, this.getWidth() / 2 - 4, this.getHeight() / 2 + 4);
        return outline;
    }

    public void setSize(Dimension size) {
        this.size = size;
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public void setLocation(int x, int y) {
        this.pos = new Point(x, y);
    }

    public Point getLocation() {
        return this.pos;
    }

    public int getX() {
        return this.pos.x;
    }

    public int getY() {
        return this.pos.y;
    }

    public void setPaletteOffset(int palOffset) {
        this.palOffset = palOffset;
    }

    public int getPaletteOffset() {
        return this.palOffset;
    }

    public void setTileOffset(int tileOffset) {
        this.tileOffset = tileOffset;
    }

    public int getTileOffset() {
        return this.tileOffset;
    }

    public void setMirrorX(boolean mirrorX) {
        this.mirrorX = mirrorX;
    }

    public void setMirrorY(boolean mirrorY) {
        this.mirrorY = mirrorY;
    }

    public boolean isMirrorX() {
        return this.mirrorX;
    }

    public boolean isMirrorY() {
        return this.mirrorY;
    }
}

