/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import util.Common;
import util.struct.CCell;
import util.struct.CCellOAM;
import util.struct.CGraphic;
import util.struct.CPalette;

public class CCellBuffer {
    private BufferedImage bufferedImage;
    private BufferedImage outlineImage;
    private Rectangle bounds;

    public CCellBuffer(int frameIndex) {
        this.bufferedImage = new BufferedImage(64, 64, 2);
        this.outlineImage = new BufferedImage(64, 64, 2);
        Graphics g = this.bufferedImage.getGraphics();
        g.setFont(new Font("Tahoma", 0, 10));
        g.setColor(Color.BLACK);
        g.drawString("Cell #" + Common.padNum(frameIndex, 2), 14, 36);
        this.outlineImage.getGraphics().drawImage(this.bufferedImage, 0, 0, null);
        this.bounds = new Rectangle(0, 0, 64, 64);
    }

    public CCellBuffer(BufferedImage image, Point pos) {
        this.bufferedImage = image;
        this.bounds = new Rectangle(pos.x, pos.y, image.getWidth(), image.getHeight());
    }

    public CCellBuffer(CPalette palette, CGraphic image, CCell bank, boolean subImage, boolean alpha, boolean reverseOrder) {
        ArrayList<CCellBuffer> buffer = new ArrayList<CCellBuffer>();
        for (int i = 0; i < bank.getItemCount(); ++i) {
            int index = i;
            if (!reverseOrder) {
                index = bank.getItemCount() - i - 1;
            }
            CCellOAM cell = bank.get(index);
            CCellBuffer c = new CCellBuffer(palette, image, cell, subImage, alpha);
            this.bounds = CCellBuffer.checkBounds(this.bounds, c.getBounds());
            buffer.add(c);
        }
        if (bank.getItemCount() > 0) {
            this.bufferedImage = new BufferedImage(this.bounds.width, this.bounds.height, 2);
            this.outlineImage = new BufferedImage(this.bounds.width + 1, this.bounds.height + 1, 2);
            Graphics g = this.bufferedImage.getGraphics();
            Graphics g2 = this.outlineImage.getGraphics();
            g2.setColor(Color.BLACK);
            g2.drawRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
            for (CCellBuffer c : buffer) {
                int x = this.bounds.x;
                int y = this.bounds.y;
                g.drawImage(c.getImage(), c.getX() - x, c.getY() - y, null);
                g2.drawImage(c.getOutline(), c.getX() - x, c.getY() - y, null);
            }
        } else {
            this.bounds = new Rectangle(0, 0, 64, 64);
            this.bufferedImage = new BufferedImage(64, 64, 2);
            this.outlineImage = new BufferedImage(64, 64, 2);
        }
    }

    public CCellBuffer(CPalette palette, CGraphic image, CCellOAM cell, boolean subImage, boolean alpha) {
        this.bufferedImage = palette != null && image != null ? cell.getImage(palette, image, subImage, alpha) : new BufferedImage(cell.getWidth(), cell.getHeight(), 2);
        this.outlineImage = cell.getOutline();
        this.bounds = new Rectangle(cell.getX(), cell.getY(), cell.getWidth(), cell.getHeight());
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setImage(BufferedImage image) {
        this.bufferedImage = image;
    }

    public void setOutline(BufferedImage outline) {
        this.outlineImage = outline;
    }

    public BufferedImage getImage() {
        return this.bufferedImage;
    }

    public BufferedImage getOutline() {
        return this.outlineImage;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getX() {
        return this.bounds.x;
    }

    public int getY() {
        return this.bounds.y;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public Dimension getSize() {
        return new Dimension(this.bounds.width, this.bounds.height);
    }

    public static Rectangle checkBounds(Rectangle bounds, Rectangle cellBounds) {
        if (bounds == null) {
            bounds = new Rectangle(cellBounds);
        } else {
            int xmin = bounds.x;
            int xmax = bounds.x + bounds.width;
            int ymin = bounds.y;
            int ymax = bounds.y + bounds.height;
            if (cellBounds.x < xmin) {
                xmin = cellBounds.x;
            }
            if (cellBounds.y < ymin) {
                ymin = cellBounds.y;
            }
            if (cellBounds.x + cellBounds.width > xmax) {
                xmax = cellBounds.x + cellBounds.width;
            }
            if (cellBounds.y + cellBounds.height > ymax) {
                ymax = cellBounds.y + cellBounds.height;
            }
            bounds = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
        }
        return bounds;
    }
}

