/*
 * Decompiled with CFR 0.152.
 */
package util.gui.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import util.CProperty;
import util.Common;
import util.TextFilter;
import util.gui.panels.CPanel;

public class CColorPanel
extends CPanel {
    private ColorSwap selected;
    private ColorSwap foreground;
    private ColorSwap background;
    private ColorPane red;
    private ColorPane green;
    private ColorPane blue;
    private JTextField hexText;
    private boolean lock = false;

    public CColorPanel(String name, int dock) {
        this(name, dock, 0, 0);
    }

    public CColorPanel(String name, int dock, int bar) {
        this(name, dock, bar, 0);
    }

    public CColorPanel(String name, int dock, int bar, int group) {
        super(name, dock, bar, group);
        this.setLayout(null);
        this.setMinimumSize(new Dimension(202, 110));
        this.foreground = new ColorSwap("Foreground");
        this.foreground.setLocation(5, 20);
        this.add(this.foreground);
        this.background = new ColorSwap("Background");
        this.background.setLocation(this.foreground.getX() + 16, this.foreground.getY() + 16);
        this.add(this.background);
        this.red = new ColorPane(0);
        this.red.setLocation(55, 5);
        this.add(this.red);
        this.green = new ColorPane(1);
        this.green.setLocation(this.red.getX(), this.red.getY() + this.red.getHeight() + 2);
        this.add(this.green);
        this.blue = new ColorPane(2);
        this.blue.setLocation(this.green.getX(), this.green.getY() + this.green.getHeight() + 2);
        this.add(this.blue);
        JLabel label = new JLabel("#");
        label.setBounds(this.blue.getX(), this.blue.getY() + this.blue.getHeight() + 4, 10, 20);
        this.add(label);
        this.hexText = new JTextField();
        this.hexText.setDocument(new TextFilter("0123456789ABCDEF", 6));
        this.hexText.setBounds(label.getX() + label.getWidth(), label.getY(), 60, label.getHeight());
        this.hexText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CColorPanel.this.setSelected(CColorPanel.this.selected);
            }
        });
        this.hexText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                CColorPanel.this.setSelected(CColorPanel.this.selected);
            }
        });
        this.hexText.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CColorPanel.this.editColor(e.getDocument());
            }

            public void removeUpdate(DocumentEvent e) {
                CColorPanel.this.editColor(e.getDocument());
            }

            public void changedUpdate(DocumentEvent e) {
                CColorPanel.this.editColor(e.getDocument());
            }
        });
        this.add(this.hexText);
        this.setSelected(this.foreground);
    }

    private void setSelected(ColorSwap selected) {
        this.selected = selected;
        Color color = (Color)selected.getProperty().getValue();
        this.red.setValue(color.getRed());
        this.green.setValue(color.getGreen());
        this.blue.setValue(color.getBlue());
        try {
            this.lock = true;
            this.hexText.setText(Common.getHex(color.getRGB(), 3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lock = false;
        this.revalidate();
    }

    private void editColor(Object source) {
        if (!this.lock) {
            int r = 0;
            int g = 0;
            int b = 0;
            if (source instanceof JSlider) {
                r = this.red.getSlider().getValue();
                g = this.green.getSlider().getValue();
                b = this.blue.getSlider().getValue();
            } else if (source instanceof TextFilter) {
                TextFilter filter = (TextFilter)source;
                String string = "";
                try {
                    string = filter.getText(0, filter.getLength());
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
                if (filter.getFilter().equals("0123456789ABCDEF")) {
                    int value = Common.getInt(string, 16);
                    r = value >> 16 & 0xFF;
                    g = value >> 8 & 0xFF;
                    b = value & 0xFF;
                }
                if (filter.getFilter().equals("0123456789")) {
                    int value = Common.getInt(string);
                    r = Common.getInt(this.red.getTextField().getText());
                    g = Common.getInt(this.green.getTextField().getText());
                    b = Common.getInt(this.blue.getTextField().getText());
                    if (this.red.getTextField().getDocument() == filter) {
                        r = value;
                    }
                    if (this.green.getTextField().getDocument() == filter) {
                        g = value;
                    }
                    if (this.blue.getTextField().getDocument() == filter) {
                        b = value;
                    }
                }
            }
            Color oldColor = (Color)this.selected.getProperty().getValue();
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            Color newColor = new Color(r, g, b);
            if (oldColor.getRGB() != newColor.getRGB()) {
                this.selected.getProperty().setValue(newColor);
            }
        }
    }

    private class ColorPane
    extends JLayeredPane {
        public static final int RED = 0;
        public static final int GREEN = 1;
        public static final int BLUE = 2;
        private JLabel label;
        private JSlider slider;
        private JTextField text;
        private int mode;

        public ColorPane(int mode) {
            this.mode = mode;
            this.setSize(142, 24);
            this.label = new JLabel(this.getLetter());
            this.label.setSize(10, this.getHeight());
            this.add(this.label);
            this.slider = new JSlider();
            this.slider.setFocusable(false);
            this.slider.setOpaque(false);
            this.slider.setBounds(this.label.getWidth(), 5, 100, this.getHeight());
            this.slider.setPaintTicks(true);
            this.slider.setMinimum(0);
            this.slider.setMaximum(255);
            this.slider.setValue(0);
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    CColorPanel.this.editColor(e.getSource());
                }
            });
            this.add(this.slider);
            this.text = new JTextField();
            this.text.setDocument(new TextFilter("0123456789", 3));
            this.text.setBounds(this.slider.getX() + this.slider.getWidth(), 2, 32, 20);
            this.text.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CColorPanel.this.setSelected(CColorPanel.this.selected);
                }
            });
            this.text.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    CColorPanel.this.setSelected(CColorPanel.this.selected);
                }
            });
            this.text.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    CColorPanel.this.editColor(e.getDocument());
                }

                public void removeUpdate(DocumentEvent e) {
                    CColorPanel.this.editColor(e.getDocument());
                }

                public void changedUpdate(DocumentEvent e) {
                    CColorPanel.this.editColor(e.getDocument());
                }
            });
            this.add(this.text);
        }

        public String getLetter() {
            switch (this.mode) {
                case 0: {
                    return "R";
                }
                case 1: {
                    return "G";
                }
                case 2: {
                    return "B";
                }
            }
            return "?";
        }

        public void setValue(int value) {
            CColorPanel.this.lock = true;
            this.slider.setValue(value);
            try {
                this.text.setText("" + value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            CColorPanel.this.lock = false;
        }

        public JSlider getSlider() {
            return this.slider;
        }

        public JTextField getTextField() {
            return this.text;
        }
    }

    private class ColorSwap
    extends JPanel {
        public static final String BACKGROUND = "Background";
        public static final String FOREGROUND = "Foreground";
        private CProperty.CPropertyOption property;

        public ColorSwap(String name) {
            this.setSize(28, 28);
            this.setName(name);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    CColorPanel.this.setSelected((ColorSwap)e.getComponent());
                }
            });
            this.property = name.equals(FOREGROUND) ? CProperty.COLOR_FOREGROUND : CProperty.COLOR_BACKGROUND;
            this.property.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ColorSwap.this.setBackground((Color)evt.getNewValue());
                    CColorPanel.this.setSelected(ColorSwap.this.getThis());
                }
            });
            this.setBackground((Color)this.property.getValue());
        }

        private boolean isSelected() {
            return CColorPanel.this.selected == this;
        }

        public String toString() {
            return this.getName() + " #" + Common.getHex(this.getBackground().getRGB(), 3);
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            this.setToolTipText("#" + Common.getHex(color.getRGB(), 3));
        }

        private ColorSwap getThis() {
            return this;
        }

        public CProperty.CPropertyOption getProperty() {
            return this.property;
        }

        public void paintComponent(Graphics g) {
            Color color = new Color(100, 100, 100);
            if (this.isSelected()) {
                color = Color.BLACK;
            }
            g.setColor(color);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(Color.WHITE);
            g.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            g.setColor(this.getBackground());
            g.fillRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
        }
    }
}

