/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import ctool.Loader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import util.CAction;
import util.CIcon;
import util.CImageIcon;
import util.Common;
import util.struct.CArchiveFolder;
import util.struct.DArchive;
import util.struct.DFile;
import util.struct.DFormat;
import util.struct.DPath;

public class FFileTreeRender
extends JScrollPane {
    private FDisplay displayPane = new FDisplay();
    private int lastSelect = -1;

    public FFileTreeRender() {
        this.setViewportView(this.displayPane);
        this.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
        this.setPreferredSize(new Dimension(300, 0));
        this.setMinimumSize(new Dimension(250, 100));
    }

    public void setData(DArchive archive) {
        DefaultMutableTreeNode model = this.drawFolder(archive, 0, archive.getPath());
        ArrayList<TreePath> paths = this.displayPane.getExpandedPaths();
        TreePath selected = this.displayPane.getSelectionPath();
        this.displayPane.setModel(new DefaultTreeModel(model));
        for (TreePath path : paths) {
            this.expandPath(path);
        }
        if (selected != null) {
            this.displayPane.setSelectionRow(this.expandPath(selected));
        } else {
            this.displayPane.expandRow(1);
            this.displayPane.setSelectionRow(0);
        }
    }

    private int expandPath(TreePath path) {
        String targetPath = "[";
        int select = 0;
        for (int i = 0; i < path.getPathCount(); ++i) {
            targetPath = targetPath + path.getPathComponent(i).toString();
            for (int j = 0; j < this.displayPane.getRowCount(); ++j) {
                String rowPath = this.displayPane.getPathForRow(j).toString();
                if (!rowPath.equals(targetPath + "]")) continue;
                this.displayPane.expandRow(j);
                select = j;
                break;
            }
            if (i >= path.getPathCount() - 1) continue;
            targetPath = targetPath + ", ";
        }
        return select;
    }

    public DPath getSelectedPath() {
        TreePath row;
        DPath path = null;
        if (this.displayPane.getRowCount() > 0 && (row = this.displayPane.getPathForRow(this.lastSelect)) != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)row.getLastPathComponent();
            path = (DPath)node.getUserObject();
        }
        return path;
    }

    public int getSelectedIndex() {
        return this.lastSelect;
    }

    private DefaultMutableTreeNode drawFolder(DArchive archive, int index, DPath path) {
        DefaultMutableTreeNode model = new DefaultMutableTreeNode(path);
        if (archive.getFolderCount() > 0 && index < archive.getFolderCount()) {
            CArchiveFolder folder = archive.getFolder(index);
            for (int i = 0; i < folder.getPathCount(); ++i) {
                DPath filePath = folder.getPath(i);
                DFile file = filePath.getFile();
                if (file.isFile()) {
                    model.add(new DefaultMutableTreeNode(filePath));
                    continue;
                }
                model.add(this.drawFolder(archive, file.getReference(), filePath));
            }
        }
        return model;
    }

    private FFileTreeRender getThis() {
        return this;
    }

    private class CTreeRender
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private CImageIcon node_open = new CImageIcon("node_open");
        private CImageIcon node_close = new CImageIcon("node_close");
        private boolean linkage = false;

        private CTreeRender() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Color colorSelect = new Color(255, 255, 255);
            Color colorDefault = new Color(0, 0, 0);
            Color colorCompressed = new Color(66, 97, 240);
            this.setBackground(new Color(51, 153, 255));
            this.setOpenIcon(this.node_open);
            this.setClosedIcon(this.node_close);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            DPath path = (DPath)node.getUserObject();
            if (!path.isChecked()) {
                path.check();
            }
            String text = path.getFile().getFullName();
            if (path.getPlugin().getType() == 0 && path.getPlugin().getStamp().length() > 0) {
                text = text + " [" + path.getPlugin().getStamp() + "]";
            }
            this.linkage = false;
            DFormat cache = Loader.getCache(path.getPlugin().getFormat());
            if (cache != null) {
                this.linkage = cache.getPath() == path && row > 0;
            }
            this.setText(text);
            this.setIcon(path.getPlugin().getIcon().getIcon());
            if (path.getFile().isCompressed()) {
                colorDefault = colorCompressed;
            }
            if (selected) {
                this.setOpaque(true);
                this.setForeground(colorSelect);
            } else {
                this.setOpaque(false);
                this.setForeground(colorDefault);
            }
            if (row == 0) {
                this.setIcon(CIcon.FILE_ROOT.getIcon());
            }
            if (path.getFile().isFolder()) {
                this.setIcon(CIcon.FILE_FOLDER.getIcon());
            }
            return this;
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.linkage) {
                CIcon icon = CIcon.LINK;
                g.drawImage(icon.getImage(), this.getWidth() - icon.getWidth(), 0, this);
            }
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.width += 16;
            return size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FDisplay
    extends JTree {
        public FDisplay() {
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setModel(null);
            this.setCellRenderer(new CTreeRender());
            this.removeMouseListener(this.getMouseListeners()[0]);
            this.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    int newSelect = FDisplay.this.getRowForPath(e.getNewLeadSelectionPath());
                    if (newSelect != -1) {
                        FFileTreeRender.this.lastSelect = newSelect;
                    }
                    FFileTreeRender.this.getThis().firePropertyChange("selected", e.getOldLeadSelectionPath(), e.getNewLeadSelectionPath());
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    JTree tree = (JTree)e.getComponent();
                    int select = (int)Math.floor((double)e.getY() / (double)tree.getRowHeight());
                    if (select < 0) {
                        select = FFileTreeRender.this.lastSelect;
                    }
                    if (select >= tree.getRowCount()) {
                        select = tree.getRowCount() - 1;
                    }
                    tree.setSelectionRow(select);
                }

                public void mouseReleased(MouseEvent e) {
                    JTree tree = (JTree)e.getComponent();
                    Rectangle leaf = tree.getRowBounds(FFileTreeRender.this.lastSelect);
                    leaf = new Rectangle(leaf.x - 16, leaf.y, 16, leaf.height);
                    if (leaf.contains(e.getPoint())) {
                        if (tree.isCollapsed(FFileTreeRender.this.lastSelect)) {
                            tree.expandRow(FFileTreeRender.this.lastSelect);
                        } else {
                            tree.collapseRow(FFileTreeRender.this.lastSelect);
                        }
                    } else {
                        DPath path = FFileTreeRender.this.getSelectedPath();
                        if (e.getButton() == 3) {
                            Common.msg("Right-Click");
                        } else if (e.getClickCount() > 1) {
                            if (tree.isCollapsed(FFileTreeRender.this.lastSelect)) {
                                tree.expandRow(FFileTreeRender.this.lastSelect);
                            } else {
                                tree.collapseRow(FFileTreeRender.this.lastSelect);
                            }
                            CAction.doAction(4000);
                        }
                    }
                }
            });
        }

        public ArrayList<TreePath> getExpandedPaths() {
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            for (int i = 0; i < this.getRowCount(); ++i) {
                TreePath path = this.getPathForRow(i);
                if (!this.isExpanded(path)) continue;
                paths.add(path);
            }
            return paths;
        }
    }
}

