/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import ctool.Loader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import util.Common;
import util.gui.frames.CSplitLayout;
import util.gui.panels.CTable;
import util.struct.DFile;
import util.struct.DFormat;
import util.struct.DPath;

public class FFileInfoRender
extends JLayeredPane {
    private CInfoTable table;
    private CPreviewPane preview;

    public FFileInfoRender() {
        this.setPreferredSize(new Dimension(0, 150));
        this.setMinimumSize(new Dimension(0, 95));
        this.setLayout(new CSplitLayout(this));
        this.table = new CInfoTable();
        this.add((Component)this.table, "West");
        this.preview = new CPreviewPane();
        this.add(this.preview);
    }

    public void setCursor(Cursor cursor) {
        this.getParent().setCursor(cursor);
    }

    public void setPath(DPath path) {
        this.table.removeAll();
        this.table.addRow("Filename", path.getFile().getFullName());
        if (path.getFile().isFolder()) {
            this.table.addRow("Type", "Folder");
        } else {
            DFile file = path.getFile();
            String type = path.getPlugin().getName();
            String size = Common.calSize(file.getSize());
            String comp = Common.formatBoolean(file.isCompressed());
            if (path.getFile().isCompressed()) {
                size = size + " (" + Common.calSize(file.getFullSize()) + " Unpacked)";
                comp = comp + " (" + file.getCompressionInfo() + ")";
            }
            this.table.addRow("Type", type);
            this.table.addRow("Size", size);
            this.table.addRow("Compressed", comp);
            this.table.addRow("Offset", "0x" + Common.getHex(file.getOffset(), 2));
        }
        BufferedImage image = null;
        DFormat format = Loader.getFormat(path);
        switch (format.getType()) {
            case 5: {
                Common.msg("Preview Palette");
            }
        }
        this.preview.setImage(image);
    }

    private class CPreviewPane
    extends JPanel {
        public CPreviewPane() {
            this.setMinimumSize(new Dimension(250, 0));
            this.setBackground(new Color(227, 227, 227));
            this.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
            this.setOpaque(true);
            this.addMouseMotionListener(new MouseAdapter(){

                public void mouseMoved(MouseEvent e) {
                }
            });
            this.setImage(null);
        }

        public void setImage(BufferedImage image) {
            this.removeAll();
            if (image == null) {
                this.add(new JLabel("No Preview"));
            } else {
                this.add(new CPreview(image));
            }
            this.revalidate();
        }

        public void doLayout() {
            super.doLayout();
            Component target = this.getComponent(0);
            if (target instanceof CPreview) {
                ((CPreview)target).resize();
            }
            target.setLocation((this.getWidth() - target.getWidth()) / 2, (this.getHeight() - target.getHeight()) / 2);
        }

        private class CPreview
        extends JPanel {
            private BufferedImage image = new BufferedImage(64, 64, 2);
            private double scale;

            public CPreview(BufferedImage image) {
                this.image = image;
            }

            public void resize() {
                Dimension size = this.getParent().getSize();
                size = new Dimension(size.width - 25, size.height - 25);
                this.scale = this.getScale(size, new Dimension(this.image.getWidth(), this.image.getHeight()));
                Dimension scaleSize = new Dimension((int)((double)this.image.getWidth() * this.scale) + 10, (int)((double)this.image.getHeight() * this.scale) + 10);
                this.setSize(scaleSize);
            }

            public void paintComponent(Graphics g) {
                int panelWidth = this.getWidth() - 1;
                int panelHeight = this.getHeight() - 1;
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, panelWidth, panelHeight);
                g.setColor(new Color(180, 180, 180));
                g.drawRect(0, 0, panelWidth, panelHeight);
                int scaleWidth = (int)Math.floor((double)this.image.getWidth() * this.scale);
                int scaleHeight = (int)Math.floor((double)this.image.getHeight() * this.scale);
                Image scaledImage = this.image.getScaledInstance(scaleWidth, scaleHeight, 16);
                g.drawImage(scaledImage, 5, 5, null);
            }

            private double getScale(Dimension area, Dimension size) {
                double xscale = 1.0;
                double yscale = 1.0;
                if (size.width > area.width) {
                    xscale = (double)area.width / (double)size.width;
                }
                if (size.height > area.height) {
                    yscale = (double)area.height / (double)size.height;
                }
                if (xscale <= yscale) {
                    return xscale;
                }
                return yscale;
            }
        }
    }

    private class CInfoTable
    extends JTable {
        private CInfoTableModel model = new CInfoTableModel();

        public CInfoTable() {
            this.setPreferredSize(new Dimension(250, 0));
            this.setMinimumSize(new Dimension(200, 0));
            this.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
            this.setGridColor(new Color(213, 213, 213));
            this.setIntercellSpacing(new Dimension(0, 0));
            this.setRowHeight(19);
            this.setRowMargin(1);
            this.setDefaultRenderer(Object.class, new CInfoTableRender());
            this.setModel(this.model);
        }

        public void doLayout() {
            int width = 80;
            if (this.getColumnModel().getColumnCount() > 0) {
                this.getColumnModel().getColumn(0).setResizable(false);
                this.getColumnModel().getColumn(0).setWidth(width);
                this.getColumnModel().getColumn(0).setPreferredWidth(width);
                this.getColumnModel().getColumn(0).setMinWidth(width);
                this.getColumnModel().getColumn(0).setMaxWidth(width);
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getRowCount() * this.getRowHeight()));
            }
            super.doLayout();
        }

        public void addRow(String name, Object value) {
            this.model.addRow(name, value);
        }

        public void removeAll() {
            super.removeAll();
            this.model.removeAll();
        }

        private class CInfoTableModel
        extends DefaultTableModel {
            private Object[][] data = new Object[0][];
            private ArrayList<String> names = new ArrayList();

            public CInfoTableModel() {
                this.names.add("Property");
                this.names.add("Value");
            }

            public void addRow(String name, Object value) {
                Object[] rowData = new Object[]{name, value};
                this.data = Common.addItem(this.data, rowData);
                this.setDataVector(this.data, this.names.toArray());
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public void removeAll() {
                this.data = new Object[0][];
                this.setDataVector(this.data, this.names.toArray());
            }
        }

        private class CInfoTableRender
        implements TableCellRenderer {
            private CInfoTableRender() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel target = new JLabel("" + value);
                int cspace = 1;
                if (column == table.getColumnCount() - 1) {
                    cspace = 0;
                }
                target.setBorder(new CTable.CBorder(1 - cspace, 5, 0, cspace, new boolean[]{false, false, true, true}, table.getGridColor()));
                target.setBackground(new Color(255, 255, 255));
                target.setForeground(new Color(0, 0, 0));
                target.setOpaque(true);
                return target;
            }
        }
    }
}

